/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processors.standard.ftp.FTPClientProvider;
import org.apache.nifi.processors.standard.socket.ClientAuthenticationException;
import org.apache.nifi.processors.standard.socket.ClientConfigurationException;
import org.apache.nifi.processors.standard.socket.ClientConnectException;
import org.apache.nifi.processors.standard.socket.SocketFactoryProvider;
import org.apache.nifi.processors.standard.socket.StandardSocketFactoryProvider;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFTPClientProvider
implements FTPClientProvider {
    private static final SocketFactoryProvider SOCKET_FACTORY_PROVIDER = new StandardSocketFactoryProvider();
    private static final String ADDRESS_FORMAT = "%s:%d";
    private static final Logger logger = LoggerFactory.getLogger(StandardFTPClientProvider.class);

    @Override
    public FTPClient getClient(PropertyContext context, Map<String, String> attributes) {
        Objects.requireNonNull(context, "Property Context required");
        Objects.requireNonNull(attributes, "Attributes required");
        FTPClient client = this.createClient(context);
        this.setClientProperties(client, context);
        boolean attributesEmpty = attributes.isEmpty();
        PropertyValue hostnameProperty = context.getProperty(FTPTransfer.HOSTNAME);
        String hostname = attributesEmpty ? hostnameProperty.evaluateAttributeExpressions().getValue() : hostnameProperty.evaluateAttributeExpressions(attributes).getValue();
        PropertyValue portProperty = context.getProperty(FTPTransfer.PORT);
        int port = attributesEmpty ? portProperty.evaluateAttributeExpressions().asInteger() : portProperty.evaluateAttributeExpressions(attributes).asInteger();
        String address = String.format(ADDRESS_FORMAT, hostname, port);
        try {
            client.connect(hostname, port);
            int dataTimeout = context.getProperty(FTPTransfer.DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
            client.setSoTimeout(dataTimeout);
        }
        catch (IOException e) {
            this.disconnectClient(client);
            throw new ClientConnectException(String.format("FTP Client connection failed [%s]", address), e);
        }
        PropertyValue usernameProperty = context.getProperty(FTPTransfer.USERNAME);
        String username = attributesEmpty ? usernameProperty.evaluateAttributeExpressions().getValue() : usernameProperty.evaluateAttributeExpressions(attributes).getValue();
        String password = context.getProperty(FTPTransfer.PASSWORD).evaluateAttributeExpressions(attributes).getValue();
        try {
            boolean authenticated = client.login(username, password);
            if (!authenticated) {
                this.disconnectClient(client);
                throw new ClientAuthenticationException(String.format("FTP Client login denied [%s]", address));
            }
            logger.debug("FTP login completed: [{}]", (Object)address);
        }
        catch (IOException e) {
            this.disconnectClient(client);
            throw new ClientAuthenticationException(String.format("FTP Client login failed [%s]", address), e);
        }
        String connectionMode = context.getProperty(FTPTransfer.CONNECTION_MODE).getValue();
        if (connectionMode.equalsIgnoreCase("Active")) {
            client.enterLocalActiveMode();
        } else {
            client.enterLocalPassiveMode();
        }
        String transferMode = context.getProperty(FTPTransfer.TRANSFER_MODE).getValue();
        int fileType = transferMode.equalsIgnoreCase("ASCII") ? 0 : 2;
        try {
            if (!client.setFileType(fileType)) {
                throw new ClientConfigurationException(String.format("FTP Client set transfer mode [%s] rejected [%s]", transferMode, address));
            }
            logger.debug("FTP set transfer mode [{}] completed: {}", (Object)transferMode, (Object)address);
        }
        catch (IOException e) {
            throw new ClientConfigurationException(String.format("FTP Client set transfer mode [%s] failed [%s]", transferMode, address), e);
        }
        return client;
    }

    private void setClientProperties(FTPClient client, PropertyContext context) {
        boolean unicodeEnabled;
        int bufferSize = context.getProperty(FTPTransfer.BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
        Duration dataTimeout = context.getProperty(FTPTransfer.DATA_TIMEOUT).asDuration();
        int connectionTimeout = context.getProperty(FTPTransfer.CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        client.setBufferSize(bufferSize);
        client.setDataTimeout(dataTimeout);
        client.setDefaultTimeout(connectionTimeout);
        client.setRemoteVerificationEnabled(false);
        client.setAutodetectUTF8(true);
        boolean bl = unicodeEnabled = context.getProperty(FTPTransfer.UTF8_ENCODING).isSet() ? context.getProperty(FTPTransfer.UTF8_ENCODING).asBoolean() : false;
        if (unicodeEnabled) {
            client.setControlEncoding(StandardCharsets.UTF_8.name());
        }
    }

    private void disconnectClient(FTPClient client) {
        try {
            client.disconnect();
        }
        catch (IOException e) {
            throw new UncheckedIOException("FTP Client disconnect failed", e);
        }
    }

    private FTPClient createClient(PropertyContext context) {
        ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context, FTPTransfer.createComponentProxyConfigSupplier(context));
        Proxy.Type proxyType = proxyConfiguration.getProxyType();
        FTPClient client = new FTPClient();
        if (Proxy.Type.HTTP == proxyType || Proxy.Type.SOCKS == proxyType) {
            SocketFactory socketFactory = SOCKET_FACTORY_PROVIDER.getSocketFactory(proxyConfiguration);
            client.setSocketFactory(socketFactory);
            client.setPassiveNatWorkaroundStrategy(null);
        }
        return client;
    }
}

