/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.listen.event.EventFactoryUtil;
import org.apache.nifi.processors.standard.relp.event.RELPMessageFactory;
import org.apache.nifi.processors.standard.relp.frame.RELPDecoder;
import org.apache.nifi.processors.standard.relp.frame.RELPEncoder;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;
import org.apache.nifi.processors.standard.relp.response.RELPChannelResponse;
import org.apache.nifi.processors.standard.relp.response.RELPResponse;

public class RELPFrameDecoder
extends ByteToMessageDecoder {
    private Charset charset;
    private RELPDecoder decoder;
    private final ComponentLog logger;
    private final RELPEncoder encoder;
    private final RELPMessageFactory eventFactory;
    static final String CMD_OPEN = "open";
    static final String CMD_CLOSE = "close";

    public RELPFrameDecoder(ComponentLog logger, Charset charset) {
        this.charset = charset;
        this.logger = logger;
        this.encoder = new RELPEncoder(charset);
        this.eventFactory = new RELPMessageFactory();
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int total = in.readableBytes();
        String senderSocket = ctx.channel().remoteAddress().toString();
        this.decoder = new RELPDecoder(this.charset, total);
        for (int i = 0; i < total; ++i) {
            byte currByte = in.readByte();
            if (!this.decoder.process(currByte)) continue;
            RELPFrame frame = this.decoder.getFrame();
            this.logger.debug("Received RELP frame with transaction {} and command {}", new Object[]{frame.getTxnr(), frame.getCommand()});
            this.handle(frame, ctx, senderSocket, out);
            in.markReaderIndex();
        }
    }

    private void handle(RELPFrame frame, ChannelHandlerContext ctx, String sender, List<Object> out) {
        if (CMD_OPEN.equals(frame.getCommand())) {
            Map<String, String> offers = RELPResponse.parseOffers(frame.getData(), this.charset);
            RELPChannelResponse response = new RELPChannelResponse(this.encoder, RELPResponse.open(frame.getTxnr(), offers));
            ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])response.toByteArray()));
        } else if (CMD_CLOSE.equals(frame.getCommand())) {
            RELPChannelResponse response = new RELPChannelResponse(this.encoder, RELPResponse.ok(frame.getTxnr()));
            ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])response.toByteArray()));
            ctx.close();
        } else {
            Map metadata = EventFactoryUtil.createMapWithSender((String)sender);
            metadata.put("relp.txnr", String.valueOf(frame.getTxnr()));
            metadata.put("relp.command", frame.getCommand());
            metadata.put("sender", sender);
            out.add((Object)this.eventFactory.create(frame.getData(), (Map<String, String>)metadata));
        }
    }
}

