/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import com.aayushatharva.brotli4j.decoder.BrotliInputStream;
import com.aayushatharva.brotli4j.encoder.BrotliOutputStream;
import com.aayushatharva.brotli4j.encoder.Encoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import lzma.sdk.lzma.Decoder;
import lzma.streams.LzmaInputStream;
import lzma.streams.LzmaOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.SystemResourceConsiderations;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.MultiProcessorUseCase;
import org.apache.nifi.annotation.documentation.ProcessorConfiguration;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.documentation.UseCases;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.standard.IdentifyMimeType;
import org.apache.nifi.stream.io.GZIPOutputStream;
import org.apache.nifi.util.StopWatch;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;
import org.xerial.snappy.SnappyFramedInputStream;
import org.xerial.snappy.SnappyFramedOutputStream;
import org.xerial.snappy.SnappyHadoopCompatibleOutputStream;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"content", "compress", "decompress", "gzip", "bzip2", "lzma", "xz-lzma2", "snappy", "snappy-hadoop", "snappy framed", "lz4-framed", "deflate", "zstd", "brotli"})
@CapabilityDescription(value="Compresses or decompresses the contents of FlowFiles using a user-specified compression algorithm and updates the mime.type attribute as appropriate. A common idiom is to precede CompressContent with IdentifyMimeType and configure Mode='decompress' AND Compression Format='use mime.type attribute'. When used in this manner, the MIME type is automatically detected and the data is decompressed, if necessary. If decompression is unnecessary, the data is passed through to the 'success' relationship. This processor operates in a very memory efficient way so very large objects well beyond the heap size are generally fine to process.")
@ReadsAttribute(attribute="mime.type", description="If the Compression Format is set to use mime.type attribute, this attribute is used to determine the compression type. Otherwise, this attribute is ignored.")
@WritesAttribute(attribute="mime.type", description="If the Mode property is set to compress, the appropriate MIME Type is set. If the Mode property is set to decompress and the file is successfully decompressed, this attribute is removed, as the MIME Type is no longer known.")
@SystemResourceConsiderations(value={@SystemResourceConsideration(resource=SystemResource.CPU), @SystemResourceConsideration(resource=SystemResource.MEMORY)})
@UseCases(value={@UseCase(description="Compress the contents of a FlowFile", configuration="\"Mode\" = \"compress\"\n\"Compression Format\" should be set to whichever compression algorithm should be used."), @UseCase(description="Decompress the contents of a FlowFile", configuration="\"Mode\" = \"decompress\"\n\"Compression Format\" should be set to whichever compression algorithm was used to compress the data previously.")})
@MultiProcessorUseCase(description="Check whether or not a FlowFile is compressed and if so, decompress it.", notes="If IdentifyMimeType determines that the content is not compressed, CompressContent will pass the FlowFile along to the 'success' relationship without attempting to decompress it.", keywords={"auto", "detect", "mime type", "compress", "decompress", "gzip", "bzip2"}, configurations={@ProcessorConfiguration(processorClass=IdentifyMimeType.class, configuration="Default property values are sufficient.\nConnect the 'success' relationship to CompressContent.\n"), @ProcessorConfiguration(processorClass=CompressContent.class, configuration="\"Mode\" = \"decompress\"\n\"Compression Format\" = \"use mime.type attribute\"\n")})
public class CompressContent
extends AbstractProcessor {
    public static final String COMPRESSION_FORMAT_ATTRIBUTE = "use mime.type attribute";
    public static final String COMPRESSION_FORMAT_GZIP = "gzip";
    public static final String COMPRESSION_FORMAT_DEFLATE = "deflate";
    public static final String COMPRESSION_FORMAT_BZIP2 = "bzip2";
    public static final String COMPRESSION_FORMAT_XZ_LZMA2 = "xz-lzma2";
    public static final String COMPRESSION_FORMAT_LZMA = "lzma";
    public static final String COMPRESSION_FORMAT_SNAPPY = "snappy";
    public static final String COMPRESSION_FORMAT_SNAPPY_HADOOP = "snappy-hadoop";
    public static final String COMPRESSION_FORMAT_SNAPPY_FRAMED = "snappy framed";
    public static final String COMPRESSION_FORMAT_LZ4_FRAMED = "lz4-framed";
    public static final String COMPRESSION_FORMAT_ZSTD = "zstd";
    public static final String COMPRESSION_FORMAT_BROTLI = "brotli";
    public static final String MODE_COMPRESS = "compress";
    public static final String MODE_DECOMPRESS = "decompress";
    public static final PropertyDescriptor COMPRESSION_FORMAT = new PropertyDescriptor.Builder().name("Compression Format").description("The compression format to use. Valid values are: GZIP, Deflate, ZSTD, BZIP2, XZ-LZMA2, LZMA, Brotli, Snappy, Snappy Hadoop, Snappy Framed, and LZ4-Framed").allowableValues(new String[]{"use mime.type attribute", "gzip", "deflate", "bzip2", "xz-lzma2", "lzma", "snappy", "snappy-hadoop", "snappy framed", "lz4-framed", "zstd", "brotli"}).defaultValue("use mime.type attribute").required(true).build();
    public static final PropertyDescriptor MODE = new PropertyDescriptor.Builder().name("Mode").description("Indicates whether the processor should compress content or decompress content. Must be either 'compress' or 'decompress'").allowableValues(new String[]{"compress", "decompress"}).defaultValue("compress").required(true).build();
    public static final PropertyDescriptor COMPRESSION_LEVEL = new PropertyDescriptor.Builder().name("Compression Level").description("The compression level to use; this is valid only when using gzip, deflate or xz-lzma2 compression. A lower value results in faster processing but less compression; a value of 0 indicates no (that is, simple archiving) for gzip or minimal for xz-lzma2 compression. Higher levels can mean much larger memory usage such as the case with levels 7-9 for xz-lzma/2 so be careful relative to heap size.").defaultValue("1").required(true).allowableValues(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}).dependsOn(COMPRESSION_FORMAT, "use mime.type attribute", new String[]{"gzip", "deflate", "xz-lzma2", "zstd", "brotli"}).dependsOn(MODE, "compress", new String[0]).build();
    public static final PropertyDescriptor UPDATE_FILENAME = new PropertyDescriptor.Builder().name("Update Filename").description("If true, will remove the filename extension when decompressing data (only if the extension indicates the appropriate compression format) and add the appropriate extension when compressing data").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles will be transferred to the success relationship after successfully being compressed or decompressed").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles will be transferred to the failure relationship if they fail to compress/decompress").build();
    private final List<PropertyDescriptor> properties = List.of(MODE, COMPRESSION_FORMAT, COMPRESSION_LEVEL, UPDATE_FILENAME);
    private final Set<Relationship> relationships = Set.of(REL_SUCCESS, REL_FAILURE);
    private final Map<String, String> compressionFormatMimeTypeMap = Map.ofEntries(Map.entry("application/gzip", "gzip"), Map.entry("application/x-gzip", "gzip"), Map.entry("application/deflate", "deflate"), Map.entry("application/x-deflate", "deflate"), Map.entry("application/bzip2", "bzip2"), Map.entry("application/x-bzip2", "bzip2"), Map.entry("application/x-lzma", "lzma"), Map.entry("application/x-snappy", "snappy"), Map.entry("application/x-snappy-hadoop", "snappy-hadoop"), Map.entry("application/x-snappy-framed", "snappy framed"), Map.entry("application/x-lz4-framed", "lz4-framed"), Map.entry("application/zstd", "zstd"), Map.entry("application/x-brotli", "brotli"));

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(context));
        if (context.getProperty(COMPRESSION_FORMAT).getValue().equalsIgnoreCase(COMPRESSION_FORMAT_SNAPPY_HADOOP) && context.getProperty(MODE).getValue().equalsIgnoreCase(MODE_DECOMPRESS)) {
            validationResults.add(new ValidationResult.Builder().subject(COMPRESSION_FORMAT.getName()).explanation("<Compression Format> set to <snappy-hadoop> and <MODE> set to <decompress> is not permitted. Data that is compressed with Snappy Hadoop can not be decompressed using this processor.").valid(false).build());
        }
        return validationResults;
    }

    public void onTrigger(final ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        long sizeBeforeCompression = flowFile.getSize();
        final String compressionMode = context.getProperty(MODE).getValue();
        String compressionFormatValue = context.getProperty(COMPRESSION_FORMAT).getValue();
        if (compressionFormatValue.equals(COMPRESSION_FORMAT_ATTRIBUTE)) {
            String mimeType = flowFile.getAttribute(CoreAttributes.MIME_TYPE.key());
            if (mimeType == null) {
                logger.error("No {} attribute exists for {}; routing to failure", new Object[]{CoreAttributes.MIME_TYPE.key(), flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            compressionFormatValue = this.compressionFormatMimeTypeMap.get(mimeType);
            if (compressionFormatValue == null) {
                logger.info("Mime Type of {} is '{}', which does not indicate a supported Compression Format; routing to success without decompressing", new Object[]{flowFile, mimeType});
                session.transfer(flowFile, REL_SUCCESS);
                return;
            }
        }
        final String compressionFormat = compressionFormatValue;
        final AtomicReference<Object> mimeTypeRef = new AtomicReference<Object>(null);
        StopWatch stopWatch = new StopWatch(true);
        String fileExtension = switch (compressionFormat.toLowerCase()) {
            case COMPRESSION_FORMAT_GZIP -> ".gz";
            case COMPRESSION_FORMAT_DEFLATE -> ".zlib";
            case COMPRESSION_FORMAT_LZMA -> ".lzma";
            case COMPRESSION_FORMAT_XZ_LZMA2 -> ".xz";
            case COMPRESSION_FORMAT_BZIP2 -> ".bz2";
            case COMPRESSION_FORMAT_SNAPPY -> ".snappy";
            case COMPRESSION_FORMAT_SNAPPY_HADOOP -> ".snappy";
            case COMPRESSION_FORMAT_SNAPPY_FRAMED -> ".sz";
            case COMPRESSION_FORMAT_LZ4_FRAMED -> ".lz4";
            case COMPRESSION_FORMAT_ZSTD -> ".zst";
            case COMPRESSION_FORMAT_BROTLI -> ".br";
            default -> "";
        };
        try {
            flowFile = session.write(flowFile, new StreamCallback(){

                public void process(InputStream rawIn, OutputStream rawOut) throws IOException {
                    FilterOutputStream compressionOut;
                    BufferedInputStream compressionIn;
                    BufferedOutputStream bufferedOut = new BufferedOutputStream(rawOut, 65536);
                    BufferedInputStream bufferedIn = new BufferedInputStream(rawIn, 65536);
                    try {
                        if (CompressContent.MODE_COMPRESS.equalsIgnoreCase(compressionMode)) {
                            compressionIn = bufferedIn;
                            switch (compressionFormat.toLowerCase()) {
                                case "gzip": {
                                    int compressionLevel = context.getProperty(COMPRESSION_LEVEL).asInteger();
                                    compressionOut = new GZIPOutputStream((OutputStream)bufferedOut, compressionLevel);
                                    mimeTypeRef.set("application/gzip");
                                    break;
                                }
                                case "deflate": {
                                    int compressionLevel = context.getProperty(COMPRESSION_LEVEL).asInteger();
                                    compressionOut = new DeflaterOutputStream((OutputStream)bufferedOut, new Deflater(compressionLevel));
                                    mimeTypeRef.set("application/gzip");
                                    break;
                                }
                                case "lzma": {
                                    compressionOut = new LzmaOutputStream.Builder((OutputStream)bufferedOut).build();
                                    mimeTypeRef.set("application/x-lzma");
                                    break;
                                }
                                case "xz-lzma2": {
                                    int xzCompressionLevel = context.getProperty(COMPRESSION_LEVEL).asInteger();
                                    compressionOut = new XZOutputStream((OutputStream)bufferedOut, (FilterOptions)new LZMA2Options(xzCompressionLevel));
                                    mimeTypeRef.set("application/x-xz");
                                    break;
                                }
                                case "snappy": {
                                    compressionOut = new SnappyOutputStream((OutputStream)bufferedOut);
                                    mimeTypeRef.set("application/x-snappy");
                                    break;
                                }
                                case "snappy-hadoop": {
                                    compressionOut = new SnappyHadoopCompatibleOutputStream((OutputStream)bufferedOut);
                                    mimeTypeRef.set("application/x-snappy-hadoop");
                                    break;
                                }
                                case "snappy framed": {
                                    compressionOut = new SnappyFramedOutputStream((OutputStream)bufferedOut);
                                    mimeTypeRef.set("application/x-snappy-framed");
                                    break;
                                }
                                case "lz4-framed": {
                                    mimeTypeRef.set("application/x-lz4-framed");
                                    compressionOut = new CompressorStreamFactory().createCompressorOutputStream(compressionFormat.toLowerCase(), (OutputStream)bufferedOut);
                                    break;
                                }
                                case "zstd": {
                                    int zstdCompressionLevel = context.getProperty(COMPRESSION_LEVEL).asInteger() * 2;
                                    compressionOut = new ZstdCompressorOutputStream((OutputStream)bufferedOut, zstdCompressionLevel);
                                    mimeTypeRef.set("application/zstd");
                                    break;
                                }
                                case "brotli": {
                                    Brotli4jLoader.ensureAvailability();
                                    int compressionLevel = context.getProperty(COMPRESSION_LEVEL).asInteger();
                                    Encoder.Parameters params = new Encoder.Parameters().setQuality(compressionLevel);
                                    compressionOut = new BrotliOutputStream((OutputStream)bufferedOut, params);
                                    mimeTypeRef.set("application/x-brotli");
                                    break;
                                }
                                default: {
                                    mimeTypeRef.set("application/x-bzip2");
                                    compressionOut = new CompressorStreamFactory().createCompressorOutputStream(compressionFormat.toLowerCase(), (OutputStream)bufferedOut);
                                    break;
                                }
                            }
                        } else {
                            compressionOut = bufferedOut;
                            compressionIn = switch (compressionFormat.toLowerCase()) {
                                case CompressContent.COMPRESSION_FORMAT_LZMA -> new LzmaInputStream((InputStream)bufferedIn, new Decoder());
                                case CompressContent.COMPRESSION_FORMAT_XZ_LZMA2 -> new XZInputStream((InputStream)bufferedIn);
                                case CompressContent.COMPRESSION_FORMAT_BZIP2 -> new BZip2CompressorInputStream((InputStream)bufferedIn, true);
                                case CompressContent.COMPRESSION_FORMAT_GZIP -> new GzipCompressorInputStream((InputStream)bufferedIn, true);
                                case CompressContent.COMPRESSION_FORMAT_DEFLATE -> new InflaterInputStream(bufferedIn);
                                case CompressContent.COMPRESSION_FORMAT_SNAPPY -> new SnappyInputStream((InputStream)bufferedIn);
                                case CompressContent.COMPRESSION_FORMAT_SNAPPY_HADOOP -> throw new Exception("Cannot decompress snappy-hadoop.");
                                case CompressContent.COMPRESSION_FORMAT_SNAPPY_FRAMED -> new SnappyFramedInputStream((InputStream)bufferedIn);
                                case CompressContent.COMPRESSION_FORMAT_LZ4_FRAMED -> new FramedLZ4CompressorInputStream((InputStream)bufferedIn, true);
                                case CompressContent.COMPRESSION_FORMAT_ZSTD -> new ZstdCompressorInputStream((InputStream)bufferedIn);
                                case CompressContent.COMPRESSION_FORMAT_BROTLI -> {
                                    Brotli4jLoader.ensureAvailability();
                                    yield new BrotliInputStream((InputStream)bufferedIn);
                                }
                                default -> new CompressorStreamFactory().createCompressorInputStream(compressionFormat.toLowerCase(), (InputStream)bufferedIn);
                            };
                        }
                    }
                    catch (Exception e) {
                        CompressContent.this.closeQuietly(bufferedOut);
                        throw new IOException(e);
                    }
                    try (BufferedInputStream in = compressionIn;
                         BufferedOutputStream out = compressionOut;){
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = ((InputStream)in).read(buffer)) > 0) {
                            ((OutputStream)out).write(buffer, 0, len);
                        }
                        ((OutputStream)out).flush();
                    }
                }
            });
            stopWatch.stop();
            long sizeAfterCompression = flowFile.getSize();
            if (MODE_DECOMPRESS.equalsIgnoreCase(compressionMode)) {
                String filename;
                flowFile = session.removeAttribute(flowFile, CoreAttributes.MIME_TYPE.key());
                if (context.getProperty(UPDATE_FILENAME).asBoolean().booleanValue() && (filename = flowFile.getAttribute(CoreAttributes.FILENAME.key())).toLowerCase().endsWith(fileExtension)) {
                    flowFile = session.putAttribute(flowFile, CoreAttributes.FILENAME.key(), filename.substring(0, filename.length() - fileExtension.length()));
                }
            } else {
                flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), (String)mimeTypeRef.get());
                if (context.getProperty(UPDATE_FILENAME).asBoolean().booleanValue()) {
                    String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
                    flowFile = session.putAttribute(flowFile, CoreAttributes.FILENAME.key(), filename + fileExtension);
                }
            }
            logger.info("Successfully {}ed {} using {} compression format; size changed from {} to {} bytes", new Object[]{compressionMode.toLowerCase(), flowFile, compressionFormat, sizeBeforeCompression, sizeAfterCompression});
            session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getDuration(TimeUnit.MILLISECONDS));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (ProcessException e) {
            logger.error("Unable to {} {} using {} compression format due to {}; routing to failure", new Object[]{compressionMode.toLowerCase(), flowFile, compressionFormat, e, e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

