/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.file.transfer.FileInfo;
import org.apache.nifi.processor.util.file.transfer.FileTransfer;
import org.apache.nifi.processor.util.file.transfer.ListFileTransfer;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processor.util.list.ListedEntityTracker;
import org.apache.nifi.processors.standard.FetchSFTP;
import org.apache.nifi.processors.standard.GetSFTP;
import org.apache.nifi.processors.standard.ListFile;
import org.apache.nifi.processors.standard.PutSFTP;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.processors.standard.util.SFTPTransfer;
import org.apache.nifi.scheduling.SchedulingStrategy;

@PrimaryNodeOnly
@TriggerSerially
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"list", "sftp", "remote", "ingest", "source", "input", "files"})
@CapabilityDescription(value="Performs a listing of the files residing on an SFTP server. For each file that is found on the remote server, a new FlowFile will be created with the filename attribute set to the name of the file on the remote server. This can then be used in conjunction with FetchSFTP in order to fetch those files.")
@SeeAlso(value={FetchSFTP.class, GetSFTP.class, PutSFTP.class})
@WritesAttributes(value={@WritesAttribute(attribute="sftp.remote.host", description="The hostname of the SFTP Server"), @WritesAttribute(attribute="sftp.remote.port", description="The port that was connected to on the SFTP Server"), @WritesAttribute(attribute="sftp.listing.user", description="The username of the user that performed the SFTP Listing"), @WritesAttribute(attribute="file.owner", description="The numeric owner id of the source file"), @WritesAttribute(attribute="file.group", description="The numeric group id of the source file"), @WritesAttribute(attribute="file.permissions", description="The read/write/execute permissions of the source file"), @WritesAttribute(attribute="file.size", description="The number of bytes in the source file"), @WritesAttribute(attribute="file.lastModifiedTime", description="The timestamp of when the file in the filesystem waslast modified as 'yyyy-MM-dd'T'HH:mm:ssZ'"), @WritesAttribute(attribute="filename", description="The name of the file on the SFTP Server"), @WritesAttribute(attribute="path", description="The fully qualified name of the directory on the SFTP Server from which the file was pulled"), @WritesAttribute(attribute="mime.type", description="The MIME Type that is provided by the configured Record Writer")})
@Stateful(scopes={Scope.CLUSTER}, description="After performing a listing of files, the timestamp of the newest file is stored. This allows the Processor to list only files that have been added or modified after this date the next time that the Processor is run. State is stored across the cluster so that this Processor can be run on Primary Node only and if a new Primary Node is selected, the new node will not duplicate the data that was listed by the previous Primary Node.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class ListSFTP
extends ListFileTransfer {
    private volatile Predicate<FileInfo> fileFilter;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(FILE_TRANSFER_LISTING_STRATEGY);
        properties.add(SFTPTransfer.HOSTNAME);
        properties.add(SFTPTransfer.PORT);
        properties.add(SFTPTransfer.USERNAME);
        properties.add(SFTPTransfer.PASSWORD);
        properties.add(SFTPTransfer.PRIVATE_KEY_PATH);
        properties.add(SFTPTransfer.PRIVATE_KEY_PASSPHRASE);
        properties.add(REMOTE_PATH);
        properties.add(RECORD_WRITER);
        properties.add(DISTRIBUTED_CACHE_SERVICE);
        properties.add(SFTPTransfer.RECURSIVE_SEARCH);
        properties.add(SFTPTransfer.FOLLOW_SYMLINK);
        properties.add(SFTPTransfer.FILE_FILTER_REGEX);
        properties.add(SFTPTransfer.PATH_FILTER_REGEX);
        properties.add(SFTPTransfer.IGNORE_DOTTED_FILES);
        properties.add(SFTPTransfer.REMOTE_POLL_BATCH_SIZE);
        properties.add(SFTPTransfer.STRICT_HOST_KEY_CHECKING);
        properties.add(SFTPTransfer.HOST_KEY_FILE);
        properties.add(SFTPTransfer.CONNECTION_TIMEOUT);
        properties.add(SFTPTransfer.DATA_TIMEOUT);
        properties.add(SFTPTransfer.USE_KEEPALIVE_ON_TIMEOUT);
        properties.add(TARGET_SYSTEM_TIMESTAMP_PRECISION);
        properties.add(SFTPTransfer.USE_COMPRESSION);
        properties.add(SFTPTransfer.PROXY_CONFIGURATION_SERVICE);
        properties.add(FTPTransfer.PROXY_TYPE);
        properties.add(FTPTransfer.PROXY_HOST);
        properties.add(FTPTransfer.PROXY_PORT);
        properties.add(FTPTransfer.HTTP_PROXY_USERNAME);
        properties.add(FTPTransfer.HTTP_PROXY_PASSWORD);
        properties.add(ListedEntityTracker.TRACKING_STATE_CACHE);
        properties.add(ListedEntityTracker.TRACKING_TIME_WINDOW);
        properties.add(ListedEntityTracker.INITIAL_LISTING_TARGET);
        properties.add(ListFile.MIN_AGE);
        properties.add(ListFile.MAX_AGE);
        properties.add(ListFile.MIN_SIZE);
        properties.add(ListFile.MAX_SIZE);
        properties.add(SFTPTransfer.CIPHERS_ALLOWED);
        properties.add(SFTPTransfer.KEY_ALGORITHMS_ALLOWED);
        properties.add(SFTPTransfer.KEY_EXCHANGE_ALGORITHMS_ALLOWED);
        properties.add(SFTPTransfer.MESSAGE_AUTHENTICATION_CODES_ALLOWED);
        return properties;
    }

    protected FileTransfer getFileTransfer(ProcessContext context) {
        return new SFTPTransfer((PropertyContext)context, this.getLogger());
    }

    protected String getProtocolName() {
        return "sftp";
    }

    protected Scope getStateScope(PropertyContext context) {
        return Scope.CLUSTER;
    }

    protected void customValidate(ValidationContext validationContext, Collection<ValidationResult> results) {
        SFTPTransfer.validateProxySpec(validationContext, results);
    }

    protected List<FileInfo> performListing(ProcessContext context, Long minTimestamp, AbstractListProcessor.ListingMode listingMode, boolean applyFilters) throws IOException {
        List listing = super.performListing(context, minTimestamp, listingMode, applyFilters);
        if (!applyFilters) {
            return listing;
        }
        Predicate<FileInfo> filePredicate = listingMode == AbstractListProcessor.ListingMode.EXECUTION ? this.fileFilter : this.createFileFilter(context);
        return listing.stream().filter(filePredicate).collect(Collectors.toList());
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.fileFilter = this.createFileFilter(context);
    }

    private Predicate<FileInfo> createFileFilter(ProcessContext context) {
        long minSize = context.getProperty(ListFile.MIN_SIZE).asDataSize(DataUnit.B).longValue();
        Double maxSize = context.getProperty(ListFile.MAX_SIZE).asDataSize(DataUnit.B);
        long minAge = context.getProperty(ListFile.MIN_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        Long maxAge = context.getProperty(ListFile.MAX_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        return attributes -> {
            if (attributes.isDirectory()) {
                return true;
            }
            if (minSize > attributes.getSize()) {
                return false;
            }
            if (maxSize != null && maxSize < (double)attributes.getSize()) {
                return false;
            }
            long fileAge = System.currentTimeMillis() - attributes.getLastModifiedTime();
            if (minAge > fileAge) {
                return false;
            }
            return maxAge == null || maxAge >= fileAge;
        };
    }
}

