/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.ConvertRecord;
import org.apache.nifi.processors.standard.SplitRecord;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.util.RecordPathCache;
import org.apache.nifi.record.path.validation.RecordPathValidator;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.util.Tuple;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="Sets the mime.type attribute to the MIME Type specified by the Record Writer"), @WritesAttribute(attribute="record.count", description="The number of records in the FlowFile")})
@Tags(value={"lookup", "enrichment", "route", "record", "csv", "json", "avro", "database", "db", "logs", "convert", "filter"})
@CapabilityDescription(value="Extracts one or more fields from a Record and looks up a value for those fields in a LookupService. If a result is returned by the LookupService, that result is optionally added to the Record. In this case, the processor functions as an Enrichment processor. Regardless, the Record is then routed to either the 'matched' relationship or 'unmatched' relationship (if the 'Routing Strategy' property is configured to do so), indicating whether or not a result was returned by the LookupService, allowing the processor to also function as a Routing processor. The \"coordinates\" to use for looking up a value in the Lookup Service are defined by adding a user-defined property. Each property that is added will have an entry added to a Map, where the name of the property becomes the Map Key and the value returned by the RecordPath becomes the value for that key. If multiple values are returned by the RecordPath, then the Record will be routed to the 'unmatched' relationship (or 'success', depending on the 'Routing Strategy' property's configuration). If one or more fields match the Result RecordPath, all fields that match will be updated. If there is no match in the configured LookupService, then no fields will be updated. I.e., it will not overwrite an existing value in the Record with a null value. Please note, however, that if the results returned by the LookupService are not accounted for in your schema (specifically, the schema that is configured for your Record Writer) then the fields will not be written out to the FlowFile.")
@DynamicProperty(name="Value To Lookup", value="Valid Record Path", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="A RecordPath that points to the field whose value will be looked up in the configured Lookup Service")
@SeeAlso(value={ConvertRecord.class, SplitRecord.class}, classNames={"org.apache.nifi.lookup.SimpleKeyValueLookupService", "org.apache.nifi.lookup.maxmind.IPLookupService", "org.apache.nifi.lookup.db.DatabaseRecordLookupService"})
public class LookupRecord
extends AbstractProcessor {
    private final RecordPathCache recordPathCache = new RecordPathCache(25);
    private volatile LookupService<?> lookupService;
    static final AllowableValue ROUTE_TO_SUCCESS = new AllowableValue("route-to-success", "Route to 'success'", "Records will be routed to a 'success' Relationship regardless of whether or not there is a match in the configured Lookup Service");
    static final AllowableValue ROUTE_TO_MATCHED_UNMATCHED = new AllowableValue("route-to-matched-unmatched", "Route to 'matched' or 'unmatched'", "Records will be routed to either a 'matched' or an 'unmatched' Relationship depending on whether or not there was a match in the configured Lookup Service. A single input FlowFile may result in two different output FlowFiles. If the given Record Paths evaluate such that multiple sub-records are evaluated, the parent Record will be routed to 'unmatched' unless all sub-records match.");
    static final AllowableValue RESULT_ENTIRE_RECORD = new AllowableValue("insert-entire-record", "Insert Entire Record", "The entire Record that is retrieved from the Lookup Service will be inserted into the destination path.");
    static final AllowableValue RESULT_RECORD_FIELDS = new AllowableValue("record-fields", "Insert Record Fields", "All of the fields in the Record that is retrieved from the Lookup Service will be inserted into the destination path.");
    static final AllowableValue USE_PROPERTY = new AllowableValue("use-property", "Use \"Result RecordPath\" Property", "The \"Result RecordPath\" property will be used to determine which part of the record should be updated with the value returned by the Lookup Service");
    static final AllowableValue REPLACE_EXISTING_VALUES = new AllowableValue("replace-existing-values", "Replace Existing Values", "The \"Result RecordPath\" property will be ignored and the lookup service must be a single simple key lookup service. Every dynamic property value should be a record path. For each dynamic property, the value contained in the field corresponding to the record path will be used as the key in the Lookup Service and the value returned by the Lookup Service will be used to replace the existing value. It is possible to configure multiple dynamic properties to replace multiple values in one execution. This strategy only supports simple types replacements (strings, integers, etc).");
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("record-reader").displayName("Record Reader").description("Specifies the Controller Service to use for reading incoming data").identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("record-writer").displayName("Record Writer").description("Specifies the Controller Service to use for writing out the records").identifiesControllerService(RecordSetWriterFactory.class).required(true).build();
    static final PropertyDescriptor LOOKUP_SERVICE = new PropertyDescriptor.Builder().name("lookup-service").displayName("Lookup Service").description("The Lookup Service to use in order to lookup a value in each Record").identifiesControllerService(LookupService.class).required(true).build();
    static final PropertyDescriptor ROOT_RECORD_PATH = new PropertyDescriptor.Builder().name("Root Record Path").description("A RecordPath that points to a child Record within each of the top-level Records in the FlowFile. If specified, the additional RecordPath properties will be evaluated against this child Record instead of the top-level Record. This allows for performing enrichment against multiple child Records within a single top-level Record.").addValidator((Validator)new RecordPathValidator()).required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor RESULT_CONTENTS = new PropertyDescriptor.Builder().name("result-contents").displayName("Record Result Contents").description("When a result is obtained that contains a Record, this property determines whether the Record itself is inserted at the configured path or if the contents of the Record (i.e., the sub-fields) will be inserted at the configured path.").allowableValues(new DescribedValue[]{RESULT_ENTIRE_RECORD, RESULT_RECORD_FIELDS}).defaultValue(RESULT_ENTIRE_RECORD.getValue()).required(true).build();
    static final PropertyDescriptor ROUTING_STRATEGY = new PropertyDescriptor.Builder().name("routing-strategy").displayName("Routing Strategy").description("Specifies how to route records after a Lookup has completed").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new DescribedValue[]{ROUTE_TO_SUCCESS, ROUTE_TO_MATCHED_UNMATCHED}).defaultValue(ROUTE_TO_SUCCESS.getValue()).required(true).build();
    static final PropertyDescriptor REPLACEMENT_STRATEGY = new PropertyDescriptor.Builder().name("record-update-strategy").displayName("Record Update Strategy").description("This property defines the strategy to use when updating the record with the value returned by the Lookup Service.").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new DescribedValue[]{REPLACE_EXISTING_VALUES, USE_PROPERTY}).defaultValue(USE_PROPERTY.getValue()).required(true).build();
    static final PropertyDescriptor RESULT_RECORD_PATH = new PropertyDescriptor.Builder().name("result-record-path").displayName("Result RecordPath").description("A RecordPath that points to the field whose value should be updated with whatever value is returned from the Lookup Service. If not specified, the value that is returned from the Lookup Service will be ignored, except for determining whether the FlowFile should be routed to the 'matched' or 'unmatched' Relationship.").addValidator((Validator)new RecordPathValidator()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(REPLACEMENT_STRATEGY, new AllowableValue[]{USE_PROPERTY}).required(false).build();
    static final PropertyDescriptor CACHE_SIZE = new PropertyDescriptor.Builder().name("record-path-lookup-miss-result-cache-size").displayName("Cache Size").description("Specifies how many lookup values/records should be cached.Setting this property to zero means no caching will be done and the table will be queried for each lookup value in each record. If the lookup table changes often or the most recent data must be retrieved, do not use the cache.").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("0").required(true).build();
    static final Relationship REL_MATCHED = new Relationship.Builder().name("matched").description("All records for which the lookup returns a value will be routed to this relationship").build();
    static final Relationship REL_UNMATCHED = new Relationship.Builder().name("unmatched").description("All records for which the lookup does not have a matching value will be routed to this relationship").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All records will be sent to this Relationship if configured to do so, unless a failure occurs").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile cannot be enriched, the unchanged FlowFile will be routed to this relationship").build();
    private static final Set<Relationship> MATCHED_COLLECTION = Collections.singleton(REL_MATCHED);
    private static final Set<Relationship> UNMATCHED_COLLECTION = Collections.singleton(REL_UNMATCHED);
    private static final Set<Relationship> SUCCESS_COLLECTION = Collections.singleton(REL_SUCCESS);
    private volatile Set<Relationship> relationships = new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE));
    private volatile boolean routeToMatchedUnmatched = false;

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.lookupService = (LookupService)context.getProperty(LOOKUP_SERVICE).asControllerService(LookupService.class);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(RECORD_READER);
        properties.add(RECORD_WRITER);
        properties.add(LOOKUP_SERVICE);
        properties.add(ROOT_RECORD_PATH);
        properties.add(ROUTING_STRATEGY);
        properties.add(RESULT_CONTENTS);
        properties.add(REPLACEMENT_STRATEGY);
        properties.add(RESULT_RECORD_PATH);
        properties.add(CACHE_SIZE);
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("A RecordPath that points to the field whose value will be looked up in the configured Lookup Service").addValidator((Validator)new RecordPathValidator()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        Set dynamicPropNames = validationContext.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).map(PropertyDescriptor::getName).collect(Collectors.toSet());
        if (dynamicPropNames.isEmpty()) {
            return Collections.singleton(new ValidationResult.Builder().subject("User-Defined Properties").valid(false).explanation("At least one user-defined property must be specified.").build());
        }
        Set requiredKeys = ((LookupService)validationContext.getProperty(LOOKUP_SERVICE).asControllerService(LookupService.class)).getRequiredKeys();
        if (validationContext.getProperty(REPLACEMENT_STRATEGY).getValue().equals(REPLACE_EXISTING_VALUES.getValue())) {
            if (requiredKeys.size() != 1) {
                return Collections.singleton(new ValidationResult.Builder().subject(LOOKUP_SERVICE.getDisplayName()).valid(false).explanation("When using \"" + REPLACE_EXISTING_VALUES.getDisplayName() + "\" as Record Update Strategy, only a Lookup Service requiring a single key can be used.").build());
            }
        } else {
            Set missingKeys = requiredKeys.stream().filter(key -> !dynamicPropNames.contains(key)).collect(Collectors.toSet());
            if (!missingKeys.isEmpty()) {
                ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
                for (String missingKey : missingKeys) {
                    ValidationResult result = new ValidationResult.Builder().subject(missingKey).valid(false).explanation("The configured Lookup Services requires that a key be provided with the name '" + missingKey + "'. Please add a new property to this Processor with a name '" + missingKey + "' and provide a RecordPath that can be used to retrieve the appropriate value.").build();
                    validationResults.add(result);
                }
                return validationResults;
            }
        }
        return Collections.emptyList();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (ROUTING_STRATEGY.equals((Object)descriptor)) {
            if (ROUTE_TO_MATCHED_UNMATCHED.getValue().equalsIgnoreCase(newValue)) {
                HashSet<Relationship> matchedUnmatchedRels = new HashSet<Relationship>();
                matchedUnmatchedRels.add(REL_MATCHED);
                matchedUnmatchedRels.add(REL_UNMATCHED);
                matchedUnmatchedRels.add(REL_FAILURE);
                this.relationships = matchedUnmatchedRels;
                this.routeToMatchedUnmatched = true;
            } else {
                HashSet<Relationship> successRels = new HashSet<Relationship>();
                successRels.add(REL_SUCCESS);
                successRels.add(REL_FAILURE);
                this.relationships = successRels;
                this.routeToMatchedUnmatched = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(final ProcessContext context, ProcessSession session) throws ProcessException {
        RecordSetWriter writer;
        RecordSchema enrichedSchema;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        final RecordReaderFactory readerFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        final RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        final FlowFile original = flowFile;
        final Map originalAttributes = original.getAttributes();
        final LookupContext lookupContext = this.createLookupContext(flowFile, context, session, writerFactory);
        final ReplacementStrategy replacementStrategy = this.createReplacementStrategy(context);
        String rootPath = context.getProperty(ROOT_RECORD_PATH).evaluateAttributeExpressions(flowFile).getValue();
        final RecordPath rootRecordPath = rootPath == null ? null : this.recordPathCache.getCompiled(rootPath);
        try {
            enrichedSchema = replacementStrategy.determineResultSchema(readerFactory, rootRecordPath, context, session, flowFile, lookupContext);
        }
        catch (Exception e) {
            this.getLogger().error("Could not determine schema to use for enriched FlowFiles", (Throwable)e);
            session.transfer(original, REL_FAILURE);
            return;
        }
        try {
            session.read(flowFile, new InputStreamCallback(){

                public void process(InputStream in) throws IOException {
                    try (RecordReader reader = readerFactory.createRecordReader(originalAttributes, in, original.getSize(), LookupRecord.this.getLogger());){
                        Record record;
                        HashMap<Relationship, RecordSchema> writeSchemas = new HashMap<Relationship, RecordSchema>();
                        while ((record = reader.nextRecord()) != null) {
                            List<Record> subRecords = LookupRecord.this.getSubRecords(record, rootRecordPath);
                            HashSet<MatchResult> matchResults = new HashSet<MatchResult>();
                            for (Record subRecord : subRecords) {
                                MatchResult matchResult = replacementStrategy.lookup(subRecord, context, lookupContext);
                                matchResults.add(matchResult);
                            }
                            record.incorporateInactiveFields();
                            Set<Relationship> relationships = LookupRecord.this.getRelationships(matchResults);
                            for (Relationship relationship : relationships) {
                                RecordSchema writeSchema = (RecordSchema)writeSchemas.get(relationship);
                                if (writeSchema == null) {
                                    RecordSchema outputSchema = enrichedSchema == null ? record.getSchema() : enrichedSchema;
                                    writeSchema = writerFactory.getSchema(originalAttributes, outputSchema);
                                    writeSchemas.put(relationship, writeSchema);
                                }
                                RecordSetWriter writer = lookupContext.getRecordWriterForRelationship(relationship, writeSchema);
                                writer.write(record);
                            }
                        }
                    }
                    catch (SchemaNotFoundException | MalformedRecordException e) {
                        throw new ProcessException("Could not parse incoming data", e);
                    }
                }
            });
            for (Relationship relationship : lookupContext.getRelationshipsUsed()) {
                writer = lookupContext.getExistingRecordWriterForRelationship(relationship);
                FlowFile childFlowFile = lookupContext.getFlowFileForRelationship(relationship);
                WriteResult writeResult = writer.finishRecordSet();
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    this.getLogger().warn("Failed to close Writer for {}", new Object[]{childFlowFile});
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("record.count", String.valueOf(writeResult.getRecordCount()));
                attributes.put(CoreAttributes.MIME_TYPE.key(), writer.getMimeType());
                attributes.putAll(writeResult.getAttributes());
                childFlowFile = session.putAllAttributes(childFlowFile, attributes);
                session.transfer(childFlowFile, relationship);
                session.adjustCounter("Records Processed", (long)writeResult.getRecordCount(), false);
                session.adjustCounter("Records Routed to " + relationship.getName(), (long)writeResult.getRecordCount(), false);
                session.getProvenanceReporter().route(childFlowFile, relationship);
            }
        }
        catch (Exception e) {
            RecordSetWriter writer2;
            try {
                this.getLogger().error("Failed to process {}", new Object[]{flowFile, e});
                for (Relationship relationship : lookupContext.getRelationshipsUsed()) {
                    writer2 = lookupContext.getExistingRecordWriterForRelationship(relationship);
                    FlowFile childFlowFile = lookupContext.getFlowFileForRelationship(relationship);
                    try {
                        writer2.close();
                    }
                    catch (Exception e1) {
                        this.getLogger().warn("Failed to close Writer for {}; some resources may not be cleaned up appropriately", new Object[]{writer2});
                    }
                    session.remove(childFlowFile);
                }
                session.transfer(flowFile, REL_FAILURE);
            }
            catch (Throwable throwable) {
                for (Relationship relationship : lookupContext.getRelationshipsUsed()) {
                    RecordSetWriter writer3 = lookupContext.getExistingRecordWriterForRelationship(relationship);
                    try {
                        writer3.close();
                    }
                    catch (Exception e2) {
                        this.getLogger().warn("Failed to close Record Writer for {}; some resources may not be properly cleaned up", new Object[]{writer3, e2});
                    }
                }
                throw throwable;
            }
            for (Relationship relationship : lookupContext.getRelationshipsUsed()) {
                writer2 = lookupContext.getExistingRecordWriterForRelationship(relationship);
                try {
                    writer2.close();
                }
                catch (Exception e3) {
                    this.getLogger().warn("Failed to close Record Writer for {}; some resources may not be properly cleaned up", new Object[]{writer2, e3});
                }
            }
            return;
        }
        for (Relationship relationship : lookupContext.getRelationshipsUsed()) {
            writer = lookupContext.getExistingRecordWriterForRelationship(relationship);
            try {
                writer.close();
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to close Record Writer for {}; some resources may not be properly cleaned up", new Object[]{writer, e});
            }
        }
        session.remove(flowFile);
        this.getLogger().info("Successfully processed {}, creating {} derivative FlowFiles and processing {} records", new Object[]{flowFile, lookupContext.getRelationshipsUsed().size(), replacementStrategy.getLookupCount()});
    }

    private List<Record> getSubRecords(Record record, RecordPath rootRecordPath) {
        if (rootRecordPath == null) {
            return List.of(record);
        }
        return rootRecordPath.evaluate(record).getSelectedFields().map(FieldValue::getValue).flatMap(val -> {
            Object selector0$temp = val;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object[].class, Iterable.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    Object[] recordArray = (Object[])selector0$temp;
                    yield Arrays.stream(recordArray);
                }
                case 1 -> {
                    Iterable iterable = (Iterable)selector0$temp;
                    yield StreamSupport.stream(iterable.spliterator(), false);
                }
                default -> Stream.of(val);
            };
        }).filter(val -> val instanceof Record).map(Record.class::cast).toList();
    }

    private Set<Relationship> getRelationships(Set<MatchResult> matchResults) {
        if (matchResults.contains((Object)MatchResult.SOME_MATCH) || matchResults.contains((Object)MatchResult.ALL_MATCH) && matchResults.contains((Object)MatchResult.NONE_MATCH)) {
            return this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
        }
        if (matchResults.contains((Object)MatchResult.ALL_MATCH)) {
            return this.routeToMatchedUnmatched ? MATCHED_COLLECTION : SUCCESS_COLLECTION;
        }
        return this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
    }

    private ReplacementStrategy createReplacementStrategy(ProcessContext context) {
        boolean isInPlaceReplacement = context.getProperty(REPLACEMENT_STRATEGY).getValue().equals(REPLACE_EXISTING_VALUES.getValue());
        if (isInPlaceReplacement) {
            return new InPlaceReplacementStrategy();
        }
        return new RecordPathReplacementStrategy(context);
    }

    protected LookupContext createLookupContext(FlowFile flowFile, ProcessContext context, ProcessSession session, RecordSetWriterFactory writerFactory) {
        RecordPath resultRecordPath;
        HashMap<String, RecordPath> recordPaths = new HashMap<String, RecordPath>();
        for (PropertyDescriptor prop : context.getProperties().keySet()) {
            if (!prop.isDynamic()) continue;
            String pathText = context.getProperty(prop).evaluateAttributeExpressions(flowFile).getValue();
            RecordPath lookupRecordPath = this.recordPathCache.getCompiled(pathText);
            recordPaths.put(prop.getName(), lookupRecordPath);
        }
        if (context.getProperty(RESULT_RECORD_PATH).isSet()) {
            String resultPathText = context.getProperty(RESULT_RECORD_PATH).evaluateAttributeExpressions(flowFile).getValue();
            resultRecordPath = this.recordPathCache.getCompiled(resultPathText);
        } else {
            resultRecordPath = null;
        }
        return new LookupContext(recordPaths, resultRecordPath, session, flowFile, writerFactory, this.getLogger());
    }

    static /* synthetic */ ComponentLog access$300(LookupRecord x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$400(LookupRecord x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$500(LookupRecord x0) {
        return x0.getLogger();
    }

    protected static class LookupContext {
        private final Map<String, RecordPath> recordPathsByCoordinateKey;
        private final RecordPath resultRecordPath;
        private final ProcessSession session;
        private final FlowFile flowFile;
        private final RecordSetWriterFactory writerFactory;
        private final ComponentLog logger;
        private final Map<Relationship, Tuple<FlowFile, RecordSetWriter>> writersByRelationship = new HashMap<Relationship, Tuple<FlowFile, RecordSetWriter>>();

        public LookupContext(Map<String, RecordPath> recordPathsByCoordinateKey, RecordPath resultRecordPath, ProcessSession session, FlowFile flowFile, RecordSetWriterFactory writerFactory, ComponentLog logger) {
            this.recordPathsByCoordinateKey = recordPathsByCoordinateKey;
            this.resultRecordPath = resultRecordPath;
            this.session = session;
            this.flowFile = flowFile;
            this.writerFactory = writerFactory;
            this.logger = logger;
        }

        public Map<String, RecordPath> getRecordPathsByCoordinateKey() {
            return this.recordPathsByCoordinateKey;
        }

        public RecordPath getResultRecordPath() {
            return this.resultRecordPath;
        }

        public FlowFile getOriginalFlowFile() {
            return this.flowFile;
        }

        private Set<Relationship> getRelationshipsUsed() {
            return this.writersByRelationship.keySet();
        }

        public FlowFile getFlowFileForRelationship(Relationship relationship) {
            Tuple<FlowFile, RecordSetWriter> tuple = this.writersByRelationship.get(relationship);
            return (FlowFile)tuple.getKey();
        }

        public RecordSetWriter getExistingRecordWriterForRelationship(Relationship relationship) {
            Tuple<FlowFile, RecordSetWriter> tuple = this.writersByRelationship.get(relationship);
            return (RecordSetWriter)tuple.getValue();
        }

        public RecordSetWriter getRecordWriterForRelationship(Relationship relationship, RecordSchema schema) throws IOException, SchemaNotFoundException {
            Tuple<FlowFile, RecordSetWriter> tuple = this.writersByRelationship.get(relationship);
            if (tuple != null) {
                return (RecordSetWriter)tuple.getValue();
            }
            FlowFile outFlowFile = this.session.create(this.flowFile);
            OutputStream out = this.session.write(outFlowFile);
            try {
                RecordSchema recordWriteSchema = this.writerFactory.getSchema(this.flowFile.getAttributes(), schema);
                RecordSetWriter recordSetWriter = this.writerFactory.createWriter(this.logger, recordWriteSchema, out, outFlowFile);
                recordSetWriter.beginRecordSet();
                this.writersByRelationship.put(relationship, (Tuple<FlowFile, RecordSetWriter>)new Tuple((Object)outFlowFile, (Object)recordSetWriter));
                return recordSetWriter;
            }
            catch (Exception e) {
                try {
                    out.close();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
                throw e;
            }
        }
    }

    private static interface ReplacementStrategy {
        public MatchResult lookup(Record var1, ProcessContext var2, LookupContext var3);

        public RecordSchema determineResultSchema(RecordReaderFactory var1, RecordPath var2, ProcessContext var3, ProcessSession var4, FlowFile var5, LookupContext var6) throws IOException, SchemaNotFoundException, MalformedRecordException, LookupFailureException;

        public int getLookupCount();
    }

    static enum MatchResult {
        ALL_MATCH,
        NONE_MATCH,
        SOME_MATCH;

    }

    private class InPlaceReplacementStrategy
    implements ReplacementStrategy {
        private int lookupCount = 0;

        private InPlaceReplacementStrategy() {
        }

        @Override
        public MatchResult lookup(Record record, ProcessContext context, LookupContext lookupContext) {
            ++this.lookupCount;
            Map<String, RecordPath> recordPaths = lookupContext.getRecordPathsByCoordinateKey();
            HashMap<String, Object> lookupCoordinates = new HashMap<String, Object>(recordPaths.size());
            String coordinateKey = (String)LookupRecord.this.lookupService.getRequiredKeys().iterator().next();
            FlowFile flowFile = lookupContext.getOriginalFlowFile();
            boolean hasUnmatchedValue = false;
            boolean hasMatchedValue = false;
            for (Map.Entry<String, RecordPath> entry : recordPaths.entrySet()) {
                RecordPath recordPath = entry.getValue();
                RecordPathResult pathResult = recordPath.evaluate(record);
                AtomicLong selectedFieldsCount = new AtomicLong(0L);
                List<FieldValue> lookupFieldValues = pathResult.getSelectedFields().filter(fieldVal -> {
                    selectedFieldsCount.incrementAndGet();
                    return fieldVal.getValue() != null;
                }).toList();
                if (selectedFieldsCount.get() == 0L) continue;
                if (lookupFieldValues.isEmpty()) {
                    Set<Relationship> rels = LookupRecord.this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                    LookupRecord.this.getLogger().debug("RecordPath for property '{}' did not match any fields in a record for {}; routing record to {}", new Object[]{coordinateKey, flowFile, rels});
                    return MatchResult.NONE_MATCH;
                }
                for (FieldValue fieldValue : lookupFieldValues) {
                    Optional lookupValueOption;
                    Object coordinateValue = DataTypeUtils.convertType((Object)fieldValue.getValue(), (DataType)fieldValue.getField().getDataType(), Optional.empty(), Optional.empty(), Optional.empty(), (String)fieldValue.getField().getFieldName());
                    lookupCoordinates.clear();
                    lookupCoordinates.put(coordinateKey, coordinateValue);
                    try {
                        lookupValueOption = LookupRecord.this.lookupService.lookup(lookupCoordinates, flowFile.getAttributes());
                    }
                    catch (Exception e) {
                        throw new ProcessException("Failed to lookup coordinates " + String.valueOf(lookupCoordinates) + " in Lookup Service", (Throwable)e);
                    }
                    if (lookupValueOption.isEmpty()) {
                        hasUnmatchedValue = true;
                        continue;
                    }
                    hasMatchedValue = true;
                    Object lookupValue = lookupValueOption.get();
                    DataType inferredDataType = DataTypeUtils.inferDataType(lookupValue, (DataType)RecordFieldType.STRING.getDataType());
                    fieldValue.updateValue(lookupValue, inferredDataType);
                }
            }
            if (hasUnmatchedValue && hasMatchedValue) {
                return MatchResult.SOME_MATCH;
            }
            if (hasUnmatchedValue) {
                return MatchResult.NONE_MATCH;
            }
            return MatchResult.ALL_MATCH;
        }

        @Override
        public RecordSchema determineResultSchema(RecordReaderFactory readerFactory, RecordPath rootRecordPath, ProcessContext context, ProcessSession session, FlowFile flowFile, LookupContext lookupContext) throws IOException, SchemaNotFoundException, MalformedRecordException {
            try (InputStream in = session.read(flowFile);){
                RecordSchema recordSchema;
                block12: {
                    RecordReader reader = readerFactory.createRecordReader(flowFile, in, LookupRecord.this.getLogger());
                    try {
                        recordSchema = reader.getSchema();
                        if (reader == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                return recordSchema;
            }
        }

        @Override
        public int getLookupCount() {
            return this.lookupCount;
        }
    }

    private class RecordPathReplacementStrategy
    implements ReplacementStrategy {
        private int lookupCount = 0;
        private volatile Cache<Map<String, Object>, Optional<?>> cache;

        public RecordPathReplacementStrategy(ProcessContext context) {
            int cacheSize = context.getProperty(CACHE_SIZE).evaluateAttributeExpressions().asInteger();
            if (this.cache == null || cacheSize > 0) {
                this.cache = Caffeine.newBuilder().maximumSize((long)cacheSize).build();
            }
        }

        @Override
        public MatchResult lookup(Record record, ProcessContext context, LookupContext lookupContext) {
            Optional lookupValueOption;
            ++this.lookupCount;
            Map<String, Object> lookupCoordinates = this.createLookupCoordinates(record, lookupContext, true);
            if (lookupCoordinates.isEmpty()) {
                return MatchResult.NONE_MATCH;
            }
            FlowFile flowFile = lookupContext.getOriginalFlowFile();
            try {
                Optional lookupValueCacheOption = (Optional)this.cache.get(lookupCoordinates, k -> null);
                lookupValueOption = lookupValueCacheOption == null ? LookupRecord.this.lookupService.lookup(lookupCoordinates, flowFile.getAttributes()) : lookupValueCacheOption;
            }
            catch (Exception e) {
                throw new ProcessException("Failed to lookup coordinates " + String.valueOf(lookupCoordinates) + " in Lookup Service", (Throwable)e);
            }
            if (lookupValueOption.isEmpty()) {
                return MatchResult.NONE_MATCH;
            }
            this.applyLookupResult(record, context, lookupContext, lookupValueOption.get());
            return MatchResult.ALL_MATCH;
        }

        private void applyLookupResult(Record record, ProcessContext context, LookupContext lookupContext, Object lookupValue) {
            RecordPath resultPath = lookupContext.getResultRecordPath();
            if (resultPath != null) {
                RecordPathResult resultPathResult = resultPath.evaluate(record);
                String resultContentsValue = context.getProperty(RESULT_CONTENTS).getValue();
                if (RESULT_RECORD_FIELDS.getValue().equals(resultContentsValue) && lookupValue instanceof Record) {
                    Record lookupRecord = (Record)lookupValue;
                    resultPathResult.getSelectedFields().forEach(fieldVal -> {
                        Object destinationValue = fieldVal.getValue();
                        if (destinationValue instanceof Record) {
                            Record destinationRecord = (Record)destinationValue;
                            for (String fieldName : lookupRecord.getRawFieldNames()) {
                                Object value = lookupRecord.getValue(fieldName);
                                Optional recordFieldOption = lookupRecord.getSchema().getField(fieldName);
                                if (recordFieldOption.isPresent()) {
                                    RecordField field = (RecordField)recordFieldOption.get();
                                    if (!LookupRecord.this.routeToMatchedUnmatched && !field.isNullable()) {
                                        field = new RecordField(field.getFieldName(), field.getDataType(), field.getDefaultValue(), field.getAliases(), true);
                                    }
                                    destinationRecord.setValue(field, value);
                                    continue;
                                }
                                destinationRecord.setValue(fieldName, value);
                            }
                        } else {
                            Optional parentOption = fieldVal.getParentRecord();
                            parentOption.ifPresent(parent -> parent.setValue(fieldVal.getField(), (Object)lookupRecord));
                        }
                    });
                } else {
                    DataType inferredDataType = DataTypeUtils.inferDataType((Object)lookupValue, (DataType)RecordFieldType.STRING.getDataType());
                    resultPathResult.getSelectedFields().forEach(fieldVal -> fieldVal.updateValue(lookupValue, inferredDataType));
                }
                record.incorporateInactiveFields();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public RecordSchema determineResultSchema(RecordReaderFactory readerFactory, RecordPath rootRecordPath, ProcessContext context, ProcessSession session, FlowFile flowFile, LookupContext lookupContext) throws IOException, SchemaNotFoundException, MalformedRecordException, LookupFailureException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 13[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Map<String, Object> createLookupCoordinates(Record record, LookupContext lookupContext, boolean logIfNotMatched) {
            Map<String, RecordPath> recordPaths = lookupContext.getRecordPathsByCoordinateKey();
            HashMap<String, Object> lookupCoordinates = new HashMap<String, Object>(recordPaths.size());
            FlowFile flowFile = lookupContext.getOriginalFlowFile();
            for (Map.Entry<String, RecordPath> entry : recordPaths.entrySet()) {
                Set<Relationship> rels;
                String coordinateKey = entry.getKey();
                RecordPath recordPath = entry.getValue();
                RecordPathResult pathResult = recordPath.evaluate(record);
                List<FieldValue> lookupFieldValues = pathResult.getSelectedFields().filter(fieldVal -> fieldVal.getValue() != null).toList();
                if (lookupFieldValues.isEmpty()) {
                    if (logIfNotMatched) {
                        rels = LookupRecord.this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                        LookupRecord.this.getLogger().debug("RecordPath for property '{}' did not match any fields in a record for {}; routing record to {}", new Object[]{coordinateKey, flowFile, rels});
                    }
                    return Collections.emptyMap();
                }
                if (lookupFieldValues.size() > 1) {
                    if (logIfNotMatched) {
                        rels = LookupRecord.this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                        LookupRecord.this.getLogger().debug("RecordPath for property '{}' matched {} fields in a record for {}; routing record to {}", new Object[]{coordinateKey, lookupFieldValues.size(), flowFile, rels});
                    }
                    return Collections.emptyMap();
                }
                FieldValue fieldValue = lookupFieldValues.getFirst();
                RecordField field = fieldValue.getField();
                DataType desiredType = field == null ? DataTypeUtils.inferDataType((Object)fieldValue.getValue(), (DataType)RecordFieldType.STRING.getDataType()) : field.getDataType();
                String fieldName = field == null ? coordinateKey : field.getFieldName();
                Object coordinateValue = DataTypeUtils.convertType((Object)fieldValue.getValue(), (DataType)desiredType, Optional.empty(), Optional.empty(), Optional.empty(), (String)fieldName);
                lookupCoordinates.put(coordinateKey, coordinateValue);
            }
            return lookupCoordinates;
        }

        @Override
        public int getLookupCount() {
            return this.lookupCount;
        }
    }
}

