/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.DefaultRunDuration;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.DynamicRelationship;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.MultiProcessorUseCase;
import org.apache.nifi.annotation.documentation.ProcessorConfiguration;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.documentation.UseCases;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.PartitionRecord;

@SideEffectFree
@SupportsBatching(defaultDuration=DefaultRunDuration.TWENTY_FIVE_MILLIS)
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"attributes", "routing", "Attribute Expression Language", "regexp", "regex", "Regular Expression", "Expression Language", "find", "text", "string", "search", "filter", "detect"})
@CapabilityDescription(value="Routes FlowFiles based on their Attributes using the Attribute Expression Language")
@DynamicProperty(name="Relationship Name", value="Expression Language expression that returns a boolean value indicating whether or not the FlowFile should be routed to this Relationship", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Routes FlowFiles whose attributes match the Expression Language specified in the Dynamic Property Value to the Relationship specified in the Dynamic Property Key")
@DynamicRelationship(name="Name from Dynamic Property", description="FlowFiles that match the Dynamic Property's Attribute Expression Language")
@WritesAttributes(value={@WritesAttribute(attribute="RouteOnAttribute.Route", description="The relation to which the FlowFile was routed")})
@UseCases(value={@UseCase(description="Route data to one or more relationships based on its attributes using the NiFi Expression Language.", keywords={"attributes", "routing", "expression language"}, configuration="Set the \"Routing Strategy\" property to \"Route to Property name\".\nFor each route that a FlowFile might be routed to, add a new property. The name of the property should describe the route.\nThe value of the property is an Attribute Expression Language expression that returns a boolean value indicating whether or not a given FlowFile will be routed to the associated relationship.\n\nFor example, we might route data based on its file extension using the following properties:\n    - \"Routing Strategy\" = \"Route to Property Name\"\n    - \"jpg\" = \"${filename:endsWith('.jpg')}\"\n    - \"png\" = \"${filename:endsWith('.png')}\"\n    - \"pdf\" = \"${filename:endsWith('.pdf')}\"\n\nThe Processor will now have 3 relationships: `jpg`, `png`, and `pdf`. Each of these should be connected to the appropriate downstream processor.\n"), @UseCase(description="Keep data only if its attributes meet some criteria, such as its filename ends with .txt.", keywords={"keep", "filter", "remove", "delete", "expression language"}, configuration="Add a new property for each condition that must be satisfied in order to keep the data.\nIf the data should be kept in the case that any of the provided conditions is met, set the \"Routing Strategy\" property to \"Route to 'matched' if any matches\".\nIf all conditions must be met in order to keep the data, set the \"Routing Strategy\" property  to \"Route to 'matched' if all match\".\n\nFor example, to keep files whose filename ends with .txt and have a file size of at least 1000 bytes, we will use the following properties:\n    - \"ends_with_txt\" = \"${filename:endsWith('.txt')}\"\n    - \"large_enough\" = \"${fileSize:ge(1000)}\n    - \"Routing Strategy\" = \"Route to 'matched' if all match\"\n\nAuto-terminate the 'unmatched' relationship.\nConnect the 'matched' relationship to the next processor in the flow.\n"), @UseCase(description="Discard or drop a file based on attributes, such as filename.", keywords={"discard", "drop", "filter", "remove", "delete", "expression language"}, configuration="Add a new property for each condition that must be satisfied in order to drop the data.\nIf the data should be dropped in the case that any of the provided conditions is met, set the \"Routing Strategy\" property to \"Route to 'matched' if any matches\".\nIf all conditions must be met in order to drop the data, set the \"Routing Strategy\" property  to \"Route to 'matched' if all match\".\n\nHere are a couple of examples for configuring the properties:\n    Example 1 Use Case: Data should be dropped if its \"uuid\" attribute has an 'a' in it or ends with '0'.\n      Here, we will use the following properties:\n        - \"has_a\" = \"${uuid:contains('a')}\"\n        - \"ends_with_0\" = \"${uuid:endsWith('0')}\n        - \"Routing Strategy\" = \"Route to 'matched' if any matches\"\n    Example 2 Use Case: Data should be dropped if its 'uuid' attribute has an 'a' AND it ends with a '1'.\n      Here, we will use the following properties:\n        - \"has_a\" = \"${uuid:contains('a')}\"\n        - \"ends_with_1\" = \"${uuid:endsWith('1')}\n        - \"Routing Strategy\" = \"Route to 'matched' if all match\"\n\nAuto-terminate the 'matched' relationship.\nConnect the 'unmatched' relationship to the next processor in the flow.\n")})
@MultiProcessorUseCase(description="Route record-oriented data based on whether or not the record's values meet some criteria", keywords={"record", "route", "content", "data"}, configurations={@ProcessorConfiguration(processorClass=PartitionRecord.class, configuration="Choose a RecordReader that is appropriate based on the format of the incoming data.\nChoose a RecordWriter that writes the data in the desired output format.\n\nAdd a single additional property. The name of the property should describe the criteria to route on. The property's value should be a RecordPath that returns `true` if the Record meets the criteria or `false` otherwise. This adds a new attribute to the FlowFile whose name is equal to the property name.\n\nConnect the 'success' Relationship to RouteOnAttribute.\n"), @ProcessorConfiguration(processorClass=RouteOnAttribute.class, configuration="Set \"Routing Strategy\" to \"Route to Property name\"\n\nAdd two additional properties. For the first one, the name of the property should describe data that matches the criteria. The value is an Expression Language expression that checks if the attribute added by the PartitionRecord processor has a value of `true`. For example, `${criteria:equals('true')}`.\nThe second property should have a name that describes data that does not match the criteria. The value is an Expression Language that evaluates to the opposite of the first property value. For example, `${criteria:equals('true'):not()}`.\n\nConnect each of the newly created Relationships to the appropriate downstream processors.\n")})
public class RouteOnAttribute
extends AbstractProcessor {
    public static final String ROUTE_ATTRIBUTE_KEY = "RouteOnAttribute.Route";
    private static final String routeAllMatchValue = "Route to 'match' if all match";
    private static final String routeAnyMatches = "Route to 'match' if any matches";
    private static final String routePropertyNameValue = "Route to Property name";
    public static final AllowableValue ROUTE_PROPERTY_NAME = new AllowableValue("Route to Property name", "Route to Property name", "A copy of the FlowFile will be routed to each relationship whose corresponding expression evaluates to 'true'");
    public static final AllowableValue ROUTE_ALL_MATCH = new AllowableValue("Route to 'match' if all match", "Route to 'matched' if all match", "Requires that all user-defined expressions evaluate to 'true' for the FlowFile to be considered a match");
    public static final AllowableValue ROUTE_ANY_MATCHES = new AllowableValue("Route to 'match' if any matches", "Route to 'matched' if any matches", "Requires that at least one user-defined expression evaluate to 'true' for the FlowFile to be considered a match");
    public static final PropertyDescriptor ROUTE_STRATEGY = new PropertyDescriptor.Builder().name("Routing Strategy").description("Specifies how to determine which relationship to use when evaluating the Expression Language").required(true).allowableValues(new DescribedValue[]{ROUTE_PROPERTY_NAME, ROUTE_ALL_MATCH, ROUTE_ANY_MATCHES}).defaultValue(ROUTE_PROPERTY_NAME.getValue()).build();
    public static final Relationship REL_NO_MATCH = new Relationship.Builder().name("unmatched").description("FlowFiles that do not match any user-define expression will be routed here").build();
    public static final Relationship REL_MATCH = new Relationship.Builder().name("matched").description("FlowFiles will be routed to 'match' if one or all Expressions match, depending on the configuration of the Routing Strategy property").build();
    private AtomicReference<Set<Relationship>> relationships = new AtomicReference();
    private List<PropertyDescriptor> properties;
    private volatile String configuredRouteStrategy = ROUTE_STRATEGY.getDefaultValue();
    private volatile Set<String> dynamicPropertyNames = new HashSet<String>();
    private volatile Map<Relationship, PropertyValue> propertyMap = new HashMap<Relationship, PropertyValue>();

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> set = new HashSet<Relationship>();
        set.add(REL_NO_MATCH);
        this.relationships = new AtomicReference(set);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(ROUTE_STRATEGY);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships.get();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().required(false).name(propertyDescriptorName).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.BOOLEAN, (boolean)false)).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.equals((Object)ROUTE_STRATEGY)) {
            this.configuredRouteStrategy = newValue;
        } else {
            HashSet<String> newDynamicPropertyNames = new HashSet<String>(this.dynamicPropertyNames);
            if (newValue == null) {
                newDynamicPropertyNames.remove(descriptor.getName());
            } else if (oldValue == null) {
                newDynamicPropertyNames.add(descriptor.getName());
            }
            this.dynamicPropertyNames = Collections.unmodifiableSet(newDynamicPropertyNames);
        }
        Set<String> allDynamicProps = this.dynamicPropertyNames;
        HashSet<Relationship> newRelationships = new HashSet<Relationship>();
        String routeStrategy = this.configuredRouteStrategy;
        if (ROUTE_PROPERTY_NAME.equals((Object)routeStrategy)) {
            for (String propName : allDynamicProps) {
                newRelationships.add(new Relationship.Builder().name(propName).build());
            }
        } else {
            newRelationships.add(REL_MATCH);
        }
        newRelationships.add(REL_NO_MATCH);
        this.relationships.set(newRelationships);
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        HashMap<Relationship, PropertyValue> newPropertyMap = new HashMap<Relationship, PropertyValue>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            this.getLogger().debug("Adding new dynamic property: {}", new Object[]{descriptor});
            newPropertyMap.put(new Relationship.Builder().name(descriptor.getName()).build(), context.getProperty(descriptor));
        }
        this.propertyMap = newPropertyMap;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        Map<Relationship, PropertyValue> propMap = this.propertyMap;
        HashSet<Relationship> matchingRelationships = new HashSet<Relationship>();
        for (Map.Entry<Relationship, PropertyValue> entry : propMap.entrySet()) {
            PropertyValue value = entry.getValue();
            boolean matches = value.evaluateAttributeExpressions(flowFile).asBoolean();
            if (!matches) continue;
            matchingRelationships.add((Relationship)entry.getKey());
        }
        HashSet<Relationship> destinationRelationships = new HashSet<Relationship>();
        switch (context.getProperty(ROUTE_STRATEGY).getValue()) {
            case "Route to 'match' if all match": {
                if (matchingRelationships.size() == propMap.size()) {
                    destinationRelationships.add(REL_MATCH);
                    break;
                }
                destinationRelationships.add(REL_NO_MATCH);
                break;
            }
            case "Route to 'match' if any matches": {
                if (matchingRelationships.isEmpty()) {
                    destinationRelationships.add(REL_NO_MATCH);
                    break;
                }
                destinationRelationships.add(REL_MATCH);
                break;
            }
            default: {
                destinationRelationships.addAll(matchingRelationships);
            }
        }
        if (destinationRelationships.isEmpty()) {
            logger.info("Routing {} to unmatched", new Object[]{flowFile});
            flowFile = session.putAttribute(flowFile, ROUTE_ATTRIBUTE_KEY, REL_NO_MATCH.getName());
            session.getProvenanceReporter().route(flowFile, REL_NO_MATCH);
            session.transfer(flowFile, REL_NO_MATCH);
        } else {
            Iterator relationshipNameIterator = destinationRelationships.iterator();
            Relationship firstRelationship = (Relationship)relationshipNameIterator.next();
            HashMap<Relationship, FlowFile> transferMap = new HashMap<Relationship, FlowFile>();
            while (relationshipNameIterator.hasNext()) {
                Relationship relationship = (Relationship)relationshipNameIterator.next();
                FlowFile cloneFlowFile = session.clone(flowFile);
                transferMap.put(relationship, cloneFlowFile);
            }
            for (Map.Entry entry : transferMap.entrySet()) {
                logger.info("Cloned {} into {} and routing clone to relationship {}", new Object[]{flowFile, entry.getValue(), entry.getKey()});
                FlowFile updatedFlowFile = session.putAttribute((FlowFile)entry.getValue(), ROUTE_ATTRIBUTE_KEY, ((Relationship)entry.getKey()).getName());
                session.getProvenanceReporter().route(updatedFlowFile, (Relationship)entry.getKey());
                session.transfer(updatedFlowFile, (Relationship)entry.getKey());
            }
            logger.info("Routing {} to {}", new Object[]{flowFile, firstRelationship});
            session.getProvenanceReporter().route(flowFile, firstRelationship);
            flowFile = session.putAttribute(flowFile, ROUTE_ATTRIBUTE_KEY, firstRelationship.getName());
            session.transfer(flowFile, firstRelationship);
        }
    }
}

