/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.hash;

import java.util.Arrays;
import java.util.List;

public enum HashAlgorithm {
    MD2("MD2", 16, "Cryptographically broken due to collisions"),
    MD5("MD5", 16, "Cryptographically broken due to collisions"),
    SHA1("SHA-1", 20, "Cryptographically broken due to collisions"),
    SHA224("SHA-224", 28, "SHA-2 family"),
    SHA256("SHA-256", 32, "SHA-2 family"),
    SHA384("SHA-384", 48, "SHA-2 family"),
    SHA512("SHA-512", 64, "SHA-2 family"),
    SHA512_224("SHA-512/224", 28, "SHA-2 using SHA-512 with truncated output"),
    SHA512_256("SHA-512/256", 32, "SHA-2 using SHA-512 with truncated output"),
    SHA3_224("SHA3-224", 28, "Keccak-based SHA3 family"),
    SHA3_256("SHA3-256", 32, "Keccak-based SHA3 family"),
    SHA3_384("SHA3-384", 48, "Keccak-based SHA3 family"),
    SHA3_512("SHA3-512", 64, "Keccak-based SHA3 family"),
    BLAKE2_160("BLAKE2-160", 20, "Also known as Blake2b"),
    BLAKE2_256("BLAKE2-256", 32, "Also known as Blake2b"),
    BLAKE2_384("BLAKE2-384", 48, "Also known as Blake2b"),
    BLAKE2_512("BLAKE2-512", 64, "Also known as Blake2b");

    private final String name;
    private final int digestBytesLength;
    private final String description;
    private static final List<String> BROKEN_ALGORITHMS;

    private HashAlgorithm(String name, int digestBytesLength, String description) {
        this.name = name;
        this.digestBytesLength = digestBytesLength;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public int getDigestBytesLength() {
        return this.digestBytesLength;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isStrongAlgorithm() {
        return !BROKEN_ALGORITHMS.contains(this.name);
    }

    public boolean isBlake2() {
        return this.name.contains("BLAKE2");
    }

    public String toString() {
        return "HashAlgorithm[Name=%s,Digest Length=%d bytes,Description=%s".formatted(this.name, this.digestBytesLength, this.description);
    }

    public String buildAllowableValueDescription() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(" (").append(this.digestBytesLength).append(" byte output)");
        if (!this.isStrongAlgorithm()) {
            sb.append(" [WARNING -- Cryptographically broken]");
        }
        if (this.description != null && !this.description.isBlank()) {
            sb.append(" ").append(this.description);
        }
        return sb.toString();
    }

    public static HashAlgorithm fromName(String algorithmName) {
        HashAlgorithm match = Arrays.stream(HashAlgorithm.values()).filter(algo -> algorithmName.equalsIgnoreCase(algo.name)).findAny().orElse(null);
        if (match == null) {
            throw new IllegalArgumentException("No algorithm matches " + algorithmName);
        }
        return match;
    }

    static {
        BROKEN_ALGORITHMS = Arrays.asList(HashAlgorithm.MD2.name, HashAlgorithm.MD5.name, HashAlgorithm.SHA1.name);
    }
}

