/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;

public class HortonworksAttributeSchemaReferenceStrategy
implements SchemaAccessStrategy {
    private final Set<SchemaField> schemaFields;
    public static final String SCHEMA_ID_ATTRIBUTE = "schema.identifier";
    public static final String SCHEMA_VERSION_ATTRIBUTE = "schema.version";
    public static final String SCHEMA_PROTOCOL_VERSION_ATTRIBUTE = "schema.protocol.version";
    private final SchemaRegistry schemaRegistry;

    public HortonworksAttributeSchemaReferenceStrategy(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
        this.schemaFields = new HashSet<SchemaField>();
        this.schemaFields.add(SchemaField.SCHEMA_IDENTIFIER);
        this.schemaFields.add(SchemaField.SCHEMA_VERSION);
        this.schemaFields.addAll(schemaRegistry == null ? Collections.emptySet() : schemaRegistry.getSuppliedSchemaFields());
    }

    public boolean isFlowFileRequired() {
        return true;
    }

    @Override
    public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) throws SchemaNotFoundException, IOException {
        String schemaIdentifier = variables.get(SCHEMA_ID_ATTRIBUTE);
        String schemaVersion = variables.get(SCHEMA_VERSION_ATTRIBUTE);
        String schemaProtocol = variables.get(SCHEMA_PROTOCOL_VERSION_ATTRIBUTE);
        if (schemaIdentifier == null || schemaVersion == null || schemaProtocol == null) {
            throw new SchemaNotFoundException("Could not determine Schema for " + variables + " because it is missing one of the following three required attributes: " + SCHEMA_ID_ATTRIBUTE + ", " + SCHEMA_VERSION_ATTRIBUTE + ", " + SCHEMA_PROTOCOL_VERSION_ATTRIBUTE);
        }
        if (!HortonworksAttributeSchemaReferenceStrategy.isNumber(schemaProtocol)) {
            throw new SchemaNotFoundException("Could not determine Schema for " + variables + " because the " + SCHEMA_PROTOCOL_VERSION_ATTRIBUTE + " has a value of '" + schemaProtocol + "', which is not a valid Protocol Version number");
        }
        int protocol = Integer.parseInt(schemaProtocol);
        if (protocol != 1) {
            throw new SchemaNotFoundException("Could not determine Schema for " + variables + " because the " + SCHEMA_PROTOCOL_VERSION_ATTRIBUTE + " has a value of '" + schemaProtocol + "', which is not a valid Protocol Version number. Expected Protocol Version to be 1.");
        }
        if (!HortonworksAttributeSchemaReferenceStrategy.isNumber(schemaIdentifier)) {
            throw new SchemaNotFoundException("Could not determine Schema for " + variables + " because the " + SCHEMA_ID_ATTRIBUTE + " has a value of '" + schemaProtocol + "', which is not a valid Schema Identifier number");
        }
        if (!HortonworksAttributeSchemaReferenceStrategy.isNumber(schemaVersion)) {
            throw new SchemaNotFoundException("Could not determine Schema for " + variables + " because the " + SCHEMA_VERSION_ATTRIBUTE + " has a value of '" + schemaProtocol + "', which is not a valid Schema Version number");
        }
        long schemaId = Long.parseLong(schemaIdentifier);
        int version = Integer.parseInt(schemaVersion);
        SchemaIdentifier identifier = SchemaIdentifier.builder().id(Long.valueOf(schemaId)).version(Integer.valueOf(version)).build();
        RecordSchema schema = this.schemaRegistry.retrieveSchema(identifier);
        if (schema == null) {
            throw new SchemaNotFoundException("Could not find a Schema in the Schema Registry with Schema Identifier '" + schemaId + "' and Version '" + version + "'");
        }
        return schema;
    }

    private static boolean isNumber(String value) {
        if (value == null) {
            return false;
        }
        String trimmed = value.trim();
        if (value.isEmpty()) {
            return false;
        }
        for (int i = 0; i < trimmed.length(); ++i) {
            char c = value.charAt(i);
            if (c <= '9' && c >= '0') continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<SchemaField> getSuppliedSchemaFields() {
        return this.schemaFields;
    }
}

