/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.access;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;

public class HortonworksAttributeSchemaReferenceWriter
implements SchemaAccessWriter {
    private static final Set<SchemaField> requiredSchemaFields = EnumSet.of(SchemaField.SCHEMA_IDENTIFIER, SchemaField.SCHEMA_VERSION);
    static final int LATEST_PROTOCOL_VERSION = 1;
    static final String SCHEMA_BRANCH_ATTRIBUTE = "schema.branch";

    @Override
    public void writeHeader(RecordSchema schema, OutputStream out) throws IOException {
    }

    @Override
    public Map<String, String> getAttributes(RecordSchema schema) {
        HashMap<String, String> attributes = new HashMap<String, String>(4);
        SchemaIdentifier id = schema.getIdentifier();
        Long schemaId = id.getIdentifier().getAsLong();
        Integer schemaVersion = id.getVersion().getAsInt();
        attributes.put("schema.identifier", String.valueOf(schemaId));
        attributes.put("schema.version", String.valueOf(schemaVersion));
        attributes.put("schema.protocol.version", String.valueOf(1));
        if (id.getBranch().isPresent()) {
            attributes.put(SCHEMA_BRANCH_ATTRIBUTE, (String)id.getBranch().get());
        }
        return attributes;
    }

    @Override
    public void validateSchema(RecordSchema schema) throws SchemaNotFoundException {
        SchemaIdentifier id = schema.getIdentifier();
        if (!id.getIdentifier().isPresent()) {
            throw new SchemaNotFoundException("Cannot write Schema Reference as Attributes because it does not contain a Schema Identifier");
        }
        if (!id.getVersion().isPresent()) {
            throw new SchemaNotFoundException("Cannot write Schema Reference as Attributes because it does not contain a Schema Version");
        }
    }

    @Override
    public Set<SchemaField> getRequiredSchemaFields() {
        return requiredSchemaFields;
    }
}

