/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.validation;

import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.nifi.schema.validation.SchemaValidationContext;
import org.apache.nifi.schema.validation.StandardSchemaValidationResult;
import org.apache.nifi.schema.validation.StandardValidationError;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.serialization.record.validation.RecordSchemaValidator;
import org.apache.nifi.serialization.record.validation.SchemaValidationResult;
import org.apache.nifi.serialization.record.validation.ValidationError;
import org.apache.nifi.serialization.record.validation.ValidationErrorType;

public class StandardSchemaValidator
implements RecordSchemaValidator {
    private final SchemaValidationContext validationContext;

    public StandardSchemaValidator(SchemaValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    public SchemaValidationResult validate(Record record) {
        return this.validate(record, this.validationContext.getSchema(), "");
    }

    private SchemaValidationResult validate(Record record, RecordSchema schema, String fieldPrefix) {
        StandardSchemaValidationResult result = new StandardSchemaValidationResult();
        for (RecordField field : schema.getFields()) {
            DataType canonicalDataType;
            Object rawValue = record.getValue(field);
            if (rawValue == null) {
                if (field.isNullable() || field.getDefaultValue() != null) continue;
                result.addValidationError(new StandardValidationError(this.concat(fieldPrefix, field), ValidationErrorType.MISSING_FIELD, "Field is required"));
                continue;
            }
            DataType dataType = field.getDataType();
            if (this.validationContext.isStrictTypeChecking()) {
                if (!this.isTypeCorrect(rawValue, dataType)) {
                    result.addValidationError(new StandardValidationError(this.concat(fieldPrefix, field), rawValue, ValidationErrorType.INVALID_FIELD, "Value is of type " + rawValue.getClass().getName() + " but was expected to be of type " + dataType));
                    continue;
                }
            } else if (!DataTypeUtils.isCompatibleDataType((Object)rawValue, (DataType)dataType)) {
                result.addValidationError(new StandardValidationError(this.concat(fieldPrefix, field), rawValue, ValidationErrorType.INVALID_FIELD, "Value is of type " + rawValue.getClass().getName() + " but was expected to be of type " + dataType));
                continue;
            }
            if ((canonicalDataType = this.getCanonicalDataType(dataType, rawValue, result, fieldPrefix, field)) == null) continue;
            this.verifyComplexType(dataType, rawValue, result, fieldPrefix, field);
        }
        if (!this.validationContext.isExtraFieldAllowed()) {
            for (String fieldName : record.getRawFieldNames()) {
                if (schema.getDataType(fieldName).isPresent()) continue;
                result.addValidationError(new StandardValidationError(fieldPrefix + "/" + fieldName, ValidationErrorType.EXTRA_FIELD, "Field is not present in the schema"));
            }
        }
        return result;
    }

    private void verifyComplexType(DataType dataType, Object rawValue, StandardSchemaValidationResult result, String fieldPrefix, RecordField field) {
        DataType canonicalDataType = this.getCanonicalDataType(dataType, rawValue, result, fieldPrefix, field);
        if (canonicalDataType == null) {
            return;
        }
        if (canonicalDataType.getFieldType() == RecordFieldType.RECORD) {
            this.verifyChildRecord(canonicalDataType, rawValue, dataType, result, field, fieldPrefix);
        }
        if (canonicalDataType.getFieldType() == RecordFieldType.ARRAY) {
            ArrayDataType arrayDataType = (ArrayDataType)canonicalDataType;
            DataType elementType = arrayDataType.getElementType();
            Object[] arrayObject = (Object[])rawValue;
            int i = 0;
            for (Object arrayValue : arrayObject) {
                this.verifyComplexType(elementType, arrayValue, result, fieldPrefix + "[" + i + "]", field);
                ++i;
            }
        }
    }

    private DataType getCanonicalDataType(DataType dataType, Object rawValue, StandardSchemaValidationResult result, String fieldPrefix, RecordField field) {
        DataType canonicalDataType;
        RecordFieldType fieldType = dataType.getFieldType();
        if (fieldType == RecordFieldType.CHOICE) {
            canonicalDataType = DataTypeUtils.chooseDataType((Object)rawValue, (ChoiceDataType)((ChoiceDataType)dataType));
            if (canonicalDataType == null) {
                result.addValidationError(new StandardValidationError(this.concat(fieldPrefix, field), rawValue, ValidationErrorType.INVALID_FIELD, "Value is of type " + rawValue.getClass().getName() + " but was expected to be of type " + dataType));
                return null;
            }
        } else {
            canonicalDataType = dataType;
        }
        return canonicalDataType;
    }

    private void verifyChildRecord(DataType canonicalDataType, Object rawValue, DataType expectedDataType, StandardSchemaValidationResult result, RecordField field, String fieldPrefix) {
        if (canonicalDataType.getFieldType() == RecordFieldType.RECORD) {
            String fullChildFieldName;
            if (!(rawValue instanceof Record)) {
                result.addValidationError(new StandardValidationError(this.concat(fieldPrefix, field), rawValue, ValidationErrorType.INVALID_FIELD, "Value is of type " + rawValue.getClass().getName() + " but was expected to be of type " + expectedDataType));
                return;
            }
            RecordDataType recordDataType = (RecordDataType)canonicalDataType;
            RecordSchema childSchema = recordDataType.getChildSchema();
            SchemaValidationResult childValidationResult = this.validate((Record)rawValue, childSchema, fullChildFieldName = this.concat(fieldPrefix, field));
            if (childValidationResult.isValid()) {
                return;
            }
            for (ValidationError validationError : childValidationResult.getValidationErrors()) {
                result.addValidationError(validationError);
            }
        }
    }

    private boolean isTypeCorrect(Object value, DataType dataType) {
        switch (dataType.getFieldType()) {
            case ARRAY: {
                Object[] array;
                if (!(value instanceof Object[])) {
                    return false;
                }
                ArrayDataType arrayDataType = (ArrayDataType)dataType;
                DataType elementType = arrayDataType.getElementType();
                for (Object arrayVal : array = (Object[])value) {
                    if (this.isTypeCorrect(arrayVal, elementType)) continue;
                    return false;
                }
                return true;
            }
            case MAP: {
                if (value instanceof Map) {
                    MapDataType mapDataType = (MapDataType)dataType;
                    DataType valueDataType = mapDataType.getValueType();
                    Map map = (Map)value;
                    for (Object mapValue : map.values()) {
                        if (this.isTypeCorrect(mapValue, valueDataType)) continue;
                        return false;
                    }
                    return true;
                }
                if (value instanceof Record) {
                    Record record = (Record)value;
                    MapDataType mapDataType = (MapDataType)dataType;
                    DataType valueDataType = mapDataType.getValueType();
                    for (String fieldName : record.getRawFieldNames()) {
                        Object fieldValue = record.getValue(fieldName);
                        if (this.isTypeCorrect(fieldValue, valueDataType)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            case RECORD: {
                return value instanceof Record;
            }
            case CHOICE: {
                ChoiceDataType choiceDataType = (ChoiceDataType)dataType;
                for (DataType choice : choiceDataType.getPossibleSubTypes()) {
                    if (!this.isTypeCorrect(value, choice)) continue;
                    return true;
                }
                return false;
            }
            case BIGINT: {
                return value instanceof BigInteger;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case BYTE: {
                return value instanceof Byte;
            }
            case CHAR: {
                return value instanceof Character;
            }
            case DATE: {
                return value instanceof Date;
            }
            case DOUBLE: {
                return value instanceof Double;
            }
            case FLOAT: {
                return value instanceof Float;
            }
            case INT: {
                return value instanceof Integer;
            }
            case LONG: {
                return value instanceof Long;
            }
            case SHORT: {
                return value instanceof Short;
            }
            case STRING: {
                return value instanceof String;
            }
            case TIME: {
                return value instanceof Time;
            }
            case TIMESTAMP: {
                return value instanceof Timestamp;
            }
        }
        return false;
    }

    private String concat(String fieldPrefix, RecordField field) {
        return fieldPrefix + "/" + field.getFieldName();
    }
}

