/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.record.listen;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.record.listen.IOUtils;
import org.apache.nifi.record.listen.SocketChannelRecordReader;
import org.apache.nifi.record.listen.SocketChannelRecordReaderDispatcher;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannel;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannelInputStream;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;

public class SSLSocketChannelRecordReader
implements SocketChannelRecordReader {
    private final SocketChannel socketChannel;
    private final SSLSocketChannel sslSocketChannel;
    private final RecordReaderFactory readerFactory;
    private final SocketChannelRecordReaderDispatcher dispatcher;
    private RecordReader recordReader;

    public SSLSocketChannelRecordReader(SocketChannel socketChannel, SSLSocketChannel sslSocketChannel, RecordReaderFactory readerFactory, SocketChannelRecordReaderDispatcher dispatcher) {
        this.socketChannel = socketChannel;
        this.sslSocketChannel = sslSocketChannel;
        this.readerFactory = readerFactory;
        this.dispatcher = dispatcher;
    }

    @Override
    public RecordReader createRecordReader(FlowFile flowFile, ComponentLog logger) throws IOException, MalformedRecordException, SchemaNotFoundException {
        if (this.recordReader != null) {
            throw new IllegalStateException("Cannot create RecordReader because already created");
        }
        SSLSocketChannelInputStream socketIn = new SSLSocketChannelInputStream(this.sslSocketChannel);
        BufferedInputStream in = new BufferedInputStream((InputStream)socketIn);
        this.recordReader = this.readerFactory.createRecordReader(flowFile, (InputStream)in, logger);
        return this.recordReader;
    }

    @Override
    public RecordReader getRecordReader() {
        return this.recordReader;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.socketChannel.socket().getInetAddress();
    }

    @Override
    public boolean isClosed() {
        return this.sslSocketChannel.isClosed();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.recordReader);
        IOUtils.closeQuietly((Closeable)this.sslSocketChannel);
        this.dispatcher.connectionCompleted();
    }
}

