/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.access;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.stream.io.StreamUtils;

public class ConfluentSchemaRegistryStrategy
implements SchemaAccessStrategy {
    private final Set<SchemaField> schemaFields;
    private final SchemaRegistry schemaRegistry;

    public ConfluentSchemaRegistryStrategy(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
        this.schemaFields = new HashSet<SchemaField>();
        this.schemaFields.add(SchemaField.SCHEMA_IDENTIFIER);
        this.schemaFields.add(SchemaField.SCHEMA_VERSION);
        this.schemaFields.addAll(schemaRegistry == null ? Collections.emptySet() : schemaRegistry.getSuppliedSchemaFields());
    }

    @Override
    public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) throws SchemaNotFoundException, IOException {
        byte[] buffer = new byte[5];
        try {
            StreamUtils.fillBuffer((InputStream)contentStream, (byte[])buffer);
        }
        catch (IOException ioe) {
            throw new SchemaNotFoundException("Could not read first 5 bytes from stream", (Throwable)ioe);
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        byte magicByte = bb.get();
        if (magicByte != 0) {
            throw new SchemaNotFoundException("Schema Encoding appears to be of an incompatible version. Expected stream to begin with a Magic Byte of 0 but first byte was " + magicByte);
        }
        int schemaId = bb.getInt();
        SchemaIdentifier schemaIdentifier = SchemaIdentifier.builder().id(Long.valueOf(schemaId)).version(Integer.valueOf(1)).build();
        return this.schemaRegistry.retrieveSchema(schemaIdentifier);
    }

    @Override
    public Set<SchemaField> getSuppliedSchemaFields() {
        return this.schemaFields;
    }
}

