/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.access;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;

public class ConfluentSchemaRegistryWriter
implements SchemaAccessWriter {
    private static final Set<SchemaField> requiredSchemaFields = EnumSet.of(SchemaField.SCHEMA_IDENTIFIER, SchemaField.SCHEMA_VERSION);

    @Override
    public void writeHeader(RecordSchema schema, OutputStream out) throws IOException {
        SchemaIdentifier identifier = schema.getIdentifier();
        Long id = identifier.getIdentifier().getAsLong();
        ByteBuffer bb = ByteBuffer.allocate(5);
        bb.put((byte)0);
        bb.putInt(id.intValue());
        out.write(bb.array());
    }

    @Override
    public Map<String, String> getAttributes(RecordSchema schema) {
        return Collections.emptyMap();
    }

    @Override
    public void validateSchema(RecordSchema schema) throws SchemaNotFoundException {
        SchemaIdentifier identifier = schema.getIdentifier();
        OptionalLong identifierOption = identifier.getIdentifier();
        if (!identifierOption.isPresent()) {
            throw new SchemaNotFoundException("Cannot write Confluent Schema Registry Reference because the Schema Identifier is not known");
        }
        OptionalInt versionOption = identifier.getVersion();
        if (!versionOption.isPresent()) {
            throw new SchemaNotFoundException("Cannot write Confluent Schema Registry Reference because the Schema Version is not known");
        }
    }

    @Override
    public Set<SchemaField> getRequiredSchemaFields() {
        return requiredSchemaFields;
    }
}

