/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.access;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;

public class SchemaNameAsAttribute
implements SchemaAccessWriter {
    private static final Set<SchemaField> schemaFields = EnumSet.of(SchemaField.SCHEMA_NAME);
    static final String SCHEMA_NAME_ATTRIBUTE = "schema.name";
    static final String SCHEMA_BRANCH_ATTRIBUTE = "schema.branch";
    static final String SCHEMA_VERSION_ATTRIBUTE = "schema.version";

    @Override
    public void writeHeader(RecordSchema schema, OutputStream out) throws IOException {
    }

    @Override
    public Map<String, String> getAttributes(RecordSchema schema) {
        Optional branchOption;
        OptionalInt versionOption;
        HashMap<String, String> attributes = new HashMap<String, String>(3);
        SchemaIdentifier identifier = schema.getIdentifier();
        Optional nameOption = identifier.getName();
        if (nameOption.isPresent()) {
            attributes.put(SCHEMA_NAME_ATTRIBUTE, (String)nameOption.get());
        }
        if ((versionOption = identifier.getVersion()).isPresent()) {
            attributes.put(SCHEMA_VERSION_ATTRIBUTE, String.valueOf(versionOption.getAsInt()));
        }
        if ((branchOption = identifier.getBranch()).isPresent()) {
            attributes.put(SCHEMA_BRANCH_ATTRIBUTE, (String)branchOption.get());
        }
        return attributes;
    }

    @Override
    public void validateSchema(RecordSchema schema) throws SchemaNotFoundException {
        SchemaIdentifier schemaId = schema.getIdentifier();
        if (schemaId == null) {
            throw new SchemaNotFoundException("Cannot write Schema Name As Attribute because Schema Identifier is not known");
        }
        if (!schemaId.getName().isPresent()) {
            throw new SchemaNotFoundException("Cannot write Schema Name As Attribute because the Schema Name is not known");
        }
    }

    @Override
    public Set<SchemaField> getRequiredSchemaFields() {
        return schemaFields;
    }
}

