/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.access;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;

public class SchemaNamePropertyStrategy
implements SchemaAccessStrategy {
    private final Set<SchemaField> schemaFields;
    private final SchemaRegistry schemaRegistry;
    private final PropertyValue schemaNamePropertyValue;
    private final PropertyValue schemaBranchNamePropertyValue;
    private final PropertyValue schemaVersionPropertyValue;

    public SchemaNamePropertyStrategy(SchemaRegistry schemaRegistry, PropertyValue schemaNamePropertyValue, PropertyValue schemaBranchNamePropertyValue, PropertyValue schemaVersionPropertyValue) {
        this.schemaRegistry = schemaRegistry;
        this.schemaNamePropertyValue = schemaNamePropertyValue;
        this.schemaBranchNamePropertyValue = schemaBranchNamePropertyValue;
        this.schemaVersionPropertyValue = schemaVersionPropertyValue;
        this.schemaFields = new HashSet<SchemaField>();
        this.schemaFields.add(SchemaField.SCHEMA_NAME);
        this.schemaFields.addAll(schemaRegistry == null ? Collections.emptySet() : schemaRegistry.getSuppliedSchemaFields());
    }

    @Override
    public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) throws SchemaNotFoundException {
        String schemaName = this.schemaNamePropertyValue.evaluateAttributeExpressions(variables).getValue();
        if (schemaName.trim().isEmpty()) {
            throw new SchemaNotFoundException(String.format("%s did not provide appropriate Schema Name", this.schemaNamePropertyValue));
        }
        try {
            RecordSchema recordSchema;
            String schemaBranchName = this.schemaBranchNamePropertyValue.evaluateAttributeExpressions(variables).getValue();
            String schemaVersion = this.schemaVersionPropertyValue.evaluateAttributeExpressions(variables).getValue();
            SchemaIdentifier.Builder identifierBuilder = SchemaIdentifier.builder();
            identifierBuilder.name(schemaName);
            if (!StringUtils.isBlank((CharSequence)schemaBranchName)) {
                identifierBuilder.branch(schemaBranchName);
            }
            if (!StringUtils.isBlank((CharSequence)schemaVersion)) {
                try {
                    identifierBuilder.version(Integer.valueOf(schemaVersion));
                }
                catch (NumberFormatException nfe) {
                    throw new SchemaNotFoundException("Could not retrieve schema with name '" + schemaName + "' because a non-numeric version was supplied '" + schemaVersion + "'", (Throwable)nfe);
                }
            }
            if ((recordSchema = this.schemaRegistry.retrieveSchema(identifierBuilder.build())) == null) {
                throw new SchemaNotFoundException("Could not find a schema with name '" + schemaName + "' in the configured Schema Registry");
            }
            return recordSchema;
        }
        catch (SchemaNotFoundException snf) {
            throw snf;
        }
        catch (Exception e) {
            throw new SchemaNotFoundException("Could not retrieve schema with name '" + schemaName + "' from the configured Schema Registry", (Throwable)e);
        }
    }

    @Override
    public Set<SchemaField> getSuppliedSchemaFields() {
        return this.schemaFields;
    }
}

