/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.validation;

import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.serialization.record.validation.ValidationError;
import org.apache.nifi.serialization.record.validation.ValidationErrorType;

public class StandardValidationError
implements ValidationError {
    private final Optional<String> fieldName;
    private final Optional<Object> inputValue;
    private final String explanation;
    private final ValidationErrorType type;

    public StandardValidationError(String fieldName, Object value, ValidationErrorType type, String explanation) {
        this.fieldName = Optional.ofNullable(fieldName);
        this.inputValue = Optional.ofNullable(value);
        this.type = type;
        this.explanation = explanation;
    }

    public StandardValidationError(String fieldName, ValidationErrorType type, String explanation) {
        this.fieldName = Optional.ofNullable(fieldName);
        this.inputValue = Optional.empty();
        this.type = type;
        this.explanation = Objects.requireNonNull(explanation);
    }

    public StandardValidationError(ValidationErrorType type, String explanation) {
        this.fieldName = Optional.empty();
        this.inputValue = Optional.empty();
        this.type = type;
        this.explanation = Objects.requireNonNull(explanation);
    }

    public ValidationErrorType getType() {
        return this.type;
    }

    public Optional<String> getFieldName() {
        return this.fieldName;
    }

    public Optional<Object> getInputValue() {
        return this.inputValue;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String toString() {
        if (this.fieldName.isPresent()) {
            if (this.inputValue.isPresent()) {
                Object input = this.inputValue.get();
                if (input instanceof Object[]) {
                    StringBuilder sb = new StringBuilder("[");
                    Object[] array = (Object[])input;
                    for (int i = 0; i < array.length; ++i) {
                        Object arrayValue = array[i];
                        if (arrayValue instanceof String) {
                            sb.append('\"').append(array[i]).append('\"');
                        } else {
                            sb.append(array[i]);
                        }
                        if (i >= array.length - 1) continue;
                        sb.append(", ");
                    }
                    sb.append("]");
                    return sb.toString() + " is not a valid value for " + this.fieldName.get() + ": " + this.explanation;
                }
                return this.inputValue.get() + " is not a valid value for " + this.fieldName.get() + ": " + this.explanation;
            }
            return this.fieldName.get() + " is invalid due to: " + this.explanation;
        }
        return this.explanation;
    }

    public int hashCode() {
        return 31 + 17 * this.fieldName.hashCode() + 17 * this.inputValue.hashCode() + 17 * this.explanation.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValidationError)) {
            return false;
        }
        ValidationError other = (ValidationError)obj;
        return this.getFieldName().equals(other.getFieldName()) && this.getInputValue().equals(other.getInputValue()) && this.getExplanation().equals(other.getExplanation());
    }
}

