/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.FlowFileAccessException;
import org.apache.nifi.processor.exception.FlowFileHandlingException;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceReporter;
import org.apache.nifi.stateless.core.ProvenanceCollector;
import org.apache.nifi.stateless.core.StatelessFlowFile;

public class StatelessProcessSession
implements ProcessSession {
    private final boolean materializeContent;
    private final Map<Relationship, Queue<StatelessFlowFile>> outputMap = new HashMap<Relationship, Queue<StatelessFlowFile>>();
    private final Queue<StatelessFlowFile> inputQueue;
    private final Set<Long> beingProcessed = new HashSet<Long>();
    private final List<StatelessFlowFile> penalized = new ArrayList<StatelessFlowFile>();
    private final Processor processor;
    private final Map<Long, StatelessFlowFile> currentVersions = new HashMap<Long, StatelessFlowFile>();
    private final Map<Long, StatelessFlowFile> originalVersions = new HashMap<Long, StatelessFlowFile>();
    private final Map<String, Long> counterMap = new HashMap<String, Long>();
    private final ProvenanceCollector provenanceReporter;
    private boolean committed = false;
    private boolean rolledback = false;
    private final Set<Long> removedFlowFiles = new HashSet<Long>();
    private static final AtomicLong enqueuedIndex = new AtomicLong(0L);
    private final Runnable nextStep;

    public StatelessProcessSession(Queue<StatelessFlowFile> input, Collection<ProvenanceEventRecord> events, Processor processor, Set<Relationship> outputRelationships, boolean materializeContent, Runnable nextStep) {
        this.processor = processor;
        this.inputQueue = input;
        this.provenanceReporter = new ProvenanceCollector(this, events, processor.getIdentifier(), processor.getClass().getSimpleName());
        this.materializeContent = materializeContent;
        this.nextStep = nextStep;
        outputRelationships.forEach(r -> {
            Queue cfr_ignored_0 = this.outputMap.put((Relationship)r, new LinkedList());
        });
    }

    public StatelessFlowFile putAllAttributes(FlowFile flowFile, Map<String, String> attrs) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (attrs == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("Cannot update attributes of a flow file that I did not create");
        }
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, this.materializeContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.putAttributes(attrs);
        return newFlowFile;
    }

    public StatelessFlowFile putAttribute(FlowFile flowFile, String attrName, String attrValue) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (attrName == null || attrValue == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("Cannot update attributes of a flow file that I did not create");
        }
        if ("uuid".equals(attrName)) {
            throw new IllegalArgumentException("Should not be attempting to set FlowFile UUID via putAttribute");
        }
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, this.materializeContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(attrName, attrValue);
        newFlowFile.putAttributes(attrs);
        return newFlowFile;
    }

    public StatelessFlowFile removeAllAttributes(FlowFile flowFile, Set<String> attrNames) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (attrNames == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, this.materializeContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.removeAttributes(attrNames);
        return newFlowFile;
    }

    public StatelessFlowFile removeAllAttributes(FlowFile flowFile, Pattern keyPattern) {
        if ((flowFile = this.validateState((FlowFile)flowFile)) == null) {
            throw new IllegalArgumentException("flowFile cannot be null");
        }
        if (keyPattern == null) {
            return (StatelessFlowFile)flowFile;
        }
        HashSet<String> attrsToRemove = new HashSet<String>();
        for (String key : flowFile.getAttributes().keySet()) {
            if (!keyPattern.matcher(key).matches()) continue;
            attrsToRemove.add(key);
        }
        return this.removeAllAttributes((FlowFile)flowFile, (Set<String>)attrsToRemove);
    }

    public StatelessFlowFile removeAttribute(FlowFile flowFile, String attrName) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (attrName == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, this.materializeContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        HashSet<String> attrNames = new HashSet<String>();
        attrNames.add(attrName);
        newFlowFile.removeAttributes(attrNames);
        return newFlowFile;
    }

    private FlowFile inheritAttributes(FlowFile source, FlowFile destination) {
        if (source == null || destination == null || source == destination) {
            return destination;
        }
        StatelessFlowFile updated = this.putAllAttributes(destination, (Map<String, String>)source.getAttributes());
        this.getProvenanceReporter().fork(source, Collections.singletonList(updated));
        return updated;
    }

    private FlowFile inheritAttributes(Collection<FlowFile> sources, FlowFile destination) {
        StatelessFlowFile updated = this.putAllAttributes(destination, StatelessProcessSession.intersectAttributes(sources));
        this.getProvenanceReporter().join(sources, (FlowFile)updated);
        return updated;
    }

    private static Map<String, String> intersectAttributes(Collection<FlowFile> flowFileList) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (flowFileList == null || flowFileList.isEmpty()) {
            return result;
        }
        if (flowFileList.size() == 1) {
            result.putAll(flowFileList.iterator().next().getAttributes());
        }
        Map firstMap = flowFileList.iterator().next().getAttributes();
        block0: for (Map.Entry mapEntry : firstMap.entrySet()) {
            String key = (String)mapEntry.getKey();
            String value = (String)mapEntry.getValue();
            for (FlowFile flowFile : flowFileList) {
                Map currMap = flowFile.getAttributes();
                String curVal = (String)currMap.get(key);
                if (curVal != null && curVal.equals(value)) continue;
                continue block0;
            }
            result.put(key, value);
        }
        return result;
    }

    public void migrate(ProcessSession newOwner, Collection<FlowFile> flowFiles) {
        Collection<FlowFile> statelessFlowFiles = flowFiles;
        StatelessProcessSession newStatelessOwner = (StatelessProcessSession)newOwner;
        if (Objects.requireNonNull(newOwner) == this) {
            throw new IllegalArgumentException("Cannot migrate FlowFiles from a Process Session to itself");
        }
        if (flowFiles == null || flowFiles.isEmpty()) {
            throw new IllegalArgumentException("Must supply at least one FlowFile to migrate");
        }
        if (!(newOwner instanceof StatelessProcessSession)) {
            throw new IllegalArgumentException("Cannot migrate from a org.apache.nifi.stateless.core.StatelessProcessSession to a session of type " + newOwner.getClass());
        }
        for (StatelessFlowFile statelessFlowFile : statelessFlowFiles) {
            StatelessFlowFile currentVersion = this.currentVersions.get(statelessFlowFile.getId());
            if (currentVersion != null) continue;
            throw new FlowFileHandlingException(statelessFlowFile + " is not known in this session");
        }
        for (Map.Entry entry : this.outputMap.entrySet()) {
            Relationship relationship = (Relationship)entry.getKey();
            Queue transferredFlowFiles = (Queue)entry.getValue();
            for (StatelessFlowFile statelessFlowFile : statelessFlowFiles) {
                if (!transferredFlowFiles.remove(statelessFlowFile)) continue;
                newStatelessOwner.outputMap.computeIfAbsent(relationship, rel -> new LinkedList()).add(statelessFlowFile);
            }
        }
        for (StatelessFlowFile statelessFlowFile : statelessFlowFiles) {
            if (this.beingProcessed.remove(statelessFlowFile.getId())) {
                newStatelessOwner.beingProcessed.add(statelessFlowFile.getId());
            }
            if (this.penalized.remove(statelessFlowFile)) {
                newStatelessOwner.penalized.add(statelessFlowFile);
            }
            if (this.currentVersions.containsKey(statelessFlowFile.getId())) {
                newStatelessOwner.currentVersions.put(statelessFlowFile.getId(), this.currentVersions.remove(statelessFlowFile.getId()));
            }
            if (this.originalVersions.containsKey(statelessFlowFile.getId())) {
                newStatelessOwner.originalVersions.put(statelessFlowFile.getId(), this.originalVersions.remove(statelessFlowFile.getId()));
            }
            if (!this.removedFlowFiles.remove(statelessFlowFile.getId())) continue;
            newStatelessOwner.removedFlowFiles.add(statelessFlowFile.getId());
        }
        Set<String> flowFileIds = flowFiles.stream().map(ff -> ff.getAttribute(CoreAttributes.UUID.key())).collect(Collectors.toSet());
        this.provenanceReporter.migrate(newStatelessOwner.provenanceReporter, flowFileIds);
    }

    public void adjustCounter(String name, long delta, boolean immediate) {
        Long counter;
        if (immediate) {
            // empty if block
        }
        if ((counter = this.counterMap.get(name)) == null) {
            counter = delta;
            this.counterMap.put(name, counter);
            return;
        }
        counter = counter + delta;
        this.counterMap.put(name, counter);
    }

    public void remove(FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        Iterator<StatelessFlowFile> penalizedItr = this.penalized.iterator();
        while (penalizedItr.hasNext()) {
            StatelessFlowFile ff = penalizedItr.next();
            if (!Objects.equals(ff.getId(), flowFile.getId())) continue;
            penalizedItr.remove();
            this.penalized.remove(ff);
            break;
        }
        Iterator<Long> processedItr = this.beingProcessed.iterator();
        while (processedItr.hasNext()) {
            Long ffId = processedItr.next();
            if (ffId == null || !ffId.equals(flowFile.getId())) continue;
            processedItr.remove();
            this.beingProcessed.remove(ffId);
            this.removedFlowFiles.add(flowFile.getId());
            this.currentVersions.remove(ffId);
            return;
        }
        throw new ProcessException(flowFile + " not found in queue");
    }

    public void remove(Collection<FlowFile> flowFiles) {
        flowFiles = this.validateState(flowFiles);
        for (FlowFile flowFile : flowFiles) {
            this.remove(flowFile);
        }
    }

    public void rollback() {
        this.rollback(false);
    }

    public void rollback(boolean penalize) {
        if (this.committed) {
            return;
        }
        for (Queue<StatelessFlowFile> list : this.outputMap.values()) {
            for (StatelessFlowFile flowFile : list) {
                this.inputQueue.offer(flowFile);
                if (!penalize) continue;
                this.penalized.add(flowFile);
            }
        }
        for (Long flowFileId : this.beingProcessed) {
            StatelessFlowFile flowFile = this.originalVersions.get(flowFileId);
            if (flowFile == null) continue;
            this.inputQueue.offer(flowFile);
            if (!penalize) continue;
            this.penalized.add(flowFile);
        }
        this.rolledback = true;
        this.beingProcessed.clear();
        this.currentVersions.clear();
        this.originalVersions.clear();
        this.outputMap.clear();
        this.clearTransferState();
        if (!penalize) {
            this.penalized.clear();
        }
    }

    public void transfer(FlowFile flowFile) {
        if (!((flowFile = this.validateState((FlowFile)flowFile)) instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("I only accept org.apache.nifi.stateless.core.StatelessFlowFile");
        }
        if (this.currentVersions.get(flowFile.getId()) != null && this.originalVersions.get(flowFile.getId()) == null) {
            throw new IllegalArgumentException("Cannot transfer FlowFiles that are created in this Session back to self");
        }
        this.beingProcessed.remove(flowFile.getId());
        this.inputQueue.add((StatelessFlowFile)flowFile);
        this.updateLastQueuedDate((StatelessFlowFile)flowFile);
    }

    public void transfer(Collection<FlowFile> flowFiles) {
        flowFiles.forEach(this::transfer);
    }

    public void transfer(FlowFile flowFile, Relationship relationship) {
        if (relationship == Relationship.SELF) {
            this.transfer((FlowFile)flowFile);
            return;
        }
        if (!this.processor.getRelationships().contains(relationship)) {
            throw new IllegalArgumentException("this relationship " + relationship.getName() + " is not known");
        }
        flowFile = this.validateState((FlowFile)flowFile);
        if (this.outputMap.containsKey(relationship)) {
            Queue<StatelessFlowFile> queue = this.outputMap.get(relationship);
            queue.add((StatelessFlowFile)flowFile);
        }
        this.beingProcessed.remove(flowFile.getId());
        this.updateLastQueuedDate((StatelessFlowFile)flowFile);
    }

    public void transfer(Collection<FlowFile> flowFiles, Relationship relationship) {
        if (relationship == Relationship.SELF) {
            this.transfer(flowFiles);
            return;
        }
        for (FlowFile flowFile : flowFiles) {
            this.transfer(flowFile, relationship);
        }
    }

    public ProvenanceReporter getProvenanceReporter() {
        return this.provenanceReporter;
    }

    public StatelessFlowFile penalize(FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, this.materializeContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.setPenalized(true);
        this.penalized.add(newFlowFile);
        return newFlowFile;
    }

    public StatelessFlowFile create() {
        StatelessFlowFile flowFile = new StatelessFlowFile(this.materializeContent);
        this.currentVersions.put(flowFile.getId(), flowFile);
        this.beingProcessed.add(flowFile.getId());
        return flowFile;
    }

    public StatelessFlowFile create(FlowFile flowFile) {
        StatelessFlowFile newFlowFile = this.create();
        newFlowFile = (StatelessFlowFile)this.inheritAttributes(flowFile, (FlowFile)newFlowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        this.beingProcessed.add(newFlowFile.getId());
        return newFlowFile;
    }

    public StatelessFlowFile create(Collection<FlowFile> flowFiles) {
        StatelessFlowFile newFlowFile = this.create();
        newFlowFile = (StatelessFlowFile)this.inheritAttributes(flowFiles, (FlowFile)newFlowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        this.beingProcessed.add(newFlowFile.getId());
        return newFlowFile;
    }

    public StatelessFlowFile get() {
        StatelessFlowFile flowFile = this.inputQueue.poll();
        if (flowFile != null) {
            this.beingProcessed.add(flowFile.getId());
            this.currentVersions.put(flowFile.getId(), flowFile);
            this.originalVersions.put(flowFile.getId(), flowFile);
        }
        return flowFile;
    }

    public List<FlowFile> get(int maxResults) {
        ArrayList<FlowFile> flowFiles = new ArrayList<FlowFile>(Math.min(500, maxResults));
        for (int i = 0; i < maxResults; ++i) {
            StatelessFlowFile nextFlowFile = this.get();
            if (nextFlowFile == null) {
                return flowFiles;
            }
            flowFiles.add((FlowFile)nextFlowFile);
        }
        return flowFiles;
    }

    public List<FlowFile> get(FlowFileFilter filter) {
        StatelessFlowFile flowFile;
        ArrayList<FlowFile> flowFiles = new ArrayList<FlowFile>();
        ArrayList<StatelessFlowFile> unselected = new ArrayList<StatelessFlowFile>();
        while ((flowFile = this.inputQueue.poll()) != null) {
            FlowFileFilter.FlowFileFilterResult filterResult = filter.filter((FlowFile)flowFile);
            if (filterResult.isAccept()) {
                flowFiles.add((FlowFile)flowFile);
                this.beingProcessed.add(flowFile.getId());
                this.currentVersions.put(flowFile.getId(), flowFile);
                this.originalVersions.put(flowFile.getId(), flowFile);
            } else {
                unselected.add(flowFile);
            }
            if (filterResult.isContinue()) continue;
            break;
        }
        this.inputQueue.addAll(unselected);
        return flowFiles;
    }

    public QueueSize getQueueSize() {
        int count = this.inputQueue.size();
        long contentSize = 0L;
        for (StatelessFlowFile flowFile : this.inputQueue) {
            contentSize += flowFile.getSize();
        }
        return new QueueSize(count, contentSize);
    }

    public void commit() {
        if (!this.beingProcessed.isEmpty()) {
            throw new FlowFileHandlingException("Cannot commit session because the following FlowFiles have not been removed or transferred: " + this.beingProcessed);
        }
        this.committed = true;
        this.nextStep.run();
        this.beingProcessed.clear();
        this.currentVersions.clear();
        this.originalVersions.clear();
    }

    public StatelessFlowFile clone(FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, this.materializeContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        this.beingProcessed.add(newFlowFile.getId());
        return newFlowFile;
    }

    public StatelessFlowFile clone(FlowFile flowFile, long offset, long size) {
        flowFile = this.validateState((FlowFile)flowFile);
        try {
            ((StatelessFlowFile)flowFile).materializeData();
        }
        catch (IOException e) {
            throw new FlowFileHandlingException("Error materializing data", (Throwable)e);
        }
        if (offset + size > flowFile.getSize()) {
            throw new FlowFileHandlingException("Specified offset of " + offset + " and size " + size + " exceeds size of " + flowFile.toString());
        }
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, offset, size, this.materializeContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        this.beingProcessed.add(newFlowFile.getId());
        return newFlowFile;
    }

    public void exportTo(FlowFile flowFile, OutputStream out) {
        if ((flowFile = this.validateState((FlowFile)flowFile)) == null || out == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        if (!(flowFile instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        try {
            this.copyTo(((StatelessFlowFile)flowFile).getDataStream(), out);
        }
        catch (IOException e) {
            throw new FlowFileAccessException(e.toString(), (Throwable)e);
        }
    }

    public void exportTo(FlowFile flowFile, Path path, boolean append) {
        if ((flowFile = this.validateState((FlowFile)flowFile)) == null || path == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        StatelessFlowFile statelessFlowFile = (StatelessFlowFile)flowFile;
        StandardOpenOption mode = append ? StandardOpenOption.APPEND : StandardOpenOption.CREATE;
        try (OutputStream out = Files.newOutputStream(path, mode);){
            if (statelessFlowFile.materializeContent) {
                statelessFlowFile.materializeData();
            }
            this.copyTo(statelessFlowFile.getDataStream(), out);
        }
        catch (IOException e) {
            throw new FlowFileAccessException(e.toString(), (Throwable)e);
        }
    }

    public StatelessFlowFile importFrom(InputStream in, FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (in == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, this.materializeContent);
        newFlowFile.setData(in);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        return newFlowFile;
    }

    public StatelessFlowFile importFrom(Path path, boolean keepSourceFile, FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (path == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        if (!keepSourceFile) {
            throw new IllegalArgumentException("Not going to delete the file...");
        }
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, this.materializeContent);
        try {
            newFlowFile.setData(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new FlowFileAccessException(e.toString(), (Throwable)e);
        }
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile = this.putAttribute((FlowFile)newFlowFile, CoreAttributes.FILENAME.key(), path.getFileName().toString());
        return newFlowFile;
    }

    public void read(FlowFile flowFile, InputStreamCallback callback) {
        this.read(flowFile, false, callback);
    }

    public void read(FlowFile flowFile, boolean allowSessionStreamManagement, InputStreamCallback callback) {
        if (callback == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!((flowFile = this.validateState((FlowFile)flowFile)) instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        try {
            ((StatelessFlowFile)flowFile).materializeData();
            callback.process(((StatelessFlowFile)flowFile).getDataStream());
        }
        catch (IOException e) {
            throw new ProcessException(e.toString(), (Throwable)e);
        }
    }

    public InputStream read(FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        return ((StatelessFlowFile)flowFile).getDataStream();
    }

    public StatelessFlowFile write(FlowFile flowFile, OutputStreamCallback callback) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (!(flowFile instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            callback.process((OutputStream)baos);
        }
        catch (IOException e) {
            throw new ProcessException(e.toString(), (Throwable)e);
        }
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, this.materializeContent);
        newFlowFile.setData(baos.toByteArray());
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        return newFlowFile;
    }

    public OutputStream write(final FlowFile flowFile) {
        if (!(flowFile instanceof StatelessFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        this.validateState(flowFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, StatelessProcessSession.this.materializeContent);
                newFlowFile.setData(this.toByteArray());
                StatelessProcessSession.this.currentVersions.put(newFlowFile.getId(), newFlowFile);
            }
        };
        return baos;
    }

    public FlowFile append(FlowFile flowFile, OutputStreamCallback callback) {
        if (callback == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        StatelessFlowFile validatedFlowFile = this.validateState(flowFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            callback.process((OutputStream)baos);
        }
        catch (IOException e) {
            throw new ProcessException(e.toString(), (Throwable)e);
        }
        StatelessFlowFile newFlowFile = new StatelessFlowFile(validatedFlowFile, this.materializeContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.addData(baos.toByteArray());
        return newFlowFile;
    }

    public StatelessFlowFile write(FlowFile flowFile, StreamCallback callback) {
        if (callback == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        StatelessFlowFile statelessFlowFile = this.validateState(flowFile);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            callback.process(statelessFlowFile.getDataStream(), (OutputStream)out);
        }
        catch (IOException e) {
            throw new ProcessException(e.toString(), (Throwable)e);
        }
        StatelessFlowFile newFlowFile = new StatelessFlowFile(statelessFlowFile, this.materializeContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.setData(out.toByteArray());
        return newFlowFile;
    }

    public StatelessFlowFile merge(Collection<FlowFile> sources, FlowFile destination) {
        sources = this.validateState(sources);
        destination = this.validateState((FlowFile)destination);
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)destination, this.materializeContent);
        for (FlowFile flowFile : sources) {
            newFlowFile.addData(((StatelessFlowFile)flowFile).getDataStream());
        }
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        return newFlowFile;
    }

    public StatelessFlowFile merge(Collection<FlowFile> sources, FlowFile destination, byte[] header, byte[] footer, byte[] demarcator) {
        List<FlowFile> statelessSources = this.validateState(sources);
        StatelessFlowFile statelessDestination = this.validateState(destination);
        if (header != null) {
            statelessDestination.addData(header);
        }
        int count = 0;
        for (StatelessFlowFile statelessFlowFile : statelessSources) {
            statelessDestination.addData(statelessFlowFile.getDataStream());
            if (demarcator == null || ++count == sources.size()) continue;
            statelessDestination.addData(demarcator);
        }
        if (footer != null) {
            statelessDestination.addData(footer);
        }
        StatelessFlowFile newFlowFile = new StatelessFlowFile(statelessDestination, this.materializeContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        return newFlowFile;
    }

    public StatelessFlowFile unpenalize(FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        StatelessFlowFile newFlowFile = new StatelessFlowFile((StatelessFlowFile)flowFile, this.materializeContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.setPenalized(false);
        this.penalized.remove(newFlowFile);
        return newFlowFile;
    }

    boolean isFlowFileKnown(FlowFile flowFile) {
        String providedUuid;
        FlowFile curFlowFile = (FlowFile)this.currentVersions.get(flowFile.getId());
        if (curFlowFile == null) {
            return false;
        }
        String curUuid = curFlowFile.getAttribute(CoreAttributes.UUID.key());
        return curUuid.equals(providedUuid = curFlowFile.getAttribute(CoreAttributes.UUID.key()));
    }

    private List<FlowFile> validateState(Collection<FlowFile> flowFiles) {
        return flowFiles.stream().map(this::validateState).collect(Collectors.toList());
    }

    private StatelessFlowFile validateState(FlowFile flowFile) {
        Objects.requireNonNull(flowFile);
        StatelessFlowFile currentVersion = this.currentVersions.get(flowFile.getId());
        if (currentVersion == null) {
            throw new FlowFileHandlingException(flowFile + " is not known in this session");
        }
        for (Queue<StatelessFlowFile> flowFiles : this.outputMap.values()) {
            if (!flowFiles.contains(flowFile)) continue;
            throw new IllegalStateException(flowFile + " has already been transferred");
        }
        return currentVersion;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isRolledback() {
        return this.rolledback;
    }

    public boolean isInputQueueEmpty() {
        return this.inputQueue.isEmpty();
    }

    public boolean areAllFlowFilesTransfered(Relationship relationship) {
        return !this.outputMap.containsKey(relationship) || this.outputMap.get(relationship).isEmpty();
    }

    public void clearTransferState() {
        this.outputMap.clear();
    }

    public int getRemovedCount() {
        return this.removedFlowFiles.size();
    }

    public Queue<StatelessFlowFile> getAndRemoveFlowFilesForRelationship(String relationship) {
        Relationship procRel = new Relationship.Builder().name(relationship).build();
        return this.getAndRemoveFlowFilesForRelationship(procRel);
    }

    public Queue<StatelessFlowFile> getAndRemoveFlowFilesForRelationship(Relationship relationship) {
        Queue<StatelessFlowFile> queue = this.outputMap.get(relationship);
        if (queue == null) {
            queue = new LinkedList<StatelessFlowFile>();
        }
        this.outputMap.remove(relationship);
        return queue;
    }

    public List<StatelessFlowFile> getPenalizedFlowFiles() {
        return this.penalized;
    }

    private void updateLastQueuedDate(StatelessFlowFile StatelessFlowFile2) {
        StatelessFlowFile2.setLastEnqueuedDate(System.currentTimeMillis());
        StatelessFlowFile2.setEnqueuedIndex(enqueuedIndex.incrementAndGet());
    }

    private void copyTo(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[0x100000];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }
}

