/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.FlowFileHandlingException;
import org.apache.nifi.provenance.ProvenanceEventBuilder;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.ProvenanceReporter;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.stateless.core.StatelessProcessSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvenanceCollector
implements ProvenanceReporter {
    private static final Logger logger = LoggerFactory.getLogger(ProvenanceCollector.class);
    private final StatelessProcessSession session;
    private final String processorId;
    private final String processorType;
    private final Collection<ProvenanceEventRecord> events;

    public ProvenanceCollector(StatelessProcessSession session, Collection<ProvenanceEventRecord> events, String processorId, String processorType) {
        this.session = session;
        this.events = events;
        this.processorId = processorId;
        this.processorType = processorType;
    }

    private void verifyFlowFileKnown(FlowFile flowFile) {
        if (this.session != null && !this.session.isFlowFileKnown(flowFile)) {
            throw new FlowFileHandlingException(flowFile + " is not known to " + this.session);
        }
    }

    void remove(ProvenanceEventRecord event) {
        this.events.remove(event);
    }

    void clear() {
        this.events.clear();
    }

    void migrate(ProvenanceCollector newOwner, Set<String> flowFileIds) {
        LinkedHashSet<ProvenanceEventRecord> toMove = new LinkedHashSet<ProvenanceEventRecord>();
        for (ProvenanceEventRecord event : this.events) {
            if (!flowFileIds.contains(event.getFlowFileUuid())) continue;
            toMove.add(event);
        }
        this.events.removeAll(toMove);
        newOwner.events.addAll(toMove);
    }

    ProvenanceEventRecord generateJoinEvent(Collection<FlowFile> parents, FlowFile child) {
        ProvenanceEventBuilder eventBuilder = this.build(child, ProvenanceEventType.JOIN);
        eventBuilder.addChildFlowFile(child);
        for (FlowFile parent : parents) {
            eventBuilder.addParentFlowFile(parent);
        }
        return eventBuilder.build();
    }

    ProvenanceEventRecord generateDropEvent(FlowFile flowFile, String details) {
        return this.build(flowFile, ProvenanceEventType.DROP).setDetails(details).build();
    }

    public void receive(FlowFile flowFile, String transitUri) {
        this.receive(flowFile, transitUri, -1L);
    }

    public void receive(FlowFile flowFile, String transitUri, String sourceSystemFlowFileIdentifier) {
        this.receive(flowFile, transitUri, sourceSystemFlowFileIdentifier, -1L);
    }

    public void receive(FlowFile flowFile, String transitUri, long transmissionMillis) {
        this.receive(flowFile, transitUri, null, transmissionMillis);
    }

    public void receive(FlowFile flowFile, String transitUri, String sourceSystemFlowFileIdentifier, long transmissionMillis) {
        this.receive(flowFile, transitUri, sourceSystemFlowFileIdentifier, null, transmissionMillis);
    }

    public void receive(FlowFile flowFile, String transitUri, String sourceSystemFlowFileIdentifier, String details, long transmissionMillis) {
        block2: {
            this.verifyFlowFileKnown(flowFile);
            try {
                ProvenanceEventRecord record = this.build(flowFile, ProvenanceEventType.RECEIVE).setTransitUri(transitUri).setSourceSystemFlowFileIdentifier(sourceSystemFlowFileIdentifier).setEventDuration(transmissionMillis).setDetails(details).build();
                this.events.add(record);
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block2;
                logger.error("", (Throwable)e);
            }
        }
    }

    public void fetch(FlowFile flowFile, String transitUri) {
        this.fetch(flowFile, transitUri, -1L);
    }

    public void fetch(FlowFile flowFile, String transitUri, long transmissionMillis) {
        this.fetch(flowFile, transitUri, null, transmissionMillis);
    }

    public void fetch(FlowFile flowFile, String transitUri, String details, long transmissionMillis) {
        block2: {
            this.verifyFlowFileKnown(flowFile);
            try {
                ProvenanceEventRecord record = this.build(flowFile, ProvenanceEventType.FETCH).setTransitUri(transitUri).setEventDuration(transmissionMillis).setDetails(details).build();
                this.events.add(record);
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block2;
                logger.error("", (Throwable)e);
            }
        }
    }

    public void send(FlowFile flowFile, String transitUri, long transmissionMillis) {
        this.send(flowFile, transitUri, transmissionMillis, true);
    }

    public void send(FlowFile flowFile, String transitUri) {
        this.send(flowFile, transitUri, null, -1L, true);
    }

    public void send(FlowFile flowFile, String transitUri, String details) {
        this.send(flowFile, transitUri, details, -1L, true);
    }

    public void send(FlowFile flowFile, String transitUri, long transmissionMillis, boolean force) {
        this.send(flowFile, transitUri, null, transmissionMillis, force);
    }

    public void send(FlowFile flowFile, String transitUri, String details, boolean force) {
        this.send(flowFile, transitUri, details, -1L, force);
    }

    public void send(FlowFile flowFile, String transitUri, String details, long transmissionMillis) {
        this.send(flowFile, transitUri, details, transmissionMillis, true);
    }

    public void send(FlowFile flowFile, String transitUri, String details, long transmissionMillis, boolean force) {
        block4: {
            try {
                ProvenanceEventRecord record = this.build(flowFile, ProvenanceEventType.SEND).setTransitUri(transitUri).setEventDuration(transmissionMillis).setDetails(details).build();
                if (force) {
                    this.events.add(record);
                } else {
                    this.events.add(record);
                }
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block4;
                logger.error("", (Throwable)e);
            }
        }
    }

    public void send(FlowFile flowFile, String transitUri, boolean force) {
        this.send(flowFile, transitUri, -1L, true);
    }

    public void invokeRemoteProcess(FlowFile flowFile, String transitUri) {
        this.invokeRemoteProcess(flowFile, transitUri, null);
    }

    public void invokeRemoteProcess(FlowFile flowFile, String transitUri, String details) {
        block2: {
            try {
                ProvenanceEventRecord record = this.build(flowFile, ProvenanceEventType.REMOTE_INVOCATION).setTransitUri(transitUri).setDetails(details).build();
                this.events.add(record);
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block2;
                logger.error("", (Throwable)e);
            }
        }
    }

    public void associate(FlowFile flowFile, String alternateIdentifierNamespace, String alternateIdentifier) {
        block5: {
            try {
                String trimmedIdentifier;
                String trimmedNamespace = alternateIdentifierNamespace.trim();
                if (trimmedNamespace.endsWith(":")) {
                    trimmedNamespace = trimmedNamespace.substring(0, trimmedNamespace.length() - 1);
                }
                if ((trimmedIdentifier = alternateIdentifier.trim()).startsWith(":")) {
                    if (trimmedIdentifier.length() == 1) {
                        throw new IllegalArgumentException("Illegal alternateIdentifier: " + alternateIdentifier);
                    }
                    trimmedIdentifier = trimmedIdentifier.substring(1);
                }
                String alternateIdentifierUri = trimmedNamespace + ":" + trimmedIdentifier;
                ProvenanceEventRecord record = this.build(flowFile, ProvenanceEventType.ADDINFO).setAlternateIdentifierUri(alternateIdentifierUri).build();
                this.events.add(record);
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block5;
                logger.error("", (Throwable)e);
            }
        }
    }

    ProvenanceEventRecord drop(FlowFile flowFile, String reason) {
        try {
            ProvenanceEventBuilder builder = this.build(flowFile, ProvenanceEventType.DROP);
            if (reason != null) {
                builder.setDetails("Discard reason: " + reason);
            }
            ProvenanceEventRecord record = builder.build();
            this.events.add(record);
            return record;
        }
        catch (Exception e) {
            logger.error("Failed to generate Provenance Event due to " + e);
            if (logger.isDebugEnabled()) {
                logger.error("", (Throwable)e);
            }
            return null;
        }
    }

    void expire(FlowFile flowFile, String details) {
        block2: {
            try {
                ProvenanceEventRecord record = this.build(flowFile, ProvenanceEventType.EXPIRE).setDetails(details).build();
                this.events.add(record);
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block2;
                logger.error("", (Throwable)e);
            }
        }
    }

    public void fork(FlowFile parent, Collection<FlowFile> children) {
        this.fork(parent, children, null, -1L);
    }

    public void fork(FlowFile parent, Collection<FlowFile> children, long forkDuration) {
        this.fork(parent, children, null, forkDuration);
    }

    public void fork(FlowFile parent, Collection<FlowFile> children, String details) {
        this.fork(parent, children, details, -1L);
    }

    public void fork(FlowFile parent, Collection<FlowFile> children, String details, long forkDuration) {
        block5: {
            this.verifyFlowFileKnown(parent);
            try {
                ProvenanceEventBuilder eventBuilder = this.build(parent, ProvenanceEventType.FORK);
                eventBuilder.addParentFlowFile(parent);
                for (FlowFile child : children) {
                    eventBuilder.addChildFlowFile(child);
                }
                if (forkDuration > -1L) {
                    eventBuilder.setEventDuration(forkDuration);
                }
                if (details != null) {
                    eventBuilder.setDetails(details);
                }
                this.events.add(eventBuilder.build());
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block5;
                logger.error("", (Throwable)e);
            }
        }
    }

    public void join(Collection<FlowFile> parents, FlowFile child) {
        this.join(parents, child, null, -1L);
    }

    public void join(Collection<FlowFile> parents, FlowFile child, long joinDuration) {
        this.join(parents, child, null, joinDuration);
    }

    public void join(Collection<FlowFile> parents, FlowFile child, String details) {
        this.join(parents, child, details, -1L);
    }

    public void join(Collection<FlowFile> parents, FlowFile child, String details, long joinDuration) {
        block3: {
            this.verifyFlowFileKnown(child);
            try {
                ProvenanceEventBuilder eventBuilder = this.build(child, ProvenanceEventType.JOIN);
                eventBuilder.addChildFlowFile(child);
                eventBuilder.setDetails(details);
                for (FlowFile parent : parents) {
                    eventBuilder.addParentFlowFile(parent);
                }
                this.events.add(eventBuilder.build());
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block3;
                logger.error("", (Throwable)e);
            }
        }
    }

    public void clone(FlowFile parent, FlowFile child) {
        block2: {
            this.verifyFlowFileKnown(child);
            try {
                ProvenanceEventBuilder eventBuilder = this.build(parent, ProvenanceEventType.CLONE);
                eventBuilder.addChildFlowFile(child);
                eventBuilder.addParentFlowFile(parent);
                this.events.add(eventBuilder.build());
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block2;
                logger.error("", (Throwable)e);
            }
        }
    }

    public void modifyContent(FlowFile flowFile) {
        this.modifyContent(flowFile, null, -1L);
    }

    public void modifyContent(FlowFile flowFile, String details) {
        this.modifyContent(flowFile, details, -1L);
    }

    public void modifyContent(FlowFile flowFile, long processingMillis) {
        this.modifyContent(flowFile, null, processingMillis);
    }

    public void modifyContent(FlowFile flowFile, String details, long processingMillis) {
        block2: {
            this.verifyFlowFileKnown(flowFile);
            try {
                ProvenanceEventRecord record = this.build(flowFile, ProvenanceEventType.CONTENT_MODIFIED).setEventDuration(processingMillis).setDetails(details).build();
                this.events.add(record);
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block2;
                logger.error("", (Throwable)e);
            }
        }
    }

    public void modifyAttributes(FlowFile flowFile) {
        this.modifyAttributes(flowFile, null);
    }

    public void modifyAttributes(FlowFile flowFile, String details) {
        block2: {
            this.verifyFlowFileKnown(flowFile);
            try {
                ProvenanceEventRecord record = this.build(flowFile, ProvenanceEventType.ATTRIBUTES_MODIFIED).setDetails(details).build();
                this.events.add(record);
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block2;
                logger.error("", (Throwable)e);
            }
        }
    }

    public void route(FlowFile flowFile, Relationship relationship) {
        this.route(flowFile, relationship, null);
    }

    public void route(FlowFile flowFile, Relationship relationship, long processingDuration) {
        this.route(flowFile, relationship, null, processingDuration);
    }

    public void route(FlowFile flowFile, Relationship relationship, String details) {
        this.route(flowFile, relationship, details, -1L);
    }

    public void route(FlowFile flowFile, Relationship relationship, String details, long processingDuration) {
        block2: {
            this.verifyFlowFileKnown(flowFile);
            try {
                ProvenanceEventRecord record = this.build(flowFile, ProvenanceEventType.ROUTE).setRelationship(relationship).setDetails(details).setEventDuration(processingDuration).build();
                this.events.add(record);
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block2;
                logger.error("", (Throwable)e);
            }
        }
    }

    public void create(FlowFile flowFile) {
        this.create(flowFile, null);
    }

    public void create(FlowFile flowFile, String details) {
        block2: {
            this.verifyFlowFileKnown(flowFile);
            try {
                ProvenanceEventRecord record = this.build(flowFile, ProvenanceEventType.CREATE).setDetails(details).build();
                this.events.add(record);
            }
            catch (Exception e) {
                logger.error("Failed to generate Provenance Event due to " + e);
                if (!logger.isDebugEnabled()) break block2;
                logger.error("", (Throwable)e);
            }
        }
    }

    ProvenanceEventBuilder build(FlowFile flowFile, ProvenanceEventType eventType) {
        StandardProvenanceEventRecord.Builder builder = new StandardProvenanceEventRecord.Builder();
        builder.setEventType(eventType);
        builder.fromFlowFile(flowFile);
        builder.setLineageStartDate(flowFile.getLineageStartDate());
        builder.setComponentId(this.processorId);
        builder.setComponentType(this.processorType);
        return builder;
    }
}

