/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.stateless.core.StatelessPropertyValue;

public class StatelessConfigurationContext
implements ConfigurationContext {
    private final Map<PropertyDescriptor, String> properties;
    private final ControllerServiceLookup serviceLookup;
    private final ControllerService service;
    private final VariableRegistry variableRegistry;
    private final ParameterLookup parameterLookup;

    public StatelessConfigurationContext(ControllerService service, Map<PropertyDescriptor, String> properties, ControllerServiceLookup serviceLookup, VariableRegistry variableRegistry, ParameterLookup parameterLookup) {
        this.service = service;
        this.properties = properties;
        this.serviceLookup = serviceLookup;
        this.variableRegistry = variableRegistry;
        this.parameterLookup = parameterLookup;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String value = this.properties.get(property);
        if (value == null) {
            value = this.getActualDescriptor(property).getDefaultValue();
        }
        return new StatelessPropertyValue(value, this.serviceLookup, this.parameterLookup, this.variableRegistry);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return new HashMap<PropertyDescriptor, String>(this.properties);
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    private PropertyDescriptor getActualDescriptor(PropertyDescriptor property) {
        if (this.service == null) {
            return property;
        }
        PropertyDescriptor resolved = this.service.getPropertyDescriptor(property.getName());
        return resolved == null ? property : resolved;
    }

    public String getSchedulingPeriod() {
        return "0 secs";
    }

    public Long getSchedulingPeriod(TimeUnit timeUnit) {
        return 0L;
    }

    public String getName() {
        return null;
    }
}

