/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterReferenceManager;

public class StatelessParameterContext
implements ParameterContext {
    private final Map<String, Parameter> parameterMap = new HashMap<String, Parameter>();

    public StatelessParameterContext(Set<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            this.parameterMap.put(parameter.getDescriptor().getName(), parameter);
        }
    }

    public String getIdentifier() {
        return "NiFi Stateless Parameter Context";
    }

    public String getProcessGroupIdentifier() {
        return null;
    }

    public String getName() {
        return "NiFi Stateless Parameter Context";
    }

    public void setName(String name) {
    }

    public String getDescription() {
        return "NiFi Stateless Parameter Context";
    }

    public void setDescription(String description) {
    }

    public void setParameters(Map<String, Parameter> updatedParameters) {
        throw new UnsupportedOperationException();
    }

    public void verifyCanSetParameters(Map<String, Parameter> parameters) {
        throw new UnsupportedOperationException();
    }

    public Optional<Parameter> getParameter(String parameterName) {
        return Optional.ofNullable(this.parameterMap.get(parameterName));
    }

    public Optional<Parameter> getParameter(ParameterDescriptor parameterDescriptor) {
        return this.getParameter(parameterDescriptor.getName());
    }

    public boolean isEmpty() {
        return this.parameterMap.isEmpty();
    }

    public Map<ParameterDescriptor, Parameter> getParameters() {
        HashMap<ParameterDescriptor, Parameter> map = new HashMap<ParameterDescriptor, Parameter>();
        for (Parameter parameter : this.parameterMap.values()) {
            map.put(parameter.getDescriptor(), parameter);
        }
        return map;
    }

    public ParameterReferenceManager getParameterReferenceManager() {
        return null;
    }

    public long getVersion() {
        return 0L;
    }

    public Authorizable getParentAuthorizable() {
        return null;
    }

    public Resource getResource() {
        return null;
    }
}

