/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.bootstrap;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoaders;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.nar.StandardExtensionDiscoveringManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionDiscovery.class);

    public static ExtensionManager discover(File narWorkingDirectory, ClassLoader systemClassLoader) throws IOException {
        NarClassLoaders narClassLoaders = NarClassLoadersHolder.getInstance();
        long discoveryStart = System.nanoTime();
        try {
            narClassLoaders.init(systemClassLoader, null, narWorkingDirectory);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Could not initialize Class Loaders", cnfe);
        }
        Set narBundles = narClassLoaders.getBundles();
        StandardExtensionDiscoveringManager extensionManager = new StandardExtensionDiscoveringManager();
        extensionManager.discoverExtensions(narBundles);
        extensionManager.logClassLoaderMapping();
        long discoveryMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - discoveryStart);
        logger.info("Successfully discovered extensions in {} milliseconds", (Object)discoveryMillis);
        return extensionManager;
    }
}

