/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.PropertyConfiguration;

public class StatelessControllerServiceConfiguration {
    private final ControllerService service;
    private final String name;
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    private String annotationData;
    private Map<PropertyDescriptor, PropertyConfiguration> properties = new HashMap<PropertyDescriptor, PropertyConfiguration>();

    public StatelessControllerServiceConfiguration(ControllerService service, String name) {
        this.service = service;
        this.name = name;
    }

    public ControllerService getService() {
        return this.service;
    }

    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setProperties(Map<PropertyDescriptor, PropertyConfiguration> props) {
        this.properties = new HashMap<PropertyDescriptor, PropertyConfiguration>(props);
    }

    public void setProperty(PropertyDescriptor key, PropertyConfiguration value) {
        this.properties.put(key, value);
    }

    public String getProperty(PropertyDescriptor descriptor) {
        PropertyConfiguration value = this.properties.get(descriptor);
        if (value == null) {
            return descriptor.getDefaultValue();
        }
        return value.getRawValue();
    }

    public void setAnnotationData(String annotationData) {
        this.annotationData = annotationData;
    }

    public String getAnnotationData() {
        return this.annotationData;
    }

    public Map<PropertyDescriptor, PropertyConfiguration> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getName() {
        return this.name;
    }
}

