/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.exception.FlowFileAccessException;
import org.apache.nifi.stateless.bootstrap.InMemoryFlowFile;
import org.apache.nifi.stream.io.StreamUtils;

public class StatelessFlowFile
implements InMemoryFlowFile {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private static AtomicLong nextID = new AtomicLong(0L);
    public final boolean materializeContent;
    private long id;
    private final long entryDate;
    private final long creationTime;
    private boolean penalized = false;
    private List<InputStream> dataStreams = new ArrayList<InputStream>();
    private byte[] data = new byte[0];
    private boolean isFullyMaterialized = true;
    private long lastEnqueuedDate = 0L;
    private long enqueuedIndex = 0L;

    public StatelessFlowFile(String content, Map<String, String> attributes, boolean materializeContent) {
        this(content.getBytes(StandardCharsets.UTF_8), attributes, materializeContent);
    }

    public StatelessFlowFile(byte[] content, Map<String, String> attributes, boolean materializeContent) {
        this(materializeContent);
        this.attributes.putAll(attributes);
        this.setData(content);
    }

    public StatelessFlowFile(StatelessFlowFile toCopy, boolean materializeContent) {
        this(materializeContent);
        this.id = toCopy.id;
        this.attributes.putAll(toCopy.getAttributes());
        this.penalized = toCopy.isPenalized();
        try {
            this.setData(toCopy.getDataArray());
        }
        catch (IOException e) {
            throw new FlowFileAccessException("Exception creating FlowFile", (Throwable)e);
        }
    }

    public StatelessFlowFile(StatelessFlowFile toCopy, long offset, long size, boolean materializeContent) {
        this(materializeContent);
        this.id = toCopy.id;
        this.attributes.putAll(toCopy.getAttributes());
        this.penalized = toCopy.isPenalized();
        try {
            this.setData(Arrays.copyOfRange(toCopy.getDataArray(), (int)offset, (int)(offset + size)));
        }
        catch (IOException e) {
            throw new FlowFileAccessException("Exception creating FlowFile", (Throwable)e);
        }
    }

    public StatelessFlowFile(boolean materializeContent) {
        this.materializeContent = materializeContent;
        this.creationTime = System.nanoTime();
        this.id = nextID.getAndIncrement();
        this.lastEnqueuedDate = this.entryDate = System.currentTimeMillis();
        this.attributes.put(CoreAttributes.FILENAME.key(), System.nanoTime() + ".statelessFlowFile");
        this.attributes.put(CoreAttributes.PATH.key(), "target");
        this.attributes.put(CoreAttributes.UUID.key(), UUID.randomUUID().toString());
    }

    void setPenalized(boolean penalized) {
        this.penalized = penalized;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLineageStartDate() {
        return this.entryDate;
    }

    public int compareTo(FlowFile o) {
        return this.getAttribute(CoreAttributes.UUID.key()).compareTo(o.getAttribute(CoreAttributes.UUID.key()));
    }

    public String getAttribute(String attrName) {
        return this.attributes.get(attrName);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public long getEntryDate() {
        return this.entryDate;
    }

    public long getId() {
        return this.id;
    }

    public boolean isPenalized() {
        return this.penalized;
    }

    public void putAttributes(Map<String, String> attrs) {
        this.attributes.putAll(attrs);
    }

    public void removeAttributes(Set<String> attrNames) {
        for (String attrName : attrNames) {
            this.attributes.remove(attrName);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof FlowFile) {
            return ((FlowFile)obj).getId() == this.id;
        }
        return false;
    }

    public Long getLastQueueDate() {
        return this.lastEnqueuedDate;
    }

    public void setLastEnqueuedDate(long lastEnqueuedDate) {
        this.lastEnqueuedDate = lastEnqueuedDate;
    }

    public long getPenaltyExpirationMillis() {
        return -1L;
    }

    public ContentClaim getContentClaim() {
        return null;
    }

    public long getContentClaimOffset() {
        return 0L;
    }

    public long getLineageStartIndex() {
        return 0L;
    }

    public long getQueueDateIndex() {
        return this.enqueuedIndex;
    }

    public void setEnqueuedIndex(long enqueuedIndex) {
        this.enqueuedIndex = enqueuedIndex;
    }

    public String toString() {
        JsonObject attributes = new JsonObject();
        this.attributes.forEach((arg_0, arg_1) -> ((JsonObject)attributes).addProperty(arg_0, arg_1));
        JsonObject result = new JsonObject();
        result.add("attributes", (JsonElement)attributes);
        return result.toString();
    }

    @Override
    public String toStringFull() {
        JsonObject attributes = new JsonObject();
        this.attributes.forEach((arg_0, arg_1) -> ((JsonObject)attributes).addProperty(arg_0, arg_1));
        JsonObject result = new JsonObject();
        result.add("attributes", (JsonElement)attributes);
        try {
            result.addProperty("content", new String(this.getDataArray(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            result.addProperty("content", "Exception getting content: " + e.getMessage());
        }
        return result.toString();
    }

    public long getSize() {
        if (this.isFullyMaterialized) {
            return this.data.length;
        }
        return 0L;
    }

    public void addData(byte[] data) {
        if (this.materializeContent) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                outputStream.write(this.data);
                outputStream.write(data);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.data = outputStream.toByteArray();
            this.isFullyMaterialized = true;
        } else {
            this.isFullyMaterialized = false;
            this.dataStreams.add(new ByteArrayInputStream(data));
        }
    }

    public void addData(InputStream in) {
        if (this.materializeContent) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                outputStream.write(this.data);
                StreamUtils.copy((InputStream)in, (OutputStream)outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.data = outputStream.toByteArray();
            this.isFullyMaterialized = true;
        } else {
            this.isFullyMaterialized = false;
            this.dataStreams.add(in);
        }
    }

    public void setData(byte[] data) {
        this.data = data;
        this.isFullyMaterialized = true;
    }

    public void setData(InputStream in) {
        if (this.materializeContent) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                StreamUtils.copy((InputStream)in, (OutputStream)outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.data = outputStream.toByteArray();
            this.isFullyMaterialized = true;
        } else {
            this.isFullyMaterialized = false;
            this.dataStreams = new ArrayList<InputStream>();
            this.dataStreams.add(in);
        }
    }

    public InputStream getDataStream() {
        if (this.isFullyMaterialized) {
            return new ByteArrayInputStream(this.data);
        }
        return new SequenceInputStream(new ByteArrayInputStream(this.data), new SequenceInputStream(Collections.enumeration(this.dataStreams)));
    }

    public byte[] getDataArray() throws IOException {
        if (!this.isFullyMaterialized) {
            this.materializeData();
        }
        return this.data;
    }

    public void materializeData() throws IOException {
        InputStream in = this.getDataStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[0x100000];
        int read = 0;
        while ((read = in.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        baos.flush();
        this.data = baos.toByteArray();
        this.dataStreams = new ArrayList<InputStream>();
        this.isFullyMaterialized = true;
    }
}

