/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core.security;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.apache.nifi.stateless.runtimes.Program;

public class StatelessSecurityUtility {
    public static String getLoggableRepresentationOfSensitiveValue(String sensitiveValue) {
        return CipherUtility.getLoggableRepresentationOfSensitiveValue((String)sensitiveValue);
    }

    public static String getLoggableRepresentationOfJsonObject(JsonObject json) {
        JsonObject localJson = null;
        boolean maskedParams = false;
        if (json.has("parameters")) {
            JsonObject parameters = json.getAsJsonObject("parameters");
            for (Map.Entry e : parameters.entrySet()) {
                JsonObject paramDescriptorMap;
                if (!((JsonElement)e.getValue()).isJsonObject() || !(paramDescriptorMap = (JsonObject)e.getValue()).has("sensitive") || !paramDescriptorMap.getAsJsonPrimitive("sensitive").getAsBoolean()) continue;
                maskedParams = true;
                if (localJson == null) {
                    localJson = json.deepCopy();
                }
                paramDescriptorMap = localJson.getAsJsonObject("parameters").getAsJsonObject((String)e.getKey()).getAsJsonObject();
                String maskedValue = StatelessSecurityUtility.getLoggableRepresentationOfSensitiveValue(paramDescriptorMap.getAsJsonPrimitive("value").getAsString());
                paramDescriptorMap.addProperty("value", maskedValue);
                localJson.getAsJsonObject("parameters").add((String)e.getKey(), (JsonElement)paramDescriptorMap);
            }
        }
        if (!maskedParams) {
            return json.toString();
        }
        return localJson.toString();
    }

    public static String formatArgs(String[] args, boolean isVerbose) {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        int jsonIndex = StatelessSecurityUtility.determineJsonIndex(argsList);
        if (jsonIndex != -1) {
            if (isVerbose) {
                JsonObject json = new JsonParser().parse((String)argsList.get(jsonIndex)).getAsJsonObject();
                String maskedJson = StatelessSecurityUtility.getLoggableRepresentationOfJsonObject(json);
                argsList.add(jsonIndex, maskedJson);
            } else {
                argsList.add(jsonIndex, "{...json...}");
            }
            argsList.remove(jsonIndex + 1);
        }
        return String.join((CharSequence)",", argsList);
    }

    public static String formatJson(JsonObject json) {
        return StatelessSecurityUtility.getLoggableRepresentationOfJsonObject(json);
    }

    public static int determineJsonIndex(List<String> argsList) {
        int jsonIndex = -1;
        if (argsList.contains("--json")) {
            jsonIndex = StatelessSecurityUtility.determineJsonIndex(argsList, "--json");
        } else if (argsList.contains("--yarnjson")) {
            jsonIndex = StatelessSecurityUtility.determineJsonIndex(argsList, "--yarnjson");
        }
        return jsonIndex;
    }

    public static int determineJsonIndex(List<String> argsList, String flag) {
        int flagIndex = argsList.indexOf(flag);
        return flagIndex >= 0 ? flagIndex + 1 : -1;
    }

    public static String sanitizeString(String input) {
        if (StatelessSecurityUtility.isSensitive(input)) {
            return StatelessSecurityUtility.getLoggableRepresentationOfSensitiveValue(input);
        }
        return input;
    }

    public static boolean isSensitive(String input) {
        return input != null && Program.SENSITIVE_INDICATORS.stream().anyMatch(indicator -> input.toLowerCase().matches(".*" + indicator + ".*"));
    }
}

