/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.runtimes.yarn;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.nifi.stateless.core.security.StatelessSecurityUtility;

public class YARNServiceUtil {
    private final String YARNUrl;
    private final String imageName;

    public YARNServiceUtil(String YARNUrl, String imageName) {
        this.YARNUrl = YARNUrl;
        this.imageName = imageName;
    }

    public boolean launchYARNService(String name, int containerCount, String[] argLaunchCommand, StringBuilder outMessage) {
        CharSequence[] updatedLaunchCommand = new String[argLaunchCommand.length];
        for (int i = 0; i < argLaunchCommand.length; ++i) {
            updatedLaunchCommand[i] = argLaunchCommand[i].equals("--json") ? "--yarnjson" : argLaunchCommand[i].replace(',', ';').replace("}}", "} }");
        }
        JsonObject spec = new JsonObject();
        spec.addProperty("name", name.substring(0, Math.min(name.length(), 25)));
        spec.addProperty("version", "1.0.0");
        spec.addProperty("description", "Stateless NiFi service");
        JsonObject component = new JsonObject();
        component.addProperty("name", "mc");
        component.addProperty("number_of_containers", (Number)containerCount);
        JsonObject artifact = new JsonObject();
        artifact.addProperty("id", this.imageName);
        artifact.addProperty("type", "DOCKER");
        component.add("artifact", (JsonElement)artifact);
        component.addProperty("launch_command", String.join((CharSequence)",", updatedLaunchCommand));
        JsonObject resource = new JsonObject();
        resource.addProperty("cpus", (Number)1);
        resource.addProperty("memory", "512");
        component.add("resource", (JsonElement)resource);
        JsonObject env = new JsonObject();
        env.addProperty("YARN_CONTAINER_RUNTIME_DOCKER_RUN_OVERRIDE_DISABLE", "true");
        JsonObject configuration = new JsonObject();
        configuration.add("env", (JsonElement)env);
        component.add("configuration", (JsonElement)configuration);
        JsonArray components = new JsonArray();
        components.add((JsonElement)component);
        spec.add("components", (JsonElement)components);
        HttpPost request = new HttpPost(this.YARNUrl + "/app/v1/services?user.name=" + System.getProperty("user.name"));
        System.out.println("Running YARN service with the following definition:");
        System.out.println(StatelessSecurityUtility.formatJson(spec));
        System.out.println("Launch Command");
        System.out.println(StatelessSecurityUtility.formatArgs((String[])updatedLaunchCommand, true));
        try {
            request.setEntity((HttpEntity)new StringEntity(spec.toString(), " application/json", StandardCharsets.UTF_8.toString()));
            CloseableHttpResponse response = HttpClientBuilder.create().build().execute((HttpUriRequest)request);
            outMessage.append(new BasicResponseHandler().handleResponse((HttpResponse)response));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            outMessage.append(e.getMessage());
            return false;
        }
    }
}

