/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.admin.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.util.DateTimeAdapter;
import org.apache.nifi.web.api.entity.ClusterEntity;
import org.apache.nifi.web.api.entity.NodeEntity;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NiFiClientUtil
implements GroovyObject {
    private static final Logger logger;
    private static final String GET_CLUSTER_ENDPOINT = "/nifi-api/controller/cluster";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public NiFiClientUtil() {
        MetaClass metaClass;
        CallSite[] callSiteArray = NiFiClientUtil.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Boolean isCluster(NiFiProperties niFiProperties) {
        CallSite[] callSiteArray = NiFiClientUtil.$getCallSiteArray();
        String clusterNode = ShortTypeHandling.castToString((Object)callSiteArray[0].call((Object)niFiProperties, callSiteArray[1].callGetProperty(NiFiProperties.class)));
        return (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(Boolean.class, (Object)clusterNode), Boolean.class);
    }

    public static String getUrl(NiFiProperties niFiProperties, String endpoint) {
        CallSite[] callSiteArray = NiFiClientUtil.$getCallSiteArray();
        StringBuilder urlBuilder = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(StringBuilder.class), StringBuilder.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call(StringUtils.class, callSiteArray[5].call((Object)niFiProperties, callSiteArray[6].callGetProperty(NiFiProperties.class))))) {
            callSiteArray[7].call((Object)urlBuilder, (Object)"https://");
            callSiteArray[8].call((Object)urlBuilder, DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call(StringUtils.class, callSiteArray[10].call((Object)niFiProperties, callSiteArray[11].callGetProperty(NiFiProperties.class)))) ? "localhost" : callSiteArray[12].call((Object)niFiProperties, callSiteArray[13].callGetProperty(NiFiProperties.class)));
            callSiteArray[14].call((Object)urlBuilder, (Object)":");
            callSiteArray[15].call((Object)urlBuilder, DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call(StringUtils.class, callSiteArray[17].call((Object)niFiProperties, callSiteArray[18].callGetProperty(NiFiProperties.class)))) ? "8081" : callSiteArray[19].call((Object)niFiProperties, callSiteArray[20].callGetProperty(NiFiProperties.class)));
        } else {
            callSiteArray[21].call((Object)urlBuilder, (Object)"http://");
            callSiteArray[22].call((Object)urlBuilder, DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call(StringUtils.class, callSiteArray[24].call((Object)niFiProperties, callSiteArray[25].callGetProperty(NiFiProperties.class)))) ? "localhost" : callSiteArray[26].call((Object)niFiProperties, callSiteArray[27].callGetProperty(NiFiProperties.class)));
            callSiteArray[28].call((Object)urlBuilder, (Object)":");
            callSiteArray[29].call((Object)urlBuilder, DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[30].call(StringUtils.class, callSiteArray[31].call((Object)niFiProperties, callSiteArray[32].callGetProperty(NiFiProperties.class)))) ? "8080" : callSiteArray[33].call((Object)niFiProperties, callSiteArray[34].callGetProperty(NiFiProperties.class)));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].call(StringUtils.class, (Object)endpoint))) {
            callSiteArray[36].call((Object)urlBuilder, (Object)endpoint);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[37].call((Object)urlBuilder));
    }

    public static String getUrl(NiFiProperties niFiProperties, NodeDTO nodeDTO, String endpoint) {
        CallSite[] callSiteArray = NiFiClientUtil.$getCallSiteArray();
        StringBuilder urlBuilder = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].callConstructor(StringBuilder.class), StringBuilder.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].call(StringUtils.class, callSiteArray[40].call((Object)niFiProperties, callSiteArray[41].callGetProperty(NiFiProperties.class))))) {
            callSiteArray[42].call((Object)urlBuilder, (Object)"https://");
        } else {
            callSiteArray[43].call((Object)urlBuilder, (Object)"http://");
        }
        callSiteArray[44].call((Object)urlBuilder, callSiteArray[45].callGetProperty((Object)nodeDTO));
        callSiteArray[46].call((Object)urlBuilder, (Object)":");
        callSiteArray[47].call((Object)urlBuilder, callSiteArray[48].callGetProperty((Object)nodeDTO));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[49].call(StringUtils.class, (Object)endpoint))) {
            callSiteArray[50].call((Object)urlBuilder, (Object)endpoint);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[51].call((Object)urlBuilder));
    }

    public static ClusterEntity getCluster(Client client, NiFiProperties niFiProperties, List<String> activeUrls, String proxyDN) {
        CallSite[] callSiteArray = NiFiClientUtil.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[52].call(activeUrls))) {
            String url = ShortTypeHandling.castToString((Object)callSiteArray[53].callStatic(NiFiClientUtil.class, (Object)niFiProperties, null));
            callSiteArray[54].call(activeUrls, (Object)url);
        }
        String activeUrl = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call(activeUrls), Iterator.class);
        while (iterator.hasNext()) {
            activeUrl = ShortTypeHandling.castToString(iterator.next());
            String url = ShortTypeHandling.castToString((Object)callSiteArray[56].call((Object)activeUrl, (Object)GET_CLUSTER_ENDPOINT));
            WebTarget webTarget = (WebTarget)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].call((Object)client, (Object)url), WebTarget.class);
            Response response = null;
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].call((Object)url, (Object)"https"))) {
                Object object = callSiteArray[59].call(callSiteArray[60].call(callSiteArray[61].call((Object)webTarget), callSiteArray[62].callGetProperty(ProxiedEntitiesUtils.class), callSiteArray[63].call(ProxiedEntitiesUtils.class, (Object)proxyDN)));
                response = (Response)ScriptBytecodeAdapter.castToType((Object)object, Response.class);
            } else {
                Object object = callSiteArray[64].call(callSiteArray[65].call((Object)webTarget));
                response = (Response)ScriptBytecodeAdapter.castToType((Object)object, Response.class);
            }
            Integer status = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].callGetProperty((Object)response), Integer.class);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)status, (Object)200)) {
                if (ScriptBytecodeAdapter.compareEqual((Object)status, (Object)404)) {
                    callSiteArray[67].call((Object)logger, (Object)"This node is not attached to a cluster. Please connect to a node that is attached to the cluster for information");
                    continue;
                }
                callSiteArray[68].call((Object)logger, (Object)"Failed with HTTP error code: {}, message: {}", (Object)status, callSiteArray[69].call((Object)response, String.class));
                continue;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)status, (Object)200)) continue;
            ClusterEntity clusterEntity = (ClusterEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call((Object)response, ClusterEntity.class), ClusterEntity.class);
            try {
                return clusterEntity;
            }
            catch (Exception ex) {
                callSiteArray[71].call((Object)logger, (Object)"Exception occurred during connection attempt: {}", callSiteArray[72].callGetProperty((Object)ex));
            }
        }
        throw (Throwable)callSiteArray[73].callConstructor(RuntimeException.class, (Object)"Unable to obtain cluster information");
    }

    public static List<String> getActiveClusterUrls(Client client, NiFiProperties niFiProperties, String proxyDN) {
        Reference niFiProperties2 = new Reference((Object)niFiProperties);
        CallSite[] callSiteArray = NiFiClientUtil.$getCallSiteArray();
        ClusterEntity clusterEntity = (ClusterEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callStatic(NiFiClientUtil.class, (Object)client, (Object)((NiFiProperties)niFiProperties2.get()), callSiteArray[75].call(Lists.class), (Object)proxyDN), ClusterEntity.class);
        List activeNodes = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].call(callSiteArray[77].callGetProperty(callSiteArray[78].callGetProperty((Object)clusterEntity)), (Object)new GeneratedClosure(NiFiClientUtil.class, NiFiClientUtil.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _getActiveClusterUrls_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getActiveClusterUrls_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)"CONNECTED");
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getActiveClusterUrls_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getActiveClusterUrls_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "status";
                return new CallSiteArray(_getActiveClusterUrls_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getActiveClusterUrls_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), List.class);
        Reference activeUrls = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].call(Lists.class), List.class)));
        callSiteArray[80].call((Object)activeNodes, (Object)new GeneratedClosure(NiFiClientUtil.class, NiFiClientUtil.class, niFiProperties2, activeUrls){
            private /* synthetic */ Reference niFiProperties;
            private /* synthetic */ Reference activeUrls;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getActiveClusterUrls_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.niFiProperties = reference2 = niFiProperties;
                this.activeUrls = reference = activeUrls;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getActiveClusterUrls_closure2.$getCallSiteArray();
                return callSiteArray[0].call(this.activeUrls.get(), callSiteArray[1].callCurrent((GroovyObject)this, this.niFiProperties.get(), it, null));
            }

            public NiFiProperties getNiFiProperties() {
                CallSite[] callSiteArray = _getActiveClusterUrls_closure2.$getCallSiteArray();
                return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.niFiProperties.get(), NiFiProperties.class);
            }

            public List getActiveUrls() {
                CallSite[] callSiteArray = _getActiveClusterUrls_closure2.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.activeUrls.get(), List.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getActiveClusterUrls_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getActiveClusterUrls_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "add";
                stringArray[1] = "getUrl";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getActiveClusterUrls_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getActiveClusterUrls_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getActiveClusterUrls_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        return (List)activeUrls.get();
    }

    public static String convertToJson(NodeDTO nodeDTO) {
        CallSite[] callSiteArray = NiFiClientUtil.$getCallSiteArray();
        ObjectMapper om = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].callConstructor(ObjectMapper.class), ObjectMapper.class);
        callSiteArray[82].call((Object)om, callSiteArray[83].callConstructor(SimpleDateFormat.class, callSiteArray[84].callGetProperty(DateTimeAdapter.class)));
        NodeEntity ne = (NodeEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[85].callConstructor(NodeEntity.class), NodeEntity.class);
        callSiteArray[86].call((Object)ne, (Object)nodeDTO);
        return ShortTypeHandling.castToString((Object)callSiteArray[87].call((Object)om, (Object)ne));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != NiFiClientUtil.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = NiFiClientUtil.$getCallSiteArray()[88].call(LoggerFactory.class, NiFiClientUtil.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getProperty";
        stringArray[1] = "CLUSTER_IS_NODE";
        stringArray[2] = "valueOf";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "isEmpty";
        stringArray[5] = "getProperty";
        stringArray[6] = "WEB_HTTPS_PORT";
        stringArray[7] = "append";
        stringArray[8] = "append";
        stringArray[9] = "isEmpty";
        stringArray[10] = "getProperty";
        stringArray[11] = "WEB_HTTPS_HOST";
        stringArray[12] = "getProperty";
        stringArray[13] = "WEB_HTTPS_HOST";
        stringArray[14] = "append";
        stringArray[15] = "append";
        stringArray[16] = "isEmpty";
        stringArray[17] = "getProperty";
        stringArray[18] = "WEB_HTTPS_PORT";
        stringArray[19] = "getProperty";
        stringArray[20] = "WEB_HTTPS_PORT";
        stringArray[21] = "append";
        stringArray[22] = "append";
        stringArray[23] = "isEmpty";
        stringArray[24] = "getProperty";
        stringArray[25] = "WEB_HTTP_HOST";
        stringArray[26] = "getProperty";
        stringArray[27] = "WEB_HTTP_HOST";
        stringArray[28] = "append";
        stringArray[29] = "append";
        stringArray[30] = "isEmpty";
        stringArray[31] = "getProperty";
        stringArray[32] = "WEB_HTTPS_PORT";
        stringArray[33] = "getProperty";
        stringArray[34] = "WEB_HTTPS_PORT";
        stringArray[35] = "isEmpty";
        stringArray[36] = "append";
        stringArray[37] = "toString";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "isEmpty";
        stringArray[40] = "getProperty";
        stringArray[41] = "WEB_HTTPS_PORT";
        stringArray[42] = "append";
        stringArray[43] = "append";
        stringArray[44] = "append";
        stringArray[45] = "address";
        stringArray[46] = "append";
        stringArray[47] = "append";
        stringArray[48] = "apiPort";
        stringArray[49] = "isEmpty";
        stringArray[50] = "append";
        stringArray[51] = "toString";
        stringArray[52] = "isEmpty";
        stringArray[53] = "getUrl";
        stringArray[54] = "add";
        stringArray[55] = "iterator";
        stringArray[56] = "plus";
        stringArray[57] = "target";
        stringArray[58] = "startsWith";
        stringArray[59] = "get";
        stringArray[60] = "header";
        stringArray[61] = "request";
        stringArray[62] = "PROXY_ENTITIES_CHAIN";
        stringArray[63] = "formatProxyDn";
        stringArray[64] = "get";
        stringArray[65] = "request";
        stringArray[66] = "status";
        stringArray[67] = "warn";
        stringArray[68] = "warn";
        stringArray[69] = "readEntity";
        stringArray[70] = "readEntity";
        stringArray[71] = "warn";
        stringArray[72] = "localizedMessage";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "getCluster";
        stringArray[75] = "newArrayList";
        stringArray[76] = "findAll";
        stringArray[77] = "nodes";
        stringArray[78] = "cluster";
        stringArray[79] = "newArrayList";
        stringArray[80] = "each";
        stringArray[81] = "<$constructor$>";
        stringArray[82] = "setDateFormat";
        stringArray[83] = "<$constructor$>";
        stringArray[84] = "DEFAULT_DATE_TIME_FORMAT";
        stringArray[85] = "<$constructor$>";
        stringArray[86] = "setNode";
        stringArray[87] = "writeValueAsString";
        stringArray[88] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[89];
        NiFiClientUtil.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(NiFiClientUtil.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = NiFiClientUtil.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

