/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.util.KeystoreType;
import org.apache.nifi.toolkit.cli.api.ClientFactory;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.VersionsClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.JerseyNiFiClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;

public class NiFiClientFactory
implements ClientFactory<NiFiClient> {
    @Override
    public NiFiClient createClient(Properties properties) throws MissingOptionException {
        String url = properties.getProperty(CommandOption.URL.getLongName());
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new MissingOptionException("Missing required option '" + CommandOption.URL.getLongName() + "'");
        }
        String keystore = properties.getProperty(CommandOption.KEYSTORE.getLongName());
        String keystoreType = properties.getProperty(CommandOption.KEYSTORE_TYPE.getLongName());
        String keystorePasswd = properties.getProperty(CommandOption.KEYSTORE_PASSWORD.getLongName());
        String keyPasswd = properties.getProperty(CommandOption.KEY_PASSWORD.getLongName());
        String truststore = properties.getProperty(CommandOption.TRUSTSTORE.getLongName());
        String truststoreType = properties.getProperty(CommandOption.TRUSTSTORE_TYPE.getLongName());
        String truststorePasswd = properties.getProperty(CommandOption.TRUSTSTORE_PASSWORD.getLongName());
        String proxiedEntity = properties.getProperty(CommandOption.PROXIED_ENTITY.getLongName());
        String protocol = properties.getProperty(CommandOption.PROTOCOL.getLongName());
        boolean secureUrl = url.startsWith("https");
        if (secureUrl && (StringUtils.isBlank((CharSequence)truststore) || StringUtils.isBlank((CharSequence)truststoreType) || StringUtils.isBlank((CharSequence)truststorePasswd))) {
            throw new MissingOptionException(CommandOption.TRUSTSTORE.getLongName() + ", " + CommandOption.TRUSTSTORE_TYPE.getLongName() + ", and " + CommandOption.TRUSTSTORE_PASSWORD.getLongName() + " are required when using an https url");
        }
        NiFiClientConfig.Builder clientConfigBuilder = new NiFiClientConfig.Builder().baseUrl(url);
        if (secureUrl) {
            if (!StringUtils.isBlank((CharSequence)keystore)) {
                clientConfigBuilder.keystoreFilename(keystore);
            }
            if (!StringUtils.isBlank((CharSequence)keystoreType)) {
                clientConfigBuilder.keystoreType(KeystoreType.valueOf((String)keystoreType.toUpperCase()));
            }
            if (!StringUtils.isBlank((CharSequence)keystorePasswd)) {
                clientConfigBuilder.keystorePassword(keystorePasswd);
            }
            if (!StringUtils.isBlank((CharSequence)keyPasswd)) {
                clientConfigBuilder.keyPassword(keyPasswd);
            }
            if (!StringUtils.isBlank((CharSequence)truststore)) {
                clientConfigBuilder.truststoreFilename(truststore);
            }
            if (!StringUtils.isBlank((CharSequence)truststoreType)) {
                clientConfigBuilder.truststoreType(KeystoreType.valueOf((String)truststoreType.toUpperCase()));
            }
            if (!StringUtils.isBlank((CharSequence)truststorePasswd)) {
                clientConfigBuilder.truststorePassword(truststorePasswd);
            }
            if (!StringUtils.isBlank((CharSequence)protocol)) {
                clientConfigBuilder.protocol(protocol);
            }
        }
        NiFiClient client = new JerseyNiFiClient.Builder().config(clientConfigBuilder.build()).build();
        if (!StringUtils.isBlank((CharSequence)proxiedEntity)) {
            return new ProxiedNiFiClient(client, proxiedEntity);
        }
        return client;
    }

    private static class ProxiedNiFiClient
    implements NiFiClient {
        private final String proxiedEntity;
        private final NiFiClient wrappedClient;

        public ProxiedNiFiClient(NiFiClient wrappedClient, String proxiedEntity) {
            this.proxiedEntity = proxiedEntity;
            this.wrappedClient = wrappedClient;
        }

        @Override
        public ControllerClient getControllerClient() {
            return this.wrappedClient.getControllerClientForProxiedEntities(this.proxiedEntity);
        }

        @Override
        public ControllerClient getControllerClientForProxiedEntities(String ... proxiedEntity) {
            return this.wrappedClient.getControllerClientForProxiedEntities(proxiedEntity);
        }

        @Override
        public ControllerClient getControllerClientForToken(String token) {
            return this.wrappedClient.getControllerClientForToken(token);
        }

        @Override
        public FlowClient getFlowClient() {
            return this.wrappedClient.getFlowClientForProxiedEntities(this.proxiedEntity);
        }

        @Override
        public FlowClient getFlowClientForProxiedEntities(String ... proxiedEntity) {
            return this.wrappedClient.getFlowClientForProxiedEntities(proxiedEntity);
        }

        @Override
        public FlowClient getFlowClientForToken(String token) {
            return this.wrappedClient.getFlowClientForToken(token);
        }

        @Override
        public ProcessGroupClient getProcessGroupClient() {
            return this.wrappedClient.getProcessGroupClientForProxiedEntities(this.proxiedEntity);
        }

        @Override
        public ProcessGroupClient getProcessGroupClientForProxiedEntities(String ... proxiedEntity) {
            return this.wrappedClient.getProcessGroupClientForProxiedEntities(proxiedEntity);
        }

        @Override
        public ProcessGroupClient getProcessGroupClientForToken(String token) {
            return this.wrappedClient.getProcessGroupClientForToken(token);
        }

        @Override
        public VersionsClient getVersionsClient() {
            return this.wrappedClient.getVersionsClientForProxiedEntities(this.proxiedEntity);
        }

        @Override
        public VersionsClient getVersionsClientForProxiedEntities(String ... proxiedEntity) {
            return this.wrappedClient.getVersionsClientForProxiedEntities(proxiedEntity);
        }

        @Override
        public VersionsClient getVersionsClientForToken(String token) {
            return this.wrappedClient.getVersionsClientForToken(token);
        }

        @Override
        public void close() throws IOException {
            this.wrappedClient.close();
        }
    }
}

