/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.ClusterEntity;
import org.apache.nifi.web.api.entity.NodeEntity;
import org.apache.nifi.web.api.entity.RegistryClientEntity;
import org.apache.nifi.web.api.entity.RegistryClientsEntity;

public class JerseyControllerClient
extends AbstractJerseyClient
implements ControllerClient {
    private final WebTarget controllerTarget;

    public JerseyControllerClient(WebTarget baseTarget) {
        this(baseTarget, Collections.emptyMap());
    }

    public JerseyControllerClient(WebTarget baseTarget, Map<String, String> headers) {
        super(headers);
        this.controllerTarget = baseTarget.path("/controller");
    }

    @Override
    public RegistryClientsEntity getRegistryClients() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving registry clients", () -> {
            WebTarget target = this.controllerTarget.path("registry-clients");
            return (RegistryClientsEntity)this.getRequestBuilder(target).get(RegistryClientsEntity.class);
        });
    }

    @Override
    public RegistryClientEntity getRegistryClient(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Registry client id cannot be null");
        }
        WebTarget target = this.controllerTarget.path("registry-clients/{id}").resolveTemplate("id", (Object)id);
        return (RegistryClientEntity)this.getRequestBuilder(target).get(RegistryClientEntity.class);
    }

    @Override
    public RegistryClientEntity createRegistryClient(RegistryClientEntity registryClient) throws NiFiClientException, IOException {
        if (registryClient == null) {
            throw new IllegalArgumentException("Registry client entity cannot be null");
        }
        return this.executeAction("Error creating registry client", () -> {
            WebTarget target = this.controllerTarget.path("registry-clients");
            return (RegistryClientEntity)this.getRequestBuilder(target).post(Entity.entity((Object)registryClient, (String)"application/json"), RegistryClientEntity.class);
        });
    }

    @Override
    public RegistryClientEntity updateRegistryClient(RegistryClientEntity registryClient) throws NiFiClientException, IOException {
        if (registryClient == null) {
            throw new IllegalArgumentException("Registry client entity cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)registryClient.getId())) {
            throw new IllegalArgumentException("Registry client entity must contain an id");
        }
        return this.executeAction("Error updating registry client", () -> {
            WebTarget target = this.controllerTarget.path("registry-clients/{id}").resolveTemplate("id", (Object)registryClient.getId());
            return (RegistryClientEntity)this.getRequestBuilder(target).put(Entity.entity((Object)registryClient, (String)"application/json"), RegistryClientEntity.class);
        });
    }

    @Override
    public NodeEntity deleteNode(String nodeId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        return this.executeAction("Error deleting node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).delete(NodeEntity.class);
        });
    }

    @Override
    public NodeEntity connectNode(String nodeId, NodeEntity nodeEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        if (nodeEntity == null) {
            throw new IllegalArgumentException("Node entity cannot be null");
        }
        return this.executeAction("Error connecting node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).put(Entity.entity((Object)nodeEntity, (String)"application/json"), NodeEntity.class);
        });
    }

    @Override
    public NodeEntity offloadNode(String nodeId, NodeEntity nodeEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        if (nodeEntity == null) {
            throw new IllegalArgumentException("Node entity cannot be null");
        }
        return this.executeAction("Error offloading node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).put(Entity.entity((Object)nodeEntity, (String)"application/json"), NodeEntity.class);
        });
    }

    @Override
    public NodeEntity disconnectNode(String nodeId, NodeEntity nodeEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        if (nodeEntity == null) {
            throw new IllegalArgumentException("Node entity cannot be null");
        }
        return this.executeAction("Error disconnecting node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).put(Entity.entity((Object)nodeEntity, (String)"application/json"), NodeEntity.class);
        });
    }

    @Override
    public NodeEntity getNode(String nodeId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        return this.executeAction("Error retrieving node status", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).get(NodeEntity.class);
        });
    }

    @Override
    public ClusterEntity getNodes() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving node status", () -> {
            WebTarget target = this.controllerTarget.path("cluster");
            return (ClusterEntity)this.getRequestBuilder(target).get(ClusterEntity.class);
        });
    }
}

