/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupBox;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.flow.ProcessGroupFlowDTO;
import org.apache.nifi.web.api.entity.ActivateControllerServicesEntity;
import org.apache.nifi.web.api.entity.ClusteSummaryEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;
import org.apache.nifi.web.api.entity.CurrentUserEntity;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;
import org.apache.nifi.web.api.entity.ScheduleComponentsEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataSetEntity;

public class JerseyFlowClient
extends AbstractJerseyClient
implements FlowClient {
    static final String ROOT = "root";
    private final WebTarget flowTarget;

    public JerseyFlowClient(WebTarget baseTarget) {
        this(baseTarget, Collections.emptyMap());
    }

    public JerseyFlowClient(WebTarget baseTarget, Map<String, String> headers) {
        super(headers);
        this.flowTarget = baseTarget.path("/flow");
    }

    @Override
    public CurrentUserEntity getCurrentUser() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving current", () -> {
            WebTarget target = this.flowTarget.path("current-user");
            return (CurrentUserEntity)this.getRequestBuilder(target).get(CurrentUserEntity.class);
        });
    }

    @Override
    public String getRootGroupId() throws NiFiClientException, IOException {
        ProcessGroupFlowEntity entity = this.getProcessGroup(ROOT);
        return entity.getProcessGroupFlow().getId();
    }

    @Override
    public ProcessGroupFlowEntity getProcessGroup(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Process group id cannot be null");
        }
        return this.executeAction("Error retrieving process group flow", () -> {
            WebTarget target = this.flowTarget.path("process-groups/{id}").resolveTemplate("id", (Object)id);
            return (ProcessGroupFlowEntity)this.getRequestBuilder(target).get(ProcessGroupFlowEntity.class);
        });
    }

    @Override
    public ProcessGroupBox getSuggestedProcessGroupCoordinates(String parentId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            throw new IllegalArgumentException("Process group id cannot be null");
        }
        ProcessGroupFlowEntity processGroup = this.getProcessGroup(parentId);
        ProcessGroupFlowDTO processGroupFlowDTO = processGroup.getProcessGroupFlow();
        FlowDTO flowDTO = processGroupFlowDTO.getFlow();
        ArrayList pgComponents = new ArrayList();
        pgComponents.addAll(flowDTO.getProcessGroups());
        pgComponents.addAll(flowDTO.getProcessors());
        pgComponents.addAll(flowDTO.getRemoteProcessGroups());
        pgComponents.addAll(flowDTO.getConnections());
        pgComponents.addAll(flowDTO.getFunnels());
        pgComponents.addAll(flowDTO.getInputPorts());
        pgComponents.addAll(flowDTO.getOutputPorts());
        pgComponents.addAll(flowDTO.getLabels());
        Set positions = pgComponents.stream().map(ComponentEntity::getPosition).collect(Collectors.toSet());
        if (positions.isEmpty()) {
            return ProcessGroupBox.CANVAS_CENTER;
        }
        List<ProcessGroupBox> coords = positions.stream().filter(Objects::nonNull).map(p -> new ProcessGroupBox(p.getX().intValue(), p.getY().intValue())).collect(Collectors.toList());
        ProcessGroupBox freeSpot = ((ProcessGroupBox)coords.get(0)).findFreeSpace(coords);
        return freeSpot;
    }

    @Override
    public ScheduleComponentsEntity scheduleProcessGroupComponents(String processGroupId, ScheduleComponentsEntity scheduleComponentsEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null");
        }
        if (scheduleComponentsEntity == null) {
            throw new IllegalArgumentException("ScheduleComponentsEntity cannot be null");
        }
        scheduleComponentsEntity.setId(processGroupId);
        return this.executeAction("Error scheduling components", () -> {
            WebTarget target = this.flowTarget.path("process-groups/{id}").resolveTemplate("id", (Object)processGroupId);
            return (ScheduleComponentsEntity)this.getRequestBuilder(target).put(Entity.entity((Object)scheduleComponentsEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ScheduleComponentsEntity.class);
        });
    }

    @Override
    public VersionedFlowSnapshotMetadataSetEntity getVersions(String registryId, String bucketId, String flowId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)registryId)) {
            throw new IllegalArgumentException("Registry id cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket id cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow id cannot be null");
        }
        return this.executeAction("Error retrieving versions", () -> {
            WebTarget target = this.flowTarget.path("registries/{registry-id}/buckets/{bucket-id}/flows/{flow-id}/versions").resolveTemplate("registry-id", (Object)registryId).resolveTemplate("bucket-id", (Object)bucketId).resolveTemplate("flow-id", (Object)flowId);
            return (VersionedFlowSnapshotMetadataSetEntity)this.getRequestBuilder(target).get(VersionedFlowSnapshotMetadataSetEntity.class);
        });
    }

    @Override
    public ControllerServicesEntity getControllerServices(String groupId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalArgumentException("Group Id cannot be null or blank");
        }
        return this.executeAction("Error retrieving controller services", () -> {
            WebTarget target = this.flowTarget.path("process-groups/{id}/controller-services").resolveTemplate("id", (Object)groupId);
            return (ControllerServicesEntity)this.getRequestBuilder(target).get(ControllerServicesEntity.class);
        });
    }

    @Override
    public ActivateControllerServicesEntity activateControllerServices(ActivateControllerServicesEntity activateControllerServicesEntity) throws NiFiClientException, IOException {
        if (activateControllerServicesEntity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)activateControllerServicesEntity.getId())) {
            throw new IllegalArgumentException("Entity must contain a process group id");
        }
        return this.executeAction("Error enabling or disabling controlling services", () -> {
            WebTarget target = this.flowTarget.path("process-groups/{id}/controller-services").resolveTemplate("id", (Object)activateControllerServicesEntity.getId());
            return (ActivateControllerServicesEntity)this.getRequestBuilder(target).put(Entity.entity((Object)activateControllerServicesEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ActivateControllerServicesEntity.class);
        });
    }

    @Override
    public ClusteSummaryEntity getClusterSummary() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving cluster summary", () -> {
            WebTarget target = this.flowTarget.path("cluster/summary");
            return (ClusteSummaryEntity)this.getRequestBuilder(target).get(ClusteSummaryEntity.class);
        });
    }
}

