/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.VariableRegistryEntity;
import org.apache.nifi.web.api.entity.VariableRegistryUpdateRequestEntity;

public class JerseyProcessGroupClient
extends AbstractJerseyClient
implements ProcessGroupClient {
    private final WebTarget processGroupsTarget;

    public JerseyProcessGroupClient(WebTarget baseTarget) {
        this(baseTarget, Collections.emptyMap());
    }

    public JerseyProcessGroupClient(WebTarget baseTarget, Map<String, String> headers) {
        super(headers);
        this.processGroupsTarget = baseTarget.path("/process-groups");
    }

    @Override
    public ProcessGroupEntity createProcessGroup(String parentGroupdId, ProcessGroupEntity entity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentGroupdId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Process group entity cannot be null");
        }
        return this.executeAction("Error creating process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/process-groups").resolveTemplate("id", (Object)parentGroupdId);
            return (ProcessGroupEntity)this.getRequestBuilder(target).post(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessGroupEntity.class);
        });
    }

    @Override
    public ProcessGroupEntity getProcessGroup(String processGroupId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        return this.executeAction("Error getting process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}").resolveTemplate("id", (Object)processGroupId);
            return (ProcessGroupEntity)this.getRequestBuilder(target).get(ProcessGroupEntity.class);
        });
    }

    @Override
    public ProcessGroupEntity updateProcessGroup(ProcessGroupEntity entity) throws NiFiClientException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Process group entity cannot be null");
        }
        return this.executeAction("Error updating process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}").resolveTemplate("id", (Object)entity.getId());
            return (ProcessGroupEntity)this.getRequestBuilder(target).put(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessGroupEntity.class);
        });
    }

    @Override
    public VariableRegistryEntity getVariables(String processGroupId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        return this.executeAction("Error getting variables for process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/variable-registry").resolveTemplate("id", (Object)processGroupId);
            return (VariableRegistryEntity)this.getRequestBuilder(target).get(VariableRegistryEntity.class);
        });
    }

    @Override
    public VariableRegistryUpdateRequestEntity updateVariableRegistry(String processGroupId, VariableRegistryEntity variableRegistryEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (variableRegistryEntity == null) {
            throw new IllegalArgumentException("Variable registry entity cannot be null");
        }
        return this.executeAction("Error getting variable registry update request", () -> {
            WebTarget target = this.processGroupsTarget.path("{processGroupId}/variable-registry/update-requests").resolveTemplate("processGroupId", (Object)processGroupId);
            return (VariableRegistryUpdateRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)variableRegistryEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), VariableRegistryUpdateRequestEntity.class);
        });
    }

    @Override
    public VariableRegistryUpdateRequestEntity getVariableRegistryUpdateRequest(String processGroupId, String requestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new IllegalArgumentException("Request id cannot be null or blank");
        }
        return this.executeAction("Error getting variable registry update request", () -> {
            WebTarget target = this.processGroupsTarget.path("{processGroupId}/variable-registry/update-requests/{updateId}").resolveTemplate("processGroupId", (Object)processGroupId).resolveTemplate("updateId", (Object)requestId);
            return (VariableRegistryUpdateRequestEntity)this.getRequestBuilder(target).get(VariableRegistryUpdateRequestEntity.class);
        });
    }

    @Override
    public VariableRegistryUpdateRequestEntity deleteVariableRegistryUpdateRequest(String processGroupId, String requestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new IllegalArgumentException("Request id cannot be null or blank");
        }
        return this.executeAction("Error getting variable registry update request", () -> {
            WebTarget target = this.processGroupsTarget.path("{processGroupId}/variable-registry/update-requests/{updateId}").resolveTemplate("processGroupId", (Object)processGroupId).resolveTemplate("updateId", (Object)requestId);
            return (VariableRegistryUpdateRequestEntity)this.getRequestBuilder(target).delete(VariableRegistryUpdateRequestEntity.class);
        });
    }
}

