/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command;

import org.apache.commons.cli.Option;

public enum CommandOption {
    URL("u", "baseUrl", "The URL to execute the command against", true),
    INPUT_SOURCE("i", "input", "A local file to read as input contents, or a public URL to fetch", true, true),
    OUTPUT_FILE("o", "outputFile", "A file to write output to, must contain full path and filename", true, true),
    PROPERTIES("p", "properties", "A properties file to load arguments from, command line values will override anything in the properties file, must contain full path to file", true, true),
    NIFI_PROPS("nifiProps", "nifiProps", "A properties file to load for NiFi config", true, true),
    NIFI_REG_PROPS("nifiRegProps", "nifiRegProps", "A properties file to load for NiFi Registry config", true, true),
    BUCKET_ID("b", "bucketIdentifier", "A bucket identifier", true),
    BUCKET_NAME("bn", "bucketName", "A bucket name", true),
    BUCKET_DESC("bd", "bucketDesc", "A bucket description", true),
    FLOW_ID("f", "flowIdentifier", "A flow identifier", true),
    FLOW_NAME("fn", "flowName", "A flow name", true),
    FLOW_DESC("fd", "flowDesc", "A flow description", true),
    FLOW_VERSION("fv", "flowVersion", "A version of a flow", true),
    SRC_PROPS("sp", "sourceProps", "A properties file to load for the source", true, true),
    SRC_FLOW_ID("sf", "sourceFlowIdentifier", "A flow identifier from the source registry", true),
    SRC_FLOW_VERSION("sfv", "sourceFlowVersion", "A version of a flow from the source registry", true),
    NIFI_NODE_ID("nnid", "nifiNodeId", "The ID of a node in the NiFi cluster", true),
    REGISTRY_CLIENT_ID("rcid", "registryClientId", "The id of a registry client", true),
    REGISTRY_CLIENT_NAME("rcn", "registryClientName", "The name of the registry client", true),
    REGISTRY_CLIENT_URL("rcu", "registryClientUrl", "The url of the registry client", true),
    REGISTRY_CLIENT_DESC("rcd", "registryClientDesc", "The description of the registry client", true),
    PG_ID("pgid", "processGroupId", "The id of a process group", true),
    PG_NAME("pgn", "processGroupName", "The name of a process group", true),
    PG_VAR_NAME("var", "varName", "The name of a variable", true),
    PG_VAR_VALUE("val", "varValue", "The value of a variable", true),
    KEYSTORE("ks", "keystore", "A keystore to use for TLS/SSL connections", true),
    KEYSTORE_TYPE("kst", "keystoreType", "The type of key store being used (JKS or PKCS12)", true),
    KEYSTORE_PASSWORD("ksp", "keystorePasswd", "The password of the keystore being used", true),
    KEY_PASSWORD("kp", "keyPasswd", "The key password of the keystore being used", true),
    TRUSTSTORE("ts", "truststore", "A truststore to use for TLS/SSL connections", true),
    TRUSTSTORE_TYPE("tst", "truststoreType", "The type of trust store being used (JKS or PKCS12)", true),
    TRUSTSTORE_PASSWORD("tsp", "truststorePasswd", "The password of the truststore being used", true),
    PROXIED_ENTITY("pe", "proxiedEntity", "The identity of an entity to proxy", true),
    PROTOCOL("pro", "protocol", "The security protocol to use, such as TLSv.1.2", true),
    FORCE("force", "force", "Indicates to force a delete operation", false),
    OUTPUT_TYPE("ot", "outputType", "The type of output to produce (json or simple)", true),
    VERBOSE("verbose", "verbose", "Indicates that verbose output should be provided", false),
    HELP("h", "help", "Help", false);

    private final String shortName;
    private final String longName;
    private final String description;
    private final boolean hasArg;
    private final boolean isFile;

    private CommandOption(String shortName, String longName, String description, boolean hasArg) {
        this(shortName, longName, description, hasArg, false);
    }

    private CommandOption(String shortName, String longName, String description, boolean hasArg, boolean isFile) {
        this.shortName = shortName;
        this.longName = longName;
        this.description = description;
        this.hasArg = hasArg;
        this.isFile = isFile;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public Option createOption() {
        return Option.builder((String)this.shortName).longOpt(this.longName).desc(this.description).hasArg(this.hasArg).build();
    }
}

