/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.Command;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.CommandGroup;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.api.ReferenceResolver;
import org.apache.nifi.toolkit.cli.api.Referenceable;
import org.apache.nifi.toolkit.cli.api.ResolvedReference;
import org.apache.nifi.toolkit.cli.api.WritableResult;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;

public class CommandProcessor {
    public static final String BACK_REF_INDICATOR = "&";
    private final Map<String, Command> topLevelCommands;
    private final Map<String, CommandGroup> commandGroups;
    private final Context context;
    private final PrintStream out;
    private final AtomicReference<ReferenceResolver> backReferenceHolder = new AtomicReference<Object>(null);

    public CommandProcessor(Map<String, Command> topLevelCommands, Map<String, CommandGroup> commandGroups, Context context) {
        this.topLevelCommands = topLevelCommands;
        this.commandGroups = commandGroups;
        this.context = context;
        this.out = context.getOutput();
        Validate.notNull(this.topLevelCommands);
        Validate.notNull(this.commandGroups);
        Validate.notNull((Object)this.context);
        Validate.notNull((Object)this.out);
    }

    public void printBasicUsage(String errorMessage) {
        this.printBasicUsage(errorMessage, false);
    }

    public void printBasicUsage(String errorMessage, boolean verbose) {
        this.out.println();
        if (errorMessage != null) {
            this.out.println("ERROR: " + errorMessage);
            this.out.println();
        }
        this.out.println("commands:");
        this.out.println();
        this.commandGroups.entrySet().stream().forEach(e -> ((CommandGroup)e.getValue()).printUsage(verbose));
        if (verbose) {
            this.out.println("-------------------------------------------------------------------------------");
        }
        this.topLevelCommands.keySet().stream().forEach(k -> this.out.println("\t" + k));
        this.out.println();
    }

    private CommandLine parseCli(Command command, String[] args) throws ParseException {
        this.resolveBackReferences(args);
        Options options = command.getOptions();
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = parser.parse(options, args);
        if (commandLine.hasOption(CommandOption.HELP.getLongName())) {
            command.printUsage(null);
            return null;
        }
        return commandLine;
    }

    private void resolveBackReferences(String[] args) {
        ReferenceResolver referenceResolver = this.backReferenceHolder.get();
        if (referenceResolver == null) {
            return;
        }
        ArrayList<ResolvedReference> resolvedReferences = new ArrayList<ResolvedReference>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null || !arg.startsWith(BACK_REF_INDICATOR)) continue;
            try {
                Integer pos;
                ResolvedReference resolvedReference;
                CommandOption option = null;
                if (i > 0) {
                    String prevArg = args[i - 1];
                    if (prevArg.startsWith("--")) {
                        prevArg = prevArg.substring(2);
                    } else if (prevArg.startsWith("-")) {
                        prevArg = prevArg.substring(1);
                    }
                    for (CommandOption opt : CommandOption.values()) {
                        if (!opt.getShortName().equals(prevArg) && !opt.getLongName().equals(prevArg)) continue;
                        option = opt;
                        break;
                    }
                }
                if ((resolvedReference = referenceResolver.resolve(option, pos = Integer.valueOf(arg.substring(1)))) == null) continue;
                args[i] = resolvedReference.getResolvedValue();
                resolvedReferences.add(resolvedReference);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.context.isInteractive()) {
            for (ResolvedReference resolvedRef : resolvedReferences) {
                this.out.println();
                this.out.printf("Using a positional back-reference for '%s'%n", resolvedRef.getDisplayName());
            }
        }
    }

    public int process(String[] args) {
        if (args == null || args.length == 0) {
            this.printBasicUsage(null);
            return -1;
        }
        if (CommandOption.HELP.getLongName().equalsIgnoreCase(args[0])) {
            if (args.length == 2 && "-v".equalsIgnoreCase(args[1])) {
                this.printBasicUsage(null, true);
                return 0;
            }
            this.printBasicUsage(null);
            return 0;
        }
        String commandStr = args[0];
        if (this.topLevelCommands.containsKey(commandStr)) {
            return this.processTopLevelCommand(commandStr, args);
        }
        if (this.commandGroups.containsKey(commandStr)) {
            return this.processGroupCommand(commandStr, args);
        }
        this.printBasicUsage("Unknown command '" + commandStr + "'");
        return -1;
    }

    private int processTopLevelCommand(String commandStr, String[] args) {
        Command command = this.topLevelCommands.get(commandStr);
        if (command == null) {
            this.printBasicUsage("Unknown command '" + commandStr + "'");
            return -1;
        }
        try {
            String[] otherArgs = (String[])Arrays.copyOfRange(args, 1, args.length, String[].class);
            return this.processCommand(otherArgs, command);
        }
        catch (Exception e) {
            command.printUsage(e.getMessage());
            return -1;
        }
    }

    private int processGroupCommand(String commandGroupStr, String[] args) {
        if (args.length <= 1) {
            this.printBasicUsage("No command provided to " + commandGroupStr);
            return -1;
        }
        String commandStr = args[1];
        CommandGroup commandGroup = this.commandGroups.get(commandGroupStr);
        Command command = commandGroup.getCommands().stream().filter(c -> c.getName().equals(commandStr)).findFirst().orElse(null);
        if (command == null) {
            this.printBasicUsage("Unknown command '" + commandGroupStr + " " + commandStr + "'");
            return -1;
        }
        try {
            String[] otherArgs = (String[])Arrays.copyOfRange(args, 2, args.length, String[].class);
            return this.processCommand(otherArgs, command);
        }
        catch (Exception e) {
            command.printUsage(e.getMessage());
            return -1;
        }
    }

    int processCommand(String[] args, Command command) throws ParseException {
        CommandLine commandLine = this.parseCli(command, args);
        if (commandLine == null) {
            this.out.println("Unable to parse command line");
            return -1;
        }
        try {
            if (args.length == 1 && CommandOption.HELP.getLongName().equalsIgnoreCase(args[0])) {
                command.printUsage(null);
            } else {
                Referenceable referenceable;
                ReferenceResolver referenceResolver;
                Object result = command.execute(commandLine);
                if (result instanceof WritableResult) {
                    WritableResult writableResult = (WritableResult)result;
                    writableResult.write(this.out);
                }
                if (result instanceof Referenceable && !(referenceResolver = (referenceable = (Referenceable)result).createReferenceResolver(this.context)).isEmpty()) {
                    this.backReferenceHolder.set(referenceResolver);
                }
            }
            return 0;
        }
        catch (Exception e) {
            if (e instanceof CommandException) {
                this.out.println();
                this.out.println("ERROR: " + e.getMessage());
                this.out.println();
            } else {
                command.printUsage(e.getMessage());
            }
            if (commandLine.hasOption(CommandOption.VERBOSE.getLongName())) {
                this.out.println();
                e.printStackTrace(this.out);
                this.out.println();
            }
            return -1;
        }
    }
}

