/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.ClientFactory;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Result;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.AbstractPropertyCommand;
import org.apache.nifi.toolkit.cli.impl.session.SessionVariable;
import org.apache.nifi.web.api.dto.RevisionDTO;

public abstract class AbstractNiFiCommand<R extends Result>
extends AbstractPropertyCommand<R> {
    public AbstractNiFiCommand(String name, Class<R> resultClass) {
        super(name, resultClass);
    }

    @Override
    protected SessionVariable getPropertiesSessionVariable() {
        return SessionVariable.NIFI_CLIENT_PROPS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final R doExecute(Properties properties) throws CommandException {
        ClientFactory<NiFiClient> clientFactory = this.getContext().getNiFiClientFactory();
        try (NiFiClient client = clientFactory.createClient(properties);){
            R r = this.doExecute(client, properties);
            return r;
        }
        catch (Exception e) {
            throw new CommandException("Error executing command '" + this.getName() + "' : " + e.getMessage(), e);
        }
    }

    public abstract R doExecute(NiFiClient var1, Properties var2) throws NiFiClientException, IOException, MissingOptionException, CommandException;

    protected RevisionDTO getInitialRevisionDTO() {
        String clientId = this.getContext().getSession().getNiFiClientID();
        RevisionDTO revisionDTO = new RevisionDTO();
        revisionDTO.setVersion(new Long(0L));
        revisionDTO.setClientId(clientId);
        return revisionDTO;
    }
}

