/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.ProcessGroupsResult;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.flow.ProcessGroupFlowDTO;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;

public class PGList
extends AbstractNiFiCommand<ProcessGroupsResult> {
    public PGList() {
        super("pg-list", ProcessGroupsResult.class);
    }

    @Override
    public String getDescription() {
        return "Returns the process groups contained in the specified process group. If no process group is specified, then the root group will be used.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public ProcessGroupsResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException {
        FlowClient flowClient = client.getFlowClient();
        String parentPgId = this.getArg(properties, CommandOption.PG_ID);
        if (StringUtils.isBlank((CharSequence)parentPgId)) {
            parentPgId = flowClient.getRootGroupId();
        }
        ProcessGroupFlowEntity processGroupFlowEntity = flowClient.getProcessGroup(parentPgId);
        ProcessGroupFlowDTO processGroupFlowDTO = processGroupFlowEntity.getProcessGroupFlow();
        FlowDTO flowDTO = processGroupFlowDTO.getFlow();
        ArrayList<ProcessGroupDTO> processGroups = new ArrayList<ProcessGroupDTO>();
        if (flowDTO.getProcessGroups() != null) {
            flowDTO.getProcessGroups().stream().map(pge -> pge.getComponent()).forEach(dto -> processGroups.add((ProcessGroupDTO)dto));
        }
        return new ProcessGroupsResult(this.getResultType(properties), processGroups);
    }
}

