/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.ProcessGroupResult;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;

public class PGStatus
extends AbstractNiFiCommand<ProcessGroupResult> {
    public PGStatus() {
        super("pg-status", ProcessGroupResult.class);
    }

    @Override
    public String getDescription() {
        return "Returns the status of the specified process group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public ProcessGroupResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        ProcessGroupEntity entity = client.getProcessGroupClient().getProcessGroup(pgId);
        return new ProcessGroupResult(this.getResultType(properties), entity);
    }
}

