/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.VersionedFlowSnapshotResult;

public class ExportFlowVersion
extends AbstractNiFiRegistryCommand<VersionedFlowSnapshotResult> {
    public ExportFlowVersion() {
        super("export-flow-version", VersionedFlowSnapshotResult.class);
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.FLOW_ID.createOption());
        this.addOption(CommandOption.FLOW_VERSION.createOption());
        this.addOption(CommandOption.OUTPUT_FILE.createOption());
    }

    @Override
    public String getDescription() {
        return "Exports a specific version of a flow. The --" + CommandOption.OUTPUT_FILE.getLongName() + " can be used to export to a file, otherwise the content will be written to terminal or standard out.";
    }

    @Override
    public VersionedFlowSnapshotResult doExecute(NiFiRegistryClient client, Properties properties) throws ParseException, IOException, NiFiRegistryException {
        String flowId = this.getRequiredArg(properties, CommandOption.FLOW_ID);
        Integer version = this.getIntArg(properties, CommandOption.FLOW_VERSION);
        VersionedFlowSnapshot versionedFlowSnapshot = version == null ? client.getFlowSnapshotClient().getLatest(flowId) : client.getFlowSnapshotClient().get(flowId, version.intValue());
        versionedFlowSnapshot.setFlow(null);
        versionedFlowSnapshot.setBucket(null);
        versionedFlowSnapshot.getSnapshotMetadata().setBucketIdentifier(null);
        versionedFlowSnapshot.getSnapshotMetadata().setFlowIdentifier(null);
        versionedFlowSnapshot.getSnapshotMetadata().setLink(null);
        String outputFile = properties.containsKey(CommandOption.OUTPUT_FILE.getLongName()) ? properties.getProperty(CommandOption.OUTPUT_FILE.getLongName()) : null;
        return new VersionedFlowSnapshotResult(versionedFlowSnapshot, outputFile);
    }
}

