/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.VersionedFlowsResult;

public class ListFlows
extends AbstractNiFiRegistryCommand<VersionedFlowsResult> {
    public ListFlows() {
        super("list-flows", VersionedFlowsResult.class);
    }

    @Override
    public String getDescription() {
        return "Lists all of the flows in the given bucket.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_ID.createOption());
    }

    @Override
    public VersionedFlowsResult doExecute(NiFiRegistryClient client, Properties properties) throws ParseException, IOException, NiFiRegistryException {
        String bucketId = this.getRequiredArg(properties, CommandOption.BUCKET_ID);
        FlowClient flowClient = client.getFlowClient();
        List flows = flowClient.getByBucket(bucketId);
        return new VersionedFlowsResult(this.getResultType(properties), flows);
    }
}

