/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result;

import java.io.PrintStream;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.WritableResult;

public class StringResult
implements WritableResult<String> {
    private final String value;
    private final boolean isInteractive;

    public StringResult(String value, boolean isInteractive) {
        this.value = value;
        this.isInteractive = isInteractive;
        Validate.notNull((Object)this.value);
    }

    @Override
    public String getResult() {
        return this.value;
    }

    @Override
    public void write(PrintStream output) {
        if (this.isInteractive) {
            output.println();
        }
        output.println(this.value);
        if (this.isInteractive) {
            output.println();
        }
    }
}

