/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.toolkit.cli.api.WritableResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;

public class VersionedFlowSnapshotResult
implements WritableResult<VersionedFlowSnapshot> {
    private final VersionedFlowSnapshot versionedFlowSnapshot;
    private final String exportFileName;

    public VersionedFlowSnapshotResult(VersionedFlowSnapshot versionedFlowSnapshot, String exportFileName) {
        this.versionedFlowSnapshot = versionedFlowSnapshot;
        this.exportFileName = exportFileName;
        Validate.notNull((Object)this.versionedFlowSnapshot);
    }

    @Override
    public VersionedFlowSnapshot getResult() {
        return this.versionedFlowSnapshot;
    }

    @Override
    public void write(PrintStream output) throws IOException {
        if (this.exportFileName != null) {
            try (FileOutputStream resultOut = new FileOutputStream(this.exportFileName);){
                JacksonUtils.write(this.versionedFlowSnapshot, resultOut);
            }
        } else {
            JacksonUtils.write(this.versionedFlowSnapshot, output);
        }
    }
}

