/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import groovy.io.GroovyPrintWriter;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import groovy.xml.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.security.KeyException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.properties.AESSensitivePropertyProvider;
import org.apache.nifi.properties.NiFiPropertiesLoader;
import org.apache.nifi.properties.ProtectedNiFiProperties;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.StandardNiFiProperties;
import org.apache.nifi.toolkit.tls.commandLine.CommandLineParseException;
import org.apache.nifi.toolkit.tls.commandLine.ExitCode;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.console.TextDevice;
import org.apache.nifi.util.console.TextDevices;
import org.bouncycastle.crypto.generators.SCrypt;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigEncryptionTool
implements GroovyObject {
    private static final Logger logger;
    public String bootstrapConfPath;
    public String niFiPropertiesPath;
    public String outputNiFiPropertiesPath;
    public String loginIdentityProvidersPath;
    public String outputLoginIdentityProvidersPath;
    public String authorizersPath;
    public String outputAuthorizersPath;
    public String flowXmlPath;
    public String outputFlowXmlPath;
    private String keyHex;
    private String migrationKeyHex;
    private String password;
    private String migrationPassword;
    private String flowPropertiesPassword;
    private String newFlowAlgorithm;
    private String newFlowProvider;
    private NiFiProperties niFiProperties;
    private String loginIdentityProviders;
    private String authorizers;
    private String flowXml;
    private boolean usingPassword;
    private boolean usingPasswordMigration;
    private boolean migration;
    private boolean isVerbose;
    private boolean handlingNiFiProperties;
    private boolean handlingLoginIdentityProviders;
    private boolean handlingAuthorizers;
    private boolean handlingFlowXml;
    private boolean ignorePropertiesFiles;
    private boolean translatingCli;
    private static final String HELP_ARG = "help";
    private static final String VERBOSE_ARG = "verbose";
    private static final String BOOTSTRAP_CONF_ARG = "bootstrapConf";
    private static final String NIFI_PROPERTIES_ARG = "niFiProperties";
    private static final String OUTPUT_NIFI_PROPERTIES_ARG = "outputNiFiProperties";
    private static final String LOGIN_IDENTITY_PROVIDERS_ARG = "loginIdentityProviders";
    private static final String OUTPUT_LOGIN_IDENTITY_PROVIDERS_ARG = "outputLoginIdentityProviders";
    private static final String AUTHORIZERS_ARG = "authorizers";
    private static final String OUTPUT_AUTHORIZERS_ARG = "outputAuthorizers";
    private static final String FLOW_XML_ARG = "flowXml";
    private static final String OUTPUT_FLOW_XML_ARG = "outputFlowXml";
    private static final String KEY_ARG = "key";
    private static final String PASSWORD_ARG = "password";
    private static final String KEY_MIGRATION_ARG = "oldKey";
    private static final String PASSWORD_MIGRATION_ARG = "oldPassword";
    private static final String USE_KEY_ARG = "useRawKey";
    private static final String MIGRATION_ARG = "migrate";
    private static final String PROPS_KEY_ARG = "propsKey";
    private static final String DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG = "encryptFlowXmlOnly";
    private static final String NEW_FLOW_ALGORITHM_ARG = "newFlowAlgorithm";
    private static final String NEW_FLOW_PROVIDER_ARG = "newFlowProvider";
    private static final String TRANSLATE_CLI_ARG = "translateCli";
    private static Options staticOptions;
    private static final String DEFAULT_NIFI_SENSITIVE_PROPS_KEY = "nififtw!";
    private static final int MIN_PASSWORD_LENGTH = 12;
    private static final int SCRYPT_N;
    private static final int SCRYPT_R = 8;
    private static final int SCRYPT_P = 1;
    private static final String CURRENT_SCRYPT_VERSION = "s0";
    private static final int DEFAULT_KDF_ITERATIONS = 1000;
    private static final int DEFAULT_SALT_SIZE_BYTES = 16;
    private static final String BOOTSTRAP_KEY_COMMENT = "# Master key in hexadecimal format for encrypted sensitive configuration values";
    private static final String BOOTSTRAP_KEY_PREFIX = "nifi.bootstrap.sensitive.key=";
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String NIFI_TOOLKIT_HOME = "NIFI_TOOLKIT_HOME";
    private static final String SEP;
    private static final String FOOTER;
    private static final String DEFAULT_DESCRIPTION;
    private static final String LDAP_PROVIDER_CLASS = "org.apache.nifi.ldap.LdapProvider";
    private static final String LDAP_PROVIDER_REGEX = "(?s)<provider>(?:(?!<provider>).)*?<class>\\s*org\\.apache\\.nifi\\.ldap\\.LdapProvider.*?</provider>";
    private static final String LDAP_USER_GROUP_PROVIDER_CLASS = "org.apache.nifi.ldap.tenants.LdapUserGroupProvider";
    private static final String LDAP_USER_GROUP_PROVIDER_REGEX = "(?s)<userGroupProvider>(?:(?!<userGroupProvider>).)*?<class>\\s*org\\.apache\\.nifi\\.ldap\\.tenants\\.LdapUserGroupProvider.*?</userGroupProvider>";
    private static final String XML_DECLARATION_REGEX = "<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>";
    private static final String WRAPPED_FLOW_XML_CIPHER_TEXT_REGEX = "enc\\{[a-fA-F0-9]+?\\}";
    private static final String DEFAULT_PROVIDER;
    private static final String DEFAULT_FLOW_ALGORITHM = "PBEWITHMD5AND256BITAES-CBC-OPENSSL";
    private static final Map<String, String> PROPERTY_KEY_MAP;
    private final Options options;
    private final String header;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$org$apache$nifi$properties$ProtectedNiFiProperties;

    public ConfigEncryptionTool() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        this(DEFAULT_DESCRIPTION);
    }

    /*
     * WARNING - void declaration
     */
    public ConfigEncryptionTool(String string) {
        void description;
        MetaClass metaClass;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        boolean bl9;
        boolean bl10;
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        this.usingPassword = bl10 = true;
        this.usingPasswordMigration = bl9 = true;
        this.migration = bl8 = false;
        this.isVerbose = bl7 = false;
        this.handlingNiFiProperties = bl6 = false;
        this.handlingLoginIdentityProviders = bl5 = false;
        this.handlingAuthorizers = bl4 = false;
        this.handlingFlowXml = bl3 = false;
        this.ignorePropertiesFiles = bl2 = false;
        this.translatingCli = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[0].callStatic(ConfigEncryptionTool.class, (Object)description);
            this.header = ShortTypeHandling.castToString((Object)object);
        } else {
            String string2 = ConfigEncryptionTool.buildHeader((String)description);
            this.header = ShortTypeHandling.castToString((Object)string2);
        }
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[1].callStatic(ConfigEncryptionTool.class);
            this.options = (Options)ScriptBytecodeAdapter.castToType((Object)object, Options.class);
        } else {
            Options options = ConfigEncryptionTool.getCliOptions();
            this.options = (Options)ScriptBytecodeAdapter.castToType((Object)options, Options.class);
        }
    }

    private static String buildHeader(String description) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{SEP, description, callSiteArray[2].call((Object)SEP, (Object)2)}, new String[]{"", "", "", ""}));
    }

    private static String buildFooter() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{SEP, callSiteArray[3].call(System.class, (Object)JAVA_HOME), SEP, callSiteArray[4].call(System.class, (Object)NIFI_TOOLKIT_HOME)}, new String[]{"", "Java home: ", "", "NiFi Toolkit home: ", ""}));
    }

    public static Options buildOptions() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Options options = (Options)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callConstructor(Options.class), Options.class);
        callSiteArray[6].call((Object)options, callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(Option.class, (Object)"h"), (Object)HELP_ARG), (Object)false), (Object)"Show usage information (this message)")));
        callSiteArray[12].call((Object)options, callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].call(Option.class, (Object)"v"), (Object)VERBOSE_ARG), (Object)false), (Object)"Sets verbose mode (default false)")));
        callSiteArray[18].call((Object)options, callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(callSiteArray[22].call(callSiteArray[23].call(callSiteArray[24].call(Option.class, (Object)"n"), (Object)NIFI_PROPERTIES_ARG), (Object)true), (Object)"file"), (Object)"The nifi.properties file containing unprotected config values (will be overwritten unless -o is specified)")));
        callSiteArray[25].call((Object)options, callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(Option.class, (Object)"o"), (Object)OUTPUT_NIFI_PROPERTIES_ARG), (Object)true), (Object)"file"), (Object)"The destination nifi.properties file containing protected config values (will not modify input nifi.properties)")));
        callSiteArray[32].call((Object)options, callSiteArray[33].call(callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(Option.class, (Object)"l"), (Object)LOGIN_IDENTITY_PROVIDERS_ARG), (Object)true), (Object)"file"), (Object)"The login-identity-providers.xml file containing unprotected config values (will be overwritten unless -i is specified)")));
        callSiteArray[39].call((Object)options, callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(Option.class, (Object)"i"), (Object)OUTPUT_LOGIN_IDENTITY_PROVIDERS_ARG), (Object)true), (Object)"file"), (Object)"The destination login-identity-providers.xml file containing protected config values (will not modify input login-identity-providers.xml)")));
        callSiteArray[46].call((Object)options, callSiteArray[47].call(callSiteArray[48].call(callSiteArray[49].call(callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call(Option.class, (Object)"a"), (Object)AUTHORIZERS_ARG), (Object)true), (Object)"file"), (Object)"The authorizers.xml file containing unprotected config values (will be overwritten unless -u is specified)")));
        callSiteArray[53].call((Object)options, callSiteArray[54].call(callSiteArray[55].call(callSiteArray[56].call(callSiteArray[57].call(callSiteArray[58].call(callSiteArray[59].call(Option.class, (Object)"u"), (Object)OUTPUT_AUTHORIZERS_ARG), (Object)true), (Object)"file"), (Object)"The destination authorizers.xml file containing protected config values (will not modify input authorizers.xml)")));
        callSiteArray[60].call((Object)options, callSiteArray[61].call(callSiteArray[62].call(callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].call(Option.class, (Object)"f"), (Object)FLOW_XML_ARG), (Object)true), (Object)"file"), (Object)"The flow.xml.gz file currently protected with old password (will be overwritten unless -g is specified)")));
        callSiteArray[67].call((Object)options, callSiteArray[68].call(callSiteArray[69].call(callSiteArray[70].call(callSiteArray[71].call(callSiteArray[72].call(callSiteArray[73].call(Option.class, (Object)"g"), (Object)OUTPUT_FLOW_XML_ARG), (Object)true), (Object)"file"), (Object)"The destination flow.xml.gz file containing protected config values (will not modify input flow.xml.gz)")));
        callSiteArray[74].call((Object)options, callSiteArray[75].call(callSiteArray[76].call(callSiteArray[77].call(callSiteArray[78].call(callSiteArray[79].call(callSiteArray[80].call(Option.class, (Object)"b"), (Object)BOOTSTRAP_CONF_ARG), (Object)true), (Object)"file"), (Object)"The bootstrap.conf file to persist master key")));
        callSiteArray[81].call((Object)options, callSiteArray[82].call(callSiteArray[83].call(callSiteArray[84].call(callSiteArray[85].call(callSiteArray[86].call(callSiteArray[87].call(Option.class, (Object)"k"), (Object)KEY_ARG), (Object)true), (Object)"keyhex"), (Object)"The raw hexadecimal key to use to encrypt the sensitive properties")));
        callSiteArray[88].call((Object)options, callSiteArray[89].call(callSiteArray[90].call(callSiteArray[91].call(callSiteArray[92].call(callSiteArray[93].call(callSiteArray[94].call(Option.class, (Object)"e"), (Object)KEY_MIGRATION_ARG), (Object)true), (Object)"keyhex"), (Object)"The old raw hexadecimal key to use during key migration")));
        callSiteArray[95].call((Object)options, callSiteArray[96].call(callSiteArray[97].call(callSiteArray[98].call(callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].call(Option.class, (Object)"p"), (Object)PASSWORD_ARG), (Object)true), (Object)PASSWORD_ARG), (Object)"The password from which to derive the key to use to encrypt the sensitive properties")));
        callSiteArray[102].call((Object)options, callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].call(callSiteArray[108].call(Option.class, (Object)"w"), (Object)PASSWORD_MIGRATION_ARG), (Object)true), (Object)PASSWORD_ARG), (Object)"The old password from which to derive the key during migration")));
        callSiteArray[109].call((Object)options, callSiteArray[110].call(callSiteArray[111].call(callSiteArray[112].call(callSiteArray[113].call(callSiteArray[114].call(Option.class, (Object)"r"), (Object)USE_KEY_ARG), (Object)false), (Object)"If provided, the secure console will prompt for the raw key value in hexadecimal form")));
        callSiteArray[115].call((Object)options, callSiteArray[116].call(callSiteArray[117].call(callSiteArray[118].call(callSiteArray[119].call(callSiteArray[120].call(Option.class, (Object)"m"), (Object)MIGRATION_ARG), (Object)false), (Object)"If provided, the nifi.properties and/or login-identity-providers.xml sensitive properties will be re-encrypted with a new key")));
        callSiteArray[121].call((Object)options, callSiteArray[122].call(callSiteArray[123].call(callSiteArray[124].call(callSiteArray[125].call(callSiteArray[126].call(Option.class, (Object)"x"), (Object)DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG), (Object)false), (Object)"If provided, the properties in flow.xml.gz will be re-encrypted with a new key but the nifi.properties and/or login-identity-providers.xml files will not be modified")));
        callSiteArray[127].call((Object)options, callSiteArray[128].call(callSiteArray[129].call(callSiteArray[130].call(callSiteArray[131].call(callSiteArray[132].call(callSiteArray[133].call(Option.class, (Object)"s"), (Object)PROPS_KEY_ARG), (Object)true), (Object)"password|keyhex"), (Object)"The password or key to use to encrypt the sensitive processor properties in flow.xml.gz")));
        callSiteArray[134].call((Object)options, callSiteArray[135].call(callSiteArray[136].call(callSiteArray[137].call(callSiteArray[138].call(callSiteArray[139].call(callSiteArray[140].call(Option.class, (Object)"A"), (Object)NEW_FLOW_ALGORITHM_ARG), (Object)true), (Object)"algorithm"), (Object)"The algorithm to use to encrypt the sensitive processor properties in flow.xml.gz")));
        callSiteArray[141].call((Object)options, callSiteArray[142].call(callSiteArray[143].call(callSiteArray[144].call(callSiteArray[145].call(callSiteArray[146].call(callSiteArray[147].call(Option.class, (Object)"P"), (Object)NEW_FLOW_PROVIDER_ARG), (Object)true), (Object)"algorithm"), (Object)"The security provider to use to encrypt the sensitive processor properties in flow.xml.gz")));
        callSiteArray[148].call((Object)options, callSiteArray[149].call(callSiteArray[150].call(callSiteArray[151].call(callSiteArray[152].call(callSiteArray[153].call(Option.class, (Object)"c"), (Object)TRANSLATE_CLI_ARG), (Object)false), (Object)"Translates the nifi.properties file to a format suitable for the NiFi CLI tool")));
        return options;
    }

    public static Options getCliOptions() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)staticOptions)) {
                Object object = callSiteArray[154].callStatic(ConfigEncryptionTool.class);
                staticOptions = (Options)ScriptBytecodeAdapter.castToType((Object)object, Options.class);
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)staticOptions)) {
            Options options;
            staticOptions = options = ConfigEncryptionTool.buildOptions();
        }
        return staticOptions;
    }

    public void printUsage(String errorMessage) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)errorMessage)) {
            callSiteArray[155].call(callSiteArray[156].callGetProperty(System.class), (Object)errorMessage);
            callSiteArray[157].call(callSiteArray[158].callGetProperty(System.class));
        }
        HelpFormatter helpFormatter = (HelpFormatter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[159].callConstructor(HelpFormatter.class), HelpFormatter.class);
        callSiteArray[160].call((Object)helpFormatter, (Object)160);
        callSiteArray[161].call((Object)helpFormatter, null);
        callSiteArray[162].call((Object)helpFormatter, ArrayUtil.createArray((Object)callSiteArray[163].call(ConfigEncryptionTool.class), (Object)this.header, (Object)this.options, (Object)FOOTER, (Object)true));
    }

    protected void printUsageAndThrow(String errorMessage, ExitCode exitCode) throws CommandLineParseException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[164].callCurrent((GroovyObject)this, (Object)errorMessage);
        } else {
            this.printUsage(errorMessage);
        }
        throw (Throwable)callSiteArray[165].callConstructor(CommandLineParseException.class, (Object)errorMessage, (Object)exitCode);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CommandLine parse(String ... args) throws CommandLineParseException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        CommandLineParser parser = (CommandLineParser)ScriptBytecodeAdapter.castToType((Object)callSiteArray[166].callConstructor(DefaultParser.class), CommandLineParser.class);
        CommandLine commandLine = null;
        try {
            Object object = callSiteArray[167].call((Object)parser, (Object)this.options, (Object)args);
            commandLine = (CommandLine)ScriptBytecodeAdapter.castToType((Object)object, CommandLine.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[168].call((Object)commandLine, (Object)HELP_ARG))) {
                callSiteArray[169].callCurrent((GroovyObject)this, null, callSiteArray[170].callGetProperty(ExitCode.class));
            }
            Object object2 = callSiteArray[171].call((Object)commandLine, (Object)VERBOSE_ARG);
            this.isVerbose = DefaultTypeTransformation.booleanUnbox((Object)object2);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[172].call((Object)commandLine, (Object)TRANSLATE_CLI_ARG))) {
                boolean bl;
                this.translatingCli = bl = true;
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[173].callCurrent((GroovyObject)this, (Object)commandLine, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{TRANSLATE_CLI_ARG, BOOTSTRAP_CONF_ARG, NIFI_PROPERTIES_ARG})))) {
                    callSiteArray[174].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{TRANSLATE_CLI_ARG}, new String[]{"When '-c'/'--", "' is specified, only '-h', '-v', and '-n'/'-b' with the relevant files are allowed"}), callSiteArray[175].callGetProperty(ExitCode.class));
                }
            }
            Object object3 = callSiteArray[176].call((Object)commandLine, (Object)BOOTSTRAP_CONF_ARG);
            this.bootstrapConfPath = ShortTypeHandling.castToString((Object)object3);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[177].call((Object)commandLine, (Object)NIFI_PROPERTIES_ARG))) {
                boolean bl;
                boolean ignoreFlagPresent = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[178].call((Object)commandLine, (Object)DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG));
                if (this.isVerbose && !ignoreFlagPresent) {
                    callSiteArray[179].call((Object)logger, (Object)"Handling encryption of nifi.properties");
                }
                Object object4 = callSiteArray[180].call((Object)commandLine, (Object)NIFI_PROPERTIES_ARG);
                this.niFiPropertiesPath = ShortTypeHandling.castToString((Object)object4);
                Object object5 = callSiteArray[181].call((Object)commandLine, (Object)OUTPUT_NIFI_PROPERTIES_ARG, (Object)this.niFiPropertiesPath);
                this.outputNiFiPropertiesPath = ShortTypeHandling.castToString((Object)object5);
                this.handlingNiFiProperties = bl = !ignoreFlagPresent;
                if (ScriptBytecodeAdapter.compareEqual((Object)this.niFiPropertiesPath, (Object)this.outputNiFiPropertiesPath)) {
                    callSiteArray[182].call((Object)logger, (Object)new GStringImpl(new Object[]{this.outputNiFiPropertiesPath}, new String[]{"The source nifi.properties and destination nifi.properties are identical [", "] so the original will be overwritten"}));
                }
            }
            if (this.translatingCli) {
                if (!(!DefaultTypeTransformation.booleanUnbox((Object)this.niFiPropertiesPath))) return commandLine;
                callSiteArray[183].callCurrent((GroovyObject)this, (Object)"When '-c'/'--translateCli' is specified, '-n'/'--niFiProperties' is required (and '-b'/'--bootstrapConf' is required if the properties are encrypted)", callSiteArray[184].callGetProperty(ExitCode.class));
                return commandLine;
            }
        }
        catch (ParseException e) {
            if (this.isVerbose) {
                callSiteArray[259].call((Object)logger, (Object)"Encountered an error", (Object)e);
            }
            callSiteArray[260].callCurrent((GroovyObject)this, callSiteArray[261].call(callSiteArray[262].call((Object)"Error parsing command line. (", callSiteArray[263].call((Object)e)), (Object)")"), callSiteArray[264].callGetProperty(ExitCode.class));
            return commandLine;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            block41: {
                block48: {
                    boolean bl;
                    block46: {
                        boolean bl2;
                        block47: {
                            block44: {
                                block45: {
                                    block43: {
                                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[185].call((Object)commandLine, (Object)DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG))) {
                                            boolean bl3;
                                            boolean bl4;
                                            boolean bl5;
                                            boolean bl6;
                                            this.handlingNiFiProperties = bl6 = false;
                                            this.handlingLoginIdentityProviders = bl5 = false;
                                            this.handlingAuthorizers = bl4 = false;
                                            this.ignorePropertiesFiles = bl3 = true;
                                        } else {
                                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[186].call((Object)commandLine, (Object)LOGIN_IDENTITY_PROVIDERS_ARG))) {
                                                boolean bl7;
                                                if (this.isVerbose) {
                                                    callSiteArray[187].call((Object)logger, (Object)"Handling encryption of login-identity-providers.xml");
                                                }
                                                Object object = callSiteArray[188].call((Object)commandLine, (Object)LOGIN_IDENTITY_PROVIDERS_ARG);
                                                this.loginIdentityProvidersPath = ShortTypeHandling.castToString((Object)object);
                                                Object object6 = callSiteArray[189].call((Object)commandLine, (Object)OUTPUT_LOGIN_IDENTITY_PROVIDERS_ARG, (Object)this.loginIdentityProvidersPath);
                                                this.outputLoginIdentityProvidersPath = ShortTypeHandling.castToString((Object)object6);
                                                this.handlingLoginIdentityProviders = bl7 = true;
                                                if (ScriptBytecodeAdapter.compareEqual((Object)this.loginIdentityProvidersPath, (Object)this.outputLoginIdentityProvidersPath)) {
                                                    callSiteArray[190].call((Object)logger, (Object)new GStringImpl(new Object[]{this.outputLoginIdentityProvidersPath}, new String[]{"The source login-identity-providers.xml and destination login-identity-providers.xml are identical [", "] so the original will be overwritten"}));
                                                }
                                            }
                                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[191].call((Object)commandLine, (Object)AUTHORIZERS_ARG))) {
                                                boolean bl8;
                                                if (this.isVerbose) {
                                                    callSiteArray[192].call((Object)logger, (Object)"Handling encryption of authorizers.xml");
                                                }
                                                Object object = callSiteArray[193].call((Object)commandLine, (Object)AUTHORIZERS_ARG);
                                                this.authorizersPath = ShortTypeHandling.castToString((Object)object);
                                                Object object7 = callSiteArray[194].call((Object)commandLine, (Object)OUTPUT_AUTHORIZERS_ARG, (Object)this.authorizersPath);
                                                this.outputAuthorizersPath = ShortTypeHandling.castToString((Object)object7);
                                                this.handlingAuthorizers = bl8 = true;
                                                if (ScriptBytecodeAdapter.compareEqual((Object)this.authorizersPath, (Object)this.outputAuthorizersPath)) {
                                                    callSiteArray[195].call((Object)logger, (Object)new GStringImpl(new Object[]{this.outputAuthorizersPath}, new String[]{"The source authorizers.xml and destination authorizers.xml are identical [", "] so the original will be overwritten"}));
                                                }
                                            }
                                        }
                                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[196].call((Object)commandLine, (Object)FLOW_XML_ARG))) {
                                            boolean bl9;
                                            if (this.isVerbose) {
                                                callSiteArray[197].call((Object)logger, (Object)"Handling encryption of flow.xml.gz");
                                            }
                                            Object object = callSiteArray[198].call((Object)commandLine, (Object)FLOW_XML_ARG);
                                            this.flowXmlPath = ShortTypeHandling.castToString((Object)object);
                                            Object object8 = callSiteArray[199].call((Object)commandLine, (Object)OUTPUT_FLOW_XML_ARG, (Object)this.flowXmlPath);
                                            this.outputFlowXmlPath = ShortTypeHandling.castToString((Object)object8);
                                            this.handlingFlowXml = bl9 = true;
                                            Object object9 = callSiteArray[200].call((Object)commandLine, (Object)NEW_FLOW_ALGORITHM_ARG);
                                            this.newFlowAlgorithm = ShortTypeHandling.castToString((Object)object9);
                                            Object object10 = callSiteArray[201].call((Object)commandLine, (Object)NEW_FLOW_PROVIDER_ARG);
                                            this.newFlowProvider = ShortTypeHandling.castToString((Object)object10);
                                            if (ScriptBytecodeAdapter.compareEqual((Object)this.flowXmlPath, (Object)this.outputFlowXmlPath)) {
                                                callSiteArray[202].call((Object)logger, (Object)new GStringImpl(new Object[]{this.outputFlowXmlPath}, new String[]{"The source flow.xml.gz and destination flow.xml.gz are identical [", "] so the original will be overwritten"}));
                                            }
                                            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[203].call((Object)commandLine, (Object)NIFI_PROPERTIES_ARG))) {
                                                callSiteArray[204].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{NIFI_PROPERTIES_ARG}, new String[]{"In order to migrate a flow.xml.gz, a nifi.properties file must also be specified via '-n'/'--", "'."}), callSiteArray[205].callGetProperty(ExitCode.class));
                                            }
                                        }
                                        if (this.isVerbose) {
                                            callSiteArray[206].call((Object)logger, (Object)new GStringImpl(new Object[]{this.bootstrapConfPath}, new String[]{"       bootstrap.conf:               ", ""}));
                                            callSiteArray[207].call((Object)logger, (Object)new GStringImpl(new Object[]{this.niFiPropertiesPath}, new String[]{"(src)  nifi.properties:              ", ""}));
                                            callSiteArray[208].call((Object)logger, (Object)new GStringImpl(new Object[]{this.outputNiFiPropertiesPath}, new String[]{"(dest) nifi.properties:              ", ""}));
                                            callSiteArray[209].call((Object)logger, (Object)new GStringImpl(new Object[]{this.loginIdentityProvidersPath}, new String[]{"(src)  login-identity-providers.xml: ", ""}));
                                            callSiteArray[210].call((Object)logger, (Object)new GStringImpl(new Object[]{this.outputLoginIdentityProvidersPath}, new String[]{"(dest) login-identity-providers.xml: ", ""}));
                                            callSiteArray[211].call((Object)logger, (Object)new GStringImpl(new Object[]{this.authorizersPath}, new String[]{"(src)  authorizers.xml:              ", ""}));
                                            callSiteArray[212].call((Object)logger, (Object)new GStringImpl(new Object[]{this.outputAuthorizersPath}, new String[]{"(dest) authorizers.xml:              ", ""}));
                                            callSiteArray[213].call((Object)logger, (Object)new GStringImpl(new Object[]{this.flowXmlPath}, new String[]{"(src)  flow.xml.gz:                  ", ""}));
                                            callSiteArray[214].call((Object)logger, (Object)new GStringImpl(new Object[]{this.outputFlowXmlPath}, new String[]{"(dest) flow.xml.gz:                  ", ""}));
                                        }
                                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) break block43;
                                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[226].call((Object)commandLine, (Object)NIFI_PROPERTIES_ARG))) break block44;
                                        break block45;
                                    }
                                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[215].call((Object)commandLine, (Object)NIFI_PROPERTIES_ARG)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[216].call((Object)commandLine, (Object)LOGIN_IDENTITY_PROVIDERS_ARG)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[217].call((Object)commandLine, (Object)AUTHORIZERS_ARG)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[218].call((Object)commandLine, (Object)DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG))) {
                                        callSiteArray[219].callCurrent((GroovyObject)this, callSiteArray[220].call(callSiteArray[221].call(callSiteArray[222].call(callSiteArray[223].call(callSiteArray[224].call((Object)"One or more of [", (Object)new GStringImpl(new Object[]{NIFI_PROPERTIES_ARG}, new String[]{"'-n'/'--", "', "})), (Object)new GStringImpl(new Object[]{LOGIN_IDENTITY_PROVIDERS_ARG}, new String[]{"'-l'/'--", "', "})), (Object)new GStringImpl(new Object[]{AUTHORIZERS_ARG}, new String[]{"'-a'/'--", "'"})), (Object)"] must be provided unless "), (Object)new GStringImpl(new Object[]{DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG}, new String[]{"'-x'/--'", "' is specified"})), callSiteArray[225].callGetProperty(ExitCode.class));
                                    }
                                    break block46;
                                }
                                bl2 = true;
                                break block47;
                            }
                            bl2 = false;
                        }
                        if (bl2 && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[227].call((Object)commandLine, (Object)LOGIN_IDENTITY_PROVIDERS_ARG)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[228].call((Object)commandLine, (Object)AUTHORIZERS_ARG)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[229].call((Object)commandLine, (Object)DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG))) {
                            callSiteArray[230].callCurrent((GroovyObject)this, callSiteArray[231].call(callSiteArray[232].call(callSiteArray[233].call(callSiteArray[234].call(callSiteArray[235].call((Object)"One or more of [", (Object)new GStringImpl(new Object[]{NIFI_PROPERTIES_ARG}, new String[]{"'-n'/'--", "', "})), (Object)new GStringImpl(new Object[]{LOGIN_IDENTITY_PROVIDERS_ARG}, new String[]{"'-l'/'--", "', "})), (Object)new GStringImpl(new Object[]{AUTHORIZERS_ARG}, new String[]{"'-a'/'--", "'"})), (Object)"] must be provided unless "), (Object)new GStringImpl(new Object[]{DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG}, new String[]{"'-x'/--'", "' is specified"})), callSiteArray[236].callGetProperty(ExitCode.class));
                        }
                    }
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[237].call((Object)commandLine, (Object)MIGRATION_ARG))) break block48;
                    this.migration = bl = true;
                    if (this.isVerbose) {
                        callSiteArray[238].call((Object)logger, (Object)"Key migration mode activated");
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[239].call((Object)commandLine, (Object)PASSWORD_MIGRATION_ARG))) {
                        boolean bl10;
                        this.usingPasswordMigration = bl10 = true;
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[240].call((Object)commandLine, (Object)KEY_MIGRATION_ARG))) {
                            callSiteArray[241].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{PASSWORD_MIGRATION_ARG, KEY_MIGRATION_ARG}, new String[]{"Only one of '-w'/'--", "' and '-e'/'--", "' can be used"}), callSiteArray[242].callGetProperty(ExitCode.class));
                            break block41;
                        } else {
                            Object object = callSiteArray[243].call((Object)commandLine, (Object)PASSWORD_MIGRATION_ARG);
                            this.migrationPassword = ShortTypeHandling.castToString((Object)object);
                        }
                        break block41;
                    } else {
                        boolean bl11;
                        Object object = callSiteArray[244].call((Object)commandLine, (Object)KEY_MIGRATION_ARG);
                        this.migrationKeyHex = ShortTypeHandling.castToString((Object)object);
                        this.usingPasswordMigration = bl11 = !DefaultTypeTransformation.booleanUnbox((Object)this.migrationKeyHex);
                    }
                    break block41;
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[245].call((Object)commandLine, (Object)PASSWORD_MIGRATION_ARG)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[246].call((Object)commandLine, (Object)KEY_MIGRATION_ARG))) {
                    callSiteArray[247].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{PASSWORD_MIGRATION_ARG, KEY_MIGRATION_ARG, MIGRATION_ARG}, new String[]{"'-w'/'--", "' and '-e'/'--", "' are ignored unless '-m'/'--", "' is enabled"}), callSiteArray[248].callGetProperty(ExitCode.class));
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[249].call((Object)commandLine, (Object)PASSWORD_ARG))) {
                boolean bl;
                this.usingPassword = bl = true;
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[250].call((Object)commandLine, (Object)KEY_ARG))) {
                    callSiteArray[251].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{PASSWORD_ARG, KEY_ARG}, new String[]{"Only one of '-p'/'--", "' and '-k'/'--", "' can be used"}), callSiteArray[252].callGetProperty(ExitCode.class));
                } else {
                    Object object = callSiteArray[253].call((Object)commandLine, (Object)PASSWORD_ARG);
                    this.password = ShortTypeHandling.castToString((Object)object);
                }
            } else {
                boolean bl;
                Object object = callSiteArray[254].call((Object)commandLine, (Object)KEY_ARG);
                this.keyHex = ShortTypeHandling.castToString((Object)object);
                this.usingPassword = bl = !DefaultTypeTransformation.booleanUnbox((Object)this.keyHex);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[255].call((Object)commandLine, (Object)USE_KEY_ARG))) {
                if (DefaultTypeTransformation.booleanUnbox((Object)this.keyHex) || DefaultTypeTransformation.booleanUnbox((Object)this.password)) {
                    callSiteArray[256].call((Object)logger, (Object)new GStringImpl(new Object[]{USE_KEY_ARG}, new String[]{"If the key or password is provided in the arguments, '-r'/'--", "' is ignored"}));
                } else {
                    boolean bl;
                    this.usingPassword = bl = false;
                }
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[257].call((Object)commandLine, (Object)PROPS_KEY_ARG))) return commandLine;
            Object object = callSiteArray[258].call((Object)commandLine, (Object)PROPS_KEY_ARG);
            this.flowPropertiesPassword = ShortTypeHandling.castToString((Object)object);
            return commandLine;
        }
    }

    public boolean commandLineHasActionFlags(CommandLine commandLine, List<String> acceptableOptionStrings) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        List ALWAYS_ACCEPTABLE_OPTIONS = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[265].callStatic(ConfigEncryptionTool.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{HELP_ARG, VERBOSE_ARG})), List.class);
        List acceptableOptions = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[266].callStatic(ConfigEncryptionTool.class, acceptableOptionStrings), List.class);
        List invalidOptions = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[267].call(callSiteArray[268].callGetProperty((Object)commandLine), callSiteArray[269].call((Object)acceptableOptions, (Object)ALWAYS_ACCEPTABLE_OPTIONS)), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)invalidOptions)) {
            if (this.isVerbose) {
                callSiteArray[270].call((Object)logger, (Object)new GStringImpl(new Object[]{invalidOptions}, new String[]{"In this mode, the following options are invalid: ", ""}));
            }
            return true;
        }
        return false;
    }

    public static List<Option> resolveOptions(List<String> strings) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[271].callSafe(strings, (Object)new GeneratedClosure(ConfigEncryptionTool.class, ConfigEncryptionTool.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _resolveOptions_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String opt) {
                Reference opt2 = new Reference((Object)opt);
                CallSite[] callSiteArray = _resolveOptions_closure1.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].callCurrent((GroovyObject)this)), (Object)new GeneratedClosure((Object)this, this.getThisObject(), opt2){
                    private /* synthetic */ Reference opt;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.opt = reference = opt;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.opt.get()) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callGetProperty(it), (Object)this.opt.get());
                        }
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)this.opt.get()) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty(it), (Object)this.opt.get());
                    }

                    public String getOpt() {
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.opt.get());
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "opt";
                        stringArray[1] = "longOpt";
                        stringArray[2] = "opt";
                        stringArray[3] = "longOpt";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure28.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure28.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure28.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                });
            }

            public Object call(String opt) {
                Reference opt2 = new Reference((Object)opt);
                CallSite[] callSiteArray = _resolveOptions_closure1.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[3].callCurrent((GroovyObject)this, (Object)((String)opt2.get()));
                }
                return this.doCall((String)opt2.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveOptions_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "find";
                stringArray[1] = "options";
                stringArray[2] = "getCliOptions";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _resolveOptions_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resolveOptions_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resolveOptions_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), List.class);
    }

    private String getKeyInternal(TextDevice device, String keyHex, String password, boolean usingPassword) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (usingPassword) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)password)) {
                if (this.isVerbose) {
                    callSiteArray[272].call((Object)logger, (Object)"Reading password from secure console");
                }
                Object object = callSiteArray[273].callStatic(ConfigEncryptionTool.class, (Object)device);
                password = ShortTypeHandling.castToString((Object)object);
            }
            Object object = callSiteArray[274].callStatic(ConfigEncryptionTool.class, (Object)password);
            keyHex = ShortTypeHandling.castToString((Object)object);
            Object var8_8 = null;
            password = ShortTypeHandling.castToString(var8_8);
            return keyHex;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)keyHex)) {
            if (this.isVerbose) {
                callSiteArray[275].call((Object)logger, (Object)"Reading hex key from secure console");
            }
            Object object = callSiteArray[276].callStatic(ConfigEncryptionTool.class, (Object)device);
            keyHex = ShortTypeHandling.castToString((Object)object);
        }
        return keyHex;
    }

    private String getKey(TextDevice textDevice) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[277].callCurrent((GroovyObject)this, (Object)textDevice, (Object)this.keyHex, (Object)this.password, (Object)this.usingPassword));
    }

    private String getMigrationKey() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[278].callCurrent((GroovyObject)this, callSiteArray[279].call(TextDevices.class), (Object)this.migrationKeyHex, (Object)this.migrationPassword, (Object)this.usingPasswordMigration));
    }

    private static String getFlowPassword(TextDevice textDevice) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[280].callStatic(ConfigEncryptionTool.class, (Object)textDevice));
    }

    private static String readKeyFromConsole(TextDevice textDevice) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        callSiteArray[281].call((Object)textDevice, (Object)"Enter the master key in hexadecimal format (spaces acceptable): ");
        return ShortTypeHandling.castToString((Object)callSiteArray[282].callConstructor(String.class, callSiteArray[283].call((Object)textDevice)));
    }

    private static String readPasswordFromConsole(TextDevice textDevice) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        callSiteArray[284].call((Object)textDevice, (Object)"Enter the password: ");
        return ShortTypeHandling.castToString((Object)callSiteArray[285].callConstructor(String.class, callSiteArray[286].call((Object)textDevice)));
    }

    private static String parseKey(String rawKey) throws KeyException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String hexKey = ShortTypeHandling.castToString((Object)callSiteArray[287].call((Object)rawKey, (Object)"[^0-9a-fA-F]", (Object)""));
        Object validKeyLengths = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            validKeyLengths = object = callSiteArray[288].callStatic(ConfigEncryptionTool.class);
        } else {
            List<Integer> list = ConfigEncryptionTool.getValidKeyLengths();
            validKeyLengths = list;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[289].call(validKeyLengths, callSiteArray[290].call(callSiteArray[291].call((Object)hexKey), (Object)4)))) {
            throw (Throwable)callSiteArray[292].callConstructor(KeyException.class, (Object)new GStringImpl(new Object[]{callSiteArray[293].call((Object)hexKey), validKeyLengths, callSiteArray[294].call(validKeyLengths, (Object)new GeneratedClosure(ConfigEncryptionTool.class, ConfigEncryptionTool.class){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _parseKey_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _parseKey_closure2.$getCallSiteArray();
                    return callSiteArray[0].call(it, (Object)4);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _parseKey_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _parseKey_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "div";
                    return new CallSiteArray(_parseKey_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _parseKey_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            })}, new String[]{"The key (", " hex chars) must be of length ", " bits (", " hex characters)"}));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[295].call((Object)hexKey));
    }

    public static List<Integer> getValidKeyLengths() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[296].call(Cipher.class, (Object)"AES"), (Object)128) ? ScriptBytecodeAdapter.createList((Object[])new Object[]{128, 192, 256}) : ScriptBytecodeAdapter.createList((Object[])new Object[]{128});
    }

    /*
     * Unable to fully structure code
     */
    private NiFiProperties loadNiFiProperties(String existingKeyHex) throws IOException {
        var2_2 = ConfigEncryptionTool.$getCallSiteArray();
        niFiPropertiesFile = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.niFiPropertiesPath)) ** GOTO lbl-1000
        var4_4 = var2_2[298].callConstructor(File.class, (Object)this.niFiPropertiesPath);
        niFiPropertiesFile = (File)ScriptBytecodeAdapter.castToType((Object)var4_4, File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[297].call(var4_4))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            properties = null;
            var6_6 = var2_2[299].call(var2_2[300].call(NiFiPropertiesLoader.class, (Object)existingKeyHex), (Object)niFiPropertiesFile);
            properties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)var6_6, NiFiProperties.class);
            var2_2[301].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{var2_2[302].call((Object)properties)}, new String[]{"Loaded NiFiProperties instance with ", " properties"}));
            var7_7 = properties;
            try {
                return var7_7;
            }
            catch (RuntimeException e) {
                if (this.isVerbose) {
                    var2_2[303].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                }
                throw (Throwable)var2_2[304].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.niFiPropertiesPath}, new String[]{"Cannot load NiFiProperties from [", "]"}), (Object)e);
            }
        }
        return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)var2_2[305].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{this.niFiPropertiesPath}, new String[]{"Cannot load NiFiProperties from [", "]"}), var2_2[306].callGetProperty(ExitCode.class)), NiFiProperties.class);
    }

    /*
     * Unable to fully structure code
     */
    private String loadLoginIdentityProviders(String existingKeyHex) throws IOException {
        var2_2 = ConfigEncryptionTool.$getCallSiteArray();
        loginIdentityProvidersFile = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.loginIdentityProvidersPath)) ** GOTO lbl-1000
        var4_4 = var2_2[308].callConstructor(File.class, (Object)this.loginIdentityProvidersPath);
        loginIdentityProvidersFile = (File)ScriptBytecodeAdapter.castToType((Object)var4_4, File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[307].call(var4_4))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            lines = (List)ScriptBytecodeAdapter.castToType((Object)var2_2[309].call(loginIdentityProvidersFile), List.class);
            xmlContent = ShortTypeHandling.castToString((Object)var2_2[310].call((Object)lines, (Object)"\n"));
            var2_2[311].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{var2_2[312].call((Object)lines)}, new String[]{"Loaded login identity providers content (", " lines)"}));
            decryptedXmlContent = ShortTypeHandling.castToString((Object)var2_2[313].callCurrent((GroovyObject)this, (Object)xmlContent, (Object)existingKeyHex));
            var8_8 = decryptedXmlContent;
            try {
                return var8_8;
            }
            catch (RuntimeException e) {
                if (this.isVerbose) {
                    var2_2[314].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                }
                throw (Throwable)var2_2[315].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.loginIdentityProvidersPath}, new String[]{"Cannot load login identity providers from [", "]"}), (Object)e);
            }
        }
        return ShortTypeHandling.castToString((Object)var2_2[316].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{this.loginIdentityProvidersPath}, new String[]{"Cannot load login identity providers from [", "]"}), var2_2[317].callGetProperty(ExitCode.class)));
    }

    /*
     * Unable to fully structure code
     */
    private String loadAuthorizers(String existingKeyHex) throws IOException {
        var2_2 = ConfigEncryptionTool.$getCallSiteArray();
        authorizersFile = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.authorizersPath)) ** GOTO lbl-1000
        var4_4 = var2_2[319].callConstructor(File.class, (Object)this.authorizersPath);
        authorizersFile = (File)ScriptBytecodeAdapter.castToType((Object)var4_4, File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[318].call(var4_4))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            lines = (List)ScriptBytecodeAdapter.castToType((Object)var2_2[320].call(authorizersFile), List.class);
            xmlContent = ShortTypeHandling.castToString((Object)var2_2[321].call((Object)lines, (Object)"\n"));
            var2_2[322].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{var2_2[323].call((Object)lines)}, new String[]{"Loaded authorizers content (", " lines)"}));
            decryptedXmlContent = ShortTypeHandling.castToString((Object)var2_2[324].callCurrent((GroovyObject)this, (Object)xmlContent, (Object)existingKeyHex));
            var8_8 = decryptedXmlContent;
            try {
                return var8_8;
            }
            catch (RuntimeException e) {
                if (this.isVerbose) {
                    var2_2[325].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                }
                throw (Throwable)var2_2[326].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.authorizersPath}, new String[]{"Cannot load authorizers from [", "]"}), (Object)e);
            }
        }
        return ShortTypeHandling.castToString((Object)var2_2[327].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{this.authorizersPath}, new String[]{"Cannot load authorizers from [", "]"}), var2_2[328].callGetProperty(ExitCode.class)));
    }

    private String loadFlowXml() throws IOException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.flowXmlPath) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[329].call(callSiteArray[330].callConstructor(File.class, (Object)this.flowXmlPath)))) {
            String string = ShortTypeHandling.castToString((Object)callSiteArray[331].call(callSiteArray[332].callConstructor(FileInputStream.class, (Object)this.flowXmlPath), (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _loadFlowXml_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _loadFlowXml_closure3.$getCallSiteArray();
                    return callSiteArray[0].call(callSiteArray[1].callConstructor(GZIPInputStream.class, it), (Object)new GeneratedClosure((Object)this, this.getThisObject()){
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;
                        {
                            CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                            String xmlContent = ShortTypeHandling.castToString((Object)callSiteArray[0].call(IOUtils.class, it, callSiteArray[1].callGetProperty(StandardCharsets.class)));
                            return xmlContent;
                        }

                        public Object doCall() {
                            CallSite[] callSiteArray = _closure29.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure29.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "toString";
                            stringArray[1] = "UTF_8";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure29.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure29.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure29.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    });
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _loadFlowXml_closure3.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadFlowXml_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "withCloseable";
                    stringArray[1] = "<$constructor$>";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _loadFlowXml_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_loadFlowXml_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _loadFlowXml_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }));
            try {
                return string;
            }
            catch (RuntimeException e) {
                if (this.isVerbose) {
                    callSiteArray[333].call((Object)logger, (Object)"Encountered an error", (Object)e);
                }
                throw (Throwable)callSiteArray[334].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.flowXmlPath}, new String[]{"Cannot load flow from [", "]"}), (Object)e);
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[335].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{this.flowXmlPath}, new String[]{"Cannot load flow from [", "]"}), callSiteArray[336].callGetProperty(ExitCode.class)));
    }

    private static String decryptFlowElement(String wrappedCipherText, String password, String algorithm, String provider) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)wrappedCipherText, (Object)WRAPPED_FLOW_XML_CIPHER_TEXT_REGEX))) {
            throw (Throwable)callSiteArray[337].callConstructor(SensitivePropertyProtectionException.class, (Object)"The provided cipher text does not match the expected format 'enc{0123456789ABCDEF...}'");
        }
        String unwrappedCipherText = ShortTypeHandling.castToString((Object)callSiteArray[338].call(callSiteArray[339].call((Object)wrappedCipherText, (Object)"enc\\{", (Object)""), (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)-1, (boolean)false)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[340].call(callSiteArray[341].call((Object)unwrappedCipherText), (Object)2), (Object)1) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[342].call((Object)unwrappedCipherText), (Object)0)) {
                throw (Throwable)callSiteArray[343].callConstructor(SensitivePropertyProtectionException.class, (Object)"The provided cipher text must have an even number of hex characters");
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[344].call(callSiteArray[345].call((Object)unwrappedCipherText), (Object)2), (Object)1) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[346].call((Object)unwrappedCipherText), (Object)0)) {
            throw (Throwable)callSiteArray[347].callConstructor(SensitivePropertyProtectionException.class, (Object)"The provided cipher text must have an even number of hex characters");
        }
        byte[] cipherBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[348].call(Hex.class, callSiteArray[349].callGetProperty((Object)unwrappedCipherText)), byte[].class);
        byte[] saltBytes = null;
        if (!BytecodeInterface8.isOrigB() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[350].call((Object)cipherBytes, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)DEFAULT_SALT_SIZE_BYTES, (boolean)false));
            saltBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            Object object = callSiteArray[351].call((Object)cipherBytes, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)DEFAULT_SALT_SIZE_BYTES, (boolean)false));
            saltBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        }
        if (!BytecodeInterface8.isOrigB() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[352].call((Object)cipherBytes, (Object)ScriptBytecodeAdapter.createRange((Object)DEFAULT_SALT_SIZE_BYTES, (Object)-1, (boolean)true));
            cipherBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            Object object = callSiteArray[353].call((Object)cipherBytes, (Object)ScriptBytecodeAdapter.createRange((Object)DEFAULT_SALT_SIZE_BYTES, (Object)-1, (boolean)true));
            cipherBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        }
        Cipher decryptionCipher = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[354].callStatic(ConfigEncryptionTool.class, (Object)password, (Object)saltBytes, (Object)algorithm, (Object)provider);
            decryptionCipher = (Cipher)ScriptBytecodeAdapter.castToType((Object)object, Cipher.class);
        } else {
            Cipher cipher;
            decryptionCipher = cipher = ConfigEncryptionTool.generateFlowDecryptionCipher(password, saltBytes, algorithm, provider);
        }
        byte[] plainBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[355].call((Object)decryptionCipher, (Object)cipherBytes), byte[].class);
        return ShortTypeHandling.castToString((Object)callSiteArray[356].callConstructor(String.class, (Object)plainBytes, callSiteArray[357].callGetProperty(StandardCharsets.class)));
    }

    private static Cipher generateFlowDecryptionCipher(String password, byte[] saltBytes, String algorithm, String provider) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Cipher decryptCipher = (Cipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[358].call(Cipher.class, (Object)algorithm, (Object)provider), Cipher.class);
        PBEKeySpec keySpec = (PBEKeySpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[359].callConstructor(PBEKeySpec.class, callSiteArray[360].callGetProperty((Object)password)), PBEKeySpec.class);
        SecretKeyFactory keyFactory = (SecretKeyFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[361].call(SecretKeyFactory.class, (Object)algorithm, (Object)provider), SecretKeyFactory.class);
        SecretKey pbeKey = (SecretKey)ScriptBytecodeAdapter.castToType((Object)callSiteArray[362].call((Object)keyFactory, (Object)keySpec), SecretKey.class);
        PBEParameterSpec parameterSpec = (PBEParameterSpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[363].callConstructor(PBEParameterSpec.class, (Object)saltBytes, (Object)DEFAULT_KDF_ITERATIONS), PBEParameterSpec.class);
        callSiteArray[364].call((Object)decryptCipher, callSiteArray[365].callGetProperty(Cipher.class), (Object)pbeKey, (Object)parameterSpec);
        return decryptCipher;
    }

    private static String encryptFlowElement(String plaintext, byte[] saltBytes, Cipher encryptCipher) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Object object = callSiteArray[366].callSafe((Object)plaintext, callSiteArray[367].callGetProperty(StandardCharsets.class));
        byte[] plainBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : (Object)new byte[0]), byte[].class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[368].callGetProperty((Object)saltBytes), (Object)DEFAULT_SALT_SIZE_BYTES)) {
            throw (Throwable)callSiteArray[369].callConstructor(SensitivePropertyProtectionException.class, (Object)new GStringImpl(new Object[]{DEFAULT_SALT_SIZE_BYTES}, new String[]{"The salt must be ", " bytes"}));
        }
        byte[] cipherBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[370].call((Object)encryptCipher, (Object)plainBytes), byte[].class);
        byte[] saltAndCipherBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[371].callStatic(ConfigEncryptionTool.class, (Object)saltBytes, (Object)cipherBytes), byte[].class);
        String hexEncodedCipherText = ShortTypeHandling.castToString((Object)callSiteArray[372].call(Hex.class, (Object)saltAndCipherBytes));
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{hexEncodedCipherText}, new String[]{"enc{", "}"}));
    }

    private static byte[] concatByteArrays(byte[] ... arrays) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Reference outputStream = new Reference((Object)((ByteArrayOutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[373].callConstructor(ByteArrayOutputStream.class), ByteArrayOutputStream.class)));
        callSiteArray[374].call((Object)arrays, (Object)new GeneratedClosure(ConfigEncryptionTool.class, ConfigEncryptionTool.class, outputStream){
            private /* synthetic */ Reference outputStream;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _concatByteArrays_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.outputStream = reference = outputStream;
            }

            public Object doCall(byte ... it) {
                CallSite[] callSiteArray = _concatByteArrays_closure4.$getCallSiteArray();
                return callSiteArray[0].call(this.outputStream.get(), (Object)it);
            }

            public Object call(byte ... it) {
                CallSite[] callSiteArray = _concatByteArrays_closure4.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[1].callCurrent((GroovyObject)this, (Object)it);
                }
                return this.doCall(it);
            }

            public ByteArrayOutputStream getOutputStream() {
                CallSite[] callSiteArray = _concatByteArrays_closure4.$getCallSiteArray();
                return (ByteArrayOutputStream)ScriptBytecodeAdapter.castToType((Object)this.outputStream.get(), ByteArrayOutputStream.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _concatByteArrays_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "write";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _concatByteArrays_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_concatByteArrays_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _concatByteArrays_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[375].call((Object)((ByteArrayOutputStream)outputStream.get())), byte[].class);
    }

    private String migrateFlowXmlContent(String flowXmlContent, String existingFlowPassword, String newFlowPassword, String existingAlgorithm, String existingProvider, String newAlgorithm, String newProvider) {
        Reference existingFlowPassword2 = new Reference((Object)existingFlowPassword);
        Reference existingAlgorithm2 = new Reference((Object)existingAlgorithm);
        Reference existingProvider2 = new Reference((Object)existingProvider);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Reference encryptionSalt = new Reference((Object)new byte[DEFAULT_SALT_SIZE_BYTES]);
        callSiteArray[376].call(callSiteArray[377].callConstructor(SecureRandom.class), (Object)((byte[])encryptionSalt.get()));
        Reference encryptCipher = new Reference(null);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[378].callStatic(ConfigEncryptionTool.class, (Object)newFlowPassword, (Object)((byte[])encryptionSalt.get()), (Object)newAlgorithm, (Object)newProvider);
            encryptCipher.set((Object)((Cipher)ScriptBytecodeAdapter.castToType((Object)object, Cipher.class)));
        } else {
            Cipher cipher = ConfigEncryptionTool.generateFlowEncryptionCipher(newFlowPassword, (byte[])encryptionSalt.get(), newAlgorithm, newProvider);
            encryptCipher.set((Object)cipher);
        }
        Reference elementCount = new Reference((Object)0);
        String migratedFlowXmlContent = ShortTypeHandling.castToString((Object)callSiteArray[379].call((Object)flowXmlContent, (Object)WRAPPED_FLOW_XML_CIPHER_TEXT_REGEX, (Object)new GeneratedClosure(this, this, existingAlgorithm2, existingFlowPassword2, existingProvider2, elementCount, encryptCipher, encryptionSalt){
            private /* synthetic */ Reference existingAlgorithm;
            private /* synthetic */ Reference existingFlowPassword;
            private /* synthetic */ Reference existingProvider;
            private /* synthetic */ Reference elementCount;
            private /* synthetic */ Reference encryptCipher;
            private /* synthetic */ Reference encryptionSalt;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                CallSite[] callSiteArray = _migrateFlowXmlContent_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.existingAlgorithm = reference6 = existingAlgorithm;
                this.existingFlowPassword = reference5 = existingFlowPassword;
                this.existingProvider = reference4 = existingProvider;
                this.elementCount = reference3 = elementCount;
                this.encryptCipher = reference2 = encryptCipher;
                this.encryptionSalt = reference = encryptionSalt;
            }

            public Object doCall(String wrappedCipherText) {
                CallSite[] callSiteArray = _migrateFlowXmlContent_closure5.$getCallSiteArray();
                String plaintext = ShortTypeHandling.castToString((Object)callSiteArray[0].callCurrent((GroovyObject)this, (Object)wrappedCipherText, this.existingFlowPassword.get(), this.existingAlgorithm.get(), this.existingProvider.get()));
                byte[] cipherBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(this.encryptCipher.get(), callSiteArray[2].callGetProperty((Object)plaintext)), byte[].class);
                byte[] saltAndCipherBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callCurrent((GroovyObject)this, this.encryptionSalt.get(), (Object)cipherBytes), byte[].class);
                Object object = this.elementCount.get();
                this.elementCount.set((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(object), Integer.class)));
                return new GStringImpl(new Object[]{callSiteArray[5].call(Hex.class, (Object)saltAndCipherBytes)}, new String[]{"enc{", "}"});
            }

            public Object call(String wrappedCipherText) {
                CallSite[] callSiteArray = _migrateFlowXmlContent_closure5.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[6].callCurrent((GroovyObject)this, (Object)wrappedCipherText);
                }
                return this.doCall(wrappedCipherText);
            }

            public String getExistingAlgorithm() {
                CallSite[] callSiteArray = _migrateFlowXmlContent_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.existingAlgorithm.get());
            }

            public String getExistingFlowPassword() {
                CallSite[] callSiteArray = _migrateFlowXmlContent_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.existingFlowPassword.get());
            }

            public String getExistingProvider() {
                CallSite[] callSiteArray = _migrateFlowXmlContent_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.existingProvider.get());
            }

            public Integer getElementCount() {
                CallSite[] callSiteArray = _migrateFlowXmlContent_closure5.$getCallSiteArray();
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.elementCount.get(), Integer.class);
            }

            public Cipher getEncryptCipher() {
                CallSite[] callSiteArray = _migrateFlowXmlContent_closure5.$getCallSiteArray();
                return (Cipher)ScriptBytecodeAdapter.castToType((Object)this.encryptCipher.get(), Cipher.class);
            }

            public byte[] getEncryptionSalt() {
                CallSite[] callSiteArray = _migrateFlowXmlContent_closure5.$getCallSiteArray();
                return (byte[])ScriptBytecodeAdapter.castToType((Object)this.encryptionSalt.get(), byte[].class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _migrateFlowXmlContent_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "decryptFlowElement";
                stringArray[1] = "doFinal";
                stringArray[2] = "bytes";
                stringArray[3] = "concatByteArrays";
                stringArray[4] = "next";
                stringArray[5] = "encodeHex";
                stringArray[6] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _migrateFlowXmlContent_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_migrateFlowXmlContent_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _migrateFlowXmlContent_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }));
        if (this.isVerbose) {
            callSiteArray[380].call((Object)logger, (Object)new GStringImpl(new Object[]{(Integer)elementCount.get()}, new String[]{"Decrypted and re-encrypted ", " elements for flow.xml.gz"}));
        }
        return migratedFlowXmlContent;
    }

    private static Cipher generateFlowEncryptionCipher(String newFlowPassword, byte[] saltBytes, String algorithm, String provider) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Cipher encryptCipher = (Cipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[381].call(Cipher.class, (Object)algorithm, (Object)provider), Cipher.class);
        PBEKeySpec keySpec = (PBEKeySpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[382].callConstructor(PBEKeySpec.class, callSiteArray[383].callGetProperty((Object)newFlowPassword)), PBEKeySpec.class);
        SecretKeyFactory keyFactory = (SecretKeyFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[384].call(SecretKeyFactory.class, (Object)algorithm, (Object)provider), SecretKeyFactory.class);
        SecretKey pbeKey = (SecretKey)ScriptBytecodeAdapter.castToType((Object)callSiteArray[385].call((Object)keyFactory, (Object)keySpec), SecretKey.class);
        PBEParameterSpec parameterSpec = (PBEParameterSpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[386].callConstructor(PBEParameterSpec.class, (Object)saltBytes, (Object)DEFAULT_KDF_ITERATIONS), PBEParameterSpec.class);
        callSiteArray[387].call((Object)encryptCipher, callSiteArray[388].callGetProperty(Cipher.class), (Object)pbeKey, (Object)parameterSpec);
        return encryptCipher;
    }

    private void writeFlowXmlToFile(String flowXmlContent) {
        Reference flowXmlContent2 = new Reference((Object)flowXmlContent);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        callSiteArray[389].call(callSiteArray[390].callConstructor(FileOutputStream.class, (Object)this.outputFlowXmlPath), (Object)new GeneratedClosure(this, this, flowXmlContent2){
            private /* synthetic */ Reference flowXmlContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _writeFlowXmlToFile_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.flowXmlContent = reference = flowXmlContent;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _writeFlowXmlToFile_closure6.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callConstructor(GZIPOutputStream.class, it), (Object)new GeneratedClosure((Object)this, this.getThisObject(), this.flowXmlContent){
                    private /* synthetic */ Reference flowXmlContent;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.flowXmlContent = reference = flowXmlContent;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        return callSiteArray[0].call(IOUtils.class, this.flowXmlContent.get(), it, callSiteArray[1].callGetProperty(StandardCharsets.class));
                    }

                    public String getFlowXmlContent() {
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.flowXmlContent.get());
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure30.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure30.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "write";
                        stringArray[1] = "UTF_8";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure30.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure30.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure30.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                });
            }

            public String getFlowXmlContent() {
                CallSite[] callSiteArray = _writeFlowXmlToFile_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.flowXmlContent.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _writeFlowXmlToFile_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _writeFlowXmlToFile_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "withCloseable";
                stringArray[1] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _writeFlowXmlToFile_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_writeFlowXmlToFile_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _writeFlowXmlToFile_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String decryptLoginIdentityProviders(String encryptedXml, String existingKeyHex) {
        Object passwords;
        Object doc;
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Reference sensitivePropertyProvider = new Reference((Object)((AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[391].callConstructor(AESSensitivePropertyProvider.class, (Object)existingKeyHex), AESSensitivePropertyProvider.class)));
        try {
            Object object;
            Object object2;
            doc = null;
            doc = !__$stMC && !BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[394].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)encryptedXml)) : (object = callSiteArray[392].call(callSiteArray[393].callStatic(ConfigEncryptionTool.class), (Object)encryptedXml));
            passwords = callSiteArray[395].call(callSiteArray[396].callGetProperty(callSiteArray[397].call(callSiteArray[398].callGetProperty(doc), (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _decryptLoginIdentityProviders_closure7.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _decryptLoginIdentityProviders_closure7.$getCallSiteArray();
                    return ScriptBytecodeAdapter.compareEqual((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].callGetProperty(it), String.class)), (Object)callSiteArray[1].callGetProperty(ConfigEncryptionTool.class));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _decryptLoginIdentityProviders_closure7.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _decryptLoginIdentityProviders_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "class";
                    stringArray[1] = "LDAP_PROVIDER_CLASS";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _decryptLoginIdentityProviders_closure7.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_decryptLoginIdentityProviders_closure7.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _decryptLoginIdentityProviders_closure7.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            })), (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _decryptLoginIdentityProviders_closure8.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _decryptLoginIdentityProviders_closure8.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)ScriptBytecodeAdapter.getField(_decryptLoginIdentityProviders_closure8.class, (Object)it, (String)"name"), (Object)"Password")) && DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)ScriptBytecodeAdapter.getField(_decryptLoginIdentityProviders_closure8.class, (Object)it, (String)"encryption"), (Object)"aes/gcm/\\d{3}"));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _decryptLoginIdentityProviders_closure8.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _decryptLoginIdentityProviders_closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_decryptLoginIdentityProviders_closure8.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _decryptLoginIdentityProviders_closure8.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[399].call(passwords))) {
                if (!this.isVerbose) return encryptedXml;
                callSiteArray[400].call((Object)logger, (Object)"No encrypted password property elements found in login-identity-providers.xml");
                return encryptedXml;
            }
        }
        catch (Exception e) {
            String string = ShortTypeHandling.castToString((Object)callSiteArray[404].callCurrent((GroovyObject)this, (Object)"Cannot decrypt login identity providers XML content", callSiteArray[405].callGetProperty(ExitCode.class)));
            return string;
        }
        {
            callSiteArray[401].call(passwords, (Object)new GeneratedClosure(this, this, sensitivePropertyProvider){
                private /* synthetic */ Reference sensitivePropertyProvider;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    CallSite[] callSiteArray = _decryptLoginIdentityProviders_closure9.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.sensitivePropertyProvider = reference = sensitivePropertyProvider;
                }

                public Object doCall(Object password) {
                    Reference password2 = new Reference(password);
                    CallSite[] callSiteArray = _decryptLoginIdentityProviders_closure9.$getCallSiteArray();
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)this))) {
                        callSiteArray[1].call(callSiteArray[2].callGetProperty(ConfigEncryptionTool.class), (Object)new GStringImpl(new Object[]{callSiteArray[3].call(password2.get())}, new String[]{"Attempting to decrypt ", ""}));
                    }
                    Reference decryptedValue = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[4].call(this.sensitivePropertyProvider.get(), callSiteArray[5].call(callSiteArray[6].call(password2.get())))));
                    return callSiteArray[7].call(password2.get(), (Object)new GeneratedClosure((Object)this, this.getThisObject(), password2, decryptedValue){
                        private /* synthetic */ Reference password;
                        private /* synthetic */ Reference decryptedValue;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;
                        {
                            Reference reference;
                            Reference reference2;
                            CallSite[] callSiteArray = _closure31.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.password = reference2 = password;
                            this.decryptedValue = reference = decryptedValue;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure31.$getCallSiteArray();
                            return callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", ScriptBytecodeAdapter.getField(_closure31.class, (Object)this.password.get(), (String)"name"), "encryption", "none"}), this.decryptedValue.get());
                        }

                        public Object getPassword() {
                            CallSite[] callSiteArray = _closure31.$getCallSiteArray();
                            return this.password.get();
                        }

                        public String getDecryptedValue() {
                            CallSite[] callSiteArray = _closure31.$getCallSiteArray();
                            return ShortTypeHandling.castToString((Object)this.decryptedValue.get());
                        }

                        public Object doCall() {
                            CallSite[] callSiteArray = _closure31.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure31.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "property";
                            return new CallSiteArray(_closure31.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure31.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    });
                }

                public AESSensitivePropertyProvider getSensitivePropertyProvider() {
                    CallSite[] callSiteArray = _decryptLoginIdentityProviders_closure9.$getCallSiteArray();
                    return (AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)this.sensitivePropertyProvider.get(), AESSensitivePropertyProvider.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _decryptLoginIdentityProviders_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "isVerbose";
                    stringArray[1] = "info";
                    stringArray[2] = "logger";
                    stringArray[3] = "text";
                    stringArray[4] = "unprotect";
                    stringArray[5] = "trim";
                    stringArray[6] = "text";
                    stringArray[7] = "replaceNode";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _decryptLoginIdentityProviders_closure9.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_decryptLoginIdentityProviders_closure9.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _decryptLoginIdentityProviders_closure9.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
            String updatedXml = ShortTypeHandling.castToString((Object)callSiteArray[402].call(XmlUtil.class, doc));
            callSiteArray[403].call((Object)logger, (Object)new GStringImpl(new Object[]{updatedXml}, new String[]{"Updated XML content: ", ""}));
            return updatedXml;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String decryptAuthorizers(String encryptedXml, String existingKeyHex) {
        Object passwords;
        Object doc;
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Reference sensitivePropertyProvider = new Reference((Object)((AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[406].callConstructor(AESSensitivePropertyProvider.class, (Object)existingKeyHex), AESSensitivePropertyProvider.class)));
        try {
            Object object;
            Object object2;
            String filename = "authorizers.xml";
            doc = null;
            doc = !__$stMC && !BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[409].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)encryptedXml)) : (object = callSiteArray[407].call(callSiteArray[408].callStatic(ConfigEncryptionTool.class), (Object)encryptedXml));
            passwords = callSiteArray[410].call(callSiteArray[411].callGetProperty(callSiteArray[412].call(callSiteArray[413].callGetProperty(doc), (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _decryptAuthorizers_closure10.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _decryptAuthorizers_closure10.$getCallSiteArray();
                    return ScriptBytecodeAdapter.compareEqual((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].callGetProperty(it), String.class)), (Object)callSiteArray[1].callGetProperty(ConfigEncryptionTool.class));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _decryptAuthorizers_closure10.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _decryptAuthorizers_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "class";
                    stringArray[1] = "LDAP_USER_GROUP_PROVIDER_CLASS";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _decryptAuthorizers_closure10.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_decryptAuthorizers_closure10.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _decryptAuthorizers_closure10.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            })), (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _decryptAuthorizers_closure11.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _decryptAuthorizers_closure11.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)ScriptBytecodeAdapter.getField(_decryptAuthorizers_closure11.class, (Object)it, (String)"name"), (Object)"Password")) && DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)ScriptBytecodeAdapter.getField(_decryptAuthorizers_closure11.class, (Object)it, (String)"encryption"), (Object)"aes/gcm/\\d{3}"));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _decryptAuthorizers_closure11.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _decryptAuthorizers_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_decryptAuthorizers_closure11.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _decryptAuthorizers_closure11.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[414].call(passwords))) {
                if (!this.isVerbose) return encryptedXml;
                callSiteArray[415].call((Object)logger, (Object)new GStringImpl(new Object[]{filename}, new String[]{"No encrypted password property elements found in ", ""}));
                return encryptedXml;
            }
        }
        catch (Exception e) {
            String string = ShortTypeHandling.castToString((Object)callSiteArray[419].callCurrent((GroovyObject)this, (Object)"Cannot decrypt authorizers XML content", callSiteArray[420].callGetProperty(ExitCode.class)));
            return string;
        }
        {
            callSiteArray[416].call(passwords, (Object)new GeneratedClosure(this, this, sensitivePropertyProvider){
                private /* synthetic */ Reference sensitivePropertyProvider;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    CallSite[] callSiteArray = _decryptAuthorizers_closure12.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.sensitivePropertyProvider = reference = sensitivePropertyProvider;
                }

                public Object doCall(Object password) {
                    Reference password2 = new Reference(password);
                    CallSite[] callSiteArray = _decryptAuthorizers_closure12.$getCallSiteArray();
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)this))) {
                        callSiteArray[1].call(callSiteArray[2].callGetProperty(ConfigEncryptionTool.class), (Object)new GStringImpl(new Object[]{callSiteArray[3].call(password2.get())}, new String[]{"Attempting to decrypt ", ""}));
                    }
                    Reference decryptedValue = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[4].call(this.sensitivePropertyProvider.get(), callSiteArray[5].call(callSiteArray[6].call(password2.get())))));
                    return callSiteArray[7].call(password2.get(), (Object)new GeneratedClosure((Object)this, this.getThisObject(), password2, decryptedValue){
                        private /* synthetic */ Reference password;
                        private /* synthetic */ Reference decryptedValue;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;
                        {
                            Reference reference;
                            Reference reference2;
                            CallSite[] callSiteArray = _closure32.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.password = reference2 = password;
                            this.decryptedValue = reference = decryptedValue;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure32.$getCallSiteArray();
                            return callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", ScriptBytecodeAdapter.getField(_closure32.class, (Object)this.password.get(), (String)"name"), "encryption", "none"}), this.decryptedValue.get());
                        }

                        public Object getPassword() {
                            CallSite[] callSiteArray = _closure32.$getCallSiteArray();
                            return this.password.get();
                        }

                        public String getDecryptedValue() {
                            CallSite[] callSiteArray = _closure32.$getCallSiteArray();
                            return ShortTypeHandling.castToString((Object)this.decryptedValue.get());
                        }

                        public Object doCall() {
                            CallSite[] callSiteArray = _closure32.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure32.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "property";
                            return new CallSiteArray(_closure32.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure32.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    });
                }

                public AESSensitivePropertyProvider getSensitivePropertyProvider() {
                    CallSite[] callSiteArray = _decryptAuthorizers_closure12.$getCallSiteArray();
                    return (AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)this.sensitivePropertyProvider.get(), AESSensitivePropertyProvider.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _decryptAuthorizers_closure12.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "isVerbose";
                    stringArray[1] = "info";
                    stringArray[2] = "logger";
                    stringArray[3] = "text";
                    stringArray[4] = "unprotect";
                    stringArray[5] = "trim";
                    stringArray[6] = "text";
                    stringArray[7] = "replaceNode";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _decryptAuthorizers_closure12.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_decryptAuthorizers_closure12.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _decryptAuthorizers_closure12.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
            String updatedXml = ShortTypeHandling.castToString((Object)callSiteArray[417].call(XmlUtil.class, doc));
            if (!this.isVerbose) return updatedXml;
            callSiteArray[418].call((Object)logger, (Object)new GStringImpl(new Object[]{updatedXml}, new String[]{"Updated XML content: ", ""}));
            return updatedXml;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String encryptLoginIdentityProviders(String plainXml, String newKeyHex) {
        Object passwords;
        Object doc;
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Reference sensitivePropertyProvider = new Reference((Object)((AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[421].callConstructor(AESSensitivePropertyProvider.class, (Object)newKeyHex), AESSensitivePropertyProvider.class)));
        try {
            Object object;
            Object object2;
            doc = null;
            doc = !__$stMC && !BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[424].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)plainXml)) : (object = callSiteArray[422].call(callSiteArray[423].callStatic(ConfigEncryptionTool.class), (Object)plainXml));
            passwords = callSiteArray[425].call(callSiteArray[426].callGetProperty(callSiteArray[427].call(callSiteArray[428].callGetProperty(doc), (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _encryptLoginIdentityProviders_closure13.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _encryptLoginIdentityProviders_closure13.$getCallSiteArray();
                    return ScriptBytecodeAdapter.compareEqual((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].callGetProperty(it), String.class)), (Object)callSiteArray[1].callGetProperty(ConfigEncryptionTool.class));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _encryptLoginIdentityProviders_closure13.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _encryptLoginIdentityProviders_closure13.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "class";
                    stringArray[1] = "LDAP_PROVIDER_CLASS";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _encryptLoginIdentityProviders_closure13.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_encryptLoginIdentityProviders_closure13.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _encryptLoginIdentityProviders_closure13.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            })), (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _encryptLoginIdentityProviders_closure14.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _encryptLoginIdentityProviders_closure14.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)ScriptBytecodeAdapter.getField(_encryptLoginIdentityProviders_closure14.class, (Object)it, (String)"name"), (Object)"Password")) && (ScriptBytecodeAdapter.compareEqual((Object)ScriptBytecodeAdapter.getField(_encryptLoginIdentityProviders_closure14.class, (Object)it, (String)"encryption"), (Object)"none") || ScriptBytecodeAdapter.compareEqual((Object)ScriptBytecodeAdapter.getField(_encryptLoginIdentityProviders_closure14.class, (Object)it, (String)"encryption"), (Object)"")) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(it));
                    }
                    return DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)ScriptBytecodeAdapter.getField(_encryptLoginIdentityProviders_closure14.class, (Object)it, (String)"name"), (Object)"Password")) && (ScriptBytecodeAdapter.compareEqual((Object)ScriptBytecodeAdapter.getField(_encryptLoginIdentityProviders_closure14.class, (Object)it, (String)"encryption"), (Object)"none") || ScriptBytecodeAdapter.compareEqual((Object)ScriptBytecodeAdapter.getField(_encryptLoginIdentityProviders_closure14.class, (Object)it, (String)"encryption"), (Object)"")) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(it));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _encryptLoginIdentityProviders_closure14.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _encryptLoginIdentityProviders_closure14.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "text";
                    stringArray[1] = "text";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _encryptLoginIdentityProviders_closure14.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_encryptLoginIdentityProviders_closure14.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _encryptLoginIdentityProviders_closure14.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[429].call(passwords))) {
                if (!this.isVerbose) return plainXml;
                callSiteArray[430].call((Object)logger, (Object)"No unencrypted password property elements found in login-identity-providers.xml");
                return plainXml;
            }
        }
        catch (Exception e) {
            if (this.isVerbose) {
                callSiteArray[434].call((Object)logger, (Object)"Encountered exception", (Object)e);
            }
            String string = ShortTypeHandling.castToString((Object)callSiteArray[435].callCurrent((GroovyObject)this, (Object)"Cannot encrypt login identity providers XML content", callSiteArray[436].callGetProperty(ExitCode.class)));
            return string;
        }
        {
            callSiteArray[431].call(passwords, (Object)new GeneratedClosure(this, this, sensitivePropertyProvider){
                private /* synthetic */ Reference sensitivePropertyProvider;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    CallSite[] callSiteArray = _encryptLoginIdentityProviders_closure15.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.sensitivePropertyProvider = reference = sensitivePropertyProvider;
                }

                public Object doCall(Object password) {
                    Reference password2 = new Reference(password);
                    CallSite[] callSiteArray = _encryptLoginIdentityProviders_closure15.$getCallSiteArray();
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)this))) {
                        callSiteArray[1].call(callSiteArray[2].callGetProperty(ConfigEncryptionTool.class), (Object)new GStringImpl(new Object[]{callSiteArray[3].call(password2.get())}, new String[]{"Attempting to encrypt ", ""}));
                    }
                    Reference encryptedValue = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[4].call(this.sensitivePropertyProvider.get(), callSiteArray[5].call(callSiteArray[6].call(password2.get())))));
                    return callSiteArray[7].call(password2.get(), (Object)new GeneratedClosure((Object)this, this.getThisObject(), this.sensitivePropertyProvider, password2, encryptedValue){
                        private /* synthetic */ Reference sensitivePropertyProvider;
                        private /* synthetic */ Reference password;
                        private /* synthetic */ Reference encryptedValue;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;
                        {
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            CallSite[] callSiteArray = _closure33.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.sensitivePropertyProvider = reference3 = sensitivePropertyProvider;
                            this.password = reference2 = password;
                            this.encryptedValue = reference = encryptedValue;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure33.$getCallSiteArray();
                            return callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", ScriptBytecodeAdapter.getField(_closure33.class, (Object)this.password.get(), (String)"name"), "encryption", callSiteArray[1].callGetProperty(this.sensitivePropertyProvider.get())}), this.encryptedValue.get());
                        }

                        public AESSensitivePropertyProvider getSensitivePropertyProvider() {
                            CallSite[] callSiteArray = _closure33.$getCallSiteArray();
                            return (AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)this.sensitivePropertyProvider.get(), AESSensitivePropertyProvider.class);
                        }

                        public Object getPassword() {
                            CallSite[] callSiteArray = _closure33.$getCallSiteArray();
                            return this.password.get();
                        }

                        public String getEncryptedValue() {
                            CallSite[] callSiteArray = _closure33.$getCallSiteArray();
                            return ShortTypeHandling.castToString((Object)this.encryptedValue.get());
                        }

                        public Object doCall() {
                            CallSite[] callSiteArray = _closure33.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure33.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "property";
                            stringArray[1] = "identifierKey";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure33.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure33.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure33.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    });
                }

                public AESSensitivePropertyProvider getSensitivePropertyProvider() {
                    CallSite[] callSiteArray = _encryptLoginIdentityProviders_closure15.$getCallSiteArray();
                    return (AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)this.sensitivePropertyProvider.get(), AESSensitivePropertyProvider.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _encryptLoginIdentityProviders_closure15.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "isVerbose";
                    stringArray[1] = "info";
                    stringArray[2] = "logger";
                    stringArray[3] = "name";
                    stringArray[4] = "protect";
                    stringArray[5] = "trim";
                    stringArray[6] = "text";
                    stringArray[7] = "replaceNode";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _encryptLoginIdentityProviders_closure15.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_encryptLoginIdentityProviders_closure15.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _encryptLoginIdentityProviders_closure15.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
            String updatedXml = ShortTypeHandling.castToString((Object)callSiteArray[432].call(XmlUtil.class, doc));
            callSiteArray[433].call((Object)logger, (Object)new GStringImpl(new Object[]{updatedXml}, new String[]{"Updated XML content: ", ""}));
            return updatedXml;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String encryptAuthorizers(String plainXml, String newKeyHex) {
        Object passwords;
        Object doc;
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Reference sensitivePropertyProvider = new Reference((Object)((AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[437].callConstructor(AESSensitivePropertyProvider.class, (Object)newKeyHex), AESSensitivePropertyProvider.class)));
        try {
            Object object;
            Object object2;
            String filename = "authorizers.xml";
            doc = null;
            doc = !__$stMC && !BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[440].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)plainXml)) : (object = callSiteArray[438].call(callSiteArray[439].callStatic(ConfigEncryptionTool.class), (Object)plainXml));
            passwords = callSiteArray[441].call(callSiteArray[442].callGetProperty(callSiteArray[443].call(callSiteArray[444].callGetProperty(doc), (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _encryptAuthorizers_closure16.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _encryptAuthorizers_closure16.$getCallSiteArray();
                    return ScriptBytecodeAdapter.compareEqual((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].callGetProperty(it), String.class)), (Object)callSiteArray[1].callGetProperty(ConfigEncryptionTool.class));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _encryptAuthorizers_closure16.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _encryptAuthorizers_closure16.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "class";
                    stringArray[1] = "LDAP_USER_GROUP_PROVIDER_CLASS";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _encryptAuthorizers_closure16.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_encryptAuthorizers_closure16.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _encryptAuthorizers_closure16.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            })), (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _encryptAuthorizers_closure17.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _encryptAuthorizers_closure17.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)ScriptBytecodeAdapter.getField(_encryptAuthorizers_closure17.class, (Object)it, (String)"name"), (Object)"Password")) && (ScriptBytecodeAdapter.compareEqual((Object)ScriptBytecodeAdapter.getField(_encryptAuthorizers_closure17.class, (Object)it, (String)"encryption"), (Object)"none") || ScriptBytecodeAdapter.compareEqual((Object)ScriptBytecodeAdapter.getField(_encryptAuthorizers_closure17.class, (Object)it, (String)"encryption"), (Object)"")) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(it));
                    }
                    return DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)ScriptBytecodeAdapter.getField(_encryptAuthorizers_closure17.class, (Object)it, (String)"name"), (Object)"Password")) && (ScriptBytecodeAdapter.compareEqual((Object)ScriptBytecodeAdapter.getField(_encryptAuthorizers_closure17.class, (Object)it, (String)"encryption"), (Object)"none") || ScriptBytecodeAdapter.compareEqual((Object)ScriptBytecodeAdapter.getField(_encryptAuthorizers_closure17.class, (Object)it, (String)"encryption"), (Object)"")) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(it));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _encryptAuthorizers_closure17.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _encryptAuthorizers_closure17.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "text";
                    stringArray[1] = "text";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _encryptAuthorizers_closure17.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_encryptAuthorizers_closure17.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _encryptAuthorizers_closure17.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[445].call(passwords))) {
                if (!this.isVerbose) return plainXml;
                callSiteArray[446].call((Object)logger, (Object)new GStringImpl(new Object[]{filename}, new String[]{"No unencrypted password property elements found in ", ""}));
                return plainXml;
            }
        }
        catch (Exception e) {
            if (this.isVerbose) {
                callSiteArray[450].call((Object)logger, (Object)"Encountered exception", (Object)e);
            }
            String string = ShortTypeHandling.castToString((Object)callSiteArray[451].callCurrent((GroovyObject)this, (Object)"Cannot encrypt authorizers XML content", callSiteArray[452].callGetProperty(ExitCode.class)));
            return string;
        }
        {
            callSiteArray[447].call(passwords, (Object)new GeneratedClosure(this, this, sensitivePropertyProvider){
                private /* synthetic */ Reference sensitivePropertyProvider;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    CallSite[] callSiteArray = _encryptAuthorizers_closure18.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.sensitivePropertyProvider = reference = sensitivePropertyProvider;
                }

                public Object doCall(Object password) {
                    Reference password2 = new Reference(password);
                    CallSite[] callSiteArray = _encryptAuthorizers_closure18.$getCallSiteArray();
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)this))) {
                        callSiteArray[1].call(callSiteArray[2].callGetProperty(ConfigEncryptionTool.class), (Object)new GStringImpl(new Object[]{callSiteArray[3].call(password2.get())}, new String[]{"Attempting to encrypt ", ""}));
                    }
                    Reference encryptedValue = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[4].call(this.sensitivePropertyProvider.get(), callSiteArray[5].call(callSiteArray[6].call(password2.get())))));
                    return callSiteArray[7].call(password2.get(), (Object)new GeneratedClosure((Object)this, this.getThisObject(), this.sensitivePropertyProvider, password2, encryptedValue){
                        private /* synthetic */ Reference sensitivePropertyProvider;
                        private /* synthetic */ Reference password;
                        private /* synthetic */ Reference encryptedValue;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;
                        {
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            CallSite[] callSiteArray = _closure34.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.sensitivePropertyProvider = reference3 = sensitivePropertyProvider;
                            this.password = reference2 = password;
                            this.encryptedValue = reference = encryptedValue;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure34.$getCallSiteArray();
                            return callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", ScriptBytecodeAdapter.getField(_closure34.class, (Object)this.password.get(), (String)"name"), "encryption", callSiteArray[1].callGetProperty(this.sensitivePropertyProvider.get())}), this.encryptedValue.get());
                        }

                        public AESSensitivePropertyProvider getSensitivePropertyProvider() {
                            CallSite[] callSiteArray = _closure34.$getCallSiteArray();
                            return (AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)this.sensitivePropertyProvider.get(), AESSensitivePropertyProvider.class);
                        }

                        public Object getPassword() {
                            CallSite[] callSiteArray = _closure34.$getCallSiteArray();
                            return this.password.get();
                        }

                        public String getEncryptedValue() {
                            CallSite[] callSiteArray = _closure34.$getCallSiteArray();
                            return ShortTypeHandling.castToString((Object)this.encryptedValue.get());
                        }

                        public Object doCall() {
                            CallSite[] callSiteArray = _closure34.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure34.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "property";
                            stringArray[1] = "identifierKey";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure34.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure34.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure34.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    });
                }

                public AESSensitivePropertyProvider getSensitivePropertyProvider() {
                    CallSite[] callSiteArray = _encryptAuthorizers_closure18.$getCallSiteArray();
                    return (AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)this.sensitivePropertyProvider.get(), AESSensitivePropertyProvider.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _encryptAuthorizers_closure18.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "isVerbose";
                    stringArray[1] = "info";
                    stringArray[2] = "logger";
                    stringArray[3] = "name";
                    stringArray[4] = "protect";
                    stringArray[5] = "trim";
                    stringArray[6] = "text";
                    stringArray[7] = "replaceNode";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _encryptAuthorizers_closure18.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_encryptAuthorizers_closure18.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _encryptAuthorizers_closure18.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
            String updatedXml = ShortTypeHandling.castToString((Object)callSiteArray[448].call(XmlUtil.class, doc));
            if (!this.isVerbose) return updatedXml;
            callSiteArray[449].call((Object)logger, (Object)new GStringImpl(new Object[]{updatedXml}, new String[]{"Updated XML content: ", ""}));
            return updatedXml;
        }
    }

    private NiFiProperties encryptSensitiveProperties(NiFiProperties plainProperties) {
        Reference plainProperties2 = new Reference((Object)plainProperties);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)((NiFiProperties)plainProperties2.get()))) {
            throw (Throwable)callSiteArray[453].callConstructor(IllegalArgumentException.class, (Object)"Cannot encrypt empty NiFiProperties");
        }
        Reference protectedWrapper = new Reference((Object)((ProtectedNiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[454].callConstructor((Object)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties(), (Object)((NiFiProperties)plainProperties2.get())), (Class)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties())));
        List sensitivePropertyKeys = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[455].call((Object)((ProtectedNiFiProperties)protectedWrapper.get())), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[456].call((Object)sensitivePropertyKeys))) {
            callSiteArray[457].call((Object)logger, (Object)"No sensitive properties to encrypt");
            return (NiFiProperties)plainProperties2.get();
        }
        Reference encryptedProperties = new Reference((Object)((Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[458].callConstructor(Properties.class), Properties.class)));
        Reference spp = new Reference((Object)((AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[459].callConstructor(AESSensitivePropertyProvider.class, (Object)this.keyHex), AESSensitivePropertyProvider.class)));
        callSiteArray[460].call((Object)((ProtectedNiFiProperties)protectedWrapper.get()), (Object)((AESSensitivePropertyProvider)spp.get()));
        Reference keysToSkip = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        callSiteArray[461].call((Object)sensitivePropertyKeys, (Object)new GeneratedClosure(this, this, protectedWrapper, spp, encryptedProperties, keysToSkip, plainProperties2){
            private /* synthetic */ Reference protectedWrapper;
            private /* synthetic */ Reference spp;
            private /* synthetic */ Reference encryptedProperties;
            private /* synthetic */ Reference keysToSkip;
            private /* synthetic */ Reference plainProperties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$apache$nifi$properties$ProtectedNiFiProperties;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.protectedWrapper = reference5 = protectedWrapper;
                this.spp = reference4 = spp;
                this.encryptedProperties = reference3 = encryptedProperties;
                this.keysToSkip = reference2 = keysToSkip;
                this.plainProperties = reference = plainProperties;
            }

            public Object doCall(String key) {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure19.$getCallSiteArray();
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.plainProperties.get(), (Object)key))) {
                    return callSiteArray[1].call(callSiteArray[2].callGetProperty(ConfigEncryptionTool.class), (Object)new GStringImpl(new Object[]{key}, new String[]{"Skipping encryption of ", " because it is empty"}));
                }
                String protectedValue = ShortTypeHandling.castToString((Object)callSiteArray[3].call(this.spp.get(), callSiteArray[4].call(this.plainProperties.get(), (Object)key)));
                callSiteArray[5].call(this.encryptedProperties.get(), (Object)key, (Object)protectedValue);
                callSiteArray[6].call(callSiteArray[7].callGetProperty(ConfigEncryptionTool.class), (Object)new GStringImpl(new Object[]{key, callSiteArray[8].call(this.spp.get()), protectedValue}, new String[]{"Protected ", " with ", " -> \t", ""}));
                String protectionKey = ShortTypeHandling.castToString((Object)callSiteArray[9].call(this.protectedWrapper.get(), (Object)key));
                callSiteArray[10].call(this.encryptedProperties.get(), (Object)protectionKey, callSiteArray[11].call(this.spp.get()));
                callSiteArray[12].call(callSiteArray[13].callGetProperty(ConfigEncryptionTool.class), (Object)new GStringImpl(new Object[]{protectionKey}, new String[]{"Updated protection key ", ""}));
                return callSiteArray[14].call(callSiteArray[15].call(this.keysToSkip.get(), (Object)key), (Object)protectionKey);
            }

            public Object call(String key) {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure19.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[16].callCurrent((GroovyObject)this, (Object)key);
                }
                return this.doCall(key);
            }

            public ProtectedNiFiProperties getProtectedWrapper() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure19.$getCallSiteArray();
                return (ProtectedNiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.protectedWrapper.get(), (Class)_encryptSensitiveProperties_closure19.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties());
            }

            public AESSensitivePropertyProvider getSpp() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure19.$getCallSiteArray();
                return (AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)this.spp.get(), AESSensitivePropertyProvider.class);
            }

            public Properties getEncryptedProperties() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure19.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.encryptedProperties.get(), Properties.class);
            }

            public List getKeysToSkip() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure19.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.keysToSkip.get(), List.class);
            }

            public NiFiProperties getPlainProperties() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure19.$getCallSiteArray();
                return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.plainProperties.get(), NiFiProperties.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _encryptSensitiveProperties_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getProperty";
                stringArray[1] = "debug";
                stringArray[2] = "logger";
                stringArray[3] = "protect";
                stringArray[4] = "getProperty";
                stringArray[5] = "setProperty";
                stringArray[6] = "info";
                stringArray[7] = "logger";
                stringArray[8] = "getIdentifierKey";
                stringArray[9] = "getProtectionKey";
                stringArray[10] = "setProperty";
                stringArray[11] = "getIdentifierKey";
                stringArray[12] = "info";
                stringArray[13] = "logger";
                stringArray[14] = "leftShift";
                stringArray[15] = "leftShift";
                stringArray[16] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[17];
                _encryptSensitiveProperties_closure19.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_encryptSensitiveProperties_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _encryptSensitiveProperties_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$apache$nifi$properties$ProtectedNiFiProperties() {
                Class clazz = $class$org$apache$nifi$properties$ProtectedNiFiProperties;
                if (clazz == null) {
                    clazz = $class$org$apache$nifi$properties$ProtectedNiFiProperties = _encryptSensitiveProperties_closure19.class$("org.apache.nifi.properties.ProtectedNiFiProperties");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        Set nonSensitiveKeys = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[462].call(callSiteArray[463].call((Object)((NiFiProperties)plainProperties2.get())), (Object)((List)keysToSkip.get())), Set.class);
        callSiteArray[464].call((Object)nonSensitiveKeys, (Object)new GeneratedClosure(this, this, encryptedProperties, plainProperties2){
            private /* synthetic */ Reference encryptedProperties;
            private /* synthetic */ Reference plainProperties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.encryptedProperties = reference2 = encryptedProperties;
                this.plainProperties = reference = plainProperties;
            }

            public Object doCall(String key) {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure20.$getCallSiteArray();
                return callSiteArray[0].call(this.encryptedProperties.get(), (Object)key, callSiteArray[1].call(this.plainProperties.get(), (Object)key));
            }

            public Object call(String key) {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure20.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)key);
                }
                return this.doCall(key);
            }

            public Properties getEncryptedProperties() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure20.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.encryptedProperties.get(), Properties.class);
            }

            public NiFiProperties getPlainProperties() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure20.$getCallSiteArray();
                return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.plainProperties.get(), NiFiProperties.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _encryptSensitiveProperties_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "setProperty";
                stringArray[1] = "getProperty";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _encryptSensitiveProperties_closure20.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_encryptSensitiveProperties_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _encryptSensitiveProperties_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        NiFiProperties mergedProperties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[465].callConstructor(StandardNiFiProperties.class, (Object)((Properties)encryptedProperties.get())), NiFiProperties.class);
        callSiteArray[466].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[467].call((Object)mergedProperties), callSiteArray[468].call((Object)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties(), (Object)mergedProperties)}, new String[]{"Final result: ", " keys including ", " protected keys"}));
        return mergedProperties;
    }

    public static String serializeXMLFragment(GPathResult gPathResult) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[469].call(callSiteArray[470].call(XmlUtil.class, (Object)gPathResult), (Object)XML_DECLARATION_REGEX, (Object)""));
    }

    /*
     * Unable to fully structure code
     */
    private void writeKeyToBootstrapConf() throws IOException {
        block7: {
            var1_1 = ConfigEncryptionTool.$getCallSiteArray();
            bootstrapConfFile = null;
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.bootstrapConfPath)) ** GOTO lbl-1000
            var3_3 = var1_1[472].callConstructor(File.class, (Object)this.bootstrapConfPath);
            bootstrapConfFile = (File)ScriptBytecodeAdapter.castToType((Object)var3_3, File.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[471].call(var3_3))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if ((v0 != false && DefaultTypeTransformation.booleanUnbox((Object)var1_1[473].call(bootstrapConfFile)) != false) != false && DefaultTypeTransformation.booleanUnbox((Object)var1_1[474].call(bootstrapConfFile)) != false) {
                try {
                    lines = (List)ScriptBytecodeAdapter.castToType((Object)var1_1[475].call(bootstrapConfFile), List.class);
                    var1_1[476].callCurrent((GroovyObject)this, (Object)lines);
                    var5_5 = var1_1[477].call((Object)lines, (Object)"\n");
                    ScriptBytecodeAdapter.setProperty((Object)var5_5, null, (Object)bootstrapConfFile, (String)"text");
                    break block7;
                }
                catch (IOException e) {
                    msg = "Encountered an exception updating the bootstrap.conf file with the master key";
                    var1_1[478].call((Object)ConfigEncryptionTool.logger, (Object)msg, (Object)e);
                    throw (Throwable)e;
                }
            }
            throw (Throwable)var1_1[479].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.bootstrapConfPath}, new String[]{"The bootstrap.conf file at ", " must exist and be readable and writable by the user running this tool"}));
        }
    }

    private List<String> updateBootstrapContentsWithKey(List<String> lines) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String keyLine = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{BOOTSTRAP_KEY_PREFIX, this.keyHex}, new String[]{"", "", ""}));
        int keyLineIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[480].call(lines, (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _updateBootstrapContentsWithKey_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _updateBootstrapContentsWithKey_closure21.$getCallSiteArray();
                return callSiteArray[0].call(it, callSiteArray[1].callGetProperty(ConfigEncryptionTool.class));
            }

            public Object doCall() {
                CallSite[] callSiteArray = _updateBootstrapContentsWithKey_closure21.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateBootstrapContentsWithKey_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "startsWith";
                stringArray[1] = "BOOTSTRAP_KEY_PREFIX";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _updateBootstrapContentsWithKey_closure21.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateBootstrapContentsWithKey_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateBootstrapContentsWithKey_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)keyLineIndex, (Object)-1)) {
            callSiteArray[481].call((Object)logger, (Object)"The key property was detected in bootstrap.conf");
            String string = keyLine;
            callSiteArray[482].call(lines, (Object)keyLineIndex, (Object)string);
            callSiteArray[483].call((Object)logger, (Object)"The bootstrap key value was updated");
            int keyCommentLineIndex = keyLineIndex > 0 ? DefaultTypeTransformation.intUnbox((Object)callSiteArray[484].call((Object)keyLineIndex, (Object)1)) : 0;
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[485].call(lines, (Object)keyCommentLineIndex), (Object)BOOTSTRAP_KEY_COMMENT)) {
                callSiteArray[486].call(lines, (Object)keyCommentLineIndex, (Object)BOOTSTRAP_KEY_COMMENT);
                callSiteArray[487].call((Object)logger, (Object)"A comment explaining the bootstrap key property was added");
            }
        } else {
            callSiteArray[488].call(lines, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"\n", BOOTSTRAP_KEY_COMMENT, keyLine}));
            callSiteArray[489].call((Object)logger, (Object)"The key property was not detected in bootstrap.conf so it was added along with a comment explaining it");
        }
        return lines;
    }

    private void writeLoginIdentityProviders() throws IOException {
        block8: {
            CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.outputLoginIdentityProvidersPath)) {
                throw (Throwable)callSiteArray[490].callConstructor(IllegalArgumentException.class, (Object)"Cannot write encrypted properties to empty login-identity-providers.xml path");
            }
            File outputLoginIdentityProvidersFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[491].callConstructor(File.class, (Object)this.outputLoginIdentityProvidersPath), File.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[492].callStatic(ConfigEncryptionTool.class, (Object)outputLoginIdentityProvidersFile))) {
                try {
                    String updatedXmlContent = null;
                    File loginIdentityProvidersFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[493].callConstructor(File.class, (Object)this.loginIdentityProvidersPath), File.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[494].call((Object)loginIdentityProvidersFile)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[495].call((Object)loginIdentityProvidersFile))) {
                        Object object = callSiteArray[496].call(callSiteArray[497].callStatic(ConfigEncryptionTool.class, (Object)this.loginIdentityProviders, (Object)loginIdentityProvidersFile), (Object)"\n");
                        updatedXmlContent = ShortTypeHandling.castToString((Object)object);
                    } else {
                        String string;
                        updatedXmlContent = string = this.loginIdentityProviders;
                    }
                    String string = updatedXmlContent;
                    ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)outputLoginIdentityProvidersFile, (String)"text");
                    break block8;
                }
                catch (IOException e) {
                    String msg = "Encountered an exception updating the login-identity-providers.xml file with the encrypted values";
                    callSiteArray[498].call((Object)logger, (Object)msg, (Object)e);
                    throw (Throwable)e;
                }
            }
            throw (Throwable)callSiteArray[499].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.outputLoginIdentityProvidersPath}, new String[]{"The login-identity-providers.xml file at ", " must be writable by the user running this tool"}));
        }
    }

    private void writeAuthorizers() throws IOException {
        block8: {
            CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.outputAuthorizersPath)) {
                throw (Throwable)callSiteArray[500].callConstructor(IllegalArgumentException.class, (Object)"Cannot write encrypted properties to empty authorizers.xml path");
            }
            File outputAuthorizersFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[501].callConstructor(File.class, (Object)this.outputAuthorizersPath), File.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[502].callStatic(ConfigEncryptionTool.class, (Object)outputAuthorizersFile))) {
                try {
                    String updatedXmlContent = null;
                    File authorizersFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[503].callConstructor(File.class, (Object)this.authorizersPath), File.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[504].call((Object)authorizersFile)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[505].call((Object)authorizersFile))) {
                        Object object = callSiteArray[506].call(callSiteArray[507].callStatic(ConfigEncryptionTool.class, (Object)this.authorizers, (Object)authorizersFile), (Object)"\n");
                        updatedXmlContent = ShortTypeHandling.castToString((Object)object);
                    } else {
                        String string;
                        updatedXmlContent = string = this.authorizers;
                    }
                    String string = updatedXmlContent;
                    ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)outputAuthorizersFile, (String)"text");
                    break block8;
                }
                catch (IOException e) {
                    String msg = "Encountered an exception updating the authorizers.xml file with the encrypted values";
                    callSiteArray[508].call((Object)logger, (Object)msg, (Object)e);
                    throw (Throwable)e;
                }
            }
            throw (Throwable)callSiteArray[509].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.outputAuthorizersPath}, new String[]{"The authorizers.xml file at ", " must be writable by the user running this tool"}));
        }
    }

    private void writeNiFiProperties() throws IOException {
        block8: {
            CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.outputNiFiPropertiesPath)) {
                throw (Throwable)callSiteArray[510].callConstructor(IllegalArgumentException.class, (Object)"Cannot write encrypted properties to empty nifi.properties path");
            }
            File outputNiFiPropertiesFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[511].callConstructor(File.class, (Object)this.outputNiFiPropertiesPath), File.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[512].callStatic(ConfigEncryptionTool.class, (Object)outputNiFiPropertiesFile))) {
                try {
                    List linesToPersist = null;
                    File niFiPropertiesFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[513].callConstructor(File.class, (Object)this.niFiPropertiesPath), File.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[514].call((Object)niFiPropertiesFile)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[515].call((Object)niFiPropertiesFile))) {
                        Object object = callSiteArray[516].callStatic(ConfigEncryptionTool.class, (Object)this.niFiProperties, (Object)niFiPropertiesFile);
                        linesToPersist = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
                    } else {
                        Object object = callSiteArray[517].callStatic(ConfigEncryptionTool.class, (Object)this.niFiProperties);
                        linesToPersist = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
                    }
                    Object object = callSiteArray[518].call((Object)linesToPersist, (Object)"\n");
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)outputNiFiPropertiesFile, (String)"text");
                    break block8;
                }
                catch (IOException e) {
                    String msg = "Encountered an exception updating the nifi.properties file with the encrypted values";
                    callSiteArray[519].call((Object)logger, (Object)msg, (Object)e);
                    throw (Throwable)e;
                }
            }
            throw (Throwable)callSiteArray[520].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.outputNiFiPropertiesPath}, new String[]{"The nifi.properties file at ", " must be writable by the user running this tool"}));
        }
    }

    private static List<String> serializeNiFiPropertiesAndPreserveFormat(NiFiProperties niFiProperties, File originalPropertiesFile) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Reference lines = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[521].call((Object)originalPropertiesFile), List.class)));
        Reference protectedNiFiProperties = new Reference((Object)((ProtectedNiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[522].callConstructor((Object)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties(), (Object)niFiProperties), (Class)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties())));
        Map protectedKeys = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[523].call((Object)((ProtectedNiFiProperties)protectedNiFiProperties.get())), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[524].call((Object)protectedKeys, callSiteArray[525].callGetProperty(NiFiProperties.class)))) {
            callSiteArray[526].call((Object)protectedKeys, callSiteArray[527].callGetProperty(NiFiProperties.class), callSiteArray[528].call((Object)((ProtectedNiFiProperties)protectedNiFiProperties.get()), callSiteArray[529].call((Object)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties(), callSiteArray[530].callGetProperty(NiFiProperties.class))));
        }
        callSiteArray[531].call((Object)protectedKeys, (Object)new GeneratedClosure(ConfigEncryptionTool.class, ConfigEncryptionTool.class, protectedNiFiProperties, lines){
            private /* synthetic */ Reference protectedNiFiProperties;
            private /* synthetic */ Reference lines;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$apache$nifi$properties$ProtectedNiFiProperties;
            {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure22.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.protectedNiFiProperties = reference2 = protectedNiFiProperties;
                this.lines = reference = lines;
            }

            public Object doCall(String key, String protectionScheme) {
                Reference key2 = new Reference((Object)key);
                CallSite[] callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure22.$getCallSiteArray();
                int l = DefaultTypeTransformation.intUnbox((Object)callSiteArray[0].call(this.lines.get(), (Object)new GeneratedClosure((Object)this, this.getThisObject(), key2){
                    private /* synthetic */ Reference key;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.key = reference = key;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        return callSiteArray[0].call(it, this.key.get());
                    }

                    public String getKey() {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.key.get());
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure35.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure35.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "startsWith";
                        return new CallSiteArray(_closure35.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure35.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)l, (Object)-1)) {
                    GStringImpl gStringImpl = new GStringImpl(new Object[]{(String)key2.get(), callSiteArray[1].call(this.protectedNiFiProperties.get(), (Object)((String)key2.get()))}, new String[]{"", "=", ""});
                    callSiteArray[2].call(this.lines.get(), (Object)l, (Object)gStringImpl);
                }
                int p = 0;
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    Object object = ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[3].call((Object)l, (Object)1), (Object)callSiteArray[4].call(this.lines.get())) ? callSiteArray[5].call(this.lines.get()) : callSiteArray[6].call((Object)l, (Object)1);
                    p = DefaultTypeTransformation.intUnbox((Object)object);
                } else {
                    Integer n = ScriptBytecodeAdapter.compareGreaterThan((Object)(l + 1), (Object)callSiteArray[7].call(this.lines.get())) ? callSiteArray[8].call(this.lines.get()) : Integer.valueOf(l + 1);
                    p = DefaultTypeTransformation.intUnbox((Object)n);
                }
                Object[] objectArray = new Object[2];
                objectArray[0] = callSiteArray[9].call(this.protectedNiFiProperties.get(), (Object)((String)key2.get()));
                String string = protectionScheme;
                objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
                String protectionLine = ShortTypeHandling.castToString((Object)new GStringImpl(objectArray, new String[]{"", "=", ""}));
                if (ScriptBytecodeAdapter.compareLessThan((Object)p, (Object)callSiteArray[10].call(this.lines.get())) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call(callSiteArray[12].call(this.lines.get(), (Object)p), (Object)new GStringImpl(new Object[]{callSiteArray[13].call(this.protectedNiFiProperties.get(), (Object)((String)key2.get()))}, new String[]{"", "="})))) {
                    return callSiteArray[14].call(this.lines.get(), (Object)p, (Object)protectionLine);
                }
                return callSiteArray[15].call(this.lines.get(), (Object)p, (Object)protectionLine);
            }

            public Object call(String key, String protectionScheme) {
                Reference key2 = new Reference((Object)key);
                CallSite[] callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure22.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[16].callCurrent((GroovyObject)this, (Object)((String)key2.get()), (Object)protectionScheme);
                }
                return this.doCall((String)key2.get(), protectionScheme);
            }

            public ProtectedNiFiProperties getProtectedNiFiProperties() {
                CallSite[] callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure22.$getCallSiteArray();
                return (ProtectedNiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.protectedNiFiProperties.get(), (Class)_serializeNiFiPropertiesAndPreserveFormat_closure22.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties());
            }

            public List getLines() {
                CallSite[] callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure22.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.lines.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializeNiFiPropertiesAndPreserveFormat_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "findIndexOf";
                stringArray[1] = "getProperty";
                stringArray[2] = "putAt";
                stringArray[3] = "plus";
                stringArray[4] = "size";
                stringArray[5] = "size";
                stringArray[6] = "plus";
                stringArray[7] = "size";
                stringArray[8] = "size";
                stringArray[9] = "getProtectionKey";
                stringArray[10] = "size";
                stringArray[11] = "startsWith";
                stringArray[12] = "get";
                stringArray[13] = "getProtectionKey";
                stringArray[14] = "set";
                stringArray[15] = "add";
                stringArray[16] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[17];
                _serializeNiFiPropertiesAndPreserveFormat_closure22.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_serializeNiFiPropertiesAndPreserveFormat_closure22.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure22.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$apache$nifi$properties$ProtectedNiFiProperties() {
                Class clazz = $class$org$apache$nifi$properties$ProtectedNiFiProperties;
                if (clazz == null) {
                    clazz = $class$org$apache$nifi$properties$ProtectedNiFiProperties = _serializeNiFiPropertiesAndPreserveFormat_closure22.class$("org.apache.nifi.properties.ProtectedNiFiProperties");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        return (List)lines.get();
    }

    private static List<String> serializeNiFiProperties(NiFiProperties nifiProperties) {
        Reference nifiProperties2 = new Reference((Object)nifiProperties);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        OutputStream out = (OutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[532].callConstructor(ByteArrayOutputStream.class), OutputStream.class);
        Writer writer = (Writer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[533].callConstructor(GroovyPrintWriter.class, (Object)out), Writer.class);
        Reference properties = new Reference((Object)((Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[534].callConstructor(Properties.class), Properties.class)));
        callSiteArray[535].call(callSiteArray[536].call((Object)((NiFiProperties)nifiProperties2.get())), (Object)new GeneratedClosure(ConfigEncryptionTool.class, ConfigEncryptionTool.class, properties, nifiProperties2){
            private /* synthetic */ Reference properties;
            private /* synthetic */ Reference nifiProperties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _serializeNiFiProperties_closure23.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.properties = reference2 = properties;
                this.nifiProperties = reference = nifiProperties;
            }

            public Object doCall(String key) {
                CallSite[] callSiteArray = _serializeNiFiProperties_closure23.$getCallSiteArray();
                return callSiteArray[0].call(this.properties.get(), (Object)key, callSiteArray[1].call(this.nifiProperties.get(), (Object)key));
            }

            public Object call(String key) {
                CallSite[] callSiteArray = _serializeNiFiProperties_closure23.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)key);
                }
                return this.doCall(key);
            }

            public Properties getProperties() {
                CallSite[] callSiteArray = _serializeNiFiProperties_closure23.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.properties.get(), Properties.class);
            }

            public NiFiProperties getNifiProperties() {
                CallSite[] callSiteArray = _serializeNiFiProperties_closure23.$getCallSiteArray();
                return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.nifiProperties.get(), NiFiProperties.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializeNiFiProperties_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "setProperty";
                stringArray[1] = "getProperty";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _serializeNiFiProperties_closure23.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_serializeNiFiProperties_closure23.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializeNiFiProperties_closure23.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        callSiteArray[537].call((Object)((Properties)properties.get()), (Object)writer, null);
        callSiteArray[538].call((Object)writer);
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[539].call(callSiteArray[540].call((Object)out), (Object)"\n"), List.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> serializeLoginIdentityProvidersAndPreserveFormat(String xmlContent, File originalLoginIdentityProvidersFile) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String fileContents = ShortTypeHandling.castToString((Object)callSiteArray[541].callGetProperty((Object)originalLoginIdentityProvidersFile));
        Object parsedXml = null;
        parsedXml = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[542].call(callSiteArray[543].callStatic(ConfigEncryptionTool.class), (Object)xmlContent)) : (object = callSiteArray[544].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)xmlContent));
        Object provider = callSiteArray[545].call(callSiteArray[546].callGetProperty(parsedXml), (Object)new GeneratedClosure(ConfigEncryptionTool.class, ConfigEncryptionTool.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _serializeLoginIdentityProvidersAndPreserveFormat_closure24.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _serializeLoginIdentityProvidersAndPreserveFormat_closure24.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].callGetProperty(it), String.class)), (Object)callSiteArray[1].callGetProperty(ConfigEncryptionTool.class));
            }

            public Object doCall() {
                CallSite[] callSiteArray = _serializeLoginIdentityProvidersAndPreserveFormat_closure24.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializeLoginIdentityProvidersAndPreserveFormat_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "class";
                stringArray[1] = "LDAP_PROVIDER_CLASS";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _serializeLoginIdentityProvidersAndPreserveFormat_closure24.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_serializeLoginIdentityProvidersAndPreserveFormat_closure24.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializeLoginIdentityProvidersAndPreserveFormat_closure24.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        if (!DefaultTypeTransformation.booleanUnbox((Object)provider)) throw (Throwable)callSiteArray[551].callConstructor(SAXException.class, (Object)"No ldap-provider element found");
        Object serializedProvider = callSiteArray[547].callStatic(ConfigEncryptionTool.class, provider);
        Object object3 = callSiteArray[548].call((Object)fileContents, (Object)LDAP_PROVIDER_REGEX, callSiteArray[549].call(Matcher.class, serializedProvider));
        fileContents = ShortTypeHandling.castToString((Object)object3);
        List list = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[550].call((Object)fileContents, (Object)"\n"), List.class);
        try {
            return list;
        }
        catch (SAXException e) {
            callSiteArray[552].call((Object)logger, callSiteArray[553].call((Object)"No provider element with class {} found in XML content; ", (Object)"the file could be empty or the element may be missing or commented out"), (Object)LDAP_PROVIDER_CLASS);
            List list2 = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[554].call((Object)fileContents, (Object)"\n"), List.class);
            return list2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> serializeAuthorizersAndPreserveFormat(String xmlContent, File originalAuthorizersFile) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String fileContents = ShortTypeHandling.castToString((Object)callSiteArray[555].callGetProperty((Object)originalAuthorizersFile));
        Object parsedXml = null;
        parsedXml = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[556].call(callSiteArray[557].callStatic(ConfigEncryptionTool.class), (Object)xmlContent)) : (object = callSiteArray[558].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)xmlContent));
        Object provider = callSiteArray[559].call(callSiteArray[560].callGetProperty(parsedXml), (Object)new GeneratedClosure(ConfigEncryptionTool.class, ConfigEncryptionTool.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _serializeAuthorizersAndPreserveFormat_closure25.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _serializeAuthorizersAndPreserveFormat_closure25.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].callGetProperty(it), String.class)), (Object)callSiteArray[1].callGetProperty(ConfigEncryptionTool.class));
            }

            public Object doCall() {
                CallSite[] callSiteArray = _serializeAuthorizersAndPreserveFormat_closure25.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializeAuthorizersAndPreserveFormat_closure25.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "class";
                stringArray[1] = "LDAP_USER_GROUP_PROVIDER_CLASS";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _serializeAuthorizersAndPreserveFormat_closure25.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_serializeAuthorizersAndPreserveFormat_closure25.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializeAuthorizersAndPreserveFormat_closure25.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        if (!DefaultTypeTransformation.booleanUnbox((Object)provider)) throw (Throwable)callSiteArray[565].callConstructor(SAXException.class, (Object)"No ldap-user-group-provider element found");
        Object serializedProvider = callSiteArray[561].callStatic(ConfigEncryptionTool.class, provider);
        Object object3 = callSiteArray[562].call((Object)fileContents, (Object)LDAP_USER_GROUP_PROVIDER_REGEX, callSiteArray[563].call(Matcher.class, serializedProvider));
        fileContents = ShortTypeHandling.castToString((Object)object3);
        List list = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[564].call((Object)fileContents, (Object)"\n"), List.class);
        try {
            return list;
        }
        catch (SAXException e) {
            callSiteArray[566].call((Object)logger, callSiteArray[567].call((Object)"No provider element with class {} found in XML content; ", (Object)"the file could be empty or the element may be missing or commented out"), (Object)LDAP_USER_GROUP_PROVIDER_CLASS);
            List list2 = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[568].call((Object)fileContents, (Object)"\n"), List.class);
            return list2;
        }
    }

    private static boolean isSafeToWrite(File fileToWrite) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)fileToWrite) && (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[569].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[570].call(callSiteArray[571].callGetProperty(callSiteArray[572].callGetProperty((Object)fileToWrite)))) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[573].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[574].call((Object)fileToWrite)));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)fileToWrite) && (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[575].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[576].call(callSiteArray[577].callGetProperty(callSiteArray[578].callGetProperty((Object)fileToWrite)))) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[579].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[580].call((Object)fileToWrite)));
    }

    private static String deriveKeyFromPassword(String password) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Object object = callSiteArray[581].callSafe((Object)password);
        password = ShortTypeHandling.castToString((Object)object);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)password) || ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[582].call((Object)password), (Object)MIN_PASSWORD_LENGTH)) {
                throw (Throwable)callSiteArray[583].callConstructor(KeyException.class, (Object)new GStringImpl(new Object[]{MIN_PASSWORD_LENGTH}, new String[]{"Cannot derive key from empty/short password -- password must be at least ", " characters"}));
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)password) || ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[584].call((Object)password), (Object)MIN_PASSWORD_LENGTH)) {
            throw (Throwable)callSiteArray[585].callConstructor(KeyException.class, (Object)new GStringImpl(new Object[]{MIN_PASSWORD_LENGTH}, new String[]{"Cannot derive key from empty/short password -- password must be at least ", " characters"}));
        }
        byte[] salt = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[586].callStatic(ConfigEncryptionTool.class);
            salt = (byte[])ScriptBytecodeAdapter.castToType((Object)object2, byte[].class);
        } else {
            byte[] byArray;
            salt = byArray = ConfigEncryptionTool.generateScryptSaltForKeyDerivation();
        }
        int keyLengthInBytes = 0;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object3 = callSiteArray[587].call(callSiteArray[588].call(callSiteArray[589].callStatic(ConfigEncryptionTool.class)), (Object)8);
            keyLengthInBytes = DefaultTypeTransformation.intUnbox((Object)object3);
        } else {
            Object object4 = callSiteArray[590].call(callSiteArray[591].call(ConfigEncryptionTool.getValidKeyLengths()), (Object)8);
            keyLengthInBytes = DefaultTypeTransformation.intUnbox((Object)object4);
        }
        byte[] derivedKeyBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[592].call(SCrypt.class, ArrayUtil.createArray((Object)callSiteArray[593].call((Object)password, callSiteArray[594].callGetProperty(StandardCharsets.class)), (Object)salt, (Object)SCRYPT_N, (Object)SCRYPT_R, (Object)SCRYPT_P, (Object)keyLengthInBytes)), byte[].class);
        return ShortTypeHandling.castToString((Object)callSiteArray[595].call(callSiteArray[596].call(Hex.class, (Object)derivedKeyBytes)));
    }

    private static byte[] generateScryptSaltForKeyDerivation() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[597].call((Object)"NIFI_SCRYPT_SALT", callSiteArray[598].callGetProperty(StandardCharsets.class)), byte[].class);
    }

    private String getExistingFlowPassword() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String string = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[599].call((Object)this.niFiProperties, callSiteArray[600].callGetProperty(NiFiProperties.class)), String.class);
        return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : DEFAULT_NIFI_SENSITIVE_PROPS_KEY;
    }

    /*
     * Exception decompiling
     */
    public boolean niFiPropertiesAreEncrypted() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static XmlSlurper getXmlSlurper() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        XmlSlurper xs = (XmlSlurper)ScriptBytecodeAdapter.castToType((Object)callSiteArray[605].callConstructor(XmlSlurper.class), XmlSlurper.class);
        callSiteArray[606].call((Object)xs, (Object)true);
        return xs;
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        callSiteArray[607].call(Security.class, callSiteArray[608].callConstructor(BouncyCastleProvider.class));
        ConfigEncryptionTool tool = (ConfigEncryptionTool)ScriptBytecodeAdapter.castToType((Object)callSiteArray[609].callConstructor(ConfigEncryptionTool.class), ConfigEncryptionTool.class);
        try {
            try {
                Object object;
                callSiteArray[610].call((Object)tool, (Object)args);
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[611].callGroovyObjectGetProperty((Object)tool))) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[612].callGroovyObjectGetProperty((Object)tool))) {
                        Object object2 = callSiteArray[613].call(NiFiPropertiesLoader.class, callSiteArray[614].callGroovyObjectGetProperty((Object)tool));
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                    }
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[615].callGroovyObjectGetProperty((Object)tool))) {
                        callSiteArray[616].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[617].callGroovyObjectGetProperty((Object)tool), callSiteArray[618].callGroovyObjectGetProperty((Object)tool)}, new String[]{"No master key detected in ", " -- if ", " is encrypted, the translation will fail"}));
                    }
                    Object object3 = callSiteArray[619].call((Object)tool, callSiteArray[620].callGroovyObjectGetProperty((Object)tool));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object3, ConfigEncryptionTool.class, (GroovyObject)tool, (String)NIFI_PROPERTIES_ARG);
                    String cliOutput = ShortTypeHandling.castToString((Object)callSiteArray[621].call((Object)tool));
                    callSiteArray[622].call(callSiteArray[623].callGetProperty(System.class), (Object)cliOutput);
                    callSiteArray[624].call(System.class, callSiteArray[625].call(callSiteArray[626].callGetProperty(ExitCode.class)));
                }
                boolean existingNiFiPropertiesAreEncrypted = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[627].call((Object)tool));
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[628].callGroovyObjectGetProperty((Object)tool)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[629].callGroovyObjectGetProperty((Object)tool)) && existingNiFiPropertiesAreEncrypted) {
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[630].callGroovyObjectGetProperty((Object)tool))) {
                            Object object4 = callSiteArray[631].call(NiFiPropertiesLoader.class, callSiteArray[632].callGroovyObjectGetProperty((Object)tool));
                            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object4, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                        } else {
                            Object object5 = callSiteArray[633].call((Object)tool);
                            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object5, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                        }
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[634].callGroovyObjectGetProperty((Object)tool))) {
                            callSiteArray[635].call((Object)tool, (Object)"Hex key must be provided", callSiteArray[636].callGetProperty(ExitCode.class));
                        }
                        try {
                            Object object6 = callSiteArray[637].callStatic(ConfigEncryptionTool.class, callSiteArray[638].callGroovyObjectGetProperty((Object)tool));
                            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object6, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                        }
                        catch (KeyException e) {
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[639].callGroovyObjectGetProperty((Object)tool))) {
                                callSiteArray[640].call((Object)logger, (Object)"Encountered an error", (Object)e);
                            }
                            callSiteArray[641].call((Object)tool, callSiteArray[642].call((Object)e), callSiteArray[643].callGetProperty(ExitCode.class));
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[644].callGroovyObjectGetProperty((Object)tool))) {
                            String migrationKeyHex = ShortTypeHandling.castToString((Object)callSiteArray[645].call((Object)tool));
                            if (!DefaultTypeTransformation.booleanUnbox((Object)migrationKeyHex)) {
                                callSiteArray[646].call((Object)tool, (Object)"Original hex key must be provided for migration", callSiteArray[647].callGetProperty(ExitCode.class));
                            }
                            try {
                                Object object7 = callSiteArray[648].callStatic(ConfigEncryptionTool.class, (Object)migrationKeyHex);
                                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object7, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"migrationKeyHex");
                            }
                            catch (KeyException e) {
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[649].callGroovyObjectGetProperty((Object)tool))) {
                                    callSiteArray[650].call((Object)logger, (Object)"Encountered an error", (Object)e);
                                }
                                callSiteArray[651].call((Object)tool, callSiteArray[652].call((Object)e), callSiteArray[653].callGetProperty(ExitCode.class));
                            }
                        }
                    }
                } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[654].callGroovyObjectGetProperty((Object)tool)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[655].callGroovyObjectGetProperty((Object)tool)) && existingNiFiPropertiesAreEncrypted) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[656].callGroovyObjectGetProperty((Object)tool))) {
                        Object object8 = callSiteArray[657].call(NiFiPropertiesLoader.class, callSiteArray[658].callGroovyObjectGetProperty((Object)tool));
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object8, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                    } else {
                        Object object9 = callSiteArray[659].call((Object)tool);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object9, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                    }
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[660].callGroovyObjectGetProperty((Object)tool))) {
                        callSiteArray[661].call((Object)tool, (Object)"Hex key must be provided", callSiteArray[662].callGetProperty(ExitCode.class));
                    }
                    try {
                        Object object10 = callSiteArray[663].callStatic(ConfigEncryptionTool.class, callSiteArray[664].callGroovyObjectGetProperty((Object)tool));
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object10, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                    }
                    catch (KeyException e) {
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[665].callGroovyObjectGetProperty((Object)tool))) {
                            callSiteArray[666].call((Object)logger, (Object)"Encountered an error", (Object)e);
                        }
                        callSiteArray[667].call((Object)tool, callSiteArray[668].call((Object)e), callSiteArray[669].callGetProperty(ExitCode.class));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[670].callGroovyObjectGetProperty((Object)tool))) {
                        String migrationKeyHex = ShortTypeHandling.castToString((Object)callSiteArray[671].call((Object)tool));
                        if (!DefaultTypeTransformation.booleanUnbox((Object)migrationKeyHex)) {
                            callSiteArray[672].call((Object)tool, (Object)"Original hex key must be provided for migration", callSiteArray[673].callGetProperty(ExitCode.class));
                        }
                        try {
                            String string = ConfigEncryptionTool.parseKey(migrationKeyHex);
                            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"migrationKeyHex");
                        }
                        catch (KeyException e) {
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[674].callGroovyObjectGetProperty((Object)tool))) {
                                callSiteArray[675].call((Object)logger, (Object)"Encountered an error", (Object)e);
                            }
                            callSiteArray[676].call((Object)tool, callSiteArray[677].call((Object)e), callSiteArray[678].callGetProperty(ExitCode.class));
                        }
                    }
                }
                String existingKeyHex = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[679].callGroovyObjectGetProperty((Object)tool))) ? object : callSiteArray[680].callGroovyObjectGetProperty((Object)tool)));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[681].callGroovyObjectGetProperty((Object)tool)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[682].callGroovyObjectGetProperty((Object)tool))) {
                    try {
                        Object object11 = callSiteArray[683].call((Object)tool, (Object)existingKeyHex);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object11, ConfigEncryptionTool.class, (GroovyObject)tool, (String)NIFI_PROPERTIES_ARG);
                    }
                    catch (Exception e) {
                        callSiteArray[684].call((Object)tool, (Object)"Cannot migrate key if no previous encryption occurred", callSiteArray[685].callGetProperty(ExitCode.class));
                    }
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[686].callGroovyObjectGetProperty((Object)tool))) {
                    try {
                        Object object12 = callSiteArray[687].call((Object)tool, (Object)existingKeyHex);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object12, ConfigEncryptionTool.class, (GroovyObject)tool, (String)LOGIN_IDENTITY_PROVIDERS_ARG);
                    }
                    catch (Exception e) {
                        callSiteArray[688].call((Object)tool, (Object)"Cannot migrate key if no previous encryption occurred", callSiteArray[689].callGetProperty(ExitCode.class));
                    }
                    Object object13 = callSiteArray[690].call((Object)tool, callSiteArray[691].callGroovyObjectGetProperty((Object)tool));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object13, ConfigEncryptionTool.class, (GroovyObject)tool, (String)LOGIN_IDENTITY_PROVIDERS_ARG);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[692].callGroovyObjectGetProperty((Object)tool))) {
                    try {
                        Object object14 = callSiteArray[693].call((Object)tool, (Object)existingKeyHex);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object14, ConfigEncryptionTool.class, (GroovyObject)tool, (String)AUTHORIZERS_ARG);
                    }
                    catch (Exception e) {
                        callSiteArray[694].call((Object)tool, (Object)"Cannot migrate key if no previous encryption occurred", callSiteArray[695].callGetProperty(ExitCode.class));
                    }
                    Object object15 = callSiteArray[696].call((Object)tool, callSiteArray[697].callGroovyObjectGetProperty((Object)tool));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object15, ConfigEncryptionTool.class, (GroovyObject)tool, (String)AUTHORIZERS_ARG);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[698].callGroovyObjectGetProperty((Object)tool))) {
                    try {
                        Object object16 = callSiteArray[699].call((Object)tool);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object16, ConfigEncryptionTool.class, (GroovyObject)tool, (String)FLOW_XML_ARG);
                    }
                    catch (Exception e) {
                        callSiteArray[700].call((Object)tool, (Object)"Cannot load flow.xml.gz", callSiteArray[701].callGetProperty(ExitCode.class));
                    }
                    String existingFlowPassword = ShortTypeHandling.castToString((Object)callSiteArray[702].call((Object)tool));
                    Object object17 = callSiteArray[703].callGroovyObjectGetProperty((Object)tool);
                    String newFlowPassword = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object17) ? object17 : callSiteArray[704].call((Object)tool)));
                    if (!DefaultTypeTransformation.booleanUnbox((Object)newFlowPassword)) {
                        String string;
                        newFlowPassword = string = existingFlowPassword;
                    }
                    Reference nfp = new Reference((Object)((NiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[705].callGroovyObjectGetProperty((Object)tool), NiFiProperties.class)));
                    Object object18 = callSiteArray[706].callSafe((Object)((NiFiProperties)nfp.get()), callSiteArray[707].callGetProperty(NiFiProperties.class));
                    String existingAlgorithm = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object18) ? object18 : DEFAULT_FLOW_ALGORITHM));
                    Object object19 = callSiteArray[708].callSafe((Object)((NiFiProperties)nfp.get()), callSiteArray[709].callGetProperty(NiFiProperties.class));
                    String existingProvider = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object19) ? object19 : DEFAULT_PROVIDER));
                    Object object20 = callSiteArray[710].callGroovyObjectGetProperty((Object)tool);
                    String newAlgorithm = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object20) ? object20 : existingAlgorithm));
                    Object object21 = callSiteArray[711].callGroovyObjectGetProperty((Object)tool);
                    String newProvider = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object21) ? object21 : existingProvider));
                    Object object22 = callSiteArray[712].call((Object)tool, ArrayUtil.createArray((Object)callSiteArray[713].callGroovyObjectGetProperty((Object)tool), (Object)existingFlowPassword, (Object)newFlowPassword, (Object)existingAlgorithm, (Object)existingProvider, (Object)newAlgorithm, (Object)newProvider));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object22, ConfigEncryptionTool.class, (GroovyObject)tool, (String)FLOW_XML_ARG);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)newFlowPassword, (Object)DEFAULT_NIFI_SENSITIVE_PROPS_KEY) && ScriptBytecodeAdapter.compareNotEqual((Object)newFlowPassword, (Object)existingFlowPassword)) {
                        Reference rawProperties = new Reference((Object)((Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[714].callConstructor(Properties.class), Properties.class)));
                        callSiteArray[715].call(callSiteArray[716].call((Object)((NiFiProperties)nfp.get())), (Object)new GeneratedClosure(ConfigEncryptionTool.class, ConfigEncryptionTool.class, nfp, rawProperties){
                            private /* synthetic */ Reference nfp;
                            private /* synthetic */ Reference rawProperties;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;
                            {
                                Reference reference;
                                Reference reference2;
                                CallSite[] callSiteArray = _main_closure26.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.nfp = reference2 = nfp;
                                this.rawProperties = reference = rawProperties;
                            }

                            public Object doCall(String k) {
                                CallSite[] callSiteArray = _main_closure26.$getCallSiteArray();
                                return callSiteArray[0].call(this.rawProperties.get(), (Object)k, callSiteArray[1].call(this.nfp.get(), (Object)k));
                            }

                            public Object call(String k) {
                                CallSite[] callSiteArray = _main_closure26.$getCallSiteArray();
                                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)k);
                                }
                                return this.doCall(k);
                            }

                            public NiFiProperties getNfp() {
                                CallSite[] callSiteArray = _main_closure26.$getCallSiteArray();
                                return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.nfp.get(), NiFiProperties.class);
                            }

                            public Properties getRawProperties() {
                                CallSite[] callSiteArray = _main_closure26.$getCallSiteArray();
                                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.rawProperties.get(), Properties.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _main_closure26.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "put";
                                stringArray[1] = "getProperty";
                                stringArray[2] = "doCall";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[3];
                                _main_closure26.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_main_closure26.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _main_closure26.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        });
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[717].callGroovyObjectGetProperty((Object)tool)) && existingNiFiPropertiesAreEncrypted) {
                            AESSensitivePropertyProvider spp = (AESSensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[718].callConstructor(AESSensitivePropertyProvider.class, callSiteArray[719].callGroovyObjectGetProperty((Object)tool)), AESSensitivePropertyProvider.class);
                            String encryptedSPK = ShortTypeHandling.castToString((Object)callSiteArray[720].call((Object)spp, (Object)newFlowPassword));
                            callSiteArray[721].call((Object)((Properties)rawProperties.get()), callSiteArray[722].callGetProperty(NiFiProperties.class), (Object)encryptedSPK);
                            callSiteArray[723].call((Object)((Properties)rawProperties.get()), callSiteArray[724].call((Object)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties(), callSiteArray[725].callGetProperty(NiFiProperties.class)), callSiteArray[726].call((Object)spp));
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[727].callGroovyObjectGetProperty((Object)tool))) {
                                callSiteArray[728].call((Object)logger, (Object)"Tool is not configured to encrypt nifi.properties, but the existing nifi.properties is encrypted and flow.xml.gz was migrated, so manually persisting the new encrypted value to nifi.properties");
                            }
                        } else {
                            callSiteArray[729].call((Object)((Properties)rawProperties.get()), callSiteArray[730].callGetProperty(NiFiProperties.class), (Object)newFlowPassword);
                        }
                        Object object23 = callSiteArray[731].callConstructor(StandardNiFiProperties.class, (Object)((Properties)rawProperties.get()));
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object23, ConfigEncryptionTool.class, (GroovyObject)tool, (String)NIFI_PROPERTIES_ARG);
                    }
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[732].callGroovyObjectGetProperty((Object)tool))) {
                    Object object24 = callSiteArray[733].call((Object)tool, callSiteArray[734].callGroovyObjectGetProperty((Object)tool));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object24, ConfigEncryptionTool.class, (GroovyObject)tool, (String)NIFI_PROPERTIES_ARG);
                }
            }
            catch (CommandLineParseException e) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[735].callGetProperty((Object)e), (Object)callSiteArray[736].callGetProperty(ExitCode.class))) {
                    callSiteArray[737].call(System.class, callSiteArray[738].call(callSiteArray[739].callGetProperty(ExitCode.class)));
                }
                throw (Throwable)e;
            }
            catch (Exception e) {
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[740].callGroovyObjectGetProperty((Object)tool))) {
                    callSiteArray[741].call((Object)logger, (Object)"Encountered an error", (Object)e);
                }
                callSiteArray[742].call((Object)tool, callSiteArray[743].callGetProperty((Object)e), callSiteArray[744].callGetProperty(ExitCode.class));
            }
            try {
                Class<ConfigEncryptionTool> clazz = ConfigEncryptionTool.class;
                synchronized (clazz) {
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[745].callGroovyObjectGetProperty((Object)tool))) {
                        callSiteArray[746].call((Object)tool);
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[747].callGroovyObjectGetProperty((Object)tool))) {
                        callSiteArray[748].call((Object)tool, callSiteArray[749].callGroovyObjectGetProperty((Object)tool));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[750].callGroovyObjectGetProperty((Object)tool)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[751].callGroovyObjectGetProperty((Object)tool))) {
                        callSiteArray[752].call((Object)tool);
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[753].callGroovyObjectGetProperty((Object)tool))) {
                        callSiteArray[754].call((Object)tool);
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[755].callGroovyObjectGetProperty((Object)tool))) {
                        callSiteArray[756].call((Object)tool);
                    }
                }
            }
            catch (Exception e) {
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[757].callGroovyObjectGetProperty((Object)tool))) {
                    callSiteArray[758].call((Object)logger, (Object)"Encountered an error", (Object)e);
                }
                callSiteArray[759].call((Object)tool, (Object)"Encountered an error writing the master key to the bootstrap.conf file and the encrypted properties to nifi.properties", callSiteArray[760].callGetProperty(ExitCode.class));
            }
        }
        catch (CommandLineParseException e) {
            callSiteArray[761].call(System.class, callSiteArray[762].call(callSiteArray[763].callGetProperty((Object)e)));
        }
        callSiteArray[764].call(System.class, callSiteArray[765].call(callSiteArray[766].callGetProperty(ExitCode.class)));
    }

    public String translateNiFiPropertiesToCLI() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String baseUrl = ShortTypeHandling.castToString((Object)callSiteArray[767].callStatic(ConfigEncryptionTool.class, (Object)this.niFiProperties));
        Reference cliOutput = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{baseUrl}, new String[]{"baseUrl=", ""})}));
        callSiteArray[768].call(PROPERTY_KEY_MAP, (Object)new GeneratedClosure(this, this, cliOutput){
            private /* synthetic */ Reference cliOutput;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _translateNiFiPropertiesToCLI_closure27.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.cliOutput = reference = cliOutput;
            }

            public Object doCall(String nfpKey, String cliKey) {
                CallSite[] callSiteArray = _translateNiFiPropertiesToCLI_closure27.$getCallSiteArray();
                return callSiteArray[0].call(this.cliOutput.get(), (Object)new GStringImpl(new Object[]{cliKey, callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)nfpKey)}, new String[]{"", "=", ""}));
            }

            public Object call(String nfpKey, String cliKey) {
                CallSite[] callSiteArray = _translateNiFiPropertiesToCLI_closure27.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[3].callCurrent((GroovyObject)this, (Object)nfpKey, (Object)cliKey);
                }
                return this.doCall(nfpKey, cliKey);
            }

            public List getCliOutput() {
                CallSite[] callSiteArray = _translateNiFiPropertiesToCLI_closure27.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.cliOutput.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateNiFiPropertiesToCLI_closure27.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "getProperty";
                stringArray[2] = ConfigEncryptionTool.NIFI_PROPERTIES_ARG;
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _translateNiFiPropertiesToCLI_closure27.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateNiFiPropertiesToCLI_closure27.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateNiFiPropertiesToCLI_closure27.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        callSiteArray[769].call((Object)((List)cliOutput.get()), (Object)"proxiedEntity=");
        return ShortTypeHandling.castToString((Object)callSiteArray[770].call((Object)((List)cliOutput.get()), (Object)"\n"));
    }

    public static String determineBaseUrl(NiFiProperties niFiProperties) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String protocol = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[771].call((Object)niFiProperties)) ? "https" : "http";
        String host = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[772].call((Object)niFiProperties)) ? callSiteArray[773].call((Object)niFiProperties, callSiteArray[774].callGetProperty(NiFiProperties.class)) : callSiteArray[775].call((Object)niFiProperties, callSiteArray[776].callGetProperty(NiFiProperties.class))));
        String port = ShortTypeHandling.castToString((Object)callSiteArray[777].call((Object)niFiProperties));
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{protocol, host, port}, new String[]{"", "://", ":", ""}));
    }

    private static String buildHeader() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ConfigEncryptionTool.buildHeader(DEFAULT_DESCRIPTION);
        }
        return ConfigEncryptionTool.buildHeader(DEFAULT_DESCRIPTION);
    }

    public boolean commandLineHasActionFlags(CommandLine commandLine) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return this.commandLineHasActionFlags(commandLine, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    private String getKeyInternal(String keyHex, String password, boolean usingPassword) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return this.getKeyInternal((TextDevice)ScriptBytecodeAdapter.castToType((Object)callSiteArray[778].call(TextDevices.class), TextDevice.class), keyHex, password, usingPassword);
    }

    private String getKey() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return this.getKey((TextDevice)ScriptBytecodeAdapter.castToType((Object)callSiteArray[779].call(TextDevices.class), TextDevice.class));
    }

    private static String getFlowPassword() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ConfigEncryptionTool.getFlowPassword((TextDevice)ScriptBytecodeAdapter.castToType((Object)callSiteArray[780].call(TextDevices.class), TextDevice.class));
    }

    private NiFiProperties loadNiFiProperties() throws IOException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.loadNiFiProperties(this.keyHex);
        }
        return this.loadNiFiProperties(this.keyHex);
    }

    private String loadLoginIdentityProviders() throws IOException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.loadLoginIdentityProviders(this.keyHex);
        }
        return this.loadLoginIdentityProviders(this.keyHex);
    }

    private String loadAuthorizers() throws IOException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.loadAuthorizers(this.keyHex);
        }
        return this.loadAuthorizers(this.keyHex);
    }

    private static String decryptFlowElement(String wrappedCipherText, String password, String algorithm) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ConfigEncryptionTool.decryptFlowElement(wrappedCipherText, password, algorithm, DEFAULT_PROVIDER);
        }
        return ConfigEncryptionTool.decryptFlowElement(wrappedCipherText, password, algorithm, DEFAULT_PROVIDER);
    }

    private static String decryptFlowElement(String wrappedCipherText, String password) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ConfigEncryptionTool.decryptFlowElement(wrappedCipherText, password, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
        }
        return ConfigEncryptionTool.decryptFlowElement(wrappedCipherText, password, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
    }

    private static Cipher generateFlowDecryptionCipher(String password, byte[] saltBytes, String algorithm) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ConfigEncryptionTool.generateFlowDecryptionCipher(password, saltBytes, algorithm, DEFAULT_PROVIDER);
        }
        return ConfigEncryptionTool.generateFlowDecryptionCipher(password, saltBytes, algorithm, DEFAULT_PROVIDER);
    }

    private static Cipher generateFlowDecryptionCipher(String password, byte ... saltBytes) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ConfigEncryptionTool.generateFlowDecryptionCipher(password, saltBytes, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
        }
        return ConfigEncryptionTool.generateFlowDecryptionCipher(password, saltBytes, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
    }

    private String migrateFlowXmlContent(String flowXmlContent, String existingFlowPassword, String newFlowPassword, String existingAlgorithm, String existingProvider, String newAlgorithm) {
        Reference existingFlowPassword2 = new Reference((Object)existingFlowPassword);
        Reference existingAlgorithm2 = new Reference((Object)existingAlgorithm);
        Reference existingProvider2 = new Reference((Object)existingProvider);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.migrateFlowXmlContent(flowXmlContent, (String)existingFlowPassword2.get(), newFlowPassword, (String)existingAlgorithm2.get(), (String)existingProvider2.get(), newAlgorithm, DEFAULT_PROVIDER);
        }
        return this.migrateFlowXmlContent(flowXmlContent, (String)existingFlowPassword2.get(), newFlowPassword, (String)existingAlgorithm2.get(), (String)existingProvider2.get(), newAlgorithm, DEFAULT_PROVIDER);
    }

    private String migrateFlowXmlContent(String flowXmlContent, String existingFlowPassword, String newFlowPassword, String existingAlgorithm, String existingProvider) {
        Reference existingFlowPassword2 = new Reference((Object)existingFlowPassword);
        Reference existingAlgorithm2 = new Reference((Object)existingAlgorithm);
        Reference existingProvider2 = new Reference((Object)existingProvider);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.migrateFlowXmlContent(flowXmlContent, (String)existingFlowPassword2.get(), newFlowPassword, (String)existingAlgorithm2.get(), (String)existingProvider2.get(), DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
        }
        return this.migrateFlowXmlContent(flowXmlContent, (String)existingFlowPassword2.get(), newFlowPassword, (String)existingAlgorithm2.get(), (String)existingProvider2.get(), DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
    }

    private String migrateFlowXmlContent(String flowXmlContent, String existingFlowPassword, String newFlowPassword, String existingAlgorithm) {
        Reference existingFlowPassword2 = new Reference((Object)existingFlowPassword);
        Reference existingAlgorithm2 = new Reference((Object)existingAlgorithm);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.migrateFlowXmlContent(flowXmlContent, (String)existingFlowPassword2.get(), newFlowPassword, (String)existingAlgorithm2.get(), DEFAULT_PROVIDER, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
        }
        return this.migrateFlowXmlContent(flowXmlContent, (String)existingFlowPassword2.get(), newFlowPassword, (String)existingAlgorithm2.get(), DEFAULT_PROVIDER, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
    }

    private String migrateFlowXmlContent(String flowXmlContent, String existingFlowPassword, String newFlowPassword) {
        Reference existingFlowPassword2 = new Reference((Object)existingFlowPassword);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.migrateFlowXmlContent(flowXmlContent, (String)existingFlowPassword2.get(), newFlowPassword, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
        }
        return this.migrateFlowXmlContent(flowXmlContent, (String)existingFlowPassword2.get(), newFlowPassword, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
    }

    private static Cipher generateFlowEncryptionCipher(String newFlowPassword, byte[] saltBytes, String algorithm) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ConfigEncryptionTool.generateFlowEncryptionCipher(newFlowPassword, saltBytes, algorithm, DEFAULT_PROVIDER);
        }
        return ConfigEncryptionTool.generateFlowEncryptionCipher(newFlowPassword, saltBytes, algorithm, DEFAULT_PROVIDER);
    }

    private static Cipher generateFlowEncryptionCipher(String newFlowPassword, byte ... saltBytes) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ConfigEncryptionTool.generateFlowEncryptionCipher(newFlowPassword, saltBytes, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
        }
        return ConfigEncryptionTool.generateFlowEncryptionCipher(newFlowPassword, saltBytes, DEFAULT_FLOW_ALGORITHM, DEFAULT_PROVIDER);
    }

    public String decryptLoginIdentityProviders(String encryptedXml) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.decryptLoginIdentityProviders(encryptedXml, this.keyHex);
        }
        return this.decryptLoginIdentityProviders(encryptedXml, this.keyHex);
    }

    public String decryptAuthorizers(String encryptedXml) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.decryptAuthorizers(encryptedXml, this.keyHex);
        }
        return this.decryptAuthorizers(encryptedXml, this.keyHex);
    }

    public String encryptLoginIdentityProviders(String plainXml) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.encryptLoginIdentityProviders(plainXml, this.keyHex);
        }
        return this.encryptLoginIdentityProviders(plainXml, this.keyHex);
    }

    public String encryptAuthorizers(String plainXml) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.encryptAuthorizers(plainXml, this.keyHex);
        }
        return this.encryptAuthorizers(plainXml, this.keyHex);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConfigEncryptionTool.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Map map;
        Object object = ConfigEncryptionTool.$getCallSiteArray()[781].call(LoggerFactory.class, ConfigEncryptionTool.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = ConfigEncryptionTool.$getCallSiteArray()[782].call((Object)2, (Object)16);
        SCRYPT_N = DefaultTypeTransformation.intUnbox((Object)object2);
        Object object3 = ConfigEncryptionTool.$getCallSiteArray()[783].call(System.class);
        SEP = ShortTypeHandling.castToString((Object)object3);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object4 = ConfigEncryptionTool.$getCallSiteArray()[784].callStatic(ConfigEncryptionTool.class);
            FOOTER = ShortTypeHandling.castToString((Object)object4);
        } else {
            String string;
            FOOTER = string = ConfigEncryptionTool.buildFooter();
        }
        Object object5 = ConfigEncryptionTool.$getCallSiteArray()[785].call(ConfigEncryptionTool.$getCallSiteArray()[786].call(ConfigEncryptionTool.$getCallSiteArray()[787].call(ConfigEncryptionTool.$getCallSiteArray()[788].call(ConfigEncryptionTool.$getCallSiteArray()[789].call((Object)"This tool reads from a nifi.properties and/or ", (Object)"login-identity-providers.xml file with plain sensitive configuration values, "), (Object)"prompts the user for a master key, and encrypts each value. It will replace the "), (Object)"plain value with the protected value in the same file (or write to a new file if "), (Object)"specified). It can also be used to migrate already-encrypted values in those "), (Object)"files or in flow.xml.gz to be encrypted with a new key.");
        DEFAULT_DESCRIPTION = ShortTypeHandling.castToString((Object)object5);
        Object object6 = ConfigEncryptionTool.$getCallSiteArray()[790].callGetProperty(BouncyCastleProvider.class);
        DEFAULT_PROVIDER = ShortTypeHandling.castToString((Object)object6);
        PROPERTY_KEY_MAP = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"nifi.security.keystore", "keystore", "nifi.security.keystoreType", "keystoreType", "nifi.security.keystorePasswd", "keystorePasswd", "nifi.security.keyPasswd", "keyPasswd", "nifi.security.truststore", "truststore", "nifi.security.truststoreType", "truststoreType", "nifi.security.truststorePasswd", "truststorePasswd"});
    }

    public static final String getCURRENT_SCRYPT_VERSION() {
        return CURRENT_SCRYPT_VERSION;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "buildHeader";
        stringArray[1] = "getCliOptions";
        stringArray[2] = "multiply";
        stringArray[3] = "getenv";
        stringArray[4] = "getenv";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "addOption";
        stringArray[7] = "build";
        stringArray[8] = "desc";
        stringArray[9] = "hasArg";
        stringArray[10] = "longOpt";
        stringArray[11] = "builder";
        stringArray[12] = "addOption";
        stringArray[13] = "build";
        stringArray[14] = "desc";
        stringArray[15] = "hasArg";
        stringArray[16] = "longOpt";
        stringArray[17] = "builder";
        stringArray[18] = "addOption";
        stringArray[19] = "build";
        stringArray[20] = "desc";
        stringArray[21] = "argName";
        stringArray[22] = "hasArg";
        stringArray[23] = "longOpt";
        stringArray[24] = "builder";
        stringArray[25] = "addOption";
        stringArray[26] = "build";
        stringArray[27] = "desc";
        stringArray[28] = "argName";
        stringArray[29] = "hasArg";
        stringArray[30] = "longOpt";
        stringArray[31] = "builder";
        stringArray[32] = "addOption";
        stringArray[33] = "build";
        stringArray[34] = "desc";
        stringArray[35] = "argName";
        stringArray[36] = "hasArg";
        stringArray[37] = "longOpt";
        stringArray[38] = "builder";
        stringArray[39] = "addOption";
        stringArray[40] = "build";
        stringArray[41] = "desc";
        stringArray[42] = "argName";
        stringArray[43] = "hasArg";
        stringArray[44] = "longOpt";
        stringArray[45] = "builder";
        stringArray[46] = "addOption";
        stringArray[47] = "build";
        stringArray[48] = "desc";
        stringArray[49] = "argName";
        stringArray[50] = "hasArg";
        stringArray[51] = "longOpt";
        stringArray[52] = "builder";
        stringArray[53] = "addOption";
        stringArray[54] = "build";
        stringArray[55] = "desc";
        stringArray[56] = "argName";
        stringArray[57] = "hasArg";
        stringArray[58] = "longOpt";
        stringArray[59] = "builder";
        stringArray[60] = "addOption";
        stringArray[61] = "build";
        stringArray[62] = "desc";
        stringArray[63] = "argName";
        stringArray[64] = "hasArg";
        stringArray[65] = "longOpt";
        stringArray[66] = "builder";
        stringArray[67] = "addOption";
        stringArray[68] = "build";
        stringArray[69] = "desc";
        stringArray[70] = "argName";
        stringArray[71] = "hasArg";
        stringArray[72] = "longOpt";
        stringArray[73] = "builder";
        stringArray[74] = "addOption";
        stringArray[75] = "build";
        stringArray[76] = "desc";
        stringArray[77] = "argName";
        stringArray[78] = "hasArg";
        stringArray[79] = "longOpt";
        stringArray[80] = "builder";
        stringArray[81] = "addOption";
        stringArray[82] = "build";
        stringArray[83] = "desc";
        stringArray[84] = "argName";
        stringArray[85] = "hasArg";
        stringArray[86] = "longOpt";
        stringArray[87] = "builder";
        stringArray[88] = "addOption";
        stringArray[89] = "build";
        stringArray[90] = "desc";
        stringArray[91] = "argName";
        stringArray[92] = "hasArg";
        stringArray[93] = "longOpt";
        stringArray[94] = "builder";
        stringArray[95] = "addOption";
        stringArray[96] = "build";
        stringArray[97] = "desc";
        stringArray[98] = "argName";
        stringArray[99] = "hasArg";
        stringArray[100] = "longOpt";
        stringArray[101] = "builder";
        stringArray[102] = "addOption";
        stringArray[103] = "build";
        stringArray[104] = "desc";
        stringArray[105] = "argName";
        stringArray[106] = "hasArg";
        stringArray[107] = "longOpt";
        stringArray[108] = "builder";
        stringArray[109] = "addOption";
        stringArray[110] = "build";
        stringArray[111] = "desc";
        stringArray[112] = "hasArg";
        stringArray[113] = "longOpt";
        stringArray[114] = "builder";
        stringArray[115] = "addOption";
        stringArray[116] = "build";
        stringArray[117] = "desc";
        stringArray[118] = "hasArg";
        stringArray[119] = "longOpt";
        stringArray[120] = "builder";
        stringArray[121] = "addOption";
        stringArray[122] = "build";
        stringArray[123] = "desc";
        stringArray[124] = "hasArg";
        stringArray[125] = "longOpt";
        stringArray[126] = "builder";
        stringArray[127] = "addOption";
        stringArray[128] = "build";
        stringArray[129] = "desc";
        stringArray[130] = "argName";
        stringArray[131] = "hasArg";
        stringArray[132] = "longOpt";
        stringArray[133] = "builder";
        stringArray[134] = "addOption";
        stringArray[135] = "build";
        stringArray[136] = "desc";
        stringArray[137] = "argName";
        stringArray[138] = "hasArg";
        stringArray[139] = "longOpt";
        stringArray[140] = "builder";
        stringArray[141] = "addOption";
        stringArray[142] = "build";
        stringArray[143] = "desc";
        stringArray[144] = "argName";
        stringArray[145] = "hasArg";
        stringArray[146] = "longOpt";
        stringArray[147] = "builder";
        stringArray[148] = "addOption";
        stringArray[149] = "build";
        stringArray[150] = "desc";
        stringArray[151] = "hasArg";
        stringArray[152] = "longOpt";
        stringArray[153] = "builder";
        stringArray[154] = "buildOptions";
        stringArray[155] = "println";
        stringArray[156] = "out";
        stringArray[157] = "println";
        stringArray[158] = "out";
        stringArray[159] = "<$constructor$>";
        stringArray[160] = "setWidth";
        stringArray[161] = "setOptionComparator";
        stringArray[162] = "printHelp";
        stringArray[163] = "getCanonicalName";
        stringArray[164] = "printUsage";
        stringArray[165] = "<$constructor$>";
        stringArray[166] = "<$constructor$>";
        stringArray[167] = "parse";
        stringArray[168] = "hasOption";
        stringArray[169] = "printUsageAndThrow";
        stringArray[170] = "HELP";
        stringArray[171] = "hasOption";
        stringArray[172] = "hasOption";
        stringArray[173] = "commandLineHasActionFlags";
        stringArray[174] = "printUsageAndThrow";
        stringArray[175] = "INVALID_ARGS";
        stringArray[176] = "getOptionValue";
        stringArray[177] = "hasOption";
        stringArray[178] = "hasOption";
        stringArray[179] = "info";
        stringArray[180] = "getOptionValue";
        stringArray[181] = "getOptionValue";
        stringArray[182] = "warn";
        stringArray[183] = "printUsageAndThrow";
        stringArray[184] = "INVALID_ARGS";
        stringArray[185] = "hasOption";
        stringArray[186] = "hasOption";
        stringArray[187] = "info";
        stringArray[188] = "getOptionValue";
        stringArray[189] = "getOptionValue";
        stringArray[190] = "warn";
        stringArray[191] = "hasOption";
        stringArray[192] = "info";
        stringArray[193] = "getOptionValue";
        stringArray[194] = "getOptionValue";
        stringArray[195] = "warn";
        stringArray[196] = "hasOption";
        stringArray[197] = "info";
        stringArray[198] = "getOptionValue";
        stringArray[199] = "getOptionValue";
        stringArray[200] = "getOptionValue";
        stringArray[201] = "getOptionValue";
        stringArray[202] = "warn";
        stringArray[203] = "hasOption";
        stringArray[204] = "printUsageAndThrow";
        stringArray[205] = "INVALID_ARGS";
        stringArray[206] = "info";
        stringArray[207] = "info";
        stringArray[208] = "info";
        stringArray[209] = "info";
        stringArray[210] = "info";
        stringArray[211] = "info";
        stringArray[212] = "info";
        stringArray[213] = "info";
        stringArray[214] = "info";
        stringArray[215] = "hasOption";
        stringArray[216] = "hasOption";
        stringArray[217] = "hasOption";
        stringArray[218] = "hasOption";
        stringArray[219] = "printUsageAndThrow";
        stringArray[220] = "plus";
        stringArray[221] = "plus";
        stringArray[222] = "plus";
        stringArray[223] = "plus";
        stringArray[224] = "plus";
        stringArray[225] = "INVALID_ARGS";
        stringArray[226] = "hasOption";
        stringArray[227] = "hasOption";
        stringArray[228] = "hasOption";
        stringArray[229] = "hasOption";
        stringArray[230] = "printUsageAndThrow";
        stringArray[231] = "plus";
        stringArray[232] = "plus";
        stringArray[233] = "plus";
        stringArray[234] = "plus";
        stringArray[235] = "plus";
        stringArray[236] = "INVALID_ARGS";
        stringArray[237] = "hasOption";
        stringArray[238] = "info";
        stringArray[239] = "hasOption";
        stringArray[240] = "hasOption";
        stringArray[241] = "printUsageAndThrow";
        stringArray[242] = "INVALID_ARGS";
        stringArray[243] = "getOptionValue";
        stringArray[244] = "getOptionValue";
        stringArray[245] = "hasOption";
        stringArray[246] = "hasOption";
        stringArray[247] = "printUsageAndThrow";
        stringArray[248] = "INVALID_ARGS";
        stringArray[249] = "hasOption";
        stringArray[250] = "hasOption";
        stringArray[251] = "printUsageAndThrow";
        stringArray[252] = "INVALID_ARGS";
        stringArray[253] = "getOptionValue";
        stringArray[254] = "getOptionValue";
        stringArray[255] = "hasOption";
        stringArray[256] = "warn";
        stringArray[257] = "hasOption";
        stringArray[258] = "getOptionValue";
        stringArray[259] = "error";
        stringArray[260] = "printUsageAndThrow";
        stringArray[261] = "plus";
        stringArray[262] = "plus";
        stringArray[263] = "getMessage";
        stringArray[264] = "ERROR_PARSING_COMMAND_LINE";
        stringArray[265] = "resolveOptions";
        stringArray[266] = "resolveOptions";
        stringArray[267] = "minus";
        stringArray[268] = "options";
        stringArray[269] = "plus";
        stringArray[270] = "error";
        stringArray[271] = "collect";
        stringArray[272] = "info";
        stringArray[273] = "readPasswordFromConsole";
        stringArray[274] = "deriveKeyFromPassword";
        stringArray[275] = "info";
        stringArray[276] = "readKeyFromConsole";
        stringArray[277] = "getKeyInternal";
        stringArray[278] = "getKeyInternal";
        stringArray[279] = "defaultTextDevice";
        stringArray[280] = "readPasswordFromConsole";
        stringArray[281] = "printf";
        stringArray[282] = "<$constructor$>";
        stringArray[283] = "readPassword";
        stringArray[284] = "printf";
        stringArray[285] = "<$constructor$>";
        stringArray[286] = "readPassword";
        stringArray[287] = "replaceAll";
        stringArray[288] = "getValidKeyLengths";
        stringArray[289] = "contains";
        stringArray[290] = "multiply";
        stringArray[291] = "size";
        stringArray[292] = "<$constructor$>";
        stringArray[293] = "size";
        stringArray[294] = "collect";
        stringArray[295] = "toUpperCase";
        stringArray[296] = "getMaxAllowedKeyLength";
        stringArray[297] = "exists";
        stringArray[298] = "<$constructor$>";
        stringArray[299] = "load";
        stringArray[300] = "withKey";
        stringArray[301] = "info";
        stringArray[302] = "size";
        stringArray[303] = "error";
        stringArray[304] = "<$constructor$>";
        stringArray[305] = "printUsageAndThrow";
        stringArray[306] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[307] = "exists";
        stringArray[308] = "<$constructor$>";
        stringArray[309] = "readLines";
        stringArray[310] = "join";
        stringArray[311] = "info";
        stringArray[312] = "size";
        stringArray[313] = "decryptLoginIdentityProviders";
        stringArray[314] = "error";
        stringArray[315] = "<$constructor$>";
        stringArray[316] = "printUsageAndThrow";
        stringArray[317] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[318] = "exists";
        stringArray[319] = "<$constructor$>";
        stringArray[320] = "readLines";
        stringArray[321] = "join";
        stringArray[322] = "info";
        stringArray[323] = "size";
        stringArray[324] = "decryptAuthorizers";
        stringArray[325] = "error";
        stringArray[326] = "<$constructor$>";
        stringArray[327] = "printUsageAndThrow";
        stringArray[328] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[329] = "exists";
        stringArray[330] = "<$constructor$>";
        stringArray[331] = "withCloseable";
        stringArray[332] = "<$constructor$>";
        stringArray[333] = "error";
        stringArray[334] = "<$constructor$>";
        stringArray[335] = "printUsageAndThrow";
        stringArray[336] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[337] = "<$constructor$>";
        stringArray[338] = "getAt";
        stringArray[339] = "replaceAll";
        stringArray[340] = "mod";
        stringArray[341] = "length";
        stringArray[342] = "length";
        stringArray[343] = "<$constructor$>";
        stringArray[344] = "mod";
        stringArray[345] = "length";
        stringArray[346] = "length";
        stringArray[347] = "<$constructor$>";
        stringArray[348] = "decodeHex";
        stringArray[349] = "chars";
        stringArray[350] = "getAt";
        stringArray[351] = "getAt";
        stringArray[352] = "getAt";
        stringArray[353] = "getAt";
        stringArray[354] = "generateFlowDecryptionCipher";
        stringArray[355] = "doFinal";
        stringArray[356] = "<$constructor$>";
        stringArray[357] = "UTF_8";
        stringArray[358] = "getInstance";
        stringArray[359] = "<$constructor$>";
        stringArray[360] = "chars";
        stringArray[361] = "getInstance";
        stringArray[362] = "generateSecret";
        stringArray[363] = "<$constructor$>";
        stringArray[364] = "init";
        stringArray[365] = "DECRYPT_MODE";
        stringArray[366] = "getBytes";
        stringArray[367] = "UTF_8";
        stringArray[368] = "length";
        stringArray[369] = "<$constructor$>";
        stringArray[370] = "doFinal";
        stringArray[371] = "concatByteArrays";
        stringArray[372] = "encodeHexString";
        stringArray[373] = "<$constructor$>";
        stringArray[374] = "each";
        stringArray[375] = "toByteArray";
        stringArray[376] = "nextBytes";
        stringArray[377] = "<$constructor$>";
        stringArray[378] = "generateFlowEncryptionCipher";
        stringArray[379] = "replaceAll";
        stringArray[380] = "info";
        stringArray[381] = "getInstance";
        stringArray[382] = "<$constructor$>";
        stringArray[383] = "chars";
        stringArray[384] = "getInstance";
        stringArray[385] = "generateSecret";
        stringArray[386] = "<$constructor$>";
        stringArray[387] = "init";
        stringArray[388] = "ENCRYPT_MODE";
        stringArray[389] = "withCloseable";
        stringArray[390] = "<$constructor$>";
        stringArray[391] = "<$constructor$>";
        stringArray[392] = "parseText";
        stringArray[393] = "getXmlSlurper";
        stringArray[394] = "parseText";
        stringArray[395] = "findAll";
        stringArray[396] = "property";
        stringArray[397] = "find";
        stringArray[398] = "provider";
        stringArray[399] = "isEmpty";
        stringArray[400] = "info";
        stringArray[401] = "each";
        stringArray[402] = "serialize";
        stringArray[403] = "info";
        stringArray[404] = "printUsageAndThrow";
        stringArray[405] = "SERVICE_ERROR";
        stringArray[406] = "<$constructor$>";
        stringArray[407] = "parseText";
        stringArray[408] = "getXmlSlurper";
        stringArray[409] = "parseText";
        stringArray[410] = "findAll";
        stringArray[411] = "property";
        stringArray[412] = "find";
        stringArray[413] = "userGroupProvider";
        stringArray[414] = "isEmpty";
        stringArray[415] = "info";
        stringArray[416] = "each";
        stringArray[417] = "serialize";
        stringArray[418] = "info";
        stringArray[419] = "printUsageAndThrow";
        stringArray[420] = "SERVICE_ERROR";
        stringArray[421] = "<$constructor$>";
        stringArray[422] = "parseText";
        stringArray[423] = "getXmlSlurper";
        stringArray[424] = "parseText";
        stringArray[425] = "findAll";
        stringArray[426] = "property";
        stringArray[427] = "find";
        stringArray[428] = "provider";
        stringArray[429] = "isEmpty";
        stringArray[430] = "info";
        stringArray[431] = "each";
        stringArray[432] = "serialize";
        stringArray[433] = "info";
        stringArray[434] = "error";
        stringArray[435] = "printUsageAndThrow";
        stringArray[436] = "SERVICE_ERROR";
        stringArray[437] = "<$constructor$>";
        stringArray[438] = "parseText";
        stringArray[439] = "getXmlSlurper";
        stringArray[440] = "parseText";
        stringArray[441] = "findAll";
        stringArray[442] = "property";
        stringArray[443] = "find";
        stringArray[444] = "userGroupProvider";
        stringArray[445] = "isEmpty";
        stringArray[446] = "info";
        stringArray[447] = "each";
        stringArray[448] = "serialize";
        stringArray[449] = "info";
        stringArray[450] = "error";
        stringArray[451] = "printUsageAndThrow";
        stringArray[452] = "SERVICE_ERROR";
        stringArray[453] = "<$constructor$>";
        stringArray[454] = "<$constructor$>";
        stringArray[455] = "getSensitivePropertyKeys";
        stringArray[456] = "isEmpty";
        stringArray[457] = "info";
        stringArray[458] = "<$constructor$>";
        stringArray[459] = "<$constructor$>";
        stringArray[460] = "addSensitivePropertyProvider";
        stringArray[461] = "each";
        stringArray[462] = "minus";
        stringArray[463] = "getPropertyKeys";
        stringArray[464] = "each";
        stringArray[465] = "<$constructor$>";
        stringArray[466] = "info";
        stringArray[467] = "size";
        stringArray[468] = "countProtectedProperties";
        stringArray[469] = "replaceFirst";
        stringArray[470] = "serialize";
        stringArray[471] = "exists";
        stringArray[472] = "<$constructor$>";
        stringArray[473] = "canRead";
        stringArray[474] = "canWrite";
        stringArray[475] = "readLines";
        stringArray[476] = "updateBootstrapContentsWithKey";
        stringArray[477] = "join";
        stringArray[478] = "error";
        stringArray[479] = "<$constructor$>";
        stringArray[480] = "findIndexOf";
        stringArray[481] = "debug";
        stringArray[482] = "putAt";
        stringArray[483] = "debug";
        stringArray[484] = "minus";
        stringArray[485] = "getAt";
        stringArray[486] = "add";
        stringArray[487] = "debug";
        stringArray[488] = "addAll";
        stringArray[489] = "debug";
        stringArray[490] = "<$constructor$>";
        stringArray[491] = "<$constructor$>";
        stringArray[492] = "isSafeToWrite";
        stringArray[493] = "<$constructor$>";
        stringArray[494] = "exists";
        stringArray[495] = "canRead";
        stringArray[496] = "join";
        stringArray[497] = "serializeLoginIdentityProvidersAndPreserveFormat";
        stringArray[498] = "error";
        stringArray[499] = "<$constructor$>";
        stringArray[500] = "<$constructor$>";
        stringArray[501] = "<$constructor$>";
        stringArray[502] = "isSafeToWrite";
        stringArray[503] = "<$constructor$>";
        stringArray[504] = "exists";
        stringArray[505] = "canRead";
        stringArray[506] = "join";
        stringArray[507] = "serializeAuthorizersAndPreserveFormat";
        stringArray[508] = "error";
        stringArray[509] = "<$constructor$>";
        stringArray[510] = "<$constructor$>";
        stringArray[511] = "<$constructor$>";
        stringArray[512] = "isSafeToWrite";
        stringArray[513] = "<$constructor$>";
        stringArray[514] = "exists";
        stringArray[515] = "canRead";
        stringArray[516] = "serializeNiFiPropertiesAndPreserveFormat";
        stringArray[517] = "serializeNiFiProperties";
        stringArray[518] = "join";
        stringArray[519] = "error";
        stringArray[520] = "<$constructor$>";
        stringArray[521] = "readLines";
        stringArray[522] = "<$constructor$>";
        stringArray[523] = "getProtectedPropertyKeys";
        stringArray[524] = "containsKey";
        stringArray[525] = "SENSITIVE_PROPS_KEY";
        stringArray[526] = "put";
        stringArray[527] = "SENSITIVE_PROPS_KEY";
        stringArray[528] = "getProperty";
        stringArray[529] = "getProtectionKey";
        stringArray[530] = "SENSITIVE_PROPS_KEY";
        stringArray[531] = "each";
        stringArray[532] = "<$constructor$>";
        stringArray[533] = "<$constructor$>";
        stringArray[534] = "<$constructor$>";
        stringArray[535] = "each";
        stringArray[536] = "getPropertyKeys";
        stringArray[537] = "store";
        stringArray[538] = "flush";
        stringArray[539] = "split";
        stringArray[540] = "toString";
        stringArray[541] = "text";
        stringArray[542] = "parseText";
        stringArray[543] = "getXmlSlurper";
        stringArray[544] = "parseText";
        stringArray[545] = "find";
        stringArray[546] = "provider";
        stringArray[547] = "serializeXMLFragment";
        stringArray[548] = "replaceFirst";
        stringArray[549] = "quoteReplacement";
        stringArray[550] = "split";
        stringArray[551] = "<$constructor$>";
        stringArray[552] = "error";
        stringArray[553] = "plus";
        stringArray[554] = "split";
        stringArray[555] = "text";
        stringArray[556] = "parseText";
        stringArray[557] = "getXmlSlurper";
        stringArray[558] = "parseText";
        stringArray[559] = "find";
        stringArray[560] = "userGroupProvider";
        stringArray[561] = "serializeXMLFragment";
        stringArray[562] = "replaceFirst";
        stringArray[563] = "quoteReplacement";
        stringArray[564] = "split";
        stringArray[565] = "<$constructor$>";
        stringArray[566] = "error";
        stringArray[567] = "plus";
        stringArray[568] = "split";
        stringArray[569] = "exists";
        stringArray[570] = "canWrite";
        stringArray[571] = "parentFile";
        stringArray[572] = "absoluteFile";
        stringArray[573] = "exists";
        stringArray[574] = "canWrite";
        stringArray[575] = "exists";
        stringArray[576] = "canWrite";
        stringArray[577] = "parentFile";
        stringArray[578] = "absoluteFile";
        stringArray[579] = "exists";
        stringArray[580] = "canWrite";
        stringArray[581] = "trim";
        stringArray[582] = "length";
        stringArray[583] = "<$constructor$>";
        stringArray[584] = "length";
        stringArray[585] = "<$constructor$>";
        stringArray[586] = "generateScryptSaltForKeyDerivation";
        stringArray[587] = "div";
        stringArray[588] = "max";
        stringArray[589] = "getValidKeyLengths";
        stringArray[590] = "div";
        stringArray[591] = "max";
        stringArray[592] = "generate";
        stringArray[593] = "getBytes";
        stringArray[594] = "UTF_8";
        stringArray[595] = "toUpperCase";
        stringArray[596] = "encodeHexString";
        stringArray[597] = "getBytes";
        stringArray[598] = "UTF_8";
        stringArray[599] = "getProperty";
        stringArray[600] = "SENSITIVE_PROPS_KEY";
        stringArray[601] = "readProtectedPropertiesFromDisk";
        stringArray[602] = "withKey";
        stringArray[603] = "<$constructor$>";
        stringArray[604] = "hasProtectedKeys";
        stringArray[605] = "<$constructor$>";
        stringArray[606] = "setKeepIgnorableWhitespace";
        stringArray[607] = "addProvider";
        stringArray[608] = "<$constructor$>";
        stringArray[609] = "<$constructor$>";
        stringArray[610] = "parse";
        stringArray[611] = "translatingCli";
        stringArray[612] = "bootstrapConfPath";
        stringArray[613] = "extractKeyFromBootstrapFile";
        stringArray[614] = "bootstrapConfPath";
        stringArray[615] = "keyHex";
        stringArray[616] = "info";
        stringArray[617] = "bootstrapConfPath";
        stringArray[618] = "niFiPropertiesPath";
        stringArray[619] = "loadNiFiProperties";
        stringArray[620] = "keyHex";
        stringArray[621] = "translateNiFiPropertiesToCLI";
        stringArray[622] = "println";
        stringArray[623] = "out";
        stringArray[624] = "exit";
        stringArray[625] = "ordinal";
        stringArray[626] = "SUCCESS";
        stringArray[627] = "niFiPropertiesAreEncrypted";
        stringArray[628] = "ignorePropertiesFiles";
        stringArray[629] = "handlingFlowXml";
        stringArray[630] = "ignorePropertiesFiles";
        stringArray[631] = "extractKeyFromBootstrapFile";
        stringArray[632] = "bootstrapConfPath";
        stringArray[633] = "getKey";
        stringArray[634] = "keyHex";
        stringArray[635] = "printUsageAndThrow";
        stringArray[636] = "INVALID_ARGS";
        stringArray[637] = "parseKey";
        stringArray[638] = "keyHex";
        stringArray[639] = "isVerbose";
        stringArray[640] = "error";
        stringArray[641] = "printUsageAndThrow";
        stringArray[642] = "getMessage";
        stringArray[643] = "INVALID_ARGS";
        stringArray[644] = "migration";
        stringArray[645] = "getMigrationKey";
        stringArray[646] = "printUsageAndThrow";
        stringArray[647] = "INVALID_ARGS";
        stringArray[648] = "parseKey";
        stringArray[649] = "isVerbose";
        stringArray[650] = "error";
        stringArray[651] = "printUsageAndThrow";
        stringArray[652] = "getMessage";
        stringArray[653] = "INVALID_ARGS";
        stringArray[654] = "ignorePropertiesFiles";
        stringArray[655] = "handlingFlowXml";
        stringArray[656] = "ignorePropertiesFiles";
        stringArray[657] = "extractKeyFromBootstrapFile";
        stringArray[658] = "bootstrapConfPath";
        stringArray[659] = "getKey";
        stringArray[660] = "keyHex";
        stringArray[661] = "printUsageAndThrow";
        stringArray[662] = "INVALID_ARGS";
        stringArray[663] = "parseKey";
        stringArray[664] = "keyHex";
        stringArray[665] = "isVerbose";
        stringArray[666] = "error";
        stringArray[667] = "printUsageAndThrow";
        stringArray[668] = "getMessage";
        stringArray[669] = "INVALID_ARGS";
        stringArray[670] = "migration";
        stringArray[671] = "getMigrationKey";
        stringArray[672] = "printUsageAndThrow";
        stringArray[673] = "INVALID_ARGS";
        stringArray[674] = "isVerbose";
        stringArray[675] = "error";
        stringArray[676] = "printUsageAndThrow";
        stringArray[677] = "getMessage";
        stringArray[678] = "INVALID_ARGS";
        stringArray[679] = "migrationKeyHex";
        stringArray[680] = "keyHex";
        stringArray[681] = "handlingNiFiProperties";
        stringArray[682] = "handlingFlowXml";
        stringArray[683] = "loadNiFiProperties";
        stringArray[684] = "printUsageAndThrow";
        stringArray[685] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[686] = "handlingLoginIdentityProviders";
        stringArray[687] = "loadLoginIdentityProviders";
        stringArray[688] = "printUsageAndThrow";
        stringArray[689] = "ERROR_INCORRECT_NUMBER_OF_PASSWORDS";
        stringArray[690] = "encryptLoginIdentityProviders";
        stringArray[691] = LOGIN_IDENTITY_PROVIDERS_ARG;
        stringArray[692] = "handlingAuthorizers";
        stringArray[693] = "loadAuthorizers";
        stringArray[694] = "printUsageAndThrow";
        stringArray[695] = "ERROR_INCORRECT_NUMBER_OF_PASSWORDS";
        stringArray[696] = "encryptAuthorizers";
        stringArray[697] = AUTHORIZERS_ARG;
        stringArray[698] = "handlingFlowXml";
        stringArray[699] = "loadFlowXml";
        stringArray[700] = "printUsageAndThrow";
        stringArray[701] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[702] = "getExistingFlowPassword";
        stringArray[703] = "flowPropertiesPassword";
        stringArray[704] = "getFlowPassword";
        stringArray[705] = NIFI_PROPERTIES_ARG;
        stringArray[706] = "getProperty";
        stringArray[707] = "SENSITIVE_PROPS_ALGORITHM";
        stringArray[708] = "getProperty";
        stringArray[709] = "SENSITIVE_PROPS_PROVIDER";
        stringArray[710] = NEW_FLOW_ALGORITHM_ARG;
        stringArray[711] = NEW_FLOW_PROVIDER_ARG;
        stringArray[712] = "migrateFlowXmlContent";
        stringArray[713] = FLOW_XML_ARG;
        stringArray[714] = "<$constructor$>";
        stringArray[715] = "each";
        stringArray[716] = "getPropertyKeys";
        stringArray[717] = "handlingNiFiProperties";
        stringArray[718] = "<$constructor$>";
        stringArray[719] = "keyHex";
        stringArray[720] = "protect";
        stringArray[721] = "put";
        stringArray[722] = "SENSITIVE_PROPS_KEY";
        stringArray[723] = "put";
        stringArray[724] = "getProtectionKey";
        stringArray[725] = "SENSITIVE_PROPS_KEY";
        stringArray[726] = "getIdentifierKey";
        stringArray[727] = "isVerbose";
        stringArray[728] = "info";
        stringArray[729] = "put";
        stringArray[730] = "SENSITIVE_PROPS_KEY";
        stringArray[731] = "<$constructor$>";
        stringArray[732] = "handlingNiFiProperties";
        stringArray[733] = "encryptSensitiveProperties";
        stringArray[734] = NIFI_PROPERTIES_ARG;
        stringArray[735] = "exitCode";
        stringArray[736] = "HELP";
        stringArray[737] = "exit";
        stringArray[738] = "ordinal";
        stringArray[739] = "HELP";
        stringArray[740] = "isVerbose";
        stringArray[741] = "error";
        stringArray[742] = "printUsageAndThrow";
        stringArray[743] = "message";
        stringArray[744] = "ERROR_PARSING_COMMAND_LINE";
        stringArray[745] = "ignorePropertiesFiles";
        stringArray[746] = "writeKeyToBootstrapConf";
        stringArray[747] = "handlingFlowXml";
        stringArray[748] = "writeFlowXmlToFile";
        stringArray[749] = FLOW_XML_ARG;
        stringArray[750] = "handlingNiFiProperties";
        stringArray[751] = "handlingFlowXml";
        stringArray[752] = "writeNiFiProperties";
        stringArray[753] = "handlingLoginIdentityProviders";
        stringArray[754] = "writeLoginIdentityProviders";
        stringArray[755] = "handlingAuthorizers";
        stringArray[756] = "writeAuthorizers";
        stringArray[757] = "isVerbose";
        stringArray[758] = "error";
        stringArray[759] = "printUsageAndThrow";
        stringArray[760] = "ERROR_GENERATING_CONFIG";
        stringArray[761] = "exit";
        stringArray[762] = "ordinal";
        stringArray[763] = "exitCode";
        stringArray[764] = "exit";
        stringArray[765] = "ordinal";
        stringArray[766] = "SUCCESS";
        stringArray[767] = "determineBaseUrl";
        stringArray[768] = "each";
        stringArray[769] = "leftShift";
        stringArray[770] = "join";
        stringArray[771] = "isHTTPSConfigured";
        stringArray[772] = "isHTTPSConfigured";
        stringArray[773] = "getProperty";
        stringArray[774] = "WEB_HTTPS_HOST";
        stringArray[775] = "getProperty";
        stringArray[776] = "WEB_HTTP_HOST";
        stringArray[777] = "getConfiguredHttpOrHttpsPort";
        stringArray[778] = "defaultTextDevice";
        stringArray[779] = "defaultTextDevice";
        stringArray[780] = "defaultTextDevice";
        stringArray[781] = "getLogger";
        stringArray[782] = "power";
        stringArray[783] = "lineSeparator";
        stringArray[784] = "buildFooter";
        stringArray[785] = "plus";
        stringArray[786] = "plus";
        stringArray[787] = "plus";
        stringArray[788] = "plus";
        stringArray[789] = "plus";
        stringArray[790] = "PROVIDER_NAME";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[791];
        ConfigEncryptionTool.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ConfigEncryptionTool.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ConfigEncryptionTool.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$org$apache$nifi$properties$ProtectedNiFiProperties() {
        Class clazz = $class$org$apache$nifi$properties$ProtectedNiFiProperties;
        if (clazz == null) {
            clazz = $class$org$apache$nifi$properties$ProtectedNiFiProperties = ConfigEncryptionTool.class$("org.apache.nifi.properties.ProtectedNiFiProperties");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

