/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.encryptconfig;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.util.CliBuilder;
import groovy.util.OptionAccessor;
import java.lang.ref.SoftReference;
import java.util.Properties;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.nifi.properties.AESSensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.toolkit.encryptconfig.Configuration;
import org.apache.nifi.toolkit.encryptconfig.EncryptConfigLogger;
import org.apache.nifi.toolkit.encryptconfig.EncryptConfigMain;
import org.apache.nifi.toolkit.encryptconfig.ToolMode;
import org.apache.nifi.toolkit.encryptconfig.util.BootstrapUtil;
import org.apache.nifi.toolkit.encryptconfig.util.NiFiRegistryAuthorizersXmlEncryptor;
import org.apache.nifi.toolkit.encryptconfig.util.NiFiRegistryIdentityProvidersXmlEncryptor;
import org.apache.nifi.toolkit.encryptconfig.util.NiFiRegistryPropertiesEncryptor;
import org.apache.nifi.toolkit.encryptconfig.util.ToolUtilities;
import org.apache.nifi.util.console.TextDevices;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiRegistryMode
implements ToolMode,
GroovyObject {
    private static final Logger logger;
    private CliBuilder cli;
    private boolean verboseEnabled;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public NiFiRegistryMode() {
        boolean bl;
        MetaClass metaClass;
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[0].callStatic(NiFiRegistryMode.class);
            this.cli = (CliBuilder)ScriptBytecodeAdapter.castToType((Object)object, CliBuilder.class);
        } else {
            CliBuilder cliBuilder;
            this.cli = cliBuilder = NiFiRegistryMode.cliBuilder();
        }
        this.verboseEnabled = bl = false;
    }

    public void run(String ... args) {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        try {
            Object options = callSiteArray[1].call((Object)this.cli, (Object)args);
            if (!DefaultTypeTransformation.booleanUnbox((Object)options) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(options))) {
                callSiteArray[3].call(EncryptConfigMain.class, (Object)"", callSiteArray[4].callGetProperty(EncryptConfigMain.class));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callGetProperty(options))) {
                boolean bl;
                this.verboseEnabled = bl = true;
            }
            callSiteArray[6].call(EncryptConfigLogger.class, (Object)this.verboseEnabled);
            NiFiRegistryConfiguration config = (NiFiRegistryConfiguration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callConstructor(NiFiRegistryConfiguration.class, options), NiFiRegistryConfiguration.class);
            callSiteArray[8].callCurrent((GroovyObject)this, (Object)config);
        }
        catch (Exception e) {
            if (this.verboseEnabled) {
                callSiteArray[9].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[10].call((Object)e)}, new String[]{"Encountered an error: ", ""}));
            }
            callSiteArray[11].call(EncryptConfigMain.class, callSiteArray[12].call((Object)e), callSiteArray[13].callGetProperty(EncryptConfigMain.class));
        }
    }

    public void run(NiFiRegistryConfiguration config) throws Exception {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].callGetProperty((Object)config))) {
            callSiteArray[15].call((Object)logger, (Object)"Using encryption key derived from password.");
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].callGetProperty((Object)config))) {
            callSiteArray[17].call((Object)logger, (Object)"Using encryption key provided.");
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].callGetProperty((Object)config))) {
            callSiteArray[19].call((Object)logger, (Object)"Using encryption key from input bootstrap.conf.");
        }
        callSiteArray[20].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[21].callGetProperty((Object)config)}, new String[]{"(src)  bootstrap.conf:           ", ""}));
        callSiteArray[22].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[23].callGetProperty((Object)config)}, new String[]{"(dest) bootstrap.conf:           ", ""}));
        callSiteArray[24].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[25].callGetProperty((Object)config)}, new String[]{"(src)  nifi-registry.properties: ", ""}));
        callSiteArray[26].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[27].callGetProperty((Object)config)}, new String[]{"(dest) nifi-registry.properties: ", ""}));
        callSiteArray[28].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[29].callGetProperty((Object)config)}, new String[]{"(src)  identity-providers.xml:   ", ""}));
        callSiteArray[30].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[31].callGetProperty((Object)config)}, new String[]{"(dest) identity-providers.xml:   ", ""}));
        callSiteArray[32].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[33].callGetProperty((Object)config)}, new String[]{"(src)  authorizers.xml:          ", ""}));
        callSiteArray[34].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[35].callGetProperty((Object)config)}, new String[]{"(dest) authorizers.xml:          ", ""}));
        Properties niFiRegistryProperties = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].callGetProperty((Object)config))) {
            try {
                callSiteArray[37].call((Object)logger, (Object)"Encrypting NiFi Registry Properties");
                Object object = callSiteArray[38].call(callSiteArray[39].callGetProperty((Object)config), callSiteArray[40].callGetProperty((Object)config));
                niFiRegistryProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)object, Properties.class);
                Object object2 = callSiteArray[41].call(callSiteArray[42].callGetProperty((Object)config), (Object)niFiRegistryProperties);
                niFiRegistryProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)object2, Properties.class);
                Object object3 = callSiteArray[43].call(callSiteArray[44].callGetProperty((Object)config), (Object)niFiRegistryProperties);
                niFiRegistryProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)object3, Properties.class);
            }
            catch (Exception e) {
                throw (Throwable)callSiteArray[45].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{callSiteArray[46].callGetProperty((Object)config), callSiteArray[47].call((Object)e)}, new String[]{"Encountered error trying to load and encrypt NiFi Registry Properties in ", ": ", ""}), (Object)e);
            }
        }
        String identityProvidersXml = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].callGetProperty((Object)config))) {
            try {
                callSiteArray[49].call((Object)logger, (Object)"Encrypting Identity Providers XML");
                Object object = callSiteArray[50].call(callSiteArray[51].callGetProperty((Object)config), callSiteArray[52].callGetProperty((Object)config));
                identityProvidersXml = ShortTypeHandling.castToString((Object)object);
                Object object4 = callSiteArray[53].call(callSiteArray[54].callGetProperty((Object)config), (Object)identityProvidersXml);
                identityProvidersXml = ShortTypeHandling.castToString((Object)object4);
                Object object5 = callSiteArray[55].call(callSiteArray[56].callGetProperty((Object)config), (Object)identityProvidersXml);
                identityProvidersXml = ShortTypeHandling.castToString((Object)object5);
            }
            catch (Exception e) {
                throw (Throwable)callSiteArray[57].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{callSiteArray[58].callGetProperty((Object)config), callSiteArray[59].call((Object)e)}, new String[]{"Encountered error trying to load and encrypt Identity Providers XML in ", ": ", ""}), (Object)e);
            }
        }
        String authorizersXml = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].callGetProperty((Object)config))) {
            try {
                callSiteArray[61].call((Object)logger, (Object)"Encrypting Authorizers XML");
                Object object = callSiteArray[62].call(callSiteArray[63].callGetProperty((Object)config), callSiteArray[64].callGetProperty((Object)config));
                authorizersXml = ShortTypeHandling.castToString((Object)object);
                Object object6 = callSiteArray[65].call(callSiteArray[66].callGetProperty((Object)config), (Object)authorizersXml);
                authorizersXml = ShortTypeHandling.castToString((Object)object6);
                Object object7 = callSiteArray[67].call(callSiteArray[68].callGetProperty((Object)config), (Object)authorizersXml);
                authorizersXml = ShortTypeHandling.castToString((Object)object7);
            }
            catch (Exception e) {
                throw (Throwable)callSiteArray[69].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{callSiteArray[70].callGetProperty((Object)config), callSiteArray[71].call((Object)e)}, new String[]{"Encountered error trying to load and encrypt Authorizers XML in ", ": ", ""}), (Object)e);
            }
        }
        try {
            NiFiRegistryMode niFiRegistryMode = this;
            synchronized (niFiRegistryMode) {
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[72].callGetProperty((Object)config))) {
                    callSiteArray[73].call(BootstrapUtil.class, callSiteArray[74].callGetProperty((Object)config), callSiteArray[75].callGetProperty(BootstrapUtil.class), callSiteArray[76].callGetProperty((Object)config), callSiteArray[77].callGetProperty((Object)config));
                    callSiteArray[78].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[79].callGetProperty((Object)config)}, new String[]{"Updated bootstrap config file with master key: ", ""}));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[80].callGetProperty((Object)config))) {
                    callSiteArray[81].call(callSiteArray[82].callGetProperty((Object)config), (Object)niFiRegistryProperties, callSiteArray[83].callGetProperty((Object)config), callSiteArray[84].callGetProperty((Object)config));
                    callSiteArray[85].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[86].callGetProperty((Object)config)}, new String[]{"Updated NiFi Registry Properties file with protected values: ", ""}));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].callGetProperty((Object)config))) {
                    callSiteArray[88].call(callSiteArray[89].callGetProperty((Object)config), (Object)identityProvidersXml, callSiteArray[90].callGetProperty((Object)config), callSiteArray[91].callGetProperty((Object)config));
                    callSiteArray[92].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[93].callGetProperty((Object)config)}, new String[]{"Updated Identity Providers XML file with protected values: ", ""}));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[94].callGetProperty((Object)config))) {
                    callSiteArray[95].call(callSiteArray[96].callGetProperty((Object)config), (Object)authorizersXml, callSiteArray[97].callGetProperty((Object)config), callSiteArray[98].callGetProperty((Object)config));
                    callSiteArray[99].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[100].callGetProperty((Object)config)}, new String[]{"Updated Authorizers XML file with protected values: ", ""}));
                }
            }
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[101].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{callSiteArray[102].call((Object)e)}, new String[]{"Encountered error while writing the output files: ", ""}), (Object)e);
        }
    }

    public static Options getCliOptions() {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Options)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].callGetProperty(callSiteArray[104].callStatic(NiFiRegistryMode.class)), Options.class);
        }
        return (Options)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].callGetProperty((Object)NiFiRegistryMode.cliBuilder()), Options.class);
    }

    public static CliBuilder cliBuilder() {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        String usage = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[106].call(NiFiRegistryMode.class)}, new String[]{"", " [options]"}));
        int formatWidth = DefaultTypeTransformation.intUnbox((Object)callSiteArray[107].callGetProperty(EncryptConfigMain.class));
        HelpFormatter formatter = (HelpFormatter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[108].callConstructor(HelpFormatter.class), HelpFormatter.class);
        callSiteArray[109].call((Object)formatter, (Object)formatWidth);
        callSiteArray[110].call((Object)formatter, null);
        CliBuilder cli = (CliBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[111].callConstructor(CliBuilder.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"usage", usage, "width", formatWidth, "formatter", formatter})), CliBuilder.class);
        callSiteArray[112].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "help"}), (Object)"Show usage information (this message)");
        callSiteArray[113].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "verbose"}), (Object)"Sets verbose mode (default false)");
        callSiteArray[114].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "password", "args", 1, "argName", "password", "optionalArg", true}), (Object)"Protect the files using a password-derived key. If an argument is not provided to this flag, interactive mode will be triggered to prompt the user to enter the password.");
        callSiteArray[115].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "key", "args", 1, "argName", "keyhex", "optionalArg", true}), (Object)"Protect the files using a raw hexadecimal key. If an argument is not provided to this flag, interactive mode will be triggered to prompt the user to enter the key.");
        callSiteArray[116].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "oldPassword", "args", 1, "argName", "password"}), (Object)"If the input files are already protected using a password-derived key, this specifies the old password so that the files can be unprotected before re-protecting.");
        callSiteArray[117].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "oldKey", "args", 1, "argName", "keyhex"}), (Object)"If the input files are already protected using a key, this specifies the raw hexadecimal key so that the files can be unprotected before re-protecting.");
        callSiteArray[118].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "bootstrapConf", "args", 1, "argName", "file"}), (Object)"The bootstrap.conf file containing no master key or an existing master key. If a new password or key is specified (using -p or -k) and no output bootstrap.conf file is specified, then this file will be overwritten to persist the new master key.");
        callSiteArray[119].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "outputBootstrapConf", "args", 1, "argName", "file"}), (Object)"The destination bootstrap.conf file to persist master key. If specified, the input bootstrap.conf will not be modified.");
        callSiteArray[120].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "nifiRegistryProperties", "args", 1, "argName", "file"}), (Object)"The nifi-registry.properties file containing unprotected config values, overwritten if no output file specified.");
        callSiteArray[121].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "outputNifiRegistryProperties", "args", 1, "argName", "file"}), (Object)"The destination nifi-registry.properties file containing protected config values.");
        callSiteArray[122].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "authorizersXml", "args", 1, "argName", "file"}), (Object)"The authorizers.xml file containing unprotected config values, overwritten if no output file specified.");
        callSiteArray[123].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "outputAuthorizersXml", "args", 1, "argName", "file"}), (Object)"The destination authorizers.xml file containing protected config values.");
        callSiteArray[124].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "identityProvidersXml", "args", 1, "argName", "file"}), (Object)"The identity-providers.xml file containing unprotected config values, overwritten if no output file specified.");
        callSiteArray[125].call((Object)cli, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"longOpt", "outputIdentityProvidersXml", "args", 1, "argName", "file"}), (Object)"The destination identity-providers.xml file containing protected config values.");
        return cli;
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NiFiRegistryMode.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, NiFiRegistryMode.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = NiFiRegistryMode.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(NiFiRegistryMode.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != NiFiRegistryMode.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = NiFiRegistryMode.$getCallSiteArray()[126].call(LoggerFactory.class, NiFiRegistryMode.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    public CliBuilder getCli() {
        return this.cli;
    }

    public void setCli(CliBuilder cliBuilder) {
        this.cli = cliBuilder;
    }

    public boolean getVerboseEnabled() {
        return this.verboseEnabled;
    }

    public boolean isVerboseEnabled() {
        return this.verboseEnabled;
    }

    public void setVerboseEnabled(boolean bl) {
        this.verboseEnabled = bl;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "cliBuilder";
        stringArray[1] = "parse";
        stringArray[2] = "h";
        stringArray[3] = "printUsageAndExit";
        stringArray[4] = "EXIT_STATUS_OTHER";
        stringArray[5] = "v";
        stringArray[6] = "configureLogger";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "run";
        stringArray[9] = "error";
        stringArray[10] = "getMessage";
        stringArray[11] = "printUsageAndExit";
        stringArray[12] = "getMessage";
        stringArray[13] = "EXIT_STATUS_FAILURE";
        stringArray[14] = "usingPassword";
        stringArray[15] = "info";
        stringArray[16] = "usingRawKeyHex";
        stringArray[17] = "info";
        stringArray[18] = "usingBootstrapKey";
        stringArray[19] = "info";
        stringArray[20] = "debug";
        stringArray[21] = "inputBootstrapPath";
        stringArray[22] = "debug";
        stringArray[23] = "outputBootstrapPath";
        stringArray[24] = "debug";
        stringArray[25] = "inputNiFiRegistryPropertiesPath";
        stringArray[26] = "debug";
        stringArray[27] = "outputNiFiRegistryPropertiesPath";
        stringArray[28] = "debug";
        stringArray[29] = "inputIdentityProvidersPath";
        stringArray[30] = "debug";
        stringArray[31] = "outputIdentityProvidersPath";
        stringArray[32] = "debug";
        stringArray[33] = "inputAuthorizersPath";
        stringArray[34] = "debug";
        stringArray[35] = "outputAuthorizersPath";
        stringArray[36] = "handlingNiFiRegistryProperties";
        stringArray[37] = "debug";
        stringArray[38] = "loadFile";
        stringArray[39] = "propertiesEncryptor";
        stringArray[40] = "inputNiFiRegistryPropertiesPath";
        stringArray[41] = "decrypt";
        stringArray[42] = "propertiesEncryptor";
        stringArray[43] = "encrypt";
        stringArray[44] = "propertiesEncryptor";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "inputNiFiRegistryPropertiesPath";
        stringArray[47] = "getMessage";
        stringArray[48] = "handlingIdentityProviders";
        stringArray[49] = "debug";
        stringArray[50] = "loadXmlFile";
        stringArray[51] = "identityProvidersXmlEncryptor";
        stringArray[52] = "inputIdentityProvidersPath";
        stringArray[53] = "decrypt";
        stringArray[54] = "identityProvidersXmlEncryptor";
        stringArray[55] = "encrypt";
        stringArray[56] = "identityProvidersXmlEncryptor";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "inputIdentityProvidersPath";
        stringArray[59] = "getMessage";
        stringArray[60] = "handlingAuthorizers";
        stringArray[61] = "debug";
        stringArray[62] = "loadXmlFile";
        stringArray[63] = "authorizersXmlEncryptor";
        stringArray[64] = "inputAuthorizersPath";
        stringArray[65] = "decrypt";
        stringArray[66] = "authorizersXmlEncryptor";
        stringArray[67] = "encrypt";
        stringArray[68] = "authorizersXmlEncryptor";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "inputAuthorizersPath";
        stringArray[71] = "getMessage";
        stringArray[72] = "writingKeyToBootstrap";
        stringArray[73] = "writeKeyToBootstrapFile";
        stringArray[74] = "encryptionKey";
        stringArray[75] = "REGISTRY_BOOTSTRAP_KEY_PROPERTY";
        stringArray[76] = "outputBootstrapPath";
        stringArray[77] = "inputBootstrapPath";
        stringArray[78] = "info";
        stringArray[79] = "outputBootstrapPath";
        stringArray[80] = "handlingNiFiRegistryProperties";
        stringArray[81] = "write";
        stringArray[82] = "propertiesEncryptor";
        stringArray[83] = "outputNiFiRegistryPropertiesPath";
        stringArray[84] = "inputNiFiRegistryPropertiesPath";
        stringArray[85] = "info";
        stringArray[86] = "outputNiFiRegistryPropertiesPath";
        stringArray[87] = "handlingIdentityProviders";
        stringArray[88] = "writeXmlFile";
        stringArray[89] = "identityProvidersXmlEncryptor";
        stringArray[90] = "outputIdentityProvidersPath";
        stringArray[91] = "inputIdentityProvidersPath";
        stringArray[92] = "info";
        stringArray[93] = "outputIdentityProvidersPath";
        stringArray[94] = "handlingAuthorizers";
        stringArray[95] = "writeXmlFile";
        stringArray[96] = "authorizersXmlEncryptor";
        stringArray[97] = "outputAuthorizersPath";
        stringArray[98] = "inputAuthorizersPath";
        stringArray[99] = "info";
        stringArray[100] = "outputAuthorizersPath";
        stringArray[101] = "<$constructor$>";
        stringArray[102] = "getMessage";
        stringArray[103] = "options";
        stringArray[104] = "cliBuilder";
        stringArray[105] = "options";
        stringArray[106] = "getCanonicalName";
        stringArray[107] = "HELP_FORMAT_WIDTH";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "setWidth";
        stringArray[110] = "setOptionComparator";
        stringArray[111] = "<$constructor$>";
        stringArray[112] = "h";
        stringArray[113] = "v";
        stringArray[114] = "p";
        stringArray[115] = "k";
        stringArray[116] = "_";
        stringArray[117] = "_";
        stringArray[118] = "b";
        stringArray[119] = "B";
        stringArray[120] = "r";
        stringArray[121] = "R";
        stringArray[122] = "a";
        stringArray[123] = "A";
        stringArray[124] = "i";
        stringArray[125] = "I";
        stringArray[126] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[127];
        NiFiRegistryMode.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(NiFiRegistryMode.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = NiFiRegistryMode.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class NiFiRegistryConfiguration
    implements Configuration,
    GroovyObject {
        private OptionAccessor rawOptions;
        private boolean usingRawKeyHex;
        private boolean usingPassword;
        private boolean usingBootstrapKey;
        private String encryptionKey;
        private String decryptionKey;
        private SensitivePropertyProvider encryptionProvider;
        private SensitivePropertyProvider decryptionProvider;
        private boolean writingKeyToBootstrap;
        private String inputBootstrapPath;
        private String outputBootstrapPath;
        private boolean handlingNiFiRegistryProperties;
        private String inputNiFiRegistryPropertiesPath;
        private String outputNiFiRegistryPropertiesPath;
        private NiFiRegistryPropertiesEncryptor propertiesEncryptor;
        private boolean handlingIdentityProviders;
        private String inputIdentityProvidersPath;
        private String outputIdentityProvidersPath;
        private NiFiRegistryIdentityProvidersXmlEncryptor identityProvidersXmlEncryptor;
        private boolean handlingAuthorizers;
        private String inputAuthorizersPath;
        private String outputAuthorizersPath;
        private NiFiRegistryAuthorizersXmlEncryptor authorizersXmlEncryptor;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NiFiRegistryConfiguration() {
            MetaClass metaClass;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            this.writingKeyToBootstrap = bl4 = false;
            this.handlingNiFiRegistryProperties = bl3 = false;
            this.handlingIdentityProviders = bl2 = false;
            this.handlingAuthorizers = bl = false;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        /*
         * WARNING - void declaration
         */
        public NiFiRegistryConfiguration(OptionAccessor optionAccessor) {
            boolean bl;
            boolean bl2;
            void options;
            MetaClass metaClass;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            this.writingKeyToBootstrap = bl6 = false;
            this.handlingNiFiRegistryProperties = bl5 = false;
            this.handlingIdentityProviders = bl4 = false;
            this.handlingAuthorizers = bl3 = false;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            void var8_8 = options;
            this.rawOptions = (OptionAccessor)ScriptBytecodeAdapter.castToType((Object)var8_8, OptionAccessor.class);
            if (BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[0].callCurrent((GroovyObject)this);
            } else {
                this.validateOptions();
            }
            Object object = callSiteArray[1].callGroovyObjectGetProperty((Object)this.rawOptions);
            this.inputBootstrapPath = ShortTypeHandling.castToString((Object)object);
            if (BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[2].callCurrent((GroovyObject)this);
            } else {
                this.determineEncryptionKey();
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.encryptionKey)) {
                throw (Throwable)callSiteArray[3].callConstructor(RuntimeException.class, (Object)"Failed to configure tool, could not determine encryption key. Must provide -p, -k, or -b. If using -b, bootstrap.conf argument must already contain master key.");
            }
            Object object2 = callSiteArray[4].callConstructor(AESSensitivePropertyProvider.class, (Object)this.encryptionKey);
            this.encryptionProvider = (SensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)object2, SensitivePropertyProvider.class);
            if (BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[5].callCurrent((GroovyObject)this);
            } else {
                this.determineDecryptionKey();
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.decryptionKey)) {
                callSiteArray[6].call(callSiteArray[7].callGetProperty(NiFiRegistryMode.class), (Object)"No decryption key specified via options, so if any input files require decryption prior to re-encryption (i.e., migration), this tool will fail.");
            }
            Object object3 = DefaultTypeTransformation.booleanUnbox((Object)this.decryptionKey) ? callSiteArray[8].callConstructor(AESSensitivePropertyProvider.class, (Object)this.decryptionKey) : null;
            this.decryptionProvider = (SensitivePropertyProvider)ScriptBytecodeAdapter.castToType(object3, SensitivePropertyProvider.class);
            this.writingKeyToBootstrap = !BytecodeInterface8.isOrigZ() || BytecodeInterface8.disabledStandardMetaClass() ? (bl2 = this.usingPassword || this.usingRawKeyHex || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGroovyObjectGetProperty((Object)this.rawOptions))) : (bl = this.usingPassword || this.usingRawKeyHex || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].callGroovyObjectGetProperty((Object)this.rawOptions)));
            if (this.writingKeyToBootstrap) {
                Object object4 = callSiteArray[11].callGroovyObjectGetProperty((Object)this.rawOptions);
                Object object5 = DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : this.inputBootstrapPath;
                this.outputBootstrapPath = ShortTypeHandling.castToString((Object)object5);
            }
            Object object6 = callSiteArray[12].callGroovyObjectGetProperty((Object)this.rawOptions);
            this.handlingNiFiRegistryProperties = DefaultTypeTransformation.booleanUnbox((Object)object6);
            if (this.handlingNiFiRegistryProperties) {
                Object object7 = callSiteArray[13].callGroovyObjectGetProperty((Object)this.rawOptions);
                this.inputNiFiRegistryPropertiesPath = ShortTypeHandling.castToString((Object)object7);
                Object object8 = callSiteArray[14].callGroovyObjectGetProperty((Object)this.rawOptions);
                Object object9 = DefaultTypeTransformation.booleanUnbox((Object)object8) ? object8 : this.inputNiFiRegistryPropertiesPath;
                this.outputNiFiRegistryPropertiesPath = ShortTypeHandling.castToString((Object)object9);
                Object object10 = callSiteArray[15].callConstructor(NiFiRegistryPropertiesEncryptor.class, (Object)this.encryptionProvider, (Object)this.decryptionProvider);
                this.propertiesEncryptor = (NiFiRegistryPropertiesEncryptor)ScriptBytecodeAdapter.castToType((Object)object10, NiFiRegistryPropertiesEncryptor.class);
            }
            Object object11 = callSiteArray[16].callGroovyObjectGetProperty((Object)this.rawOptions);
            this.handlingIdentityProviders = DefaultTypeTransformation.booleanUnbox((Object)object11);
            if (this.handlingIdentityProviders) {
                Object object12 = callSiteArray[17].callGroovyObjectGetProperty((Object)this.rawOptions);
                this.inputIdentityProvidersPath = ShortTypeHandling.castToString((Object)object12);
                Object object13 = callSiteArray[18].callGroovyObjectGetProperty((Object)this.rawOptions);
                Object object14 = DefaultTypeTransformation.booleanUnbox((Object)object13) ? object13 : this.inputIdentityProvidersPath;
                this.outputIdentityProvidersPath = ShortTypeHandling.castToString((Object)object14);
                Object object15 = callSiteArray[19].callConstructor(NiFiRegistryIdentityProvidersXmlEncryptor.class, (Object)this.encryptionProvider, (Object)this.decryptionProvider);
                this.identityProvidersXmlEncryptor = (NiFiRegistryIdentityProvidersXmlEncryptor)ScriptBytecodeAdapter.castToType((Object)object15, NiFiRegistryIdentityProvidersXmlEncryptor.class);
            }
            Object object16 = callSiteArray[20].callGroovyObjectGetProperty((Object)this.rawOptions);
            this.handlingAuthorizers = DefaultTypeTransformation.booleanUnbox((Object)object16);
            if (this.handlingAuthorizers) {
                Object object17 = callSiteArray[21].callGroovyObjectGetProperty((Object)this.rawOptions);
                this.inputAuthorizersPath = ShortTypeHandling.castToString((Object)object17);
                Object object18 = callSiteArray[22].callGroovyObjectGetProperty((Object)this.rawOptions);
                Object object19 = DefaultTypeTransformation.booleanUnbox((Object)object18) ? object18 : this.inputAuthorizersPath;
                this.outputAuthorizersPath = ShortTypeHandling.castToString((Object)object19);
                Object object20 = callSiteArray[23].callConstructor(NiFiRegistryAuthorizersXmlEncryptor.class, (Object)this.encryptionProvider, (Object)this.decryptionProvider);
                this.authorizersXmlEncryptor = (NiFiRegistryAuthorizersXmlEncryptor)ScriptBytecodeAdapter.castToType((Object)object20, NiFiRegistryAuthorizersXmlEncryptor.class);
            }
        }

        private void validateOptions() {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            String validationFailedMessage = null;
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                String string;
                validationFailedMessage = string = "-b flag for bootstrap.conf is required.";
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                    validationFailedMessage = ShortTypeHandling.castToString((Object)callSiteArray[26].call((Object)validationFailedMessage, (Object)" Input bootsrap.conf will be used as template for output bootstrap.conf"));
                } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].callGroovyObjectGetProperty((Object)this.rawOptions)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                    String string2;
                    validationFailedMessage = string2 = " Encryption key will be persisted to bootstrap.conf";
                }
            }
            if (DefaultTypeTransformation.booleanUnbox(validationFailedMessage)) {
                throw (Throwable)callSiteArray[29].callConstructor(RuntimeException.class, callSiteArray[30].call((Object)"Invalid options: ", (Object)validationFailedMessage));
            }
        }

        private void determineEncryptionKey() {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].callGroovyObjectGetProperty((Object)this.rawOptions)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[32].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                String password = null;
                String keyHex = null;
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                    boolean bl;
                    callSiteArray[34].call(callSiteArray[35].callGetProperty(NiFiRegistryMode.class), (Object)"Attempting to generate key from password.");
                    this.usingPassword = bl = true;
                    Object object = callSiteArray[36].call(callSiteArray[37].call((Object)this.rawOptions), (Object)"p");
                    password = ShortTypeHandling.castToString((Object)object);
                } else {
                    boolean bl;
                    this.usingRawKeyHex = bl = true;
                    Object object = callSiteArray[38].call(callSiteArray[39].call((Object)this.rawOptions), (Object)"k");
                    keyHex = ShortTypeHandling.castToString((Object)object);
                }
                Object object = callSiteArray[40].call(ToolUtilities.class, callSiteArray[41].call(TextDevices.class), (Object)keyHex, (Object)password, (Object)this.usingPassword);
                this.encryptionKey = ShortTypeHandling.castToString((Object)object);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                boolean bl;
                callSiteArray[43].call(callSiteArray[44].callGetProperty(NiFiRegistryMode.class), (Object)"Attempting to read master key from input bootstrap.conf file.");
                this.usingBootstrapKey = bl = true;
                Object object = callSiteArray[45].call(BootstrapUtil.class, (Object)this.inputBootstrapPath, callSiteArray[46].callGetProperty(BootstrapUtil.class));
                this.encryptionKey = ShortTypeHandling.castToString((Object)object);
                if (!DefaultTypeTransformation.booleanUnbox((Object)this.encryptionKey)) {
                    callSiteArray[47].call(callSiteArray[48].callGetProperty(NiFiRegistryMode.class), (Object)"-b specified without -p or -k, but the input bootstrap.conf file did not contain a master key.");
                }
            }
        }

        private String determineDecryptionKey() {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[49].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                callSiteArray[50].call(callSiteArray[51].callGetProperty(NiFiRegistryMode.class), (Object)"Attempting to generate decryption key (for migration) from old password.");
                Object object = callSiteArray[52].call(ToolUtilities.class, callSiteArray[53].call(TextDevices.class), null, callSiteArray[54].callGroovyObjectGetProperty((Object)this.rawOptions), (Object)true);
                this.decryptionKey = ShortTypeHandling.castToString((Object)object);
                return ShortTypeHandling.castToString((Object)object);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].callGroovyObjectGetProperty((Object)this.rawOptions))) {
                Object object = callSiteArray[56].callGroovyObjectGetProperty((Object)this.rawOptions);
                this.decryptionKey = ShortTypeHandling.castToString((Object)object);
                return ShortTypeHandling.castToString((Object)object);
            }
            return ShortTypeHandling.castToString(null);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = NiFiRegistryConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NiFiRegistryConfiguration.class, NiFiRegistryMode.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NiFiRegistryConfiguration.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public OptionAccessor getRawOptions() {
            return this.rawOptions;
        }

        public void setRawOptions(OptionAccessor optionAccessor) {
            this.rawOptions = optionAccessor;
        }

        public boolean getUsingRawKeyHex() {
            return this.usingRawKeyHex;
        }

        public boolean isUsingRawKeyHex() {
            return this.usingRawKeyHex;
        }

        public void setUsingRawKeyHex(boolean bl) {
            this.usingRawKeyHex = bl;
        }

        public boolean getUsingPassword() {
            return this.usingPassword;
        }

        public boolean isUsingPassword() {
            return this.usingPassword;
        }

        public void setUsingPassword(boolean bl) {
            this.usingPassword = bl;
        }

        public boolean getUsingBootstrapKey() {
            return this.usingBootstrapKey;
        }

        public boolean isUsingBootstrapKey() {
            return this.usingBootstrapKey;
        }

        public void setUsingBootstrapKey(boolean bl) {
            this.usingBootstrapKey = bl;
        }

        public String getEncryptionKey() {
            return this.encryptionKey;
        }

        public void setEncryptionKey(String string) {
            this.encryptionKey = string;
        }

        public String getDecryptionKey() {
            return this.decryptionKey;
        }

        public void setDecryptionKey(String string) {
            this.decryptionKey = string;
        }

        public SensitivePropertyProvider getEncryptionProvider() {
            return this.encryptionProvider;
        }

        public void setEncryptionProvider(SensitivePropertyProvider sensitivePropertyProvider) {
            this.encryptionProvider = sensitivePropertyProvider;
        }

        public SensitivePropertyProvider getDecryptionProvider() {
            return this.decryptionProvider;
        }

        public void setDecryptionProvider(SensitivePropertyProvider sensitivePropertyProvider) {
            this.decryptionProvider = sensitivePropertyProvider;
        }

        public boolean getWritingKeyToBootstrap() {
            return this.writingKeyToBootstrap;
        }

        public boolean isWritingKeyToBootstrap() {
            return this.writingKeyToBootstrap;
        }

        public void setWritingKeyToBootstrap(boolean bl) {
            this.writingKeyToBootstrap = bl;
        }

        public String getInputBootstrapPath() {
            return this.inputBootstrapPath;
        }

        public void setInputBootstrapPath(String string) {
            this.inputBootstrapPath = string;
        }

        public String getOutputBootstrapPath() {
            return this.outputBootstrapPath;
        }

        public void setOutputBootstrapPath(String string) {
            this.outputBootstrapPath = string;
        }

        public boolean getHandlingNiFiRegistryProperties() {
            return this.handlingNiFiRegistryProperties;
        }

        public boolean isHandlingNiFiRegistryProperties() {
            return this.handlingNiFiRegistryProperties;
        }

        public void setHandlingNiFiRegistryProperties(boolean bl) {
            this.handlingNiFiRegistryProperties = bl;
        }

        public String getInputNiFiRegistryPropertiesPath() {
            return this.inputNiFiRegistryPropertiesPath;
        }

        public void setInputNiFiRegistryPropertiesPath(String string) {
            this.inputNiFiRegistryPropertiesPath = string;
        }

        public String getOutputNiFiRegistryPropertiesPath() {
            return this.outputNiFiRegistryPropertiesPath;
        }

        public void setOutputNiFiRegistryPropertiesPath(String string) {
            this.outputNiFiRegistryPropertiesPath = string;
        }

        public NiFiRegistryPropertiesEncryptor getPropertiesEncryptor() {
            return this.propertiesEncryptor;
        }

        public void setPropertiesEncryptor(NiFiRegistryPropertiesEncryptor niFiRegistryPropertiesEncryptor) {
            this.propertiesEncryptor = niFiRegistryPropertiesEncryptor;
        }

        public boolean getHandlingIdentityProviders() {
            return this.handlingIdentityProviders;
        }

        public boolean isHandlingIdentityProviders() {
            return this.handlingIdentityProviders;
        }

        public void setHandlingIdentityProviders(boolean bl) {
            this.handlingIdentityProviders = bl;
        }

        public String getInputIdentityProvidersPath() {
            return this.inputIdentityProvidersPath;
        }

        public void setInputIdentityProvidersPath(String string) {
            this.inputIdentityProvidersPath = string;
        }

        public String getOutputIdentityProvidersPath() {
            return this.outputIdentityProvidersPath;
        }

        public void setOutputIdentityProvidersPath(String string) {
            this.outputIdentityProvidersPath = string;
        }

        public NiFiRegistryIdentityProvidersXmlEncryptor getIdentityProvidersXmlEncryptor() {
            return this.identityProvidersXmlEncryptor;
        }

        public void setIdentityProvidersXmlEncryptor(NiFiRegistryIdentityProvidersXmlEncryptor niFiRegistryIdentityProvidersXmlEncryptor) {
            this.identityProvidersXmlEncryptor = niFiRegistryIdentityProvidersXmlEncryptor;
        }

        public boolean getHandlingAuthorizers() {
            return this.handlingAuthorizers;
        }

        public boolean isHandlingAuthorizers() {
            return this.handlingAuthorizers;
        }

        public void setHandlingAuthorizers(boolean bl) {
            this.handlingAuthorizers = bl;
        }

        public String getInputAuthorizersPath() {
            return this.inputAuthorizersPath;
        }

        public void setInputAuthorizersPath(String string) {
            this.inputAuthorizersPath = string;
        }

        public String getOutputAuthorizersPath() {
            return this.outputAuthorizersPath;
        }

        public void setOutputAuthorizersPath(String string) {
            this.outputAuthorizersPath = string;
        }

        public NiFiRegistryAuthorizersXmlEncryptor getAuthorizersXmlEncryptor() {
            return this.authorizersXmlEncryptor;
        }

        public void setAuthorizersXmlEncryptor(NiFiRegistryAuthorizersXmlEncryptor niFiRegistryAuthorizersXmlEncryptor) {
            this.authorizersXmlEncryptor = niFiRegistryAuthorizersXmlEncryptor;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "validateOptions";
            stringArray[1] = "b";
            stringArray[2] = "determineEncryptionKey";
            stringArray[3] = "<$constructor$>";
            stringArray[4] = "<$constructor$>";
            stringArray[5] = "determineDecryptionKey";
            stringArray[6] = "debug";
            stringArray[7] = "logger";
            stringArray[8] = "<$constructor$>";
            stringArray[9] = "B";
            stringArray[10] = "B";
            stringArray[11] = "B";
            stringArray[12] = "r";
            stringArray[13] = "r";
            stringArray[14] = "R";
            stringArray[15] = "<$constructor$>";
            stringArray[16] = "i";
            stringArray[17] = "i";
            stringArray[18] = "I";
            stringArray[19] = "<$constructor$>";
            stringArray[20] = "a";
            stringArray[21] = "a";
            stringArray[22] = "A";
            stringArray[23] = "<$constructor$>";
            stringArray[24] = "b";
            stringArray[25] = "B";
            stringArray[26] = "plus";
            stringArray[27] = "p";
            stringArray[28] = "k";
            stringArray[29] = "<$constructor$>";
            stringArray[30] = "plus";
            stringArray[31] = "p";
            stringArray[32] = "k";
            stringArray[33] = "p";
            stringArray[34] = "debug";
            stringArray[35] = "logger";
            stringArray[36] = "getOptionValue";
            stringArray[37] = "getInner";
            stringArray[38] = "getOptionValue";
            stringArray[39] = "getInner";
            stringArray[40] = "determineKey";
            stringArray[41] = "defaultTextDevice";
            stringArray[42] = "b";
            stringArray[43] = "debug";
            stringArray[44] = "logger";
            stringArray[45] = "extractKeyFromBootstrapFile";
            stringArray[46] = "REGISTRY_BOOTSTRAP_KEY_PROPERTY";
            stringArray[47] = "warn";
            stringArray[48] = "logger";
            stringArray[49] = "oldPassword";
            stringArray[50] = "debug";
            stringArray[51] = "logger";
            stringArray[52] = "determineKey";
            stringArray[53] = "defaultTextDevice";
            stringArray[54] = "oldPassword";
            stringArray[55] = "oldKey";
            stringArray[56] = "oldKey";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[57];
            NiFiRegistryConfiguration.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(NiFiRegistryConfiguration.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NiFiRegistryConfiguration.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

