/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.encryptconfig.util;

import groovy.io.GroovyPrintWriter;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.toolkit.encryptconfig.util.ToolUtilities;
import org.apache.nifi.util.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesEncryptor
implements GroovyObject {
    private static final Logger logger;
    private static final String SUPPORTED_PROPERTY_FILE_REGEX = "^\\s*nifi\\.[-.\\w\\s]+\\s*=";
    protected static final String PROPERTY_PART_DELIMINATOR;
    protected static final String PROTECTION_ID_PROPERTY_SUFFIX = "protected";
    protected SensitivePropertyProvider encryptionProvider;
    protected SensitivePropertyProvider decryptionProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public PropertiesEncryptor(SensitivePropertyProvider sensitivePropertyProvider, SensitivePropertyProvider sensitivePropertyProvider2) {
        void decryptionProvider;
        void encryptionProvider;
        MetaClass metaClass;
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var5_5 = encryptionProvider;
        this.encryptionProvider = (SensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)var5_5, SensitivePropertyProvider.class);
        void var6_6 = decryptionProvider;
        this.decryptionProvider = (SensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)var6_6, SensitivePropertyProvider.class);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean supportsFile(String filePath) {
        File file;
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        try {
            file = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(File.class, (Object)filePath), File.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(ToolUtilities.class, (Object)file))) {
                return false;
            }
            boolean bl = false;
            if (bl) {
                return false;
            }
        }
        catch (Throwable ignored) {
            boolean bl = false;
            return bl;
        }
        {
            Pattern p = (Pattern)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(Pattern.class, (Object)SUPPORTED_PROPERTY_FILE_REGEX), Pattern.class);
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].call((Object)file), (Object)new GeneratedClosure(PropertiesEncryptor.class, PropertiesEncryptor.class){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _supportsFile_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _supportsFile_closure1.$getCallSiteArray();
                    return ScriptBytecodeAdapter.findRegex((Object)it, (Object)callSiteArray[0].callGetProperty(PropertiesEncryptor.class));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _supportsFile_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _supportsFile_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "SUPPORTED_PROPERTY_FILE_REGEX";
                    return new CallSiteArray(_supportsFile_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _supportsFile_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }));
        }
    }

    public static Properties loadFile(String filePath) throws IOException {
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        Reference rawProperties = new Reference(null);
        Properties cfr_ignored_0 = (Properties)rawProperties.get();
        File inputPropertiesFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callConstructor(File.class, (Object)filePath), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(ToolUtilities.class, (Object)inputPropertiesFile))) {
            throw (Throwable)callSiteArray[9].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{filePath}, new String[]{"The file at ", " must exist and be readable by the user running this tool"}));
        }
        Object object = callSiteArray[7].callConstructor(Properties.class);
        rawProperties.set((Object)((Properties)ScriptBytecodeAdapter.castToType((Object)object, Properties.class)));
        callSiteArray[8].call((Object)inputPropertiesFile, (Object)new GeneratedClosure(PropertiesEncryptor.class, PropertiesEncryptor.class, rawProperties){
            private /* synthetic */ Reference rawProperties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _loadFile_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.rawProperties = reference = rawProperties;
            }

            public Object doCall(Object reader) {
                CallSite[] callSiteArray = _loadFile_closure2.$getCallSiteArray();
                return callSiteArray[0].call(this.rawProperties.get(), reader);
            }

            public Properties getRawProperties() {
                CallSite[] callSiteArray = _loadFile_closure2.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.rawProperties.get(), Properties.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadFile_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "load";
                return new CallSiteArray(_loadFile_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _loadFile_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        return (Properties)rawProperties.get();
    }

    public Properties decrypt(Properties properties) {
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        Set propertiesToSkip = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].callStatic(PropertiesEncryptor.class, (Object)properties), Set.class);
        Map propertiesToDecrypt = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callStatic(PropertiesEncryptor.class, (Object)properties), Map.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call((Object)propertiesToDecrypt))) {
            return properties;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.decryptionProvider, null)) {
            throw (Throwable)callSiteArray[13].callConstructor(IllegalStateException.class, callSiteArray[14].call((Object)"Decryption capability not supported without provider. ", (Object)"Usually this means a decryption password / key was not provided to the tool."));
        }
        Reference supportedDecryptionScheme = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[15].call((Object)this.decryptionProvider)));
        if (DefaultTypeTransformation.booleanUnbox((Object)((String)supportedDecryptionScheme.get()))) {
            callSiteArray[16].call(callSiteArray[17].call((Object)propertiesToDecrypt), (Object)new GeneratedClosure(this, this, supportedDecryptionScheme){
                private /* synthetic */ Reference supportedDecryptionScheme;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    CallSite[] callSiteArray = _decrypt_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.supportedDecryptionScheme = reference = supportedDecryptionScheme;
                }

                public Object doCall(Object entry) {
                    CallSite[] callSiteArray = _decrypt_closure3.$getCallSiteArray();
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.supportedDecryptionScheme.get(), callSiteArray[1].call(entry)))) {
                        throw (Throwable)callSiteArray[2].callConstructor(IllegalStateException.class, callSiteArray[3].call(callSiteArray[4].call((Object)"Decryption capability not supported by this tool. ", (Object)new GStringImpl(new Object[]{this.supportedDecryptionScheme.get()}, new String[]{"This tool supports ", ", but this properties file contains "})), (Object)new GStringImpl(new Object[]{callSiteArray[5].call(entry), callSiteArray[6].call(entry)}, new String[]{"", " protected by ", ""})));
                    }
                    return null;
                }

                public String getSupportedDecryptionScheme() {
                    CallSite[] callSiteArray = _decrypt_closure3.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.supportedDecryptionScheme.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _decrypt_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "equals";
                    stringArray[1] = "getValue";
                    stringArray[2] = "<$constructor$>";
                    stringArray[3] = "plus";
                    stringArray[4] = "plus";
                    stringArray[5] = "getKey";
                    stringArray[6] = "getValue";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[7];
                    _decrypt_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_decrypt_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _decrypt_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
        }
        Properties unprotectedProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].callConstructor(Properties.class), Properties.class);
        String propertyName = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].call(callSiteArray[20].call((Object)properties)), Iterator.class);
        while (iterator.hasNext()) {
            propertyName = ShortTypeHandling.castToString(iterator.next());
            String propertyValue = ShortTypeHandling.castToString((Object)callSiteArray[21].call((Object)properties, (Object)propertyName));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].call((Object)propertiesToSkip, (Object)propertyName))) continue;
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call(callSiteArray[24].call((Object)propertiesToDecrypt), (Object)propertyName))) {
                String decryptedPropertyValue = ShortTypeHandling.castToString((Object)callSiteArray[25].call((Object)this.decryptionProvider, (Object)propertyValue));
                callSiteArray[26].call((Object)unprotectedProperties, (Object)propertyName, (Object)decryptedPropertyValue);
                continue;
            }
            callSiteArray[27].call((Object)unprotectedProperties, (Object)propertyName, (Object)propertyValue);
        }
        return unprotectedProperties;
    }

    public Properties encrypt(Properties properties) {
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        return (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].callCurrent((GroovyObject)this, (Object)properties, callSiteArray[29].call((Object)properties)), Properties.class);
    }

    public Properties encrypt(Properties properties, Set<String> propertiesToEncrypt) {
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)this.encryptionProvider, null)) {
            throw (Throwable)callSiteArray[30].callConstructor(IllegalStateException.class, callSiteArray[31].call((Object)"Input properties is encrypted, but decryption capability is not enabled. ", (Object)"Usually this means a decryption password / key was not provided to the tool."));
        }
        callSiteArray[32].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[33].call(propertiesToEncrypt)}, new String[]{"Encrypting ", " properties"}));
        Properties protectedProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(Properties.class), Properties.class);
        String propertyName = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call(callSiteArray[36].call((Object)properties)), Iterator.class);
        while (iterator.hasNext()) {
            propertyName = ShortTypeHandling.castToString(iterator.next());
            String propertyValue = ShortTypeHandling.castToString((Object)callSiteArray[37].call((Object)properties, (Object)propertyName));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[38].call(StringUtils.class, (Object)propertyValue)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].call(propertiesToEncrypt, (Object)propertyName))) {
                String encryptedPropertyValue = ShortTypeHandling.castToString((Object)callSiteArray[40].call((Object)this.encryptionProvider, (Object)propertyValue));
                callSiteArray[41].call((Object)protectedProperties, (Object)propertyName, (Object)encryptedPropertyValue);
                callSiteArray[42].call((Object)protectedProperties, callSiteArray[43].callStatic(PropertiesEncryptor.class, (Object)propertyName), callSiteArray[44].call((Object)this.encryptionProvider));
                continue;
            }
            callSiteArray[45].call((Object)protectedProperties, (Object)propertyName, (Object)propertyValue);
        }
        return protectedProperties;
    }

    public void write(Properties updatedProperties, String outputFilePath, String inputFilePath) {
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)outputFilePath)) {
            throw (Throwable)callSiteArray[46].callConstructor(IllegalArgumentException.class, (Object)"Cannot write encrypted properties to empty file path");
        }
        File outputPropertiesFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callConstructor(File.class, (Object)outputFilePath), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call(ToolUtilities.class, (Object)outputPropertiesFile))) {
            throw (Throwable)callSiteArray[50].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{outputFilePath}, new String[]{"The file at ", " must be writable by the user running this tool"}));
        }
        String serializedProperties = ShortTypeHandling.castToString((Object)callSiteArray[49].callCurrent((GroovyObject)this, (Object)updatedProperties, (Object)inputFilePath));
        String string = serializedProperties;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)outputPropertiesFile, (String)"text");
    }

    private String serializePropertiesAndPreserveFormatIfPossible(Properties updatedProperties, String inputFilePath) {
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        List linesToPersist = null;
        File inputPropertiesFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callConstructor(File.class, (Object)inputFilePath), File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[52].call(ToolUtilities.class, (Object)inputPropertiesFile))) {
            Object object = callSiteArray[53].callCurrent((GroovyObject)this, (Object)updatedProperties, (Object)inputPropertiesFile);
            linesToPersist = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        } else {
            Object object = callSiteArray[54].callCurrent((GroovyObject)this, (Object)updatedProperties);
            linesToPersist = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[55].call((Object)linesToPersist, (Object)"\n"));
    }

    private List<String> serializePropertiesAndPreserveFormat(Properties properties, File originalPropertiesFile) {
        Reference properties2 = new Reference((Object)properties);
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        Configurations configurations = (Configurations)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].callConstructor(Configurations.class), Configurations.class);
        Reference originalPropertiesConfiguration = new Reference((Object)((PropertiesConfiguration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].call((Object)configurations, (Object)originalPropertiesFile), PropertiesConfiguration.class)));
        Reference keysToAdd = new Reference(callSiteArray[58].call(callSiteArray[59].call((Object)((Properties)properties2.get())), (Object)new GeneratedClosure(this, this, originalPropertiesConfiguration){
            private /* synthetic */ Reference originalPropertiesConfiguration;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.originalPropertiesConfiguration = reference = originalPropertiesConfiguration;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure4.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.originalPropertiesConfiguration.get(), callSiteArray[1].call(it)));
            }

            public PropertiesConfiguration getOriginalPropertiesConfiguration() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure4.$getCallSiteArray();
                return (PropertiesConfiguration)ScriptBytecodeAdapter.castToType((Object)this.originalPropertiesConfiguration.get(), PropertiesConfiguration.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializePropertiesAndPreserveFormat_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "containsKey";
                stringArray[1] = "toString";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _serializePropertiesAndPreserveFormat_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_serializePropertiesAndPreserveFormat_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializePropertiesAndPreserveFormat_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }));
        Object keysToUpdate = callSiteArray[60].call(callSiteArray[61].call((Object)((Properties)properties2.get())), (Object)new GeneratedClosure(this, this, keysToAdd, originalPropertiesConfiguration, properties2){
            private /* synthetic */ Reference keysToAdd;
            private /* synthetic */ Reference originalPropertiesConfiguration;
            private /* synthetic */ Reference properties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.keysToAdd = reference3 = keysToAdd;
                this.originalPropertiesConfiguration = reference2 = originalPropertiesConfiguration;
                this.properties = reference = properties;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure5.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.keysToAdd.get(), it)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[1].call(this.properties.get(), callSiteArray[2].call(it)), (Object)callSiteArray[3].call(this.originalPropertiesConfiguration.get(), callSiteArray[4].call(it)));
                }
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call(this.keysToAdd.get(), it)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[6].call(this.properties.get(), callSiteArray[7].call(it)), (Object)callSiteArray[8].call(this.originalPropertiesConfiguration.get(), callSiteArray[9].call(it)));
            }

            public Object getKeysToAdd() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure5.$getCallSiteArray();
                return this.keysToAdd.get();
            }

            public PropertiesConfiguration getOriginalPropertiesConfiguration() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure5.$getCallSiteArray();
                return (PropertiesConfiguration)ScriptBytecodeAdapter.castToType((Object)this.originalPropertiesConfiguration.get(), PropertiesConfiguration.class);
            }

            public Properties getProperties() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure5.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.properties.get(), Properties.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializePropertiesAndPreserveFormat_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "getProperty";
                stringArray[2] = "toString";
                stringArray[3] = "getProperty";
                stringArray[4] = "toString";
                stringArray[5] = "contains";
                stringArray[6] = "getProperty";
                stringArray[7] = "toString";
                stringArray[8] = "getProperty";
                stringArray[9] = "toString";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                _serializePropertiesAndPreserveFormat_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_serializePropertiesAndPreserveFormat_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializePropertiesAndPreserveFormat_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        Object keysToRemove = callSiteArray[62].call(callSiteArray[63].call((Object)((PropertiesConfiguration)originalPropertiesConfiguration.get())), (Object)new GeneratedClosure(this, this, properties2){
            private /* synthetic */ Reference properties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.properties = reference = properties;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure6.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.properties.get(), it));
            }

            public Properties getProperties() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure6.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.properties.get(), Properties.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializePropertiesAndPreserveFormat_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "containsKey";
                return new CallSiteArray(_serializePropertiesAndPreserveFormat_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializePropertiesAndPreserveFormat_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        callSiteArray[64].call(keysToUpdate, (Object)new GeneratedClosure(this, this, originalPropertiesConfiguration, properties2){
            private /* synthetic */ Reference originalPropertiesConfiguration;
            private /* synthetic */ Reference properties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.originalPropertiesConfiguration = reference2 = originalPropertiesConfiguration;
                this.properties = reference = properties;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure7.$getCallSiteArray();
                return callSiteArray[0].call(this.originalPropertiesConfiguration.get(), callSiteArray[1].call(it), callSiteArray[2].call(this.properties.get(), callSiteArray[3].call(it)));
            }

            public PropertiesConfiguration getOriginalPropertiesConfiguration() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure7.$getCallSiteArray();
                return (PropertiesConfiguration)ScriptBytecodeAdapter.castToType((Object)this.originalPropertiesConfiguration.get(), PropertiesConfiguration.class);
            }

            public Properties getProperties() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure7.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.properties.get(), Properties.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializePropertiesAndPreserveFormat_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "setProperty";
                stringArray[1] = "toString";
                stringArray[2] = "getProperty";
                stringArray[3] = "toString";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _serializePropertiesAndPreserveFormat_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_serializePropertiesAndPreserveFormat_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializePropertiesAndPreserveFormat_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        callSiteArray[65].call(keysToRemove, (Object)new GeneratedClosure(this, this, originalPropertiesConfiguration){
            private /* synthetic */ Reference originalPropertiesConfiguration;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.originalPropertiesConfiguration = reference = originalPropertiesConfiguration;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure8.$getCallSiteArray();
                return callSiteArray[0].call(this.originalPropertiesConfiguration.get(), callSiteArray[1].call(it));
            }

            public PropertiesConfiguration getOriginalPropertiesConfiguration() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure8.$getCallSiteArray();
                return (PropertiesConfiguration)ScriptBytecodeAdapter.castToType((Object)this.originalPropertiesConfiguration.get(), PropertiesConfiguration.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializePropertiesAndPreserveFormat_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "clearProperty";
                stringArray[1] = "toString";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _serializePropertiesAndPreserveFormat_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_serializePropertiesAndPreserveFormat_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializePropertiesAndPreserveFormat_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        Reference isFirst = new Reference((Object)true);
        callSiteArray[66].call(callSiteArray[67].call(keysToAdd.get()), (Object)new GeneratedClosure(this, this, isFirst, originalPropertiesConfiguration, properties2){
            private /* synthetic */ Reference isFirst;
            private /* synthetic */ Reference originalPropertiesConfiguration;
            private /* synthetic */ Reference properties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.isFirst = reference3 = isFirst;
                this.originalPropertiesConfiguration = reference2 = originalPropertiesConfiguration;
                this.properties = reference = properties;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure9.$getCallSiteArray();
                callSiteArray[0].call(this.originalPropertiesConfiguration.get(), callSiteArray[1].call(it), callSiteArray[2].call(this.properties.get(), callSiteArray[3].call(it)));
                if (DefaultTypeTransformation.booleanUnbox((Object)this.isFirst.get())) {
                    callSiteArray[4].call(callSiteArray[5].call(this.originalPropertiesConfiguration.get()), callSiteArray[6].call(it), (Object)1);
                    callSiteArray[7].call(callSiteArray[8].call(this.originalPropertiesConfiguration.get()), callSiteArray[9].call(it), (Object)"protection properties");
                    boolean bl = false;
                    this.isFirst.set((Object)bl);
                    return bl;
                }
                return null;
            }

            public Boolean getIsFirst() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure9.$getCallSiteArray();
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.isFirst.get(), Boolean.class);
            }

            public PropertiesConfiguration getOriginalPropertiesConfiguration() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure9.$getCallSiteArray();
                return (PropertiesConfiguration)ScriptBytecodeAdapter.castToType((Object)this.originalPropertiesConfiguration.get(), PropertiesConfiguration.class);
            }

            public Properties getProperties() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure9.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.properties.get(), Properties.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _serializePropertiesAndPreserveFormat_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializePropertiesAndPreserveFormat_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "setProperty";
                stringArray[1] = "toString";
                stringArray[2] = "getProperty";
                stringArray[3] = "toString";
                stringArray[4] = "setBlancLinesBefore";
                stringArray[5] = "getLayout";
                stringArray[6] = "toString";
                stringArray[7] = "setComment";
                stringArray[8] = "getLayout";
                stringArray[9] = "toString";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                _serializePropertiesAndPreserveFormat_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_serializePropertiesAndPreserveFormat_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializePropertiesAndPreserveFormat_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        OutputStream out = (OutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].callConstructor(ByteArrayOutputStream.class), OutputStream.class);
        Writer writer = (Writer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callConstructor(GroovyPrintWriter.class, (Object)out), Writer.class);
        PropertiesConfigurationLayout layout = (PropertiesConfigurationLayout)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call((Object)((PropertiesConfiguration)originalPropertiesConfiguration.get())), PropertiesConfigurationLayout.class);
        callSiteArray[71].call((Object)layout, (Object)"=");
        callSiteArray[72].call((Object)layout, (Object)((PropertiesConfiguration)originalPropertiesConfiguration.get()), (Object)writer);
        callSiteArray[73].call((Object)writer);
        List lines = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].call(callSiteArray[75].call((Object)out), (Object)"\n"), List.class);
        List list = lines;
        try {
            return list;
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[76].callConstructor(RuntimeException.class, (Object)"Error serializing properties.", (Object)e);
        }
    }

    private List<String> serializeProperties(Properties properties) {
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        OutputStream out = (OutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].callConstructor(ByteArrayOutputStream.class), OutputStream.class);
        Writer writer = (Writer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callConstructor(GroovyPrintWriter.class, (Object)out), Writer.class);
        callSiteArray[79].call((Object)properties, (Object)writer, null);
        callSiteArray[80].call((Object)writer);
        List lines = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].call(callSiteArray[82].call((Object)out), (Object)"\n"), List.class);
        return lines;
    }

    private static Map<String, String> getProtectedPropertyKeys(Properties properties) {
        Reference properties2 = new Reference((Object)properties);
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        Reference protectedProperties = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[83].callConstructor(HashMap.class), Map.class)));
        callSiteArray[84].call(callSiteArray[85].call((Object)((Properties)properties2.get())), (Object)new GeneratedClosure(PropertiesEncryptor.class, PropertiesEncryptor.class, protectedProperties, properties2){
            private /* synthetic */ Reference protectedProperties;
            private /* synthetic */ Reference properties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getProtectedPropertyKeys_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.protectedProperties = reference2 = protectedProperties;
                this.properties = reference = properties;
            }

            public Object doCall(Object key) {
                CallSite[] callSiteArray = _getProtectedPropertyKeys_closure10.$getCallSiteArray();
                String protectionKey = ShortTypeHandling.castToString((Object)callSiteArray[0].callCurrent((GroovyObject)this, key));
                String protectionIdentifier = ShortTypeHandling.castToString((Object)callSiteArray[1].call(this.properties.get(), (Object)protectionKey));
                if (DefaultTypeTransformation.booleanUnbox((Object)protectionIdentifier)) {
                    return callSiteArray[2].call(this.protectedProperties.get(), key, (Object)protectionIdentifier);
                }
                return null;
            }

            public Map getProtectedProperties() {
                CallSite[] callSiteArray = _getProtectedPropertyKeys_closure10.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.protectedProperties.get(), Map.class);
            }

            public Properties getProperties() {
                CallSite[] callSiteArray = _getProtectedPropertyKeys_closure10.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.properties.get(), Properties.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getProtectedPropertyKeys_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "protectionPropertyForProperty";
                stringArray[1] = "getProperty";
                stringArray[2] = "put";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getProtectedPropertyKeys_closure10.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getProtectedPropertyKeys_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getProtectedPropertyKeys_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        return (Map)protectedProperties.get();
    }

    private static Set<String> getProtectionIdPropertyKeys(Properties properties) {
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        Set protectedProperties = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].call(callSiteArray[87].call((Object)properties), (Object)new GeneratedClosure(PropertiesEncryptor.class, PropertiesEncryptor.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _getProtectionIdPropertyKeys_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object key) {
                CallSite[] callSiteArray = _getProtectionIdPropertyKeys_closure11.$getCallSiteArray();
                return callSiteArray[0].call(key, callSiteArray[1].call(callSiteArray[2].callGetProperty(PropertiesEncryptor.class), callSiteArray[3].callGetProperty(PropertiesEncryptor.class)));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getProtectionIdPropertyKeys_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "endsWith";
                stringArray[1] = "plus";
                stringArray[2] = "PROPERTY_PART_DELIMINATOR";
                stringArray[3] = "PROTECTION_ID_PROPERTY_SUFFIX";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _getProtectionIdPropertyKeys_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getProtectionIdPropertyKeys_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getProtectionIdPropertyKeys_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), Set.class);
        return protectedProperties;
    }

    private static String protectionPropertyForProperty(String propertyName) {
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[88].call(callSiteArray[89].call((Object)propertyName, (Object)PROPERTY_PART_DELIMINATOR), (Object)PROTECTION_ID_PROPERTY_SUFFIX));
    }

    private static String propertyForProtectionProperty(String protectionPropertyName) {
        CallSite[] callSiteArray = PropertiesEncryptor.$getCallSiteArray();
        Object[] propertyNameParts = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[90].call((Object)protectionPropertyName, callSiteArray[91].call(Pattern.class, (Object)PROPERTY_PART_DELIMINATOR)), String[].class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[92].callGetProperty((Object)propertyNameParts), (Object)2) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[93].call((Object)PROTECTION_ID_PROPERTY_SUFFIX, callSiteArray[94].call((Object)propertyNameParts, (Object)-1)))) {
                return ShortTypeHandling.castToString((Object)callSiteArray[95].call(callSiteArray[96].call((Object)propertyNameParts, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)-2, (boolean)true)), (Object)PROPERTY_PART_DELIMINATOR));
            }
        } else if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[97].callGetProperty((Object)propertyNameParts), (Object)2) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[98].call((Object)PROTECTION_ID_PROPERTY_SUFFIX, BytecodeInterface8.objectArrayGet((Object[])propertyNameParts, (int)-1)))) {
            return ShortTypeHandling.castToString((Object)callSiteArray[99].call(callSiteArray[100].call((Object)propertyNameParts, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)-2, (boolean)true)), (Object)PROPERTY_PART_DELIMINATOR));
        }
        return ShortTypeHandling.castToString(null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PropertiesEncryptor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        PROPERTY_PART_DELIMINATOR = string = ".";
        Object object = PropertiesEncryptor.$getCallSiteArray()[101].call(LoggerFactory.class, PropertiesEncryptor.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "canRead";
        stringArray[2] = "compile";
        stringArray[3] = "any";
        stringArray[4] = "readLines";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "canRead";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "withReader";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "getProtectionIdPropertyKeys";
        stringArray[11] = "getProtectedPropertyKeys";
        stringArray[12] = "isEmpty";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "plus";
        stringArray[15] = "getIdentifierKey";
        stringArray[16] = "each";
        stringArray[17] = "entrySet";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "iterator";
        stringArray[20] = "stringPropertyNames";
        stringArray[21] = "getProperty";
        stringArray[22] = "contains";
        stringArray[23] = "contains";
        stringArray[24] = "keySet";
        stringArray[25] = "unprotect";
        stringArray[26] = "setProperty";
        stringArray[27] = "setProperty";
        stringArray[28] = "encrypt";
        stringArray[29] = "stringPropertyNames";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "plus";
        stringArray[32] = "debug";
        stringArray[33] = "size";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "iterator";
        stringArray[36] = "stringPropertyNames";
        stringArray[37] = "getProperty";
        stringArray[38] = "isEmpty";
        stringArray[39] = "contains";
        stringArray[40] = "protect";
        stringArray[41] = "setProperty";
        stringArray[42] = "setProperty";
        stringArray[43] = "protectionPropertyForProperty";
        stringArray[44] = "getIdentifierKey";
        stringArray[45] = "setProperty";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "isSafeToWrite";
        stringArray[49] = "serializePropertiesAndPreserveFormatIfPossible";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "canRead";
        stringArray[53] = "serializePropertiesAndPreserveFormat";
        stringArray[54] = "serializeProperties";
        stringArray[55] = "join";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "properties";
        stringArray[58] = "findAll";
        stringArray[59] = "keySet";
        stringArray[60] = "findAll";
        stringArray[61] = "keySet";
        stringArray[62] = "findAll";
        stringArray[63] = "getKeys";
        stringArray[64] = "forEach";
        stringArray[65] = "forEach";
        stringArray[66] = "forEach";
        stringArray[67] = "sort";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "getLayout";
        stringArray[71] = "setGlobalSeparator";
        stringArray[72] = "save";
        stringArray[73] = "flush";
        stringArray[74] = "split";
        stringArray[75] = "toString";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "store";
        stringArray[80] = "flush";
        stringArray[81] = "split";
        stringArray[82] = "toString";
        stringArray[83] = "<$constructor$>";
        stringArray[84] = "forEach";
        stringArray[85] = "stringPropertyNames";
        stringArray[86] = "findAll";
        stringArray[87] = "stringPropertyNames";
        stringArray[88] = "plus";
        stringArray[89] = "plus";
        stringArray[90] = "split";
        stringArray[91] = "quote";
        stringArray[92] = "length";
        stringArray[93] = "equals";
        stringArray[94] = "getAt";
        stringArray[95] = "join";
        stringArray[96] = "getAt";
        stringArray[97] = "length";
        stringArray[98] = "equals";
        stringArray[99] = "join";
        stringArray[100] = "getAt";
        stringArray[101] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[102];
        PropertiesEncryptor.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(PropertiesEncryptor.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PropertiesEncryptor.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

