/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.encryptconfig.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.security.KeyException;
import java.util.Collection;
import java.util.List;
import javax.crypto.Cipher;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.util.console.TextDevice;
import org.apache.nifi.util.console.TextDevices;
import org.bouncycastle.crypto.generators.SCrypt;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolUtilities
implements GroovyObject {
    private static final Logger logger;
    private static final int DEFAULT_MIN_PASSWORD_LENGTH = 12;
    private static final int SCRYPT_N;
    private static final int SCRYPT_R = 8;
    private static final int SCRYPT_P = 1;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ToolUtilities() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static boolean isExactlyOneOptionSet(CommandLine commandLine, String ... opt) {
        Reference commandLine2 = new Reference((Object)commandLine);
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        Collection setOptions = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call((Object)opt, (Object)new GeneratedClosure(ToolUtilities.class, ToolUtilities.class, commandLine2){
            private /* synthetic */ Reference commandLine;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _isExactlyOneOptionSet_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.commandLine = reference = commandLine;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _isExactlyOneOptionSet_closure1.$getCallSiteArray();
                return callSiteArray[0].call(this.commandLine.get(), it);
            }

            public CommandLine getCommandLine() {
                CallSite[] callSiteArray = _isExactlyOneOptionSet_closure1.$getCallSiteArray();
                return (CommandLine)ScriptBytecodeAdapter.castToType((Object)this.commandLine.get(), CommandLine.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _isExactlyOneOptionSet_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isExactlyOneOptionSet_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "hasOption";
                return new CallSiteArray(_isExactlyOneOptionSet_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _isExactlyOneOptionSet_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), Collection.class);
        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].call((Object)setOptions), (Object)1);
    }

    public static boolean isExactlyOneTrue(Boolean ... b) {
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        Collection trues = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call((Object)b, (Object)new GeneratedClosure(ToolUtilities.class, ToolUtilities.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _isExactlyOneTrue_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _isExactlyOneTrue_closure2.$getCallSiteArray();
                return it;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _isExactlyOneTrue_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isExactlyOneTrue_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_isExactlyOneTrue_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _isExactlyOneTrue_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), Collection.class);
        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].call((Object)trues), (Object)1);
    }

    public static boolean canRead(File fileToRead) {
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)fileToRead) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call((Object)fileToRead)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)fileToRead));
    }

    public static boolean isSafeToWrite(File fileToWrite) {
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)fileToWrite) && (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call(callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty((Object)fileToWrite)))) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call((Object)fileToWrite)));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)fileToWrite) && (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call(callSiteArray[14].callGetProperty(callSiteArray[15].callGetProperty((Object)fileToWrite)))) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call((Object)fileToWrite)));
    }

    public static String determineKey(TextDevice device, String keyHex, String password, boolean usingPassword) {
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        if (usingPassword) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)password)) {
                callSiteArray[18].call((Object)logger, (Object)"Reading password from secure console");
                Object object = callSiteArray[19].callStatic(ToolUtilities.class, (Object)device);
                password = ShortTypeHandling.castToString((Object)object);
            }
            Object object = callSiteArray[20].callStatic(ToolUtilities.class, (Object)password);
            keyHex = ShortTypeHandling.castToString((Object)object);
            Object var7_7 = null;
            password = ShortTypeHandling.castToString(var7_7);
            return keyHex;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)keyHex)) {
            callSiteArray[21].call((Object)logger, (Object)"Reading hex key from secure console");
            Object object = callSiteArray[22].callStatic(ToolUtilities.class, (Object)device);
            keyHex = ShortTypeHandling.castToString((Object)object);
        }
        return keyHex;
    }

    private static String readKeyFromConsole(TextDevice textDevice) {
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        callSiteArray[23].call((Object)textDevice, (Object)"Enter the master key in hexadecimal format (spaces acceptable): ");
        return ShortTypeHandling.castToString((Object)callSiteArray[24].callConstructor(String.class, callSiteArray[25].call((Object)textDevice)));
    }

    private static String readPasswordFromConsole(TextDevice textDevice) {
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        callSiteArray[26].call((Object)textDevice, (Object)"Enter the password: ");
        return ShortTypeHandling.castToString((Object)callSiteArray[27].callConstructor(String.class, callSiteArray[28].call((Object)textDevice)));
    }

    public static List<Integer> getValidKeyLengths() {
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[29].call(Cipher.class, (Object)"AES"), (Object)128) ? ScriptBytecodeAdapter.createList((Object[])new Object[]{128, 192, 256}) : ScriptBytecodeAdapter.createList((Object[])new Object[]{128});
    }

    private static String deriveKeyFromPassword(String password, int minPasswordLength) {
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        Object object = callSiteArray[30].callSafe((Object)password);
        password = ShortTypeHandling.castToString((Object)object);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)password) || ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[31].call((Object)password), (Object)minPasswordLength)) {
                throw (Throwable)callSiteArray[32].callConstructor(KeyException.class, (Object)new GStringImpl(new Object[]{minPasswordLength}, new String[]{"Cannot derive key from empty/short password -- password must be at least ", " characters"}));
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)password) || ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[33].call((Object)password), (Object)minPasswordLength)) {
            throw (Throwable)callSiteArray[34].callConstructor(KeyException.class, (Object)new GStringImpl(new Object[]{minPasswordLength}, new String[]{"Cannot derive key from empty/short password -- password must be at least ", " characters"}));
        }
        byte[] salt = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[35].callStatic(ToolUtilities.class);
            salt = (byte[])ScriptBytecodeAdapter.castToType((Object)object2, byte[].class);
        } else {
            byte[] byArray;
            salt = byArray = ToolUtilities.generateScryptSalt();
        }
        int keyLengthInBytes = 0;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object3 = callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].callStatic(ToolUtilities.class)), (Object)8);
            keyLengthInBytes = DefaultTypeTransformation.intUnbox((Object)object3);
        } else {
            Object object4 = callSiteArray[39].call(callSiteArray[40].call(ToolUtilities.getValidKeyLengths()), (Object)8);
            keyLengthInBytes = DefaultTypeTransformation.intUnbox((Object)object4);
        }
        byte[] derivedKeyBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call(SCrypt.class, ArrayUtil.createArray((Object)callSiteArray[42].call((Object)password, callSiteArray[43].callGetProperty(StandardCharsets.class)), (Object)salt, (Object)SCRYPT_N, (Object)SCRYPT_R, (Object)SCRYPT_P, (Object)keyLengthInBytes)), byte[].class);
        return ShortTypeHandling.castToString((Object)callSiteArray[44].call(callSiteArray[45].call(Hex.class, (Object)derivedKeyBytes)));
    }

    private static byte[] generateScryptSalt() {
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call((Object)"NIFI_SCRYPT_SALT", callSiteArray[47].callGetProperty(StandardCharsets.class)), byte[].class);
    }

    public static String determineKey(String keyHex, String password, boolean usingPassword) {
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        return ToolUtilities.determineKey((TextDevice)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].call(TextDevices.class), TextDevice.class), keyHex, password, usingPassword);
    }

    private static String deriveKeyFromPassword(String password) {
        CallSite[] callSiteArray = ToolUtilities.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ToolUtilities.deriveKeyFromPassword(password, DEFAULT_MIN_PASSWORD_LENGTH);
        }
        return ToolUtilities.deriveKeyFromPassword(password, DEFAULT_MIN_PASSWORD_LENGTH);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ToolUtilities.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = ToolUtilities.$getCallSiteArray()[49].call(LoggerFactory.class, ToolUtilities.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = ToolUtilities.$getCallSiteArray()[50].call((Object)2, (Object)16);
        SCRYPT_N = DefaultTypeTransformation.intUnbox((Object)object2);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "findAll";
        stringArray[1] = "size";
        stringArray[2] = "findAll";
        stringArray[3] = "size";
        stringArray[4] = "exists";
        stringArray[5] = "canRead";
        stringArray[6] = "exists";
        stringArray[7] = "canWrite";
        stringArray[8] = "parentFile";
        stringArray[9] = "absoluteFile";
        stringArray[10] = "exists";
        stringArray[11] = "canWrite";
        stringArray[12] = "exists";
        stringArray[13] = "canWrite";
        stringArray[14] = "parentFile";
        stringArray[15] = "absoluteFile";
        stringArray[16] = "exists";
        stringArray[17] = "canWrite";
        stringArray[18] = "debug";
        stringArray[19] = "readPasswordFromConsole";
        stringArray[20] = "deriveKeyFromPassword";
        stringArray[21] = "debug";
        stringArray[22] = "readKeyFromConsole";
        stringArray[23] = "printf";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "readPassword";
        stringArray[26] = "printf";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "readPassword";
        stringArray[29] = "getMaxAllowedKeyLength";
        stringArray[30] = "trim";
        stringArray[31] = "length";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "length";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "generateScryptSalt";
        stringArray[36] = "div";
        stringArray[37] = "max";
        stringArray[38] = "getValidKeyLengths";
        stringArray[39] = "div";
        stringArray[40] = "max";
        stringArray[41] = "generate";
        stringArray[42] = "getBytes";
        stringArray[43] = "UTF_8";
        stringArray[44] = "toUpperCase";
        stringArray[45] = "encodeHexString";
        stringArray[46] = "getBytes";
        stringArray[47] = "UTF_8";
        stringArray[48] = "defaultTextDevice";
        stringArray[49] = "getLogger";
        stringArray[50] = "power";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[51];
        ToolUtilities.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ToolUtilities.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ToolUtilities.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

