/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.commandLine;

import org.apache.commons.cli.CommandLine;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.toolkit.tls.commandLine.BaseCommandLine;
import org.apache.nifi.toolkit.tls.commandLine.CommandLineParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTlsToolkitCommandLine
extends BaseCommandLine {
    private static final Logger logger = LoggerFactory.getLogger(BaseTlsToolkitCommandLine.class);
    public static final String KEY_SIZE_ARG = "keySize";
    public static final String KEY_ALGORITHM_ARG = "keyAlgorithm";
    public static final String CERTIFICATE_AUTHORITY_HOSTNAME_ARG = "certificateAuthorityHostname";
    public static final String DAYS_ARG = "days";
    public static final String KEY_STORE_TYPE_ARG = "keyStoreType";
    public static final String SIGNING_ALGORITHM_ARG = "signingAlgorithm";
    public static final String DN_ARG = "dn";
    public static final String DIFFERENT_KEY_AND_KEYSTORE_PASSWORDS_ARG = "differentKeyAndKeystorePasswords";
    public static final String KEYSTORE = "keystore.";
    public static final String TRUSTSTORE = "truststore.";
    private int keySize;
    private String keyAlgorithm;
    private String certificateAuthorityHostname;
    private String keyStoreType;
    private int days;
    private String signingAlgorithm;
    private boolean differentPasswordForKeyAndKeystore;

    public BaseTlsToolkitCommandLine(String header) {
        super(header);
        if (this.shouldAddDaysArg()) {
            this.addOptionWithArg("d", DAYS_ARG, "Number of days issued certificate should be valid for.", 1095);
        }
        this.addOptionWithArg("T", KEY_STORE_TYPE_ARG, "The type of keyStores to generate.", this.getKeyStoreTypeDefault());
        this.addOptionWithArg("c", CERTIFICATE_AUTHORITY_HOSTNAME_ARG, "Hostname of NiFi Certificate Authority", "localhost");
        this.addOptionWithArg("a", KEY_ALGORITHM_ARG, "Algorithm to use for generated keys.", "RSA");
        this.addOptionWithArg("k", KEY_SIZE_ARG, "Number of bits for generated keys.", 2048);
        if (this.shouldAddSigningAlgorithmArg()) {
            this.addOptionWithArg("s", SIGNING_ALGORITHM_ARG, "Algorithm to use for signing certificates.", "SHA256WITHRSA");
        }
        this.addOptionNoArg("g", DIFFERENT_KEY_AND_KEYSTORE_PASSWORDS_ARG, "Use different generated password for the key and the keyStore.");
    }

    protected String getKeyStoreTypeDefault() {
        return "jks";
    }

    protected boolean shouldAddSigningAlgorithmArg() {
        return true;
    }

    protected boolean shouldAddDaysArg() {
        return true;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public String getCertificateAuthorityHostname() {
        return this.certificateAuthorityHostname;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public int getDays() {
        return this.days;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public boolean differentPasswordForKeyAndKeystore() {
        return this.differentPasswordForKeyAndKeystore;
    }

    @Override
    protected void postParse(CommandLine commandLine) throws CommandLineParseException {
        this.certificateAuthorityHostname = commandLine.getOptionValue(CERTIFICATE_AUTHORITY_HOSTNAME_ARG, "localhost");
        this.days = this.getIntValue(commandLine, DAYS_ARG, 1095);
        this.keySize = this.getIntValue(commandLine, KEY_SIZE_ARG, 2048);
        this.keyAlgorithm = commandLine.getOptionValue(KEY_ALGORITHM_ARG, "RSA");
        this.keyStoreType = commandLine.getOptionValue(KEY_STORE_TYPE_ARG, this.getKeyStoreTypeDefault());
        if (KeystoreType.PKCS12.toString().equalsIgnoreCase(this.keyStoreType)) {
            logger.info("Command line argument --keyStoreType=" + this.keyStoreType + " only applies to keystore, recommended truststore type of " + KeystoreType.JKS.toString() + " unaffected.");
        }
        this.signingAlgorithm = commandLine.getOptionValue(SIGNING_ALGORITHM_ARG, "SHA256WITHRSA");
        this.differentPasswordForKeyAndKeystore = commandLine.hasOption(DIFFERENT_KEY_AND_KEYSTORE_PASSWORDS_ARG);
    }
}

