/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.configuration;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.nifi.util.StringUtils;

public class InstanceIdentifier {
    public static final Comparator<InstanceIdentifier> HOST_IDENTIFIER_COMPARATOR = (o1, o2) -> {
        int i = o1.getHostname().compareTo(o2.getHostname());
        if (i == 0) {
            return o1.getNumber() - o2.getNumber();
        }
        return i;
    };
    private static final Pattern RANGE_PATTERN = Pattern.compile("^[0-9]+(-[0-9]+)?$");
    private final String hostname;
    private final int number;

    public InstanceIdentifier(String hostname, int number) {
        this.hostname = hostname;
        this.number = number;
    }

    public static Map<InstanceIdentifier, Integer> createOrderMap(Stream<String> hostnameExpressions) {
        List instanceIdentifiers = InstanceIdentifier.createIdentifiers(hostnameExpressions).sorted(HOST_IDENTIFIER_COMPARATOR).collect(Collectors.toList());
        HashMap<InstanceIdentifier, Integer> result = new HashMap<InstanceIdentifier, Integer>();
        for (int i = 0; i < instanceIdentifiers.size(); ++i) {
            result.put((InstanceIdentifier)instanceIdentifiers.get(i), i + 1);
        }
        return result;
    }

    public static Stream<InstanceIdentifier> createIdentifiers(Stream<String> hostnameExpressions) {
        return hostnameExpressions.flatMap(hostnameExpression -> InstanceIdentifier.extractHostnames(hostnameExpression).flatMap(hostname -> {
            ExtractedRange extractedRange = new ExtractedRange((String)hostname, '(', ')');
            if (extractedRange.range == null) {
                return Stream.of(new InstanceIdentifier((String)hostname, 1));
            }
            if (!StringUtils.isEmpty((String)extractedRange.afterClose)) {
                throw new IllegalArgumentException("No characters expected after )");
            }
            return extractedRange.range.map(numString -> new InstanceIdentifier(extractedRange.beforeOpen, Integer.parseInt(numString)));
        }));
    }

    protected static Stream<String> extractHostnames(String hostname) {
        ExtractedRange extractedRange = new ExtractedRange(hostname, '[', ']');
        if (extractedRange.range == null) {
            return Stream.of(hostname);
        }
        return extractedRange.range.map(s -> extractedRange.beforeOpen + s + extractedRange.afterClose).flatMap(InstanceIdentifier::extractHostnames);
    }

    private static Stream<String> extractRange(String range) {
        if (!RANGE_PATTERN.matcher(range).matches()) {
            throw new IllegalArgumentException("Expected either one number or two separated by a single hyphen");
        }
        String[] split = range.split("-");
        if (split.length == 1) {
            String prefix = "1-";
            if (split[0].charAt(0) == '0') {
                prefix = String.format("%0" + split[0].length() + "d-", 1);
            }
            return InstanceIdentifier.extractRange(prefix + split[0]);
        }
        int baseLength = split[0].length();
        int low = Integer.parseInt(split[0]);
        String padding = split[0].substring(0, split[0].length() - Integer.toString(low).length());
        int high = Integer.parseInt(split[1]);
        return IntStream.range(low, high + 1).mapToObj(i -> {
            String s = Integer.toString(i);
            int length = s.length();
            if (length >= baseLength) {
                return s;
            }
            return padding.substring(0, baseLength - length) + s;
        });
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceIdentifier that = (InstanceIdentifier)o;
        if (this.number != that.number) {
            return false;
        }
        return this.hostname != null ? this.hostname.equals(that.hostname) : that.hostname == null;
    }

    public int hashCode() {
        int result = this.hostname != null ? this.hostname.hashCode() : 0;
        result = 31 * result + this.number;
        return result;
    }

    private static class ExtractedRange {
        private final String beforeOpen;
        private final Stream<String> range;
        private final String afterClose;

        public ExtractedRange(String string, char rangeOpen, char rangeClose) {
            int openBracket = string.indexOf(rangeOpen);
            if (openBracket >= 0) {
                int closeBracket = string.indexOf(rangeClose, openBracket);
                if (closeBracket < 0) {
                    throw new IllegalArgumentException("Unable to find matching " + rangeClose + " for " + rangeOpen + " in " + string);
                }
                this.beforeOpen = string.substring(0, openBracket);
                this.afterClose = closeBracket + 1 < string.length() ? string.substring(closeBracket + 1) : "";
                this.range = InstanceIdentifier.extractRange(string.substring(openBracket + 1, closeBracket));
            } else {
                this.beforeOpen = string;
                this.range = null;
                this.afterClose = "";
            }
        }
    }
}

