/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.toolkit.tls.configuration.TlsConfig;
import org.apache.nifi.toolkit.tls.manager.writer.ConfigurationWriter;
import org.apache.nifi.toolkit.tls.util.InputStreamFactory;
import org.apache.nifi.toolkit.tls.util.OutputStreamFactory;
import org.apache.nifi.toolkit.tls.util.PasswordUtil;
import org.apache.nifi.toolkit.tls.util.TlsHelper;
import org.apache.nifi.util.StringUtils;

public class BaseTlsManager {
    private final TlsConfig tlsConfig;
    private final PasswordUtil passwordUtil;
    private final InputStreamFactory inputStreamFactory;
    private final KeyStore keyStore;
    private final List<ConfigurationWriter<TlsConfig>> configurationWriters;
    private boolean differentKeyAndKeyStorePassword = false;
    private boolean keyStorePasswordGenerated = false;

    public BaseTlsManager(TlsConfig tlsConfig) throws GeneralSecurityException, IOException {
        this(tlsConfig, new PasswordUtil(), FileInputStream::new);
    }

    public BaseTlsManager(TlsConfig tlsConfig, PasswordUtil passwordUtil, InputStreamFactory inputStreamFactory) throws GeneralSecurityException, IOException {
        this.tlsConfig = tlsConfig;
        this.passwordUtil = passwordUtil;
        this.inputStreamFactory = inputStreamFactory;
        this.keyStore = this.loadKeystore(tlsConfig.getKeyStore(), tlsConfig.getKeyStoreType(), this.getKeyStorePassword());
        this.configurationWriters = new ArrayList<ConfigurationWriter<TlsConfig>>();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyStore.Entry getEntry(String alias) throws GeneralSecurityException {
        String keyPassword = this.getKeyPassword();
        return this.keyStore.getEntry(alias, new KeyStore.PasswordProtection(keyPassword == null ? null : keyPassword.toCharArray()));
    }

    public KeyStore.Entry addPrivateKeyToKeyStore(KeyPair keyPair, String alias, Certificate ... certificates) throws GeneralSecurityException {
        String passphrase = this.getKeyPassword();
        this.keyStore.setKeyEntry(alias, keyPair.getPrivate(), passphrase == null ? null : passphrase.toCharArray(), certificates);
        return this.getEntry(alias);
    }

    public void setDifferentKeyAndKeyStorePassword(boolean differentKeyAndKeyStorePassword) {
        this.differentKeyAndKeyStorePassword = differentKeyAndKeyStorePassword;
    }

    private String getKeyPassword() {
        if (this.keyStore.getType().equalsIgnoreCase(KeystoreType.PKCS12.toString())) {
            this.tlsConfig.setKeyPassword(null);
            return null;
        }
        String result = this.tlsConfig.getKeyPassword();
        if (StringUtils.isEmpty((String)result)) {
            result = this.differentKeyAndKeyStorePassword ? this.passwordUtil.generatePassword() : this.getKeyStorePassword();
            this.tlsConfig.setKeyPassword(result);
        }
        return result;
    }

    private String getKeyStorePassword() {
        String result = this.tlsConfig.getKeyStorePassword();
        if (StringUtils.isEmpty((String)result)) {
            result = this.passwordUtil.generatePassword();
            this.keyStorePasswordGenerated = true;
            this.tlsConfig.setKeyStorePassword(result);
        }
        return result;
    }

    protected KeyStore loadKeystore(String keyStore, String keyStoreType, String keyStorePassword) throws GeneralSecurityException, IOException {
        KeyStore result = KeyStoreUtils.getKeyStore((String)keyStoreType);
        File file = new File(keyStore);
        if (file.exists()) {
            try (InputStream stream = this.inputStreamFactory.create(file);){
                result.load(stream, keyStorePassword.toCharArray());
            }
            return result;
        }
        result.load(null, null);
        return result;
    }

    public void write(OutputStreamFactory outputStreamFactory) throws IOException, GeneralSecurityException {
        String keyStorePassword = this.getKeyStorePassword();
        this.tlsConfig.setKeyStorePassword(TlsHelper.writeKeyStore(this.keyStore, outputStreamFactory, new File(this.tlsConfig.getKeyStore()), keyStorePassword, this.keyStorePasswordGenerated));
        for (ConfigurationWriter<TlsConfig> configurationWriter : this.configurationWriters) {
            configurationWriter.write(this.tlsConfig, outputStreamFactory);
        }
    }

    protected PasswordUtil getPasswordUtil() {
        return this.passwordUtil;
    }

    public void addConfigurationWriter(ConfigurationWriter<TlsConfig> configurationWriter) {
        this.configurationWriters.add(configurationWriter);
    }

    protected TlsConfig getTlsConfig() {
        return this.tlsConfig;
    }
}

