/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.manager;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.apache.nifi.security.util.CertificateUtils;
import org.apache.nifi.toolkit.tls.configuration.TlsConfig;
import org.apache.nifi.toolkit.tls.manager.BaseTlsManager;
import org.apache.nifi.toolkit.tls.util.TlsHelper;

public class TlsCertificateAuthorityManager
extends BaseTlsManager {
    public TlsCertificateAuthorityManager(TlsConfig tlsConfig) throws GeneralSecurityException, IOException {
        super(tlsConfig);
    }

    public KeyStore.PrivateKeyEntry getOrGenerateCertificateAuthority() throws GeneralSecurityException, IOException {
        KeyStore.Entry entry = this.getEntry("nifi-key");
        if (entry == null) {
            TlsConfig tlsConfig = this.getTlsConfig();
            KeyPair keyPair = TlsHelper.generateKeyPair(tlsConfig.getKeyPairAlgorithm(), tlsConfig.getKeySize());
            X509Certificate caCert = CertificateUtils.generateSelfSignedX509Certificate((KeyPair)keyPair, (String)CertificateUtils.reorderDn((String)tlsConfig.getDn()), (String)tlsConfig.getSigningAlgorithm(), (int)tlsConfig.getDays());
            entry = this.addPrivateKeyToKeyStore(keyPair, "nifi-key", caCert);
        } else if (!KeyStore.PrivateKeyEntry.class.isInstance(entry)) {
            throw new IOException("Expected nifi-key alias to contain a private key entry");
        }
        return (KeyStore.PrivateKeyEntry)entry;
    }
}

