/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.service.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.apache.nifi.toolkit.tls.configuration.TlsConfig;
import org.apache.nifi.toolkit.tls.manager.TlsCertificateAuthorityManager;
import org.apache.nifi.toolkit.tls.manager.writer.JsonConfigurationWriter;
import org.apache.nifi.toolkit.tls.service.server.TlsCertificateAuthorityServiceHandler;
import org.apache.nifi.toolkit.tls.util.OutputStreamFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsCertificateAuthorityService {
    private final Logger logger = LoggerFactory.getLogger(TlsCertificateAuthorityService.class);
    private final OutputStreamFactory outputStreamFactory;
    private Server server;

    public TlsCertificateAuthorityService() {
        this(FileOutputStream::new);
    }

    public TlsCertificateAuthorityService(OutputStreamFactory outputStreamFactory) {
        this.outputStreamFactory = outputStreamFactory;
    }

    private static Server createServer(Handler handler, int port, KeyStore keyStore, String keyPassword) throws Exception {
        Server server = new Server();
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setIncludeProtocols(new String[]{"TLSv1.2"});
        sslContextFactory.setKeyStore(keyStore);
        sslContextFactory.setKeyManagerPassword(keyPassword);
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        sslConnector.setPort(port);
        server.addConnector((Connector)sslConnector);
        server.setHandler(handler);
        return server;
    }

    public synchronized void start(TlsConfig tlsConfig, String configJson, boolean differentPasswordsForKeyAndKeystore) throws Exception {
        TlsCertificateAuthorityManager tlsManager;
        if (this.server != null) {
            throw new IllegalStateException("Server already started");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            tlsManager = new TlsCertificateAuthorityManager(tlsConfig);
            tlsManager.setDifferentKeyAndKeyStorePassword(differentPasswordsForKeyAndKeystore);
        }
        catch (IOException e) {
            this.logger.error("Unable to open existing keystore, it can be reused by specifiying both configJson and useConfigJson");
            throw e;
        }
        tlsManager.addConfigurationWriter(new JsonConfigurationWriter<TlsConfig>(objectMapper, new File(configJson)));
        KeyStore.PrivateKeyEntry privateKeyEntry = tlsManager.getOrGenerateCertificateAuthority();
        KeyPair keyPair = new KeyPair(privateKeyEntry.getCertificate().getPublicKey(), privateKeyEntry.getPrivateKey());
        Certificate[] certificateChain = privateKeyEntry.getCertificateChain();
        if (certificateChain.length != 1) {
            throw new IOException("Expected root ca cert to be only certificate in chain");
        }
        Certificate certificate = certificateChain[0];
        if (!(certificate instanceof X509Certificate)) {
            throw new IOException("Expected " + X509Certificate.class + " as root ca cert");
        }
        X509Certificate caCert = (X509Certificate)certificate;
        tlsManager.write(this.outputStreamFactory);
        String signingAlgorithm = tlsConfig.getSigningAlgorithm();
        int days = tlsConfig.getDays();
        this.server = TlsCertificateAuthorityService.createServer((Handler)new TlsCertificateAuthorityServiceHandler(signingAlgorithm, days, tlsConfig.getToken(), caCert, keyPair, objectMapper), tlsConfig.getPort(), tlsManager.getKeyStore(), tlsConfig.getKeyPassword());
        this.server.start();
    }

    public synchronized void shutdown() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Server already shutdown");
        }
        this.server.stop();
        this.server.join();
    }
}

