/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.nifi.toolkit.tls.commandLine.BaseTlsToolkitCommandLine;
import org.apache.nifi.toolkit.tls.commandLine.CommandLineParseException;
import org.apache.nifi.toolkit.tls.commandLine.ExitCode;
import org.apache.nifi.toolkit.tls.configuration.InstanceDefinition;
import org.apache.nifi.toolkit.tls.configuration.StandaloneConfig;
import org.apache.nifi.toolkit.tls.properties.NiFiPropertiesWriterFactory;
import org.apache.nifi.toolkit.tls.standalone.TlsToolkitStandalone;
import org.apache.nifi.toolkit.tls.util.PasswordUtil;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsToolkitStandaloneCommandLine
extends BaseTlsToolkitCommandLine {
    public static final String OUTPUT_DIRECTORY_ARG = "outputDirectory";
    public static final String NIFI_PROPERTIES_FILE_ARG = "nifiPropertiesFile";
    public static final String KEY_STORE_PASSWORD_ARG = "keyStorePassword";
    public static final String TRUST_STORE_PASSWORD_ARG = "trustStorePassword";
    public static final String KEY_PASSWORD_ARG = "keyPassword";
    public static final String HOSTNAMES_ARG = "hostnames";
    public static final String OVERWRITE_ARG = "isOverwrite";
    public static final String CLIENT_CERT_DN_ARG = "clientCertDn";
    public static final String CLIENT_CERT_PASSWORD_ARG = "clientCertPassword";
    public static final String GLOBAL_PORT_SEQUENCE_ARG = "globalPortSequence";
    public static final String NIFI_DN_PREFIX_ARG = "nifiDnPrefix";
    public static final String NIFI_DN_SUFFIX_ARG = "nifiDnSuffix";
    public static final String SUBJECT_ALTERNATIVE_NAMES_ARG = "subjectAlternativeNames";
    public static final String ADDITIONAL_CA_CERTIFICATE_ARG = "additionalCACertificate";
    public static final String DEFAULT_OUTPUT_DIRECTORY = TlsToolkitStandaloneCommandLine.calculateDefaultOutputDirectory(Paths.get(".", new String[0]));
    public static final String DESCRIPTION = "Creates certificates and config files for nifi cluster.";
    private final Logger logger = LoggerFactory.getLogger(TlsToolkitStandaloneCommandLine.class);
    private final PasswordUtil passwordUtil;
    private File baseDir;
    private List<InstanceDefinition> instanceDefinitions;
    private NiFiPropertiesWriterFactory niFiPropertiesWriterFactory;
    private List<String> clientDns;
    private List<String> clientPasswords;
    private boolean clientPasswordsGenerated;
    private boolean overwrite;
    private String dnPrefix;
    private String dnSuffix;
    private String domainAlternativeNames;
    private String additionalCACertificatePath;

    protected static String calculateDefaultOutputDirectory(Path currentPath) {
        Path currentAbsolutePath = currentPath.toAbsolutePath();
        Path parent = currentAbsolutePath.getParent();
        if (currentAbsolutePath.getRoot().equals(parent)) {
            return parent.toString();
        }
        Path currentNormalizedPath = currentAbsolutePath.normalize();
        return "../" + currentNormalizedPath.getFileName().toString();
    }

    public TlsToolkitStandaloneCommandLine() {
        this(new PasswordUtil());
    }

    protected TlsToolkitStandaloneCommandLine(PasswordUtil passwordUtil) {
        super(DESCRIPTION);
        this.passwordUtil = passwordUtil;
        this.addOptionWithArg("o", OUTPUT_DIRECTORY_ARG, "The directory to output keystores, truststore, config files.", DEFAULT_OUTPUT_DIRECTORY);
        this.addOptionWithArg("n", HOSTNAMES_ARG, "Comma separated list of hostnames.");
        this.addOptionWithArg("f", NIFI_PROPERTIES_FILE_ARG, "Base nifi.properties file to update. (Embedded file identical to the one in a default NiFi install will be used if not specified.)");
        this.addOptionWithArg("S", KEY_STORE_PASSWORD_ARG, "Keystore password to use.  Must either be one value or one for each host. (autogenerate if not specified)");
        this.addOptionWithArg("K", KEY_PASSWORD_ARG, "Key password to use.  Must either be one value or one for each host. (autogenerate if not specified)");
        this.addOptionWithArg("P", TRUST_STORE_PASSWORD_ARG, "Keystore password to use.  Must either be one value or one for each host. (autogenerate if not specified)");
        this.addOptionWithArg("C", CLIENT_CERT_DN_ARG, "Generate client certificate suitable for use in browser with specified DN. (Can be specified multiple times.)");
        this.addOptionWithArg("B", CLIENT_CERT_PASSWORD_ARG, "Password for client certificate.  Must either be one value or one for each client DN. (autogenerate if not specified)");
        this.addOptionWithArg("G", GLOBAL_PORT_SEQUENCE_ARG, "Use sequential ports that are calculated for all hosts according to the provided hostname expressions. (Can be specified multiple times, MUST BE SAME FROM RUN TO RUN.)");
        this.addOptionWithArg(null, SUBJECT_ALTERNATIVE_NAMES_ARG, "Comma-separated list of domains to use as Subject Alternative Names in the certificate");
        this.addOptionWithArg(null, NIFI_DN_PREFIX_ARG, "String to prepend to hostname(s) when determining DN.", "CN=");
        this.addOptionWithArg(null, NIFI_DN_SUFFIX_ARG, "String to append to hostname(s) when determining DN.", ", OU=NIFI");
        this.addOptionNoArg("O", OVERWRITE_ARG, "Overwrite existing host output.");
        this.addOptionWithArg(null, ADDITIONAL_CA_CERTIFICATE_ARG, "Path to additional CA certificate (used to sign toolkit CA certificate) in PEM format if necessary");
    }

    public static void main(String[] args) {
        TlsToolkitStandaloneCommandLine tlsToolkitStandaloneCommandLine = new TlsToolkitStandaloneCommandLine();
        try {
            tlsToolkitStandaloneCommandLine.parse(args);
        }
        catch (CommandLineParseException e) {
            System.exit(e.getExitCode().ordinal());
        }
        try {
            new TlsToolkitStandalone().createNifiKeystoresAndTrustStores(tlsToolkitStandaloneCommandLine.createConfig());
        }
        catch (Exception e) {
            tlsToolkitStandaloneCommandLine.printUsage("Error generating TLS configuration. (" + e.getMessage() + ")");
            System.exit(ExitCode.ERROR_GENERATING_CONFIG.ordinal());
        }
        System.exit(ExitCode.SUCCESS.ordinal());
    }

    @Override
    protected CommandLine doParse(String ... args) throws CommandLineParseException {
        CommandLine commandLine = super.doParse(args);
        String outputDirectory = commandLine.getOptionValue(OUTPUT_DIRECTORY_ARG, DEFAULT_OUTPUT_DIRECTORY);
        this.baseDir = new File(outputDirectory);
        this.dnPrefix = commandLine.getOptionValue(NIFI_DN_PREFIX_ARG, "CN=");
        this.dnSuffix = commandLine.getOptionValue(NIFI_DN_SUFFIX_ARG, ", OU=NIFI");
        this.domainAlternativeNames = commandLine.getOptionValue(SUBJECT_ALTERNATIVE_NAMES_ARG);
        Stream<String> globalOrderExpressions = null;
        if (commandLine.hasOption(GLOBAL_PORT_SEQUENCE_ARG)) {
            globalOrderExpressions = Arrays.stream(commandLine.getOptionValues(GLOBAL_PORT_SEQUENCE_ARG)).flatMap(s -> Arrays.stream(s.split(","))).map(String::trim);
        }
        this.instanceDefinitions = commandLine.hasOption(HOSTNAMES_ARG) ? Collections.unmodifiableList(InstanceDefinition.createDefinitions(globalOrderExpressions, Arrays.stream(commandLine.getOptionValues(HOSTNAMES_ARG)).flatMap(s -> Arrays.stream(s.split(",")).map(String::trim)), this.parsePasswordSupplier(commandLine, KEY_STORE_PASSWORD_ARG, this.passwordUtil.passwordSupplier()), this.parsePasswordSupplier(commandLine, KEY_PASSWORD_ARG, commandLine.hasOption("differentKeyAndKeystorePasswords") ? this.passwordUtil.passwordSupplier() : null), this.parsePasswordSupplier(commandLine, TRUST_STORE_PASSWORD_ARG, this.passwordUtil.passwordSupplier()))) : Collections.emptyList();
        String[] clientDnValues = commandLine.getOptionValues(CLIENT_CERT_DN_ARG);
        this.clientDns = clientDnValues != null ? Collections.unmodifiableList(Arrays.stream(clientDnValues).collect(Collectors.toList())) : Collections.emptyList();
        this.clientPasswords = Collections.unmodifiableList(this.getPasswords(CLIENT_CERT_PASSWORD_ARG, commandLine, this.clientDns.size(), CLIENT_CERT_DN_ARG));
        this.clientPasswordsGenerated = commandLine.getOptionValues(CLIENT_CERT_PASSWORD_ARG) == null;
        this.overwrite = commandLine.hasOption(OVERWRITE_ARG);
        this.additionalCACertificatePath = commandLine.getOptionValue(ADDITIONAL_CA_CERTIFICATE_ARG);
        String nifiPropertiesFile = commandLine.getOptionValue(NIFI_PROPERTIES_FILE_ARG, "");
        try {
            if (StringUtils.isEmpty((String)nifiPropertiesFile)) {
                this.logger.info("No nifiPropertiesFile specified, using embedded one.");
                this.niFiPropertiesWriterFactory = new NiFiPropertiesWriterFactory();
            } else {
                this.logger.info("Using " + nifiPropertiesFile + " as template.");
                this.niFiPropertiesWriterFactory = new NiFiPropertiesWriterFactory(new FileInputStream(nifiPropertiesFile));
            }
        }
        catch (IOException e) {
            this.printUsageAndThrow("Unable to read nifi.properties from " + (StringUtils.isEmpty((String)nifiPropertiesFile) ? "classpath" : nifiPropertiesFile), ExitCode.ERROR_READING_NIFI_PROPERTIES);
        }
        return commandLine;
    }

    private List<String> getPasswords(String arg, CommandLine commandLine, int num, String numArg) throws CommandLineParseException {
        String[] optionValues = commandLine.getOptionValues(arg);
        if (optionValues == null) {
            return IntStream.range(0, num).mapToObj(operand -> this.passwordUtil.generatePassword()).collect(Collectors.toList());
        }
        if (optionValues.length == 1) {
            return IntStream.range(0, num).mapToObj(value -> optionValues[0]).collect(Collectors.toList());
        }
        if (optionValues.length == num) {
            return Arrays.stream(optionValues).collect(Collectors.toList());
        }
        return (List)this.printUsageAndThrow("Expected either 1 value or " + num + " (the number of " + numArg + ") values for " + arg, ExitCode.ERROR_INCORRECT_NUMBER_OF_PASSWORDS);
    }

    private Supplier<String> parsePasswordSupplier(CommandLine commandLine, String option, Supplier<String> defaultSupplier) {
        if (commandLine.hasOption(option)) {
            String[] values = commandLine.getOptionValues(option);
            if (values.length == 1) {
                return PasswordUtil.passwordSupplier(values[0]);
            }
            return PasswordUtil.passwordSupplier("Provided " + option + " exhausted, please don't specify " + option + ", specify one value to be used for all NiFi instances, or specify one value for each NiFi instance.", values);
        }
        return defaultSupplier;
    }

    public StandaloneConfig createConfig() {
        StandaloneConfig standaloneConfig = new StandaloneConfig();
        standaloneConfig.setBaseDir(this.baseDir);
        standaloneConfig.setNiFiPropertiesWriterFactory(this.niFiPropertiesWriterFactory);
        standaloneConfig.setInstanceDefinitions(this.instanceDefinitions);
        standaloneConfig.setOverwrite(this.overwrite);
        standaloneConfig.setClientDns(this.clientDns);
        standaloneConfig.setClientPasswords(this.clientPasswords);
        standaloneConfig.setClientPasswordsGenerated(this.clientPasswordsGenerated);
        standaloneConfig.setCaHostname(this.getCertificateAuthorityHostname());
        standaloneConfig.setKeyStore("nifi-ca-keystore." + this.getKeyStoreType().toLowerCase());
        standaloneConfig.setKeyStoreType(this.getKeyStoreType());
        standaloneConfig.setKeySize(this.getKeySize());
        standaloneConfig.setKeyPairAlgorithm(this.getKeyAlgorithm());
        standaloneConfig.setSigningAlgorithm(this.getSigningAlgorithm());
        standaloneConfig.setDays(this.getDays());
        standaloneConfig.setDnPrefix(this.dnPrefix);
        standaloneConfig.setDnSuffix(this.dnSuffix);
        standaloneConfig.setDomainAlternativeNames(this.domainAlternativeNames);
        standaloneConfig.setAdditionalCACertificate(this.additionalCACertificatePath);
        standaloneConfig.initDefaults();
        return standaloneConfig;
    }
}

