/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.user;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.authorization.Authority;
import org.apache.nifi.user.NiFiUser;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class NiFiUserDetails
implements UserDetails {
    private final NiFiUser user;

    public NiFiUserDetails(NiFiUser user) {
        this.user = user;
    }

    public NiFiUser getNiFiUser() {
        return this.user;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        Set authorities = this.user.getAuthorities();
        HashSet<SimpleGrantedAuthority> grantedAuthorities = new HashSet<SimpleGrantedAuthority>(authorities.size());
        for (Authority authority : authorities) {
            grantedAuthorities.add(new SimpleGrantedAuthority(authority.toString()));
        }
        return grantedAuthorities;
    }

    public String getPassword() {
        return "";
    }

    public String getUsername() {
        return this.user.getIdentity();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }
}

